/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.impl.SibRaDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.Synchronization;

class SibRaSynchronizedDispatcher
extends SibRaDispatcher {
    private SITransaction _transaction;
    private boolean _transactionRolledBack = false;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaSynchronizedDispatcher.class);
    private static TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String CLASS_NAME = SibRaSynchronizedDispatcher.class.getName();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";

    protected SibRaSynchronizedDispatcher(SICoreConnection sICoreConnection, AbstractConsumerSession abstractConsumerSession, SibRaEndpointActivation sibRaEndpointActivation) throws ResourceException {
        super(sICoreConnection, abstractConsumerSession, sibRaEndpointActivation);
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaSynchronizedDispatcher", (Object)new Object[]{sICoreConnection, abstractConsumerSession, sibRaEndpointActivation});
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaSynchronizedDispatcher");
        }
    }

    protected SITransaction getTransaction() throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getTransaction");
        }
        if (this._transaction == null) {
            try {
                this._transaction = this._connection.createUncoordinatedTransaction();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "getTransaction"), (String)FFDC_PROBE_1, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
                }
                throw new ResourceException(NLS.getFormattedMessage("UNCOORD_TRAN_CWSIV1201", new Object[]{this._connection, exception}, null), (Throwable)exception);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getTransaction", (Object)this._transaction);
        }
        return this._transaction;
    }

    protected MessageEndpoint createEndpoint() throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createEndpoint");
        }
        MessageEndpoint messageEndpoint = this._endpointFactory.createEndpoint(null);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createEndpoint", (Object)messageEndpoint);
        }
        return messageEndpoint;
    }

    protected void beforeDelivery(SIBusMessage sIBusMessage, MessageEndpoint messageEndpoint) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery", (Object)sIBusMessage);
        }
        try {
            messageEndpoint.beforeDelivery(this._invoker.getEndpointMethod());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            FFDCFilter.processException((Throwable)noSuchMethodException, (String)(CLASS_NAME + "." + "beforeDelivery"), (String)FFDC_PROBE_2, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)noSuchMethodException);
            }
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("BEFORE_DELIVERY_CWSIV1200", new Object[]{noSuchMethodException, messageEndpoint}, null), (Throwable)noSuchMethodException);
        }
        final SITransaction sITransaction = this.getTransaction();
        if (sITransaction instanceof Synchronization) {
            try {
                WebSphereTransactionManager webSphereTransactionManager = TransactionManagerFactory.getTransactionManager();
                UOWCoordinator uOWCoordinator = TransactionManagerFactory.getUOWCurrent().getUOWCoord();
                webSphereTransactionManager.registerSynchronization(uOWCoordinator, new Synchronization(){

                    public void beforeCompletion() {
                        ((Synchronization)sITransaction).beforeCompletion();
                    }

                    public void afterCompletion(int n) {
                        ((Synchronization)sITransaction).afterCompletion(n);
                        SibRaSynchronizedDispatcher.this._transactionRolledBack = 3 != n;
                    }
                }, 2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "beforeDelivery"), (String)FFDC_PROBE_3, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
                }
                throw new ResourceException(NLS.getFormattedMessage("REGISTER_SYNC_CWSIV1202", new Object[]{sITransaction, exception}, null), (Throwable)exception);
            }
        } else {
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("SYNC_CWSIV1203", new Object[]{sITransaction, Synchronization.class.getName()}, null));
        }
        this.deleteMessage(sIBusMessage, sITransaction);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery");
        }
    }

    protected void afterDelivery(SIBusMessage sIBusMessage, MessageEndpoint messageEndpoint, boolean bl) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"afterDelivery", (Object)new Object[]{sIBusMessage, bl});
        }
        this._transaction = null;
        messageEndpoint.afterDelivery();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"afterDelivery");
        }
    }

    protected void cleanup() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"cleanup");
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"cleanup");
        }
    }

    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator sibRaStringGenerator = super.getStringGenerator();
        sibRaStringGenerator.addField("transaction", this._transaction);
        return sibRaStringGenerator;
    }

    protected boolean isTransactionRolledBack() {
        return this._transactionRolledBack;
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaSynchronizedDispatcher.java, SIB.ra, WAS602.SIB, o0610.11 1.8");
        }
    }
}

