/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.impl.SibRaDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaListener;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessagingEngineConnection;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SIMessageNotLockedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.pacing.AsynchDispatchScheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.resource.ResourceException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;

final class SibRaSingleProcessListener
extends SibRaListener {
    private final WorkManager _workManager;
    private int _workCount;
    private final int _maxWorkCount;
    private final Stack _freeWork;
    private final boolean _deleteBestEffortNonPersistentMessages;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaSingleProcessListener.class);
    private static final TraceComponent WORK_TRACE = SibRaUtils.getTraceComponent(SibRaSingleProcessListener.class);
    private static final String CLASS_NAME = SibRaSingleProcessListener.class.getName();
    private static final String WORK_CLASS_NAME = SibRaWork.class.getName();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";
    private static final String FFDC_PROBE_5 = "5";
    private static final String FFDC_PROBE_6 = "6";
    private static final String FFDC_PROBE_7 = "7";
    private static final String FFDC_PROBE_8 = "8";
    private static final String FFDC_PROBE_9 = "9";

    SibRaSingleProcessListener(SibRaMessagingEngineConnection sibRaMessagingEngineConnection, SIDestinationAddress sIDestinationAddress) throws ResourceException {
        super(sibRaMessagingEngineConnection, sIDestinationAddress);
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaSingleProcessListener", (Object)new Object[]{sibRaMessagingEngineConnection, sIDestinationAddress});
        }
        this._workManager = this._connection.getEndpointActivation().getWorkManager();
        this._maxWorkCount = this._connection.getEndpointConfiguration().getMaxConcurrency();
        this._deleteBestEffortNonPersistentMessages = !sibRaMessagingEngineConnection.getEndpointActivation().isEndpointMethodTransactional();
        this._freeWork = new Stack();
        this.startConsumer();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaSingleProcessListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalConsumeMessages(LockedMessageEnumeration lockedMessageEnumeration, AsynchDispatchScheduler asynchDispatchScheduler) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"internalConsumeMessages", (Object)new Object[]{lockedMessageEnumeration, asynchDispatchScheduler});
        }
        try {
            SibRaWork sibRaWork;
            SIBusMessage sIBusMessage;
            ArrayList<SIBusMessage> arrayList = new ArrayList<SIBusMessage>();
            while ((sIBusMessage = lockedMessageEnumeration.nextLocked()) != null) {
                arrayList.add(sIBusMessage);
                if (!this._deleteBestEffortNonPersistentMessages || !Reliability.BEST_EFFORT_NONPERSISTENT.equals(sIBusMessage.getReliability())) continue;
                lockedMessageEnumeration.deleteCurrent(null);
            }
            SibRaSingleProcessListener sibRaSingleProcessListener = this;
            synchronized (sibRaSingleProcessListener) {
                sibRaWork = this._freeWork.isEmpty() ? new SibRaWork() : (SibRaWork)this._freeWork.pop();
            }
            sibRaWork.schedule(arrayList, asynchDispatchScheduler);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(CLASS_NAME + "." + "internalConsumeMessages"), (String)FFDC_PROBE_9, (Object)this);
            SibTr.error((TraceComponent)TRACE, (String)"RETRIEVE_MESSAGES_CWSIV1100", (Object)new Object[]{throwable, lockedMessageEnumeration});
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"internalConsumeMessages");
        }
    }

    protected void processCachedMessage(SIBusMessage sIBusMessage, LockedMessageEnumeration lockedMessageEnumeration) throws SISessionDroppedException, SIConnectionDroppedException, SISessionUnavailableException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SIMessageNotLockedException, SIResourceException, SIIncorrectCallException {
        if (this._deleteBestEffortNonPersistentMessages && Reliability.BEST_EFFORT_NONPERSISTENT.equals(sIBusMessage.getReliability())) {
            lockedMessageEnumeration.deleteCurrent(null);
        }
    }

    boolean isSessionBifurcated() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"isSessionBifurcated");
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"isSessionBifurcated", (Object)Boolean.FALSE);
        }
        return false;
    }

    int getMaxActiveMessages() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getMaxActiveMessages");
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getMaxActiveMessages", (Object)"0");
        }
        return 0;
    }

    long getMessageLockExpiry() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getMessageLockExpiry");
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getMessageLockExpiry", (Object)"0");
        }
        return 0L;
    }

    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator sibRaStringGenerator = super.getStringGenerator();
        sibRaStringGenerator.addField("workManager", this._workManager);
        sibRaStringGenerator.addField("workCount", this._workCount);
        sibRaStringGenerator.addField("freeWork", this._freeWork);
        return sibRaStringGenerator;
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaSingleProcessListener.java, SIB.ra, WAS602.SIB, o0610.11 1.12.1.1");
        }
    }

    private final class SibRaWork
    implements Work,
    WorkListener {
        private List _messages;
        private SibRaDispatcher _dispatcher;
        private AsynchDispatchScheduler _asynchDispatchScheduler;

        private SibRaWork() {
        }

        public void schedule(List list, AsynchDispatchScheduler asynchDispatchScheduler) {
            if (WORK_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"schedule", (Object)new Object[]{list, asynchDispatchScheduler});
            }
            this._messages = list;
            this._asynchDispatchScheduler = asynchDispatchScheduler;
            try {
                SibRaSingleProcessListener.this._workManager.scheduleWork((Work)this, Long.MAX_VALUE, null, (WorkListener)this);
            }
            catch (WorkException workException) {
                FFDCFilter.processException((Throwable)workException, (String)(WORK_CLASS_NAME + "." + "schedule"), (String)SibRaSingleProcessListener.FFDC_PROBE_1, (Object)this);
                if (WORK_TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)WORK_TRACE, (Exception)((Object)workException));
                }
                this.unlockMessages();
            }
            if (WORK_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"schedule");
            }
        }

        public synchronized void run() {
            block7: {
                if (WORK_TRACE.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"run");
                }
                try {
                    if (this._dispatcher == null) {
                        this._dispatcher = SibRaSingleProcessListener.this._connection.createDispatcher((AbstractConsumerSession)SibRaSingleProcessListener.this._session);
                    }
                    this._dispatcher.dispatch(this._messages, this._asynchDispatchScheduler);
                }
                catch (IllegalStateException illegalStateException) {
                    if (WORK_TRACE.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)WORK_TRACE, (Exception)((Object)illegalStateException));
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)(WORK_CLASS_NAME + "." + "run"), (String)SibRaSingleProcessListener.FFDC_PROBE_2, (Object)this);
                    if (!WORK_TRACE.isEventEnabled()) break block7;
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Throwable)throwable);
                }
            }
            if (WORK_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"run");
            }
        }

        public synchronized void release() {
            if (WORK_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"release");
            }
            if (this._dispatcher != null) {
                this._dispatcher.cancel();
            }
            if (WORK_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"release");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void workAccepted(WorkEvent workEvent) {
            if (WORK_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"workAccepted", (Object)workEvent);
            }
            SibRaSingleProcessListener sibRaSingleProcessListener = SibRaSingleProcessListener.this;
            synchronized (sibRaSingleProcessListener) {
                block10: {
                    SibRaSingleProcessListener.this._workCount++;
                    if (SibRaSingleProcessListener.this._workCount == SibRaSingleProcessListener.this._maxWorkCount) {
                        try {
                            SibRaSingleProcessListener.this._session.stop();
                        }
                        catch (SIException sIException) {
                            FFDCFilter.processException((Throwable)sIException, (String)(WORK_CLASS_NAME + "." + "workAccepted"), (String)SibRaSingleProcessListener.FFDC_PROBE_3, (Object)this);
                            if (WORK_TRACE.isEventEnabled()) {
                                SibTr.exception((Object)this, (TraceComponent)WORK_TRACE, (Exception)((Object)sIException));
                            }
                        }
                        catch (SIErrorException sIErrorException) {
                            FFDCFilter.processException((Throwable)sIErrorException, (String)(WORK_CLASS_NAME + "." + "workAccepted"), (String)SibRaSingleProcessListener.FFDC_PROBE_6, (Object)this);
                            if (!WORK_TRACE.isEventEnabled()) break block10;
                            SibTr.exception((Object)this, (TraceComponent)WORK_TRACE, (Exception)((Object)sIErrorException));
                        }
                    }
                }
            }
            if (WORK_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"workAccepted");
            }
        }

        public void workRejected(WorkEvent workEvent) {
            if (WORK_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"workRejected", (Object)workEvent);
            }
            this.unlockMessages();
            this.workEnded();
            if (WORK_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"workRejected");
            }
        }

        public void workStarted(WorkEvent workEvent) {
            if (WORK_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"workStarted", (Object)workEvent);
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"workStarted");
            }
        }

        public void workCompleted(WorkEvent workEvent) {
            if (WORK_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"workCompleted", (Object)workEvent);
            }
            this.workEnded();
            if (WORK_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"workCompleted");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void workEnded() {
            if (WORK_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"workEnded");
            }
            SibRaSingleProcessListener sibRaSingleProcessListener = SibRaSingleProcessListener.this;
            synchronized (sibRaSingleProcessListener) {
                block10: {
                    SibRaSingleProcessListener.this._freeWork.push(this);
                    if (SibRaSingleProcessListener.this._workCount == SibRaSingleProcessListener.this._maxWorkCount) {
                        try {
                            SibRaSingleProcessListener.this._session.start(false);
                        }
                        catch (SIException sIException) {
                            FFDCFilter.processException((Throwable)sIException, (String)(WORK_CLASS_NAME + "." + "workEnded"), (String)SibRaSingleProcessListener.FFDC_PROBE_4, (Object)this);
                            if (WORK_TRACE.isEventEnabled()) {
                                SibTr.exception((Object)this, (TraceComponent)WORK_TRACE, (Exception)((Object)sIException));
                            }
                        }
                        catch (SIErrorException sIErrorException) {
                            FFDCFilter.processException((Throwable)sIErrorException, (String)(WORK_CLASS_NAME + "." + "workEnded"), (String)SibRaSingleProcessListener.FFDC_PROBE_7, (Object)this);
                            if (!WORK_TRACE.isEventEnabled()) break block10;
                            SibTr.exception((Object)this, (TraceComponent)WORK_TRACE, (Exception)((Object)sIErrorException));
                        }
                    }
                }
                SibRaSingleProcessListener.this._workCount--;
            }
            if (WORK_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"workEnded");
            }
        }

        private void unlockMessages() {
            if (WORK_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"unlockMessages");
            }
            if (this._messages != null) {
                block7: {
                    try {
                        SibRaSingleProcessListener.this._session.unlockSet(SibRaListener.getMessageHandles(this._messages));
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)(WORK_CLASS_NAME + "." + "unlockMessages"), (String)SibRaSingleProcessListener.FFDC_PROBE_5, (Object)this);
                        if (WORK_TRACE.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)WORK_TRACE, (Exception)((Object)sIException));
                        }
                    }
                    catch (SIErrorException sIErrorException) {
                        FFDCFilter.processException((Throwable)sIErrorException, (String)(WORK_CLASS_NAME + "." + "unlockMessages"), (String)SibRaSingleProcessListener.FFDC_PROBE_8, (Object)this);
                        if (!WORK_TRACE.isEventEnabled()) break block7;
                        SibTr.exception((Object)this, (TraceComponent)WORK_TRACE, (Exception)((Object)sIErrorException));
                    }
                }
                this._messages = null;
            }
            if (WORK_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"unlockMessages");
            }
        }

        public String toString() {
            SibRaStringGenerator sibRaStringGenerator = new SibRaStringGenerator(this);
            sibRaStringGenerator.addField("messages", this._messages);
            sibRaStringGenerator.addField("dispatcher", this._dispatcher);
            sibRaStringGenerator.addField("deleteBestEfforNonPersistentMessages", SibRaSingleProcessListener.this._deleteBestEffortNonPersistentMessages);
            sibRaStringGenerator.addParent("SibRaSingleProcessListener.this", SibRaSingleProcessListener.this);
            return sibRaStringGenerator.getStringRepresentation();
        }
    }
}

