/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.util.CRAHelperFactory;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfigurationProvider;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.ra.inbound.impl.SibRaDispatchEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaDynamicDestinationEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStaticDestinationEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

public class SibRaResourceAdapterImpl
implements ResourceAdapter {
    private final Map _endpointActivations = new HashMap();
    private BootstrapContext _bootstrapContext;
    private static final boolean IS_ZSR;
    private static final boolean IS_ZCRA;
    private static final int MAX_ENDPOINTS = 10;
    private static final TraceComponent TRACE;
    private static TraceNLS NLS;
    private static final String CLASS_NAME;
    private static final String FFDC_PROBE_1 = "1";

    public final void start(BootstrapContext bootstrapContext) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"start", (Object)bootstrapContext);
        }
        this._bootstrapContext = bootstrapContext;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"start");
        }
    }

    public final void stop() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"stop");
        }
        Iterator iterator = this._endpointActivations.keySet().iterator();
        while (iterator.hasNext()) {
            SibRaEndpointActivation sibRaEndpointActivation = (SibRaEndpointActivation)iterator.next();
            sibRaEndpointActivation.deactivate();
        }
        this._endpointActivations.clear();
        this._bootstrapContext = null;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"stop");
        }
    }

    public final void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws NotSupportedException, ResourceException {
        SibRaEndpointActivation sibRaEndpointActivation;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"endpointActivation", (Object)new Object[]{messageEndpointFactory, activationSpec});
        }
        if (activationSpec instanceof SibRaEndpointConfigurationProvider) {
            String string;
            SibRaEndpointConfiguration sibRaEndpointConfiguration;
            SibRaEndpointConfigurationProvider sibRaEndpointConfigurationProvider = (SibRaEndpointConfigurationProvider)activationSpec;
            try {
                sibRaEndpointConfiguration = sibRaEndpointConfigurationProvider.getEndpointConfiguration();
            }
            catch (InvalidPropertyException invalidPropertyException) {
                FFDCFilter.processException((Throwable)invalidPropertyException, (String)(CLASS_NAME + "." + "endpointActivation"), (String)FFDC_PROBE_1, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)invalidPropertyException));
                }
                throw new NotSupportedException(NLS.getFormattedMessage("INVALID_ACTIVATION_SPEC_CWSIV0452", new Object[]{activationSpec, invalidPropertyException}, null), (Throwable)invalidPropertyException);
            }
            if (IS_ZCRA && (string = sibRaEndpointConfiguration.getBusName()) != null && !CRAHelperFactory.get().isServiceConfigured(1, string)) {
                if (TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Ignoring endpoint " + messageEndpointFactory + " as bus " + string + " configured on activation specification " + activationSpec + " is not supported by this CRA"));
                }
                if (TRACE.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"endpointActivation");
                }
                return;
            }
            string = sibRaEndpointConfigurationProvider.getEndpointInvoker();
            sibRaEndpointActivation = null;
            if (IS_ZSR) {
                int n = sibRaEndpointConfiguration.getMaxConcurrency();
                if (n > 10) {
                    n = 10;
                }
                if (n == 0) {
                    n = 10;
                }
                for (int i = 0; i < n; ++i) {
                    sibRaEndpointActivation = new SibRaDispatchEndpointActivation(this, messageEndpointFactory, sibRaEndpointConfiguration, (SibRaEndpointInvoker)string, n);
                }
            } else {
                sibRaEndpointActivation = sibRaEndpointConfiguration.getDestination() == null ? new SibRaDynamicDestinationEndpointActivation(this, messageEndpointFactory, sibRaEndpointConfiguration, (SibRaEndpointInvoker)string) : new SibRaStaticDestinationEndpointActivation(this, messageEndpointFactory, sibRaEndpointConfiguration, (SibRaEndpointInvoker)string);
            }
        } else {
            NotSupportedException notSupportedException = new NotSupportedException(NLS.getFormattedMessage("UNEXPECTED_ACTIVATION_SPEC_CWSIV0451", new Object[]{activationSpec, SibRaEndpointConfigurationProvider.class}, null));
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)notSupportedException);
            }
            throw notSupportedException;
        }
        this._endpointActivations.put(messageEndpointFactory, sibRaEndpointActivation);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"endpointActivation");
        }
    }

    public final void endpointDeactivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) {
        SibRaEndpointActivation sibRaEndpointActivation;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"endpointDeactivation", (Object)new Object[]{messageEndpointFactory, activationSpec});
        }
        if ((sibRaEndpointActivation = (SibRaEndpointActivation)this._endpointActivations.remove(messageEndpointFactory)) != null) {
            sibRaEndpointActivation.deactivate();
        } else if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Endpoint deactivation called for unknown endpoint " + messageEndpointFactory));
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"endpointDeactivation");
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] activationSpecArray) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getXAResources", (Object)activationSpecArray);
        }
        XAResource[] xAResourceArray = null;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getXAResources", xAResourceArray);
        }
        return xAResourceArray;
    }

    final BootstrapContext getBootstrapContext() {
        return this._bootstrapContext;
    }

    public final String toString() {
        SibRaStringGenerator sibRaStringGenerator = new SibRaStringGenerator(this);
        sibRaStringGenerator.addField("endpointActivations", this._endpointActivations);
        sibRaStringGenerator.addField("bootstrapContext", this._bootstrapContext);
        return sibRaStringGenerator.getStringRepresentation();
    }

    static {
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        boolean bl = platformHelper.isZOS();
        IS_ZCRA = bl && platformHelper.isCRAJvm();
        IS_ZSR = bl && platformHelper.isServantJvm() && !IS_ZCRA;
        TRACE = SibRaUtils.getTraceComponent(SibRaResourceAdapterImpl.class);
        NLS = SibRaUtils.getTraceNls();
        CLASS_NAME = SibRaResourceAdapterImpl.class.getName();
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaResourceAdapterImpl.java, SIB.ra, WAS602.SIB, o0610.11 1.15");
        }
    }
}

