/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.impl.SibRaDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.BifurcatedConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import java.util.ArrayList;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;

class SibRaNonTransactionalDispatcher
extends SibRaDispatcher {
    private final List _unsuccessfulMessages = new ArrayList();
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaNonTransactionalDispatcher.class);
    private static final String CLASS_NAME = SibRaNonTransactionalDispatcher.class.getName();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";

    SibRaNonTransactionalDispatcher(SICoreConnection sICoreConnection, AbstractConsumerSession abstractConsumerSession, SibRaEndpointActivation sibRaEndpointActivation) throws ResourceException {
        super(sICoreConnection, abstractConsumerSession, sibRaEndpointActivation);
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaNonTransactionalDispatcher", (Object)new Object[]{sICoreConnection, abstractConsumerSession, sibRaEndpointActivation});
        }
        boolean bl = this._bestEffortNonPersistentMessagesDeleted = !sibRaEndpointActivation.isEndpointMethodTransactional() && !(abstractConsumerSession instanceof BifurcatedConsumerSession);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaNonTransactionalDispatcher");
        }
    }

    protected SITransaction getTransaction() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getTransaction");
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getTransaction", null);
        }
        return null;
    }

    protected final MessageEndpoint createEndpoint() throws UnavailableException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createEndpoint");
        }
        MessageEndpoint messageEndpoint = this._endpointFactory.createEndpoint(null);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createEndpoint", (Object)messageEndpoint);
        }
        return messageEndpoint;
    }

    protected final void beforeDelivery(SIBusMessage sIBusMessage, MessageEndpoint messageEndpoint) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery", (Object)sIBusMessage);
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery");
        }
    }

    protected void afterDelivery(SIBusMessage sIBusMessage, MessageEndpoint messageEndpoint, boolean bl) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"afterDelivery", (Object)new Object[]{sIBusMessage, bl});
        }
        if (!bl && this.processMessage(sIBusMessage)) {
            this._unsuccessfulMessages.add(sIBusMessage);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"afterDelivery");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"cleanup");
        }
        if (this._unsuccessfulMessages.size() > 0) {
            try {
                try {
                    SIUncoordinatedTransaction sIUncoordinatedTransaction = this._connection.createUncoordinatedTransaction();
                    this.deleteMessages(this._unsuccessfulMessages, (SITransaction)sIUncoordinatedTransaction);
                    sIUncoordinatedTransaction.rollback();
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "." + "cleanup"), (String)FFDC_PROBE_2, (Object)this);
                    if (TRACE.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                    }
                }
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, (String)(CLASS_NAME + "." + "cleanup"), (String)FFDC_PROBE_1, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)resourceException));
                }
            }
            finally {
                this._unsuccessfulMessages.clear();
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"cleanup");
        }
    }

    protected boolean processMessage(SIBusMessage sIBusMessage) {
        return !this._bestEffortNonPersistentMessagesDeleted || !Reliability.BEST_EFFORT_NONPERSISTENT.equals(sIBusMessage.getReliability());
    }

    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator sibRaStringGenerator = super.getStringGenerator();
        sibRaStringGenerator.addField("unsuccessfulMessages", this._unsuccessfulMessages);
        return sibRaStringGenerator;
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaNonTransactionalDispatcher.java, SIB.ra, WAS602.SIB, o0610.11 1.17");
        }
    }
}

