/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaMessageDeletionMode;
import com.ibm.ws.sib.ra.inbound.impl.SibRaBatchMessageDeletionDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaListener;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMultiProcessListener;
import com.ibm.ws.sib.ra.inbound.impl.SibRaNonTransactionalDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaSingleMessageDeletionDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaSingleProcessListener;
import com.ibm.ws.sib.ra.inbound.impl.SibRaSynchronizedDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaTransactionalDispatcher;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.selector.FactoryType;
import com.ibm.wsspi.sib.core.selector.SICoreConnectionFactorySelector;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.IllegalStateException;

final class SibRaMessagingEngineConnection {
    private final SibRaEndpointActivation _endpointActivation;
    private final SibRaEndpointConfiguration _endpointConfiguration;
    private final String _busName;
    private final SICoreConnection _connection;
    private final SibRaConnectionListener _connectionListener;
    private final Map _listeners = Collections.synchronizedMap(new HashMap());
    private final Set _dispatchers = Collections.synchronizedSet(new HashSet());
    private volatile boolean _closed = false;
    private static final boolean IS_ZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaMessagingEngineConnection.class);
    private static final TraceComponent LISTENER_TRACE = SibRaUtils.getTraceComponent(SibRaConnectionListener.class);
    private static TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String CLASS_NAME = SibRaMessagingEngineConnection.class.getName();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";
    private static final String FFDC_PROBE_5 = "5";
    private static final String FFDC_PROBE_6 = "6";
    private static final String FFDC_PROBE_7 = "7";
    private static final String FFDC_PROBE_8 = "8";

    SibRaMessagingEngineConnection(SibRaEndpointActivation sibRaEndpointActivation, JsMessagingEngine jsMessagingEngine) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaMessagingEngineConnection", (Object)new Object[]{sibRaEndpointActivation, jsMessagingEngine});
        }
        this._endpointActivation = sibRaEndpointActivation;
        this._endpointConfiguration = sibRaEndpointActivation.getEndpointConfiguration();
        this._busName = jsMessagingEngine.getBusName();
        SICoreConnectionFactory sICoreConnectionFactory = (SICoreConnectionFactory)jsMessagingEngine.getMessageProcessor();
        try {
            this._connection = sICoreConnectionFactory.createConnection(this._endpointConfiguration.getUserName(), this._endpointConfiguration.getPassword(), null);
            this._connectionListener = new SibRaConnectionListener();
            this._connection.addConnectionListener((SICoreConnectionListener)this._connectionListener);
        }
        catch (SIAuthenticationException sIAuthenticationException) {
            FFDCFilter.processException((Throwable)sIAuthenticationException, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)FFDC_PROBE_7, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIAuthenticationException));
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0954", new Object[]{sIAuthenticationException, sICoreConnectionFactory}, null), (Throwable)sIAuthenticationException);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)FFDC_PROBE_1, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0950", new Object[]{sIException, sICoreConnectionFactory}, null), (Throwable)sIException);
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)FFDC_PROBE_2, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0950", new Object[]{sIErrorException, sICoreConnectionFactory}, null), (Throwable)sIErrorException);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaMessagingEngineConnection");
        }
    }

    SibRaMessagingEngineConnection(SibRaEndpointActivation sibRaEndpointActivation, String string, String string2) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaMessagingEngineConnection", (Object)new Object[]{sibRaEndpointActivation, string, string2});
        }
        this._endpointActivation = sibRaEndpointActivation;
        this._endpointConfiguration = sibRaEndpointActivation.getEndpointConfiguration();
        this._busName = string;
        try {
            SICoreConnectionFactory sICoreConnectionFactory = SICoreConnectionFactorySelector.getSICoreConnectionFactory((FactoryType)FactoryType.TRM_CONNECTION);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("busName", string);
            hashMap.put("connectionProximity", "Server");
            hashMap.put("targetType", "MEUuid");
            hashMap.put("targetGroup", string2);
            hashMap.put("targetSignificance", "Required");
            this._connection = sICoreConnectionFactory.createConnection(this._endpointConfiguration.getUserName(), this._endpointConfiguration.getPassword(), hashMap);
            this._connectionListener = new SibRaConnectionListener();
            this._connection.addConnectionListener((SICoreConnectionListener)this._connectionListener);
        }
        catch (SIAuthenticationException sIAuthenticationException) {
            FFDCFilter.processException((Throwable)sIAuthenticationException, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)FFDC_PROBE_8, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIAuthenticationException));
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0955", new Object[]{sIAuthenticationException, string2}, null), (Throwable)sIAuthenticationException);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)FFDC_PROBE_3, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0951", new Object[]{sIException, string2}, null), (Throwable)sIException);
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)FFDC_PROBE_4, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0951", new Object[]{sIErrorException, string2}, null), (Throwable)sIErrorException);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaMessagingEngineConnection");
        }
    }

    SibRaMessagingEngineConnection(SibRaEndpointActivation sibRaEndpointActivation, String string) throws SIException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaMessagingEngineConnection", (Object)new Object[]{sibRaEndpointActivation, string});
        }
        this._endpointActivation = sibRaEndpointActivation;
        this._endpointConfiguration = sibRaEndpointActivation.getEndpointConfiguration();
        this._busName = string;
        SICoreConnectionFactory sICoreConnectionFactory = SICoreConnectionFactorySelector.getSICoreConnectionFactory((FactoryType)FactoryType.TRM_CONNECTION);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("busName", string);
        String string2 = this._endpointConfiguration.getTargetTransportChain();
        if (string2 != null && !"".equals(string2)) {
            hashMap.put("targetTransportChain", string2);
        }
        this._connection = sICoreConnectionFactory.createConnection(this._endpointConfiguration.getUserName(), this._endpointConfiguration.getPassword(), hashMap);
        this._connectionListener = new SibRaConnectionListener();
        this._connection.addConnectionListener((SICoreConnectionListener)this._connectionListener);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaMessagingEngineConnection");
        }
    }

    SICoreConnection getConnection() {
        return this._connection;
    }

    SibRaEndpointActivation getEndpointActivation() {
        return this._endpointActivation;
    }

    SibRaEndpointConfiguration getEndpointConfiguration() {
        return this._endpointConfiguration;
    }

    String getBusName() {
        return this._busName;
    }

    SibRaListener createListener(SIDestinationAddress sIDestinationAddress) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createListener", (Object)sIDestinationAddress);
        }
        if (this._closed) {
            throw new IllegalStateException(NLS.getString("LISTENER_CLOSED_CWSIV0952"));
        }
        SibRaListener sibRaListener = IS_ZOS ? new SibRaMultiProcessListener(this, sIDestinationAddress) : new SibRaSingleProcessListener(this, sIDestinationAddress);
        this._listeners.put(sIDestinationAddress, sibRaListener);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createListener", (Object)sibRaListener);
        }
        return sibRaListener;
    }

    SibRaDispatcher createDispatcher(AbstractConsumerSession abstractConsumerSession) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getDispatcher", (Object)abstractConsumerSession);
        }
        if (this._closed) {
            throw new IllegalStateException(NLS.getString("LISTENER_CLOSED_CWSIV0953"));
        }
        SibRaDispatcher sibRaDispatcher = this._endpointActivation.isEndpointMethodTransactional() ? (this._endpointConfiguration.getShareDataSourceWithCMP() ? new SibRaSynchronizedDispatcher(this._connection, abstractConsumerSession, this._endpointActivation) : new SibRaTransactionalDispatcher(this._connection, abstractConsumerSession, this._endpointActivation, this._busName)) : (SibRaMessageDeletionMode.BATCH.equals(this._endpointConfiguration.getMessageDeletionMode()) ? new SibRaBatchMessageDeletionDispatcher(this._connection, abstractConsumerSession, this._endpointActivation) : (SibRaMessageDeletionMode.SINGLE.equals(this._endpointConfiguration.getMessageDeletionMode()) ? new SibRaSingleMessageDeletionDispatcher(this._connection, abstractConsumerSession, this._endpointActivation) : new SibRaNonTransactionalDispatcher(this._connection, abstractConsumerSession, this._endpointActivation)));
        this._dispatchers.add(sibRaDispatcher);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getDispatcher", (Object)sibRaDispatcher);
        }
        return sibRaDispatcher;
    }

    void closeDispatcher(SibRaDispatcher sibRaDispatcher) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"closeDispatcher");
        }
        this._dispatchers.remove(sibRaDispatcher);
        sibRaDispatcher.close();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"closeDispatcher");
        }
    }

    void close() {
        block9: {
            Object object;
            if (TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"close");
            }
            this._closed = true;
            Iterator<Object> iterator = this._listeners.values().iterator();
            while (iterator.hasNext()) {
                object = (SibRaListener)iterator.next();
                ((SibRaListener)object).stop();
            }
            iterator = this._dispatchers.iterator();
            while (iterator.hasNext()) {
                object = (SibRaDispatcher)iterator.next();
                ((SibRaDispatcher)object).close();
            }
            this._dispatchers.clear();
            iterator = this._listeners.values().iterator();
            while (iterator.hasNext()) {
                object = (SibRaListener)iterator.next();
                ((SibRaListener)object).close();
            }
            this._listeners.clear();
            try {
                this._connection.removeConnectionListener((SICoreConnectionListener)this._connectionListener);
                this._connection.close();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "." + "close"), (String)FFDC_PROBE_5, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                }
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "." + "close"), (String)FFDC_PROBE_6, (Object)this);
                if (!TRACE.isEventEnabled()) break block9;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"close");
        }
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaMessagingEngineConnection.java, SIB.ra, WAS602.SIB, o0610.11 1.13");
        }
    }

    private final class SibRaConnectionListener
    implements SICoreConnectionListener {
        private SibRaConnectionListener() {
        }

        public void asynchronousException(ConsumerSession consumerSession, Throwable throwable) {
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"asynchronousException", (Object)new Object[]{consumerSession, throwable});
            }
            SibRaMessagingEngineConnection.this._endpointActivation.sessionError(SibRaMessagingEngineConnection.this, consumerSession, throwable);
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"asynchronousException");
            }
        }

        public void meQuiescing(SICoreConnection sICoreConnection) {
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meQuiescing", (Object)sICoreConnection);
            }
            SibRaMessagingEngineConnection.this._endpointActivation.messagingEngineQuiescing(SibRaMessagingEngineConnection.this);
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meQuiescing");
            }
        }

        public void commsFailure(SICoreConnection sICoreConnection, SIConnectionLostException sIConnectionLostException) {
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"commsFailure", (Object)new Object[]{sICoreConnection, sIConnectionLostException});
            }
            SibRaMessagingEngineConnection.this._endpointActivation.connectionError(SibRaMessagingEngineConnection.this, (SIException)((Object)sIConnectionLostException));
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"commsFailure");
            }
        }

        public void meTerminated(SICoreConnection sICoreConnection) {
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meTerminated", (Object)sICoreConnection);
            }
            SibRaMessagingEngineConnection.this._endpointActivation.messagingEngineTerminated(SibRaMessagingEngineConnection.this);
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meTerminated");
            }
        }
    }
}

