/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;

public final class SibRaMessageToken
implements Serializable {
    private static final long serialVersionUID = 3701528563970253962L;
    private final String _busName;
    private final String _meUuid;
    private final long _sessionId;
    private final String _j2eeName;
    private ArrayList _messageHandles;
    private transient Map _contextInfo;
    private boolean _bestEfforNonPeristantMessages;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaMessageToken.class);

    SibRaMessageToken(String string, String string2, long l, String string3) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaMessageToken", (Object)new Object[]{string, string2, new Long(l), string3});
        }
        this._busName = string;
        this._meUuid = string2;
        this._sessionId = l;
        this._j2eeName = string3;
        this._messageHandles = new ArrayList();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaMessageToken");
        }
    }

    String getBusName() {
        return this._busName;
    }

    String getJ2EEName() {
        return this._j2eeName;
    }

    SIMessageHandle getMessageHandle(int n) {
        return (SIMessageHandle)this._messageHandles.get(n);
    }

    int getNumberOfMessageHandles() {
        return this._messageHandles.size();
    }

    String getMeUuid() {
        return this._meUuid;
    }

    long getSessionId() {
        return this._sessionId;
    }

    Map getContext() {
        return this._contextInfo;
    }

    void clear() {
        this._bestEfforNonPeristantMessages = false;
        this._messageHandles.clear();
        this._contextInfo = null;
    }

    boolean addHandle(SIMessageHandle sIMessageHandle, Map map, boolean bl) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"addHandle", (Object)new Object[]{sIMessageHandle, map, new Boolean(bl)});
        }
        boolean bl2 = false;
        if (this._messageHandles.isEmpty()) {
            if (TRACE.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TRACE, (String)("No existing message handles - using current message as template <ctxInfo=" + map + "> <isBENP=" + bl + "> <handle= " + sIMessageHandle + ">"));
            }
            this._messageHandles.add(sIMessageHandle);
            this._contextInfo = map;
            this._bestEfforNonPeristantMessages = bl;
            bl2 = true;
        } else if (this.matches(map, bl)) {
            if (TRACE.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TRACE, (String)("Message matched token for supplied handle - adding handle to the token <handle=" + sIMessageHandle + ">"));
            }
            this._messageHandles.add(sIMessageHandle);
            bl2 = true;
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"addHandle", (Object)new Boolean(bl2));
        }
        return bl2;
    }

    boolean matches(Map map, boolean bl) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"matches", (Object)new Object[]{map, new Boolean(bl)});
        }
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)("Attempting to match againgst token <context=" + this._contextInfo + "> <isBENP=" + this._bestEfforNonPeristantMessages));
        }
        boolean bl2 = false;
        if (bl == this._bestEfforNonPeristantMessages && map.size() == this._contextInfo.size() && this._contextInfo.size() == 1) {
            Object k = this._contextInfo.keySet().iterator().next();
            Object k2 = map.keySet().iterator().next();
            if (k != null) {
                Object v = this._contextInfo.get(k);
                Object v2 = map.get(k2);
                boolean bl3 = bl2 = v != null && v.equals(v2) && k != null && k.equals(k2);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"matches", (Object)new Boolean(bl2));
        }
        return bl2;
    }

    SIMessageHandle[] getMessageHandleArray() {
        return this._messageHandles.toArray(new SIMessageHandle[0]);
    }

    public final String toString() {
        SibRaStringGenerator sibRaStringGenerator = new SibRaStringGenerator(this);
        sibRaStringGenerator.addField("busName", this._busName);
        sibRaStringGenerator.addField("j2eeName", this._j2eeName);
        sibRaStringGenerator.addField("messageHandles", this._messageHandles.toArray(new SIMessageHandle[0]));
        sibRaStringGenerator.addField("meUuid", this._meUuid);
        sibRaStringGenerator.addField("sessionId", this._sessionId);
        sibRaStringGenerator.addField("bestEfforNonPeristantMessages", this._bestEfforNonPeristantMessages);
        sibRaStringGenerator.addField("contextInfo", this._contextInfo);
        return sibRaStringGenerator.getStringRepresentation();
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaMessageToken.java, SIB.ra, WAS602.SIB, o0610.11 1.3");
        }
    }
}

