/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaDurableSubscriptionSharing;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaReadAhead;
import com.ibm.ws.sib.ra.inbound.impl.SibRaLockedMessageEnumeration;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessagingEngineConnection;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectionCriteriaFactory;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SIMessageNotLockedException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import com.ibm.wsspi.sib.pacing.AsynchDispatchScheduler;
import com.ibm.wsspi.sib.pacing.AsynchResumeCallback;
import com.ibm.wsspi.sib.pacing.MessagePacingControl;
import com.ibm.wsspi.sib.pacing.MessagePacingControlFactory;
import java.util.List;
import javax.resource.ResourceException;

abstract class SibRaListener
implements AsynchConsumerCallback,
AsynchResumeCallback {
    protected final SibRaMessagingEngineConnection _connection;
    protected final ConsumerSession _session;
    private final SelectionCriteriaFactory _selectionCriteriaFactory;
    protected final int _maxActiveMessages;
    protected final SIDestinationAddress _destinationAddress;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaListener.class);
    private static TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String CLASS_NAME = SibRaListener.class.getName();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_4 = "4";
    private static final String FFDC_PROBE_5 = "5";
    private static final String FFDC_PROBE_6 = "6";
    private static final String FFDC_PROBE_7 = "7";
    private static final String FFDC_PROBE_8 = "8";
    private static final String FFDC_PROBE_9 = "9";
    private static final String FFDC_PROBE_10 = "10";
    private static final String FFDC_PROBE_11 = "11";
    private static final String FFDC_PROBE_12 = "12";
    private static final String FFDC_PROBE_13 = "13";
    private AsynchDispatchScheduler _aysnDispatchScheduler = null;
    protected SibRaLockedMessageEnumeration _cachedEnumeration = null;
    private AsynchDispatchScheduler _cachedAsynchDispatchScheduler;

    SibRaListener(SibRaMessagingEngineConnection sibRaMessagingEngineConnection, SIDestinationAddress sIDestinationAddress) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaListener", (Object)new Object[]{sibRaMessagingEngineConnection, sIDestinationAddress});
        }
        this._connection = sibRaMessagingEngineConnection;
        this._destinationAddress = sIDestinationAddress;
        try {
            this._selectionCriteriaFactory = SelectionCriteriaFactory.getInstance();
            this._session = this.createSession(sIDestinationAddress);
            this._maxActiveMessages = sibRaMessagingEngineConnection.getEndpointConfiguration().getMaxConcurrency();
            int n = sibRaMessagingEngineConnection.getEndpointConfiguration().getMaxBatchSize();
            MessagePacingControl messagePacingControl = MessagePacingControlFactory.getInstance();
            if (messagePacingControl != null && messagePacingControl.isActive()) {
                n = messagePacingControl.overrideMaxBatchSize(sibRaMessagingEngineConnection.getEndpointConfiguration().getBusName(), sIDestinationAddress.getDestinationName(), n);
            }
            int n2 = this.getMaxActiveMessages();
            long l = this.getMessageLockExpiry();
            this._session.registerAsynchConsumerCallback((AsynchConsumerCallback)this, n2, l, n, null);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "." + "SibRaListener"), (String)FFDC_PROBE_1, (Object)this);
            this.close();
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
            }
            throw new ResourceException(NLS.getFormattedMessage("LISTENER_CREATION_CWSIV0900", new Object[]{sIException, sIDestinationAddress.getDestinationName(), sibRaMessagingEngineConnection.getBusName(), sibRaMessagingEngineConnection.getConnection()}, null), (Throwable)sIException);
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "." + "SibRaListener"), (String)FFDC_PROBE_5, (Object)this);
            this.close();
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
            }
            throw new ResourceException(NLS.getFormattedMessage("LISTENER_CREATION_CWSIV0900", new Object[]{sIErrorException, sIDestinationAddress.getDestinationName(), sibRaMessagingEngineConnection.getBusName(), sibRaMessagingEngineConnection.getConnection()}, null), (Throwable)sIErrorException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "SibRaListener"), (String)FFDC_PROBE_2, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
            throw new ResourceException(NLS.getFormattedMessage("SELECTION_FACTORY_CWSIV0901", new Object[]{exception}, null), (Throwable)exception);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaListener");
        }
    }

    void startConsumer() throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"startConsumer");
        }
        try {
            this._session.start(false);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "." + "startConsumer"), (String)FFDC_PROBE_1, (Object)this);
            this.close();
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
            }
            throw new ResourceException(NLS.getFormattedMessage("LISTENER_CREATION_CWSIV0900", new Object[]{sIException, this._session.getDestinationAddress().getDestinationName(), this._connection.getBusName(), this._connection.getConnection()}, null), (Throwable)sIException);
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "." + "startConsumer"), (String)FFDC_PROBE_5, (Object)this);
            this.close();
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
            }
            throw new ResourceException(NLS.getFormattedMessage("LISTENER_CREATION_CWSIV0900", new Object[]{sIErrorException, this._session.getDestinationAddress().getDestinationName(), this._connection.getBusName(), this._connection.getConnection()}, null), (Throwable)sIErrorException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "startConsumer"), (String)FFDC_PROBE_2, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
            throw new ResourceException(NLS.getFormattedMessage("SELECTION_FACTORY_CWSIV0901", new Object[]{exception}, null), (Throwable)exception);
        }
    }

    private final ConsumerSession createSession(SIDestinationAddress sIDestinationAddress) throws SIDurableSubscriptionAlreadyExistsException, SIDurableSubscriptionNotFoundException, SIDurableSubscriptionMismatchException, SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createSession", (Object)new Object[]{sIDestinationAddress});
        }
        SibRaEndpointConfiguration sibRaEndpointConfiguration = this._connection.getEndpointConfiguration();
        Reliability reliability = null;
        Reliability reliability2 = this._connection.getEndpointActivation().isEndpointMethodTransactional() ? Reliability.NONE : Reliability.BEST_EFFORT_NONPERSISTENT;
        DestinationType destinationType = sibRaEndpointConfiguration.getDestinationType();
        String string = sibRaEndpointConfiguration.getMessageSelector();
        String string2 = sibRaEndpointConfiguration.getDiscriminator();
        SelectionCriteria selectionCriteria = this._selectionCriteriaFactory.createSelectionCriteria(string2, string, sibRaEndpointConfiguration.getSelectorDomain());
        boolean bl = this.isSessionBifurcated();
        String string3 = null;
        SICoreConnection sICoreConnection = this._connection.getConnection();
        ConsumerSession consumerSession = null;
        if (sibRaEndpointConfiguration.isDurableSubscription()) {
            String string4 = sibRaEndpointConfiguration.getDurableSubscriptionName();
            String string5 = sibRaEndpointConfiguration.getDurableSubscriptionHome();
            boolean bl2 = SibRaDurableSubscriptionSharing.CLUSTER_ONLY.equals(sibRaEndpointConfiguration.getShareDurableSubscriptions()) ? RuntimeInfo.isClusteredServer() : SibRaDurableSubscriptionSharing.ALWAYS.equals(sibRaEndpointConfiguration.getShareDurableSubscriptions());
            boolean bl3 = SibRaReadAhead.DEFAULT.equals(sibRaEndpointConfiguration.getReadAhead()) ? !bl2 : SibRaReadAhead.ON.equals(sibRaEndpointConfiguration.getReadAhead());
            try {
                consumerSession = sICoreConnection.createConsumerSessionForDurableSubscription(string4, string5, sIDestinationAddress, selectionCriteria, bl2, false, reliability, bl3, reliability2, bl, string3);
            }
            catch (SIDurableSubscriptionNotFoundException sIDurableSubscriptionNotFoundException) {
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIDurableSubscriptionNotFoundException));
                }
                sICoreConnection.createDurableSubscription(string4, string5, sIDestinationAddress, selectionCriteria, bl2, false, string3);
                consumerSession = sICoreConnection.createConsumerSessionForDurableSubscription(string4, string5, sIDestinationAddress, selectionCriteria, bl2, false, reliability, bl3, reliability2, bl, string3);
            }
            catch (SIDurableSubscriptionMismatchException sIDurableSubscriptionMismatchException) {
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIDurableSubscriptionMismatchException));
                }
                sICoreConnection.deleteDurableSubscription(string4, string5);
                sICoreConnection.createDurableSubscription(string4, string5, sIDestinationAddress, selectionCriteria, bl2, false, string3);
                consumerSession = sICoreConnection.createConsumerSessionForDurableSubscription(string4, string5, sIDestinationAddress, selectionCriteria, bl2, false, reliability, bl3, reliability2, bl, string3);
            }
        } else {
            boolean bl4 = SibRaReadAhead.DEFAULT.equals(sibRaEndpointConfiguration.getReadAhead()) ? DestinationType.TOPICSPACE.equals(destinationType) : SibRaReadAhead.ON.equals(sibRaEndpointConfiguration.getReadAhead());
            consumerSession = sICoreConnection.createConsumerSession(sIDestinationAddress, destinationType, selectionCriteria, reliability, bl4, false, reliability2, bl, string3);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createSession", (Object)consumerSession);
        }
        return consumerSession;
    }

    final void close() {
        block7: {
            if (TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"close");
            }
            try {
                if (this._session != null) {
                    this._session.stop();
                    this._session.close();
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "." + "close"), (String)FFDC_PROBE_4, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                }
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "." + "close"), (String)FFDC_PROBE_6, (Object)this);
                if (!TRACE.isEventEnabled()) break block7;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"close");
        }
    }

    final void stop() {
        block7: {
            if (TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"stop");
            }
            try {
                if (this._session != null) {
                    this._session.stop();
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "." + "stop"), (String)FFDC_PROBE_7, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                }
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "." + "stop"), (String)FFDC_PROBE_8, (Object)this);
                if (!TRACE.isEventEnabled()) break block7;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"stop");
        }
    }

    public abstract void internalConsumeMessages(LockedMessageEnumeration var1, AsynchDispatchScheduler var2);

    public synchronized void consumeMessages(LockedMessageEnumeration lockedMessageEnumeration) {
        block10: {
            MessagePacingControl messagePacingControl;
            if (TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"consumeMessages", (Object)lockedMessageEnumeration);
            }
            if ((messagePacingControl = MessagePacingControlFactory.getInstance()) != null && messagePacingControl.isActive()) {
                this._aysnDispatchScheduler = messagePacingControl.preAsynchDispatch(this._connection.getEndpointConfiguration().getBusName(), this._destinationAddress.getDestinationName(), (Object)this);
                if (this._aysnDispatchScheduler.suspendAsynchDispatcher()) {
                    this.createCachedEnumeration(lockedMessageEnumeration, this._aysnDispatchScheduler);
                    try {
                        this._session.stop();
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "." + "consumeMessages"), (String)FFDC_PROBE_9, (Object)this);
                        if (TRACE.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                        }
                        break block10;
                    }
                    catch (SIErrorException sIErrorException) {
                        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "." + "consumeMessages"), (String)FFDC_PROBE_10, (Object)this);
                        if (TRACE.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
                        }
                        break block10;
                    }
                }
                this.internalConsumeMessages(lockedMessageEnumeration, this._aysnDispatchScheduler);
            } else {
                this.internalConsumeMessages(lockedMessageEnumeration, null);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"consumeMessages");
        }
    }

    public synchronized void resume() {
        block6: {
            if (TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"resume");
            }
            this.internalConsumeMessages(this._cachedEnumeration, this._cachedAsynchDispatchScheduler);
            try {
                this._session.start(true);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "." + "resume"), (String)FFDC_PROBE_11, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                }
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "." + "resume"), (String)FFDC_PROBE_12, (Object)this);
                if (!TRACE.isEventEnabled()) break block6;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"resume");
        }
    }

    abstract boolean isSessionBifurcated();

    abstract int getMaxActiveMessages();

    abstract long getMessageLockExpiry();

    static SIMessageHandle[] getMessageHandles(List list) {
        SIMessageHandle[] sIMessageHandleArray = new SIMessageHandle[list.size()];
        for (int i = 0; i < sIMessageHandleArray.length; ++i) {
            SIBusMessage sIBusMessage = (SIBusMessage)list.get(i);
            sIMessageHandleArray[i] = sIBusMessage.getMessageHandle();
        }
        return sIMessageHandleArray;
    }

    public final String toString() {
        return this.getStringGenerator().getStringRepresentation();
    }

    protected abstract void processCachedMessage(SIBusMessage var1, LockedMessageEnumeration var2) throws SISessionDroppedException, SIConnectionDroppedException, SISessionUnavailableException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SIMessageNotLockedException, SIResourceException, SIIncorrectCallException;

    protected void createCachedEnumeration(LockedMessageEnumeration lockedMessageEnumeration, AsynchDispatchScheduler asynchDispatchScheduler) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createCachedEnumeration", (Object)new Object[]{lockedMessageEnumeration, asynchDispatchScheduler});
        }
        this._cachedEnumeration = new SibRaLockedMessageEnumeration();
        this._cachedAsynchDispatchScheduler = asynchDispatchScheduler;
        SIBusMessage sIBusMessage = null;
        try {
            while ((sIBusMessage = lockedMessageEnumeration.nextLocked()) != null) {
                this._cachedEnumeration.add(sIBusMessage);
                this.processCachedMessage(sIBusMessage, lockedMessageEnumeration);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(CLASS_NAME + "." + "createCachedEnumeration"), (String)FFDC_PROBE_13, (Object)this);
            SibTr.error((TraceComponent)TRACE, (String)"RETRIEVE_MESSAGES_CWSIV1100", (Object)new Object[]{throwable, lockedMessageEnumeration});
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createCachedEnumeration");
        }
    }

    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator sibRaStringGenerator = new SibRaStringGenerator(this);
        sibRaStringGenerator.addParent("connection", this._connection);
        sibRaStringGenerator.addField("session", this._session);
        return sibRaStringGenerator;
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaListener.java, SIB.ra, WAS602.SIB, o0610.11 1.17.1.2");
        }
    }
}

