/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.ra.SibRaEngineComponent;
import com.ibm.ws.sib.ra.SibRaMessagingEngineListener;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessagingEngineConnection;
import com.ibm.ws.sib.ra.inbound.impl.SibRaResourceAdapterImpl;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;

abstract class SibRaEndpointActivation
implements SibRaMessagingEngineListener {
    private final MessageEndpointFactory _messageEndpointFactory;
    protected final SibRaEndpointConfiguration _endpointConfiguration;
    private final SibRaEndpointInvoker _endpointInvoker;
    private final WorkManager _workManager;
    protected final Map _connections = new HashMap();
    private final boolean _endpointMethodTransactional;
    private boolean _active = true;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaEndpointActivation.class);
    private static TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String CLASS_NAME = SibRaEndpointActivation.class.getName();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";

    SibRaEndpointActivation(SibRaResourceAdapterImpl sibRaResourceAdapterImpl, MessageEndpointFactory messageEndpointFactory, SibRaEndpointConfiguration sibRaEndpointConfiguration, SibRaEndpointInvoker sibRaEndpointInvoker) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaEndpointActivation", (Object)new Object[]{sibRaResourceAdapterImpl, messageEndpointFactory, sibRaEndpointConfiguration, sibRaEndpointInvoker});
        }
        this._messageEndpointFactory = messageEndpointFactory;
        this._endpointConfiguration = sibRaEndpointConfiguration;
        this._endpointInvoker = sibRaEndpointInvoker;
        Method method = this._endpointInvoker.getEndpointMethod();
        try {
            this._endpointMethodTransactional = this._messageEndpointFactory.isDeliveryTransacted(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            FFDCFilter.processException((Throwable)noSuchMethodException, (String)(CLASS_NAME + "." + "SibRaEndpointActivation"), (String)FFDC_PROBE_1, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)noSuchMethodException);
            }
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("NO_METHOD_CWSIV0550", new Object[]{messageEndpointFactory, noSuchMethodException}, null), (Throwable)noSuchMethodException);
        }
        this._workManager = sibRaResourceAdapterImpl.getBootstrapContext().getWorkManager();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaEndpointActivation");
        }
    }

    abstract void addMessagingEngine(JsMessagingEngine var1) throws ResourceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"deactivate");
        }
        this._active = false;
        SibRaEngineComponent.deregisterMessagingEngineListener((SibRaMessagingEngineListener)this, (String)this._endpointConfiguration.getBusName());
        Map map = this._connections;
        synchronized (map) {
            Iterator iterator = this._connections.values().iterator();
            while (iterator.hasNext()) {
                SibRaMessagingEngineConnection sibRaMessagingEngineConnection = (SibRaMessagingEngineConnection)iterator.next();
                sibRaMessagingEngineConnection.close();
            }
            this._connections.clear();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"deactivate");
        }
    }

    final MessageEndpointFactory getMessageEndpointFactory() {
        return this._messageEndpointFactory;
    }

    final SibRaEndpointConfiguration getEndpointConfiguration() {
        return this._endpointConfiguration;
    }

    final SibRaEndpointInvoker getEndpointInvoker() {
        return this._endpointInvoker;
    }

    final WorkManager getWorkManager() {
        return this._workManager;
    }

    final boolean isEndpointMethodTransactional() {
        return this._endpointMethodTransactional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SibRaMessagingEngineConnection getConnection(JsMessagingEngine jsMessagingEngine) throws ResourceException {
        SibRaMessagingEngineConnection sibRaMessagingEngineConnection;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getConnection", (Object)jsMessagingEngine);
        }
        if (this._active) {
            Map map = this._connections;
            synchronized (map) {
                sibRaMessagingEngineConnection = (SibRaMessagingEngineConnection)this._connections.get(jsMessagingEngine.getUuid().toString());
                if (sibRaMessagingEngineConnection == null) {
                    sibRaMessagingEngineConnection = new SibRaMessagingEngineConnection(this, jsMessagingEngine);
                    this._connections.put(jsMessagingEngine.getUuid().toString(), sibRaMessagingEngineConnection);
                }
            }
        } else {
            throw new IllegalStateException(NLS.getFormattedMessage("ENDPOINT_DEACTIVATED_CWSIV0554", new Object[]{jsMessagingEngine.getUuid(), jsMessagingEngine.getBusName(), this}, null));
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getConnection", (Object)sibRaMessagingEngineConnection);
        }
        return sibRaMessagingEngineConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SibRaMessagingEngineConnection getConnection(String string, String string2) throws ResourceException {
        SibRaMessagingEngineConnection sibRaMessagingEngineConnection;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getConnection", (Object)new Object[]{string, string2});
        }
        if (this._active) {
            Map map = this._connections;
            synchronized (map) {
                sibRaMessagingEngineConnection = (SibRaMessagingEngineConnection)this._connections.get(string2);
                if (sibRaMessagingEngineConnection == null) {
                    sibRaMessagingEngineConnection = new SibRaMessagingEngineConnection(this, string, string2);
                    this._connections.put(string2, sibRaMessagingEngineConnection);
                }
            }
        } else {
            throw new IllegalStateException(NLS.getFormattedMessage("ENDPOINT_DEACTIVATED_CWSIV0554", new Object[]{string2, string, this}, null));
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getConnection", (Object)sibRaMessagingEngineConnection);
        }
        return sibRaMessagingEngineConnection;
    }

    protected final void closeConnection(JsMessagingEngine jsMessagingEngine) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"closeConnection", (Object)jsMessagingEngine);
        }
        this.closeConnection(jsMessagingEngine.getUuid().toString());
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"closeConnection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection(String string) {
        SibRaMessagingEngineConnection sibRaMessagingEngineConnection;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"closeConnection", (Object)string);
        }
        Map map = this._connections;
        synchronized (map) {
            sibRaMessagingEngineConnection = (SibRaMessagingEngineConnection)this._connections.remove(string);
        }
        if (sibRaMessagingEngineConnection != null) {
            sibRaMessagingEngineConnection.close();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"closeConnection");
        }
    }

    public void messagingEngineStarting(JsMessagingEngine jsMessagingEngine) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineStarting", (Object)jsMessagingEngine);
        }
        try {
            this.addMessagingEngine(jsMessagingEngine);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)(CLASS_NAME + "." + "messagingEngineStarting"), (String)FFDC_PROBE_2, (Object)this);
            SibTr.error((TraceComponent)TRACE, (String)"MESSAGING_ENGINE_STARTING_CWSIV0555", (Object)new Object[]{resourceException, jsMessagingEngine.getName(), jsMessagingEngine.getBusName(), this});
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineStarting");
        }
    }

    public void messagingEngineStopping(JsMessagingEngine jsMessagingEngine, int n) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineStopping", (Object)new Object[]{jsMessagingEngine, new Integer(n)});
        }
        this.closeConnection(jsMessagingEngine);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineStopping");
        }
    }

    abstract void sessionError(SibRaMessagingEngineConnection var1, ConsumerSession var2, Throwable var3);

    abstract void connectionError(SibRaMessagingEngineConnection var1, SIException var2);

    abstract void messagingEngineTerminated(SibRaMessagingEngineConnection var1);

    abstract void messagingEngineQuiescing(SibRaMessagingEngineConnection var1);

    public final String toString() {
        return this.getStringGenerator().getStringRepresentation();
    }

    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator sibRaStringGenerator = new SibRaStringGenerator(this);
        sibRaStringGenerator.addField("active", this._active);
        sibRaStringGenerator.addField("connections", this._connections);
        sibRaStringGenerator.addField("messageEndpointFactory", this._messageEndpointFactory);
        sibRaStringGenerator.addField("endpointConfiguration", this._endpointConfiguration);
        sibRaStringGenerator.addField("endpointInvoker", this._endpointInvoker);
        sibRaStringGenerator.addField("workManager", this._workManager);
        sibRaStringGenerator.addField("endpointMethodTransactional", this._endpointMethodTransactional);
        return sibRaStringGenerator;
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaEndpointActivation.java, SIB.ra, WAS602.SIB, o0610.11 1.29");
        }
    }
}

