/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.SelfXARecoverable;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaDurableSubscriptionSharing;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfigurationProvider;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.ra.inbound.SibRaMessageDeletionMode;
import com.ibm.ws.sib.ra.inbound.SibRaReadAhead;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointInvokerImpl;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.sib.zwlmclassifier.WlmClassifierHandlerFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.exitpoint.ra.RAHandlerRegistry;
import com.ibm.wsspi.sib.exitpoint.ra.RAType;
import com.ibm.wsspi.sib.exitpoint.ra.RegistrationException;
import com.ibm.wsspi.sib.ra.SibRaActivationSpec;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;

public final class SibRaActivationSpecImpl
implements SibRaActivationSpec,
SelfXARecoverable,
SibRaEndpointConfigurationProvider {
    private static final String DEFAULT_SHARE_DURABLE_SUBSCRIPTIONS = "InCluster";
    private transient ResourceAdapter _resourceAdapter;
    private String _busName = null;
    private String _userName = null;
    private String _password = null;
    private String _destinationType;
    private String _destinationName = null;
    private String _messageSelector = null;
    private String _discriminator = null;
    private String _subscriptionName = null;
    private String _durableSubscriptionHome = null;
    private String _shareDurableSubscriptions = "InCluster";
    private Integer _maxBatchSize = new Integer(1);
    private String _messageDeletionMode = "Single";
    private Integer _maxConcurrency = new Integer(10);
    private String _xaRecoveryAlias;
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String CLASS_NAME = SibRaActivationSpecImpl.class.getName();
    private static final Map SUBSCRIPTION_SHAREABILITY = new HashMap(3);
    private static final Map DESTINATION_TYPES;
    private static final Map MESSAGE_DELETION_MODES;
    private static final TraceComponent TRACE;
    private static final TraceComponent CONFIG_TRACE;
    private static TraceNLS NLS;

    public void setBusName(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"BusName", (Object)string);
        }
        this._busName = string;
    }

    public String getBusName() {
        return this._busName;
    }

    public void setUserName(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"UserName", (Object)string);
        }
        this._userName = string;
    }

    public String getUserName() {
        return this._userName;
    }

    public void setPassword(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Password", (Object)(string == null ? null : "*****"));
        }
        this._password = string;
    }

    public String getPassword() {
        return this._password;
    }

    public void setDestinationType(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"DestinationType", (Object)string);
        }
        this._destinationType = string;
    }

    public String getDestinationType() {
        return this._destinationType;
    }

    public void setDestinationName(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"DestinationName", (Object)string);
        }
        this._destinationName = string;
    }

    public String getDestinationName() {
        return this._destinationName;
    }

    public void setMessageSelector(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"MessageSelector", (Object)string);
        }
        this._messageSelector = string;
    }

    public String getMessageSelector() {
        return this._messageSelector;
    }

    public void setDiscriminator(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Discriminator", (Object)string);
        }
        this._discriminator = string;
    }

    public String getDiscriminator() {
        return this._discriminator;
    }

    public void setSubscriptionName(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"SubscriptionName", (Object)string);
        }
        this._subscriptionName = string;
    }

    public String getSubscriptionName() {
        return this._subscriptionName;
    }

    public void setDurableSubscriptionHome(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"DurableSubscriptionHome", (Object)string);
        }
        this._durableSubscriptionHome = string;
    }

    public String getDurableSubscriptionHome() {
        return this._durableSubscriptionHome;
    }

    public void setShareDurableSubscriptions(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"ShareDurableSubscriptions", (Object)string);
        }
        this._shareDurableSubscriptions = string;
    }

    public String getShareDurableSubscriptions() {
        return this._shareDurableSubscriptions;
    }

    public void setMaxBatchSize(Integer n) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"MaxBatchSize", (Object)n);
        }
        this._maxBatchSize = n;
    }

    public Integer getMaxBatchSize() {
        return this._maxBatchSize;
    }

    public void setMessageDeletionMode(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"MessageDeletionMode", (Object)string);
        }
        this._messageDeletionMode = string;
    }

    public String getMessageDeletionMode() {
        return this._messageDeletionMode;
    }

    public void setMaxConcurrency(Integer n) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"MaxConcurrency", (Object)n);
        }
        this._maxConcurrency = n;
    }

    public Integer getMaxConcurrency() {
        return this._maxConcurrency;
    }

    public void validate() throws InvalidPropertyException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"validate");
        }
        HashSet<PropertyDescriptor> hashSet = new HashSet<PropertyDescriptor>();
        try {
            if (SibRaActivationSpecImpl.isSet(this._destinationName)) {
                if (!SibRaActivationSpecImpl.isSet(this._busName)) {
                    hashSet.add(new PropertyDescriptor("BusName", SibRaActivationSpec.class));
                }
                if (!DESTINATION_TYPES.keySet().contains(this._destinationType)) {
                    hashSet.add(new PropertyDescriptor("DestinationType", SibRaActivationSpec.class));
                }
                if ("TopicSpace".equals(this._destinationType) && SibRaActivationSpecImpl.isSet(this._subscriptionName)) {
                    if (!SUBSCRIPTION_SHAREABILITY.keySet().contains(this._shareDurableSubscriptions)) {
                        hashSet.add(new PropertyDescriptor("ShareDurableSubscriptions", SibRaActivationSpec.class));
                    }
                    if (!SibRaActivationSpecImpl.isSet(this._durableSubscriptionHome)) {
                        hashSet.add(new PropertyDescriptor("DurableSubscriptionHome", SibRaActivationSpec.class));
                    }
                }
            } else if (!DESTINATION_TYPES.keySet().contains(this._destinationType) || "TopicSpace".equals(this._destinationType)) {
                hashSet.add(new PropertyDescriptor("DestinationType", SibRaActivationSpec.class));
            }
            if (this._maxBatchSize == null || this._maxBatchSize < 1) {
                hashSet.add(new PropertyDescriptor("MaxBatchSize", SibRaActivationSpec.class));
            }
            if (!MESSAGE_DELETION_MODES.keySet().contains(this._messageDeletionMode)) {
                hashSet.add(new PropertyDescriptor("MessageDeletionMode", SibRaActivationSpec.class));
            }
            if (this._maxConcurrency == null || this._maxConcurrency < 1) {
                hashSet.add(new PropertyDescriptor("MaxConcurrency", SibRaActivationSpec.class));
            }
        }
        catch (IntrospectionException introspectionException) {
            FFDCFilter.processException((Throwable)introspectionException, (String)(CLASS_NAME + "." + "validate"), (String)FFDC_PROBE_1, (Object)this);
        }
        if (!hashSet.isEmpty()) {
            PropertyDescriptor[] propertyDescriptorArray = hashSet.toArray(new PropertyDescriptor[hashSet.size()]);
            ArrayList<String> arrayList = new ArrayList<String>(hashSet.size());
            Object object = hashSet.iterator();
            while (object.hasNext()) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)object.next();
                arrayList.add(propertyDescriptor.getDisplayName());
            }
            object = new InvalidPropertyException(NLS.getFormattedMessage("INVALID_PROPERTIES_CWSIV0501", new Object[]{this, arrayList}, null));
            object.setInvalidPropertyDescriptors(propertyDescriptorArray);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, object);
            }
            throw object;
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"validate");
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return this._resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setResourceAdapter", (Object)resourceAdapter);
        }
        this._resourceAdapter = resourceAdapter;
    }

    public void setXARecoveryAlias(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setXARecoveryAlias", (Object)string);
        }
        this._xaRecoveryAlias = string;
    }

    String getXARecoveryAlias() {
        return this._xaRecoveryAlias;
    }

    public String toString() {
        SibRaStringGenerator sibRaStringGenerator = new SibRaStringGenerator(this);
        sibRaStringGenerator.addParent("resourceAdapter", this._resourceAdapter);
        sibRaStringGenerator.addField("busName", this._busName);
        sibRaStringGenerator.addField("userName", this._userName);
        sibRaStringGenerator.addPasswordField("password", this._password);
        sibRaStringGenerator.addField("destinationType", this._destinationType);
        sibRaStringGenerator.addField("destinationName", this._destinationName);
        sibRaStringGenerator.addField("messageSelector", this._messageSelector);
        sibRaStringGenerator.addField("discriminators", this._discriminator);
        sibRaStringGenerator.addField("subscriptionName", this._subscriptionName);
        sibRaStringGenerator.addField("durableSubscriptionHome", this._durableSubscriptionHome);
        sibRaStringGenerator.addField("shareDurableSubscriptions", this._shareDurableSubscriptions);
        sibRaStringGenerator.addField("maxBatchSize", this._maxBatchSize);
        sibRaStringGenerator.addField("messageDeletionMode", this._messageDeletionMode);
        sibRaStringGenerator.addField("maxConcurrency", this._maxConcurrency);
        sibRaStringGenerator.addField("xaRecoveryAlias", this._xaRecoveryAlias);
        return sibRaStringGenerator.getStringRepresentation();
    }

    private static boolean isSet(String string) {
        return string != null && !string.equals("");
    }

    public SibRaEndpointInvoker getEndpointInvoker() throws ResourceAdapterInternalException {
        return new SibRaEndpointInvokerImpl();
    }

    public SibRaEndpointConfiguration getEndpointConfiguration() throws InvalidPropertyException, ResourceAdapterInternalException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getEndpointConfiguration");
        }
        SibRaEndpointConfigurationImpl sibRaEndpointConfigurationImpl = new SibRaEndpointConfigurationImpl();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getEndpointConfiguration", (Object)sibRaEndpointConfigurationImpl);
        }
        return sibRaEndpointConfigurationImpl;
    }

    static {
        SUBSCRIPTION_SHAREABILITY.put(DEFAULT_SHARE_DURABLE_SUBSCRIPTIONS, SibRaDurableSubscriptionSharing.CLUSTER_ONLY);
        SUBSCRIPTION_SHAREABILITY.put("AlwaysShared", SibRaDurableSubscriptionSharing.ALWAYS);
        SUBSCRIPTION_SHAREABILITY.put("NeverShared", SibRaDurableSubscriptionSharing.NEVER);
        DESTINATION_TYPES = new HashMap(4);
        DESTINATION_TYPES.put("Queue", DestinationType.QUEUE);
        DESTINATION_TYPES.put("TopicSpace", DestinationType.TOPICSPACE);
        DESTINATION_TYPES.put("Port", DestinationType.PORT);
        DESTINATION_TYPES.put("Service", DestinationType.SERVICE);
        MESSAGE_DELETION_MODES = new HashMap(3);
        MESSAGE_DELETION_MODES.put("Single", SibRaMessageDeletionMode.SINGLE);
        MESSAGE_DELETION_MODES.put("Batch", SibRaMessageDeletionMode.BATCH);
        MESSAGE_DELETION_MODES.put("Application", SibRaMessageDeletionMode.APPLICATION);
        TRACE = SibRaUtils.getTraceComponent(SibRaActivationSpecImpl.class);
        if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
            try {
                RAHandlerRegistry.register(WlmClassifierHandlerFactory.getInstance().getWlmClassifierHandlerClass(), RAType.CORE, 10);
            }
            catch (RegistrationException registrationException) {
                FFDCFilter.processException((Throwable)registrationException, (String)CLASS_NAME, (String)FFDC_PROBE_3);
                SibTr.error((TraceComponent)TRACE, (String)"WLM_CLASSIFIER_REG_CWSIV0503", (Object)new Object[]{registrationException});
            }
        }
        CONFIG_TRACE = SibRaUtils.getTraceComponent(SibRaEndpointConfigurationImpl.class);
        NLS = SibRaUtils.getTraceNls();
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaActivationSpecImpl.java, SIB.ra, WAS602.SIB, o0610.11 1.20");
        }
    }

    private class SibRaEndpointConfigurationImpl
    implements SibRaEndpointConfiguration {
        private final SIDestinationAddressFactory _destinationAddressFactory;

        private SibRaEndpointConfigurationImpl() throws InvalidPropertyException, ResourceAdapterInternalException {
            if (CONFIG_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)CONFIG_TRACE, (String)"SibRaEndpointConfigurationImpl");
            }
            SibRaActivationSpecImpl.this.validate();
            try {
                this._destinationAddressFactory = SIDestinationAddressFactory.getInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".SibRaEndpointConfigurationImpl." + "SibRaEndpointConfigurationImpl"), (String)SibRaActivationSpecImpl.FFDC_PROBE_2, (Object)this);
                if (CONFIG_TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)CONFIG_TRACE, (Exception)exception);
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("DEST_FACTORY_CWSIV0502", new Object[]{exception}, null), (Throwable)exception);
            }
            if (CONFIG_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)CONFIG_TRACE, (String)"SibRaEndpointConfigurationImpl");
            }
        }

        public SIDestinationAddress getDestination() {
            if (CONFIG_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)CONFIG_TRACE, (String)"getDestination");
            }
            SIDestinationAddress sIDestinationAddress = SibRaActivationSpecImpl.this._destinationName == null ? null : this._destinationAddressFactory.createSIDestinationAddress(SibRaActivationSpecImpl.this._destinationName, false);
            if (CONFIG_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)CONFIG_TRACE, (String)"getDestination", (Object)sIDestinationAddress);
            }
            return sIDestinationAddress;
        }

        public DestinationType getDestinationType() {
            return (DestinationType)DESTINATION_TYPES.get(SibRaActivationSpecImpl.this._destinationType);
        }

        public String getDiscriminator() {
            return SibRaActivationSpecImpl.this._discriminator;
        }

        public int getMaxConcurrency() {
            return SibRaActivationSpecImpl.this._maxConcurrency;
        }

        public int getMaxBatchSize() {
            return SibRaActivationSpecImpl.this._maxBatchSize;
        }

        public String getBusName() {
            return SibRaActivationSpecImpl.this._busName;
        }

        public String getUserName() {
            return SibRaActivationSpecImpl.this._userName;
        }

        public String getPassword() {
            return SibRaActivationSpecImpl.this._password;
        }

        public String getXaRecoveryAlias() {
            return SibRaActivationSpecImpl.this._xaRecoveryAlias;
        }

        public String getMessageSelector() {
            return SibRaActivationSpecImpl.this._messageSelector;
        }

        public String getDurableSubscriptionName() {
            return SibRaActivationSpecImpl.this._subscriptionName;
        }

        public String getDurableSubscriptionHome() {
            return SibRaActivationSpecImpl.this._durableSubscriptionHome;
        }

        public SibRaDurableSubscriptionSharing getShareDurableSubscriptions() {
            return (SibRaDurableSubscriptionSharing)SUBSCRIPTION_SHAREABILITY.get(SibRaActivationSpecImpl.this._shareDurableSubscriptions);
        }

        public SibRaMessageDeletionMode getMessageDeletionMode() {
            return (SibRaMessageDeletionMode)MESSAGE_DELETION_MODES.get(SibRaActivationSpecImpl.this._messageDeletionMode);
        }

        public boolean isDurableSubscription() {
            return "TopicSpace".equals(SibRaActivationSpecImpl.this._destinationType) && SibRaActivationSpecImpl.isSet(SibRaActivationSpecImpl.this._subscriptionName);
        }

        public SelectorDomain getSelectorDomain() {
            return SelectorDomain.SIMESSAGE;
        }

        public boolean getShareDataSourceWithCMP() {
            return false;
        }

        public String getTargetTransportChain() {
            return null;
        }

        public SibRaReadAhead getReadAhead() {
            return SibRaReadAhead.DEFAULT;
        }

        public RAType getRaType() {
            return RAType.CORE;
        }

        public ActivationSpec getActivationSpec() {
            return SibRaActivationSpecImpl.this;
        }

        public String toString() {
            SibRaStringGenerator sibRaStringGenerator = new SibRaStringGenerator(this);
            sibRaStringGenerator.addField("SibRaActivationSpecImpl.this", SibRaActivationSpecImpl.this);
            return sibRaStringGenerator.getStringRepresentation();
        }
    }
}

