/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SIMessageNotLockedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.ra.SibRaNotSupportedException;
import javax.resource.spi.ResourceAdapterInternalException;

final class SibRaAbstractConsumerSession
implements AbstractConsumerSession {
    private final AbstractConsumerSession _delegate;
    private final SICoreConnection _connectionClone;
    private boolean _outOfScope = false;
    private static TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaAbstractConsumerSession.class);
    private static final TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String RA_INBOUND_CONS_PROBE_1 = "RA_INB_CONS1";
    private static final String RA_INBOUND_CONS_PROBE_2 = "RA_INB_CONS2";

    SibRaAbstractConsumerSession(AbstractConsumerSession abstractConsumerSession) throws ResourceAdapterInternalException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaAbstractConsumerSession", (Object)abstractConsumerSession);
        }
        this._delegate = abstractConsumerSession;
        try {
            this._connectionClone = abstractConsumerSession.getConnection().cloneConnection();
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.ra.inbound.impl.SibRaAbstractConsumerSession.SibRaAbstractConsumerSession", (String)RA_INBOUND_CONS_PROBE_1, (Object)this);
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("CLONE_EXCEPTION_CWSIV0700", new Object[]{sIException, abstractConsumerSession}, null), (Throwable)sIException);
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.ra.inbound.impl.SibRaAbstractConsumerSession.SibRaAbstractConsumerSession", (String)RA_INBOUND_CONS_PROBE_2, (Object)this);
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("CLONE_EXCEPTION_CWSIV0700", new Object[]{sIErrorException, abstractConsumerSession}, null), (Throwable)sIErrorException);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaAbstractConsumerSession");
        }
    }

    public void close() throws SibRaNotSupportedException {
        throw new SibRaNotSupportedException(NLS.getFormattedMessage("NOT_SUPPORTED_CWSIV0701", new Object[]{"close"}, null));
    }

    public SICoreConnection getConnection() throws SISessionUnavailableException {
        this.checkInScope();
        return this._connectionClone;
    }

    public SIDestinationAddress getDestinationAddress() {
        return this._delegate.getDestinationAddress();
    }

    private void checkInScope() throws SISessionUnavailableException {
        if (this._outOfScope) {
            throw new SISessionUnavailableException(NLS.getString("OUT_OF_SCOPE_CWSIV0702"));
        }
    }

    void outOfScope() {
        block6: {
            if (TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"outOfScope");
            }
            this._outOfScope = true;
            try {
                this._connectionClone.close();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.ra.inbound.impl.SibRaAbstractConsumerSession.outOfScope", (String)FFDC_PROBE_1, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                }
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.ra.inbound.impl.SibRaAbstractConsumerSession.outOfScope", (String)FFDC_PROBE_2, (Object)this);
                if (!TRACE.isEventEnabled()) break block6;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"outOfScope");
        }
    }

    public void deleteSet(SIMessageHandle[] sIMessageHandleArray, SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIMessageNotLockedException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"deleteSet", (Object)new Object[]{sIMessageHandleArray, sITransaction});
        }
        this.checkInScope();
        this._delegate.deleteSet(sIMessageHandleArray, sITransaction);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"deleteSet");
        }
    }

    public void unlockSet(SIMessageHandle[] sIMessageHandleArray) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIIncorrectCallException, SIMessageNotLockedException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"unlockSet", (Object)new Object[]{sIMessageHandleArray});
        }
        this.checkInScope();
        this._delegate.unlockSet(sIMessageHandleArray);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"unlockSet");
        }
    }

    public String toString() {
        SibRaStringGenerator sibRaStringGenerator = new SibRaStringGenerator(this);
        sibRaStringGenerator.addParent("delegate", this._delegate);
        sibRaStringGenerator.addField("connectionClone", this._connectionClone);
        sibRaStringGenerator.addField("outOfScope", this._outOfScope);
        return sibRaStringGenerator.getStringRepresentation();
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaAbstractConsumerSession.java, SIB.ra, WAS602.SIB, o0610.11 1.16");
        }
    }
}

