/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import java.util.HashMap;
import java.util.Map;
import javax.resource.spi.ConnectionRequestInfo;
import javax.security.auth.Subject;

class SibRaConnectionRequestInfo
implements ConnectionRequestInfo {
    private final String _userName;
    private final String _password;
    private final Subject _subject;
    private final Map _connectionProperties;
    private SICoreConnection _coreConnection;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaConnectionRequestInfo.class);

    SibRaConnectionRequestInfo(String string, String string2, Map map) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaConnectionRequestInfo", (Object)new Object[]{string, string2 == null ? null : "*****", map});
        }
        this._userName = string;
        this._password = string2;
        this._subject = null;
        this._connectionProperties = new HashMap(map);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaConnectionRequestInfo");
        }
    }

    SibRaConnectionRequestInfo(Subject subject, Map map) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaConnectionRequestInfo", (Object)new Object[]{SibRaUtils.subjectToString(subject), map});
        }
        this._userName = null;
        this._password = null;
        this._subject = subject;
        this._connectionProperties = new HashMap(map);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaConnectionRequestInfo");
        }
    }

    String getUserName() {
        return this._userName;
    }

    String getPassword() {
        return this._password;
    }

    Subject getSubject() {
        return this._subject;
    }

    Map getConnectionProperties() {
        return this._connectionProperties;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SibRaConnectionRequestInfo) {
            SibRaConnectionRequestInfo sibRaConnectionRequestInfo = (SibRaConnectionRequestInfo)object;
            if (SibRaUtils.objectsNotEqual(this._userName, sibRaConnectionRequestInfo._userName)) {
                return false;
            }
            if (SibRaUtils.objectsNotEqual(this._password, sibRaConnectionRequestInfo._password)) {
                return false;
            }
            if (SibRaUtils.objectsNotEqual(this._subject, sibRaConnectionRequestInfo._subject)) {
                return false;
            }
            if (SibRaUtils.objectsNotEqual(this._connectionProperties, sibRaConnectionRequestInfo._connectionProperties)) {
                return false;
            }
            return this._coreConnection == null || sibRaConnectionRequestInfo._coreConnection == null || this._coreConnection.isEquivalentTo(sibRaConnectionRequestInfo._coreConnection);
        }
        return false;
    }

    public int hashCode() {
        int n = SibRaUtils.objectHashCode(this._userName);
        n = SibRaUtils.addObjectToHashCode(n, this._password);
        n = SibRaUtils.addObjectToHashCode(n, this._subject);
        n = SibRaUtils.addObjectToHashCode(n, this._connectionProperties);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = SibRaUtils.startToString(this);
        SibRaUtils.addFieldToString(stringBuffer, "userName", this._userName);
        SibRaUtils.addPasswordFieldToString(stringBuffer, "password", this._password);
        SibRaUtils.addFieldToString(stringBuffer, "subject", SibRaUtils.subjectToString(this._subject));
        SibRaUtils.addFieldToString(stringBuffer, "connectionProperties", this._connectionProperties);
        SibRaUtils.addFieldToString(stringBuffer, "coreConnection", this._coreConnection);
        SibRaUtils.endToString(stringBuffer);
        return stringBuffer.toString();
    }

    void setCoreConnection(SICoreConnection sICoreConnection) {
        this._coreConnection = sICoreConnection;
    }

    SICoreConnection getCoreConnection() {
        return this._coreConnection;
    }
}

