/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.sib.ra.impl.SibRaConnectionRequestInfo;
import com.ibm.ws.sib.ra.impl.SibRaManagedConnectionFactory;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

final class SibRaConnectionInfo {
    private final String _userName;
    private final String _password;
    private final Subject _subject;
    private final Map _properties;
    private final SibRaManagedConnectionFactory _managedConnectionFactory;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaConnectionInfo.class);
    private static final TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    static /* synthetic */ Class class$javax$resource$spi$security$PasswordCredential;

    SibRaConnectionInfo(final SibRaManagedConnectionFactory sibRaManagedConnectionFactory, final Subject subject, SibRaConnectionRequestInfo sibRaConnectionRequestInfo) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaConnectionInfo", (Object)new Object[]{sibRaManagedConnectionFactory, SibRaUtils.subjectToString(subject), sibRaConnectionRequestInfo});
        }
        this._managedConnectionFactory = sibRaManagedConnectionFactory;
        this._properties = sibRaConnectionRequestInfo.getConnectionProperties();
        if (subject == null) {
            if (sibRaConnectionRequestInfo.getSubject() == null) {
                this._userName = sibRaConnectionRequestInfo.getUserName();
                this._password = sibRaConnectionRequestInfo.getPassword();
                this._subject = null;
            } else {
                this._userName = null;
                this._password = null;
                this._subject = sibRaConnectionRequestInfo.getSubject();
            }
        } else {
            PasswordCredential passwordCredential = (PasswordCredential)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    Set set = subject.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential == null ? (class$javax$resource$spi$security$PasswordCredential = SibRaConnectionInfo.class$("javax.resource.spi.security.PasswordCredential")) : class$javax$resource$spi$security$PasswordCredential);
                    PasswordCredential passwordCredential = null;
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext() && passwordCredential == null) {
                        PasswordCredential passwordCredential2 = (PasswordCredential)iterator.next();
                        if (!sibRaManagedConnectionFactory.equals(passwordCredential2.getManagedConnectionFactory())) continue;
                        passwordCredential = passwordCredential2;
                    }
                    return passwordCredential;
                }
            });
            if (passwordCredential == null) {
                this._userName = null;
                this._password = null;
                this._subject = subject;
            } else {
                this._userName = passwordCredential.getUserName();
                this._password = String.valueOf(passwordCredential.getPassword());
                this._subject = null;
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaConnectionInfo");
        }
    }

    SICoreConnection createConnection() throws ResourceAdapterInternalException, ResourceException {
        SICoreConnection sICoreConnection;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createConnection");
        }
        SICoreConnectionFactory sICoreConnectionFactory = this._managedConnectionFactory.getCoreFactory();
        try {
            sICoreConnection = this._subject == null ? sICoreConnectionFactory.createConnection(this._userName, this._password, this._properties) : sICoreConnectionFactory.createConnection(this._subject, this._properties);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.ra.impl.SibRaConnectionInfo.createConnection", (String)FFDC_PROBE_1, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
            }
            throw new ResourceException(NLS.getFormattedMessage("CONNECTION_CREATION_CWSIV0300", new Object[]{sIException}, null), (Throwable)sIException);
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.ra.impl.SibRaConnectionInfo.createConnection", (String)FFDC_PROBE_2, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
            }
            throw new ResourceException(NLS.getFormattedMessage("CONNECTION_CREATION_CWSIV0300", new Object[]{sIErrorException}, null), (Throwable)sIErrorException);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)sICoreConnection);
        }
        return sICoreConnection;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SibRaConnectionInfo) {
            SibRaConnectionInfo sibRaConnectionInfo = (SibRaConnectionInfo)object;
            if (SibRaUtils.objectsNotEqual(this._userName, sibRaConnectionInfo._userName)) {
                return false;
            }
            if (SibRaUtils.objectsNotEqual(this._password, sibRaConnectionInfo._password)) {
                return false;
            }
            if (SibRaUtils.objectsNotEqual(this._subject, sibRaConnectionInfo._subject)) {
                return false;
            }
            return !SibRaUtils.objectsNotEqual(this._properties, sibRaConnectionInfo._properties);
        }
        return false;
    }

    public int hashCode() {
        int n = SibRaUtils.objectHashCode(this._userName);
        n = SibRaUtils.addObjectToHashCode(n, this._password);
        n = SibRaUtils.addObjectToHashCode(n, this._subject);
        n = SibRaUtils.addObjectToHashCode(n, this._properties);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = SibRaUtils.startToString(this);
        SibRaUtils.addFieldToString(stringBuffer, "userName", this._userName);
        SibRaUtils.addPasswordFieldToString(stringBuffer, "password", this._password);
        SibRaUtils.addFieldToString(stringBuffer, "subject", SibRaUtils.subjectToString(this._subject));
        SibRaUtils.addFieldToString(stringBuffer, "properties", this._properties);
        SibRaUtils.addFieldToString(stringBuffer, "managedConnectionFactory", this._managedConnectionFactory);
        SibRaUtils.endToString(stringBuffer);
        return stringBuffer.toString();
    }

    String getUserName() {
        return this._userName;
    }

    String getPassword() {
        return this._password;
    }

    String getBusName() {
        return (String)this._properties.get("busName");
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/impl/SibRaConnectionInfo.java, SIB.ra, WAS602.SIB, o0610.11 1.11");
        }
    }
}

