/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaBifurcatedConsumerSession;
import com.ibm.ws.sib.ra.impl.SibRaBrowserSession;
import com.ibm.ws.sib.ra.impl.SibRaConnectionFactory;
import com.ibm.ws.sib.ra.impl.SibRaConnectionRequestInfo;
import com.ibm.ws.sib.ra.impl.SibRaConsumerSession;
import com.ibm.ws.sib.ra.impl.SibRaManagedConnection;
import com.ibm.ws.sib.ra.impl.SibRaProducerSession;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.BifurcatedConsumerSession;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationConfiguration;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.Distribution;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SIInvalidDestinationPrefixException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import com.ibm.wsspi.sib.ra.SibRaAutoCommitTransaction;
import com.ibm.wsspi.sib.ra.SibRaNotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;

final class SibRaConnection
implements SICoreConnection {
    private SibRaManagedConnection _managedConnection;
    private final SibRaConnectionRequestInfo _requestInfo;
    private final SICoreConnection _delegateConnection;
    private boolean _valid = true;
    private SibRaUncoordinatedTransaction _applicationLocalTransaction;
    private SibRaConnectionFactory _connectionFactory;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaConnection.class);
    private static final TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";

    SibRaConnection(SibRaManagedConnection sibRaManagedConnection, SibRaConnectionRequestInfo sibRaConnectionRequestInfo, SICoreConnection sICoreConnection) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaConnection", (Object)new Object[]{sibRaManagedConnection, sibRaConnectionRequestInfo, sICoreConnection});
        }
        this._managedConnection = sibRaManagedConnection;
        this._requestInfo = sibRaConnectionRequestInfo;
        this._delegateConnection = sICoreConnection;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaConnection");
        }
    }

    public byte[] createUniqueId() throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SIResourceException, SIErrorException {
        this.checkValid();
        return this._delegateConnection.createUniqueId();
    }

    public SIDestinationAddress createTemporaryDestination(Distribution distribution, String string) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIInvalidDestinationPrefixException, SIResourceException, SIErrorException {
        this.checkValid();
        return this._delegateConnection.createTemporaryDestination(distribution, string);
    }

    public void close() throws SIConnectionLostException, SIResourceException, SIErrorException, SIConnectionDroppedException, SIConnectionUnavailableException {
        this._delegateConnection.close();
        if (this._managedConnection != null) {
            this._managedConnection.connectionClosed(this);
        }
    }

    public SIUncoordinatedTransaction createUncoordinatedTransaction() throws SIIncorrectCallException, SIConnectionUnavailableException, SIResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createUncoordinatedTransaction");
        }
        this.checkValid();
        if (this._applicationLocalTransaction != null) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(NLS.getString("ACTIVE_LOCAL_TRAN_CWSIV0150"));
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        if (this.getContainerTransaction() != null) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(NLS.getString("ACTIVE_CONTAINER_TRAN_CWSIV0151"));
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        this._applicationLocalTransaction = new SibRaUncoordinatedTransaction(this._delegateConnection.createUncoordinatedTransaction());
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createUncoordinatedTransaction", (Object)this._applicationLocalTransaction);
        }
        return this._applicationLocalTransaction;
    }

    public SIXAResource getSIXAResource() throws SibRaNotSupportedException {
        throw new SibRaNotSupportedException(NLS.getString("XARESOURCE_NOT_SUPPORTED_CWSIV0152"));
    }

    public ProducerSession createProducerSession(SIDestinationAddress sIDestinationAddress, DestinationType destinationType, OrderingContext orderingContext, String string) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException {
        this.checkValid();
        ProducerSession producerSession = this._delegateConnection.createProducerSession(sIDestinationAddress, destinationType, orderingContext, string);
        return new SibRaProducerSession(this, producerSession);
    }

    public ProducerSession createProducerSession(SIDestinationAddress sIDestinationAddress, String string, DestinationType destinationType, OrderingContext orderingContext, String string2) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SITemporaryDestinationNotFoundException, SIDiscriminatorSyntaxException, SIResourceException, SIErrorException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException {
        this.checkValid();
        ProducerSession producerSession = this._delegateConnection.createProducerSession(sIDestinationAddress, string, destinationType, orderingContext, string2);
        return new SibRaProducerSession(this, producerSession);
    }

    public ConsumerSession createConsumerSession(SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, Reliability reliability, boolean bl, boolean bl2, Reliability reliability2, boolean bl3, String string) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        ConsumerSession consumerSession = this._delegateConnection.createConsumerSession(sIDestinationAddress, destinationType, selectionCriteria, reliability, bl, bl2, reliability2, bl3, string);
        return new SibRaConsumerSession(this, consumerSession);
    }

    public void send(SIBusMessage sIBusMessage, SITransaction sITransaction, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, OrderingContext orderingContext, String string) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        this._delegateConnection.send(sIBusMessage, this.mapTransaction(sITransaction), sIDestinationAddress, destinationType, orderingContext, string);
    }

    public SICoreConnection cloneConnection() throws SibRaNotSupportedException {
        throw new SibRaNotSupportedException(NLS.getString("CLONE_NOT_SUPPORTED_CWSIV0153"));
    }

    public boolean isEquivalentTo(SICoreConnection sICoreConnection) {
        boolean bl;
        if (sICoreConnection instanceof SibRaConnection) {
            SICoreConnection sICoreConnection2 = ((SibRaConnection)sICoreConnection)._delegateConnection;
            bl = this._delegateConnection.isEquivalentTo(sICoreConnection2);
        } else {
            bl = this._delegateConnection.isEquivalentTo(sICoreConnection);
        }
        return bl;
    }

    public String getMeName() {
        return this._delegateConnection.getMeName();
    }

    public String getMeUuid() {
        return this._delegateConnection.getMeUuid();
    }

    public void addConnectionListener(SICoreConnectionListener sICoreConnectionListener) throws SIConnectionDroppedException, SIConnectionUnavailableException {
        this.checkValid();
        this._delegateConnection.addConnectionListener(sICoreConnectionListener);
    }

    public void removeConnectionListener(SICoreConnectionListener sICoreConnectionListener) throws SIConnectionDroppedException, SIConnectionUnavailableException {
        this._delegateConnection.removeConnectionListener(sICoreConnectionListener);
    }

    public SICoreConnectionListener[] getConnectionListeners() throws SIConnectionDroppedException, SIConnectionUnavailableException {
        return this._delegateConnection.getConnectionListeners();
    }

    public String getApiLevelDescription() {
        return this._delegateConnection.getApiLevelDescription();
    }

    public long getApiMajorVersion() {
        return this._delegateConnection.getApiMajorVersion();
    }

    public long getApiMinorVersion() {
        return this._delegateConnection.getApiMinorVersion();
    }

    public void sendToExceptionDestination(SIDestinationAddress sIDestinationAddress, SIBusMessage sIBusMessage, int n, String[] stringArray, SITransaction sITransaction, String string) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        this._delegateConnection.sendToExceptionDestination(sIDestinationAddress, sIBusMessage, n, stringArray, this.mapTransaction(sITransaction), string);
    }

    public DestinationConfiguration getDestinationConfiguration(SIDestinationAddress sIDestinationAddress) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SINotAuthorizedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        return this._delegateConnection.getDestinationConfiguration(sIDestinationAddress);
    }

    public void deleteTemporaryDestination(SIDestinationAddress sIDestinationAddress) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SINotAuthorizedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIDestinationLockedException, SIIncorrectCallException {
        this.checkValid();
        this._delegateConnection.deleteTemporaryDestination(sIDestinationAddress);
    }

    public void createDurableSubscription(String string, String string2, SIDestinationAddress sIDestinationAddress, SelectionCriteria selectionCriteria, boolean bl, boolean bl2, String string3) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDurableSubscriptionAlreadyExistsException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        this._delegateConnection.createDurableSubscription(string, string2, sIDestinationAddress, selectionCriteria, bl, bl2, string3);
    }

    public ConsumerSession createConsumerSessionForDurableSubscription(String string, String string2, SIDestinationAddress sIDestinationAddress, SelectionCriteria selectionCriteria, boolean bl, boolean bl2, Reliability reliability, boolean bl3, Reliability reliability2, boolean bl4, String string3) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDurableSubscriptionNotFoundException, SIDurableSubscriptionMismatchException, SIDestinationLockedException, SIResourceException, SIErrorException, SIIncorrectCallException {
        this.checkValid();
        ConsumerSession consumerSession = this._delegateConnection.createConsumerSessionForDurableSubscription(string, string2, sIDestinationAddress, selectionCriteria, bl, bl2, reliability, bl3, reliability2, bl4, string3);
        return new SibRaConsumerSession(this, consumerSession);
    }

    public void deleteDurableSubscription(String string, String string2) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SINotAuthorizedException, SIDurableSubscriptionNotFoundException, SIDestinationLockedException, SIResourceException, SIErrorException, SIIncorrectCallException {
        this.checkValid();
        this._delegateConnection.deleteDurableSubscription(string, string2);
    }

    public SIBusMessage receiveNoWait(SITransaction sITransaction, Reliability reliability, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, Reliability reliability2, String string) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        return this._delegateConnection.receiveNoWait(this.mapTransaction(sITransaction), reliability, sIDestinationAddress, destinationType, selectionCriteria, reliability2, string);
    }

    public SIBusMessage receiveWithWait(SITransaction sITransaction, Reliability reliability, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, Reliability reliability2, long l, String string) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        return this._delegateConnection.receiveWithWait(this.mapTransaction(sITransaction), reliability, sIDestinationAddress, destinationType, selectionCriteria, reliability2, l, string);
    }

    public BrowserSession createBrowserSession(SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, String string) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        BrowserSession browserSession = this._delegateConnection.createBrowserSession(sIDestinationAddress, destinationType, selectionCriteria, string);
        return new SibRaBrowserSession(this, browserSession);
    }

    public OrderingContext createOrderingContext() throws SIConnectionDroppedException, SIConnectionUnavailableException, SIErrorException {
        this.checkValid();
        return this._delegateConnection.createOrderingContext();
    }

    public String getResolvedUserid() throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SIResourceException, SIErrorException {
        this.checkValid();
        return this._delegateConnection.getResolvedUserid();
    }

    public SIDestinationAddress checkMessagingRequired(SIDestinationAddress sIDestinationAddress, SIDestinationAddress sIDestinationAddress2, DestinationType destinationType, String string) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SIResourceException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"checkMessagingRequired");
        }
        SIDestinationAddress sIDestinationAddress3 = this._delegateConnection.checkMessagingRequired(sIDestinationAddress, sIDestinationAddress2, destinationType, string);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"checkMessagingRequired", (Object)sIDestinationAddress3);
        }
        return sIDestinationAddress3;
    }

    public BifurcatedConsumerSession createBifurcatedConsumerSession(long l) throws SISessionDroppedException, SIConnectionDroppedException, SISessionUnavailableException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIResourceException, SIErrorException, SIIncorrectCallException {
        this.checkValid();
        BifurcatedConsumerSession bifurcatedConsumerSession = this._delegateConnection.createBifurcatedConsumerSession(l);
        return new SibRaBifurcatedConsumerSession(this, bifurcatedConsumerSession);
    }

    public String toString() {
        StringBuffer stringBuffer = SibRaUtils.startToString(this);
        SibRaUtils.addFieldToString(stringBuffer, "managedConnection", this._managedConnection);
        SibRaUtils.addFieldToString(stringBuffer, "requestInfo", this._requestInfo);
        SibRaUtils.addFieldToString(stringBuffer, "delegateConnection", this._delegateConnection);
        SibRaUtils.addFieldToString(stringBuffer, "valid", this._valid);
        SibRaUtils.addFieldToString(stringBuffer, "applicationLocalTransaction", this._applicationLocalTransaction);
        SibRaUtils.addFieldToString(stringBuffer, "connectionFactory", this._connectionFactory);
        SibRaUtils.endToString(stringBuffer);
        return stringBuffer.toString();
    }

    SibRaManagedConnection getManagedConnection() {
        return this._managedConnection;
    }

    void setManagedConnection(SibRaManagedConnection sibRaManagedConnection) {
        this._managedConnection = sibRaManagedConnection;
    }

    private SibRaManagedConnection getAssociatedManagedConnection() throws SIResourceException {
        block5: {
            try {
                if (this._managedConnection != null) break block5;
                ConnectionManager connectionManager = this._connectionFactory.getConnectionManager();
                if (connectionManager instanceof LazyAssociatableConnectionManager) {
                    ((LazyAssociatableConnectionManager)connectionManager).associateConnection((Object)this, (ManagedConnectionFactory)this._connectionFactory.getManagedConnectionFactory(), (ConnectionRequestInfo)this._requestInfo);
                    break block5;
                }
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException(NLS.getFormattedMessage("LAZY_ENLIST_NOT_SUPPORTED_CWSIV0154", new Object[]{connectionManager}, null));
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)resourceAdapterInternalException);
                }
                throw resourceAdapterInternalException;
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.sib.ra.impl.SibRaConnection.getAssociatedManagedConnection", (String)FFDC_PROBE_1, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)resourceException));
                }
                throw new SIResourceException(NLS.getFormattedMessage("REASSOCIATION_FAILED_CWSIV0155", new Object[]{resourceException}, null), (Throwable)resourceException);
            }
        }
        return this._managedConnection;
    }

    void invalidate() {
        block4: {
            try {
                this._delegateConnection.close();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.ra.impl.SibRaConnection.invalidate", (String)FFDC_PROBE_2, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                }
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.ra.impl.SibRaConnection.invalidate", (String)FFDC_PROBE_3, (Object)this);
                if (!TRACE.isEventEnabled()) break block4;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
            }
        }
        this._valid = false;
    }

    boolean isValid() {
        return this._valid;
    }

    private void checkValid() throws SIConnectionUnavailableException {
        if (!this._valid) {
            throw new SIConnectionUnavailableException(NLS.getString("INVALID_CONNECTION_CWSIV0156"));
        }
    }

    private SITransaction getContainerTransaction() throws SIResourceException {
        SITransaction sITransaction;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getContainerTransaction");
        }
        try {
            SibRaManagedConnection sibRaManagedConnection = this.getAssociatedManagedConnection();
            sITransaction = sibRaManagedConnection.getContainerTransaction(this._connectionFactory.getConnectionManager());
        }
        catch (ResourceException resourceException) {
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)resourceException));
            }
            throw new SIResourceException(NLS.getFormattedMessage("CONTAINER_TRAN_CWSIV0157", new Object[]{resourceException}, null), (Throwable)resourceException);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getContainerTransaction", (Object)sITransaction);
        }
        return sITransaction;
    }

    SITransaction mapTransaction(SITransaction sITransaction) throws SIIncorrectCallException, SIResourceException {
        SITransaction sITransaction2;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"mapTransaction", (Object)sITransaction);
        }
        if (sITransaction == null) {
            if (this._applicationLocalTransaction != null) {
                SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(NLS.getString("ACTIVE_LOCAL_TRAN_CWSIV0158"));
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIIncorrectCallException));
                }
                throw sIIncorrectCallException;
            }
            sITransaction2 = this.getContainerTransaction();
        } else if (sITransaction instanceof SIUncoordinatedTransaction) {
            if (sITransaction != this._applicationLocalTransaction) {
                SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(NLS.getString("INCORRECT_LOCAL_TRAN_CWSIV0159"));
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIIncorrectCallException));
                }
                throw sIIncorrectCallException;
            }
            sITransaction2 = this._applicationLocalTransaction.getUncoordinatedTransaction();
        } else {
            if (sITransaction instanceof SIXAResource) {
                SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(NLS.getString("INVALID_XARESOURCE_CWSIV0160"));
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIIncorrectCallException));
                }
                throw sIIncorrectCallException;
            }
            if (sITransaction instanceof SibRaAutoCommitTransaction) {
                sITransaction2 = null;
            } else {
                SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(NLS.getFormattedMessage("UNRECOGNISED_TRAN_CWSIV0161", new Object[]{sITransaction}, null));
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIIncorrectCallException));
                }
                throw sIIncorrectCallException;
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"mapTransaction", (Object)sITransaction2);
        }
        return sITransaction2;
    }

    void setConnectionFactory(SibRaConnectionFactory sibRaConnectionFactory) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"setConnectionFactory", (Object)sibRaConnectionFactory);
        }
        this._connectionFactory = sibRaConnectionFactory;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"setConnectionFactory");
        }
    }

    void commitApplicationLocalTransaction() throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"commitApplicationLocalTransaction");
        }
        if (this._applicationLocalTransaction != null) {
            SIUncoordinatedTransaction sIUncoordinatedTransaction = this._applicationLocalTransaction.getUncoordinatedTransaction();
            try {
                sIUncoordinatedTransaction.commit();
            }
            catch (SIException sIException) {
                if (TRACE.isEntryEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                }
                throw new ResourceException(NLS.getFormattedMessage("CONTAINER_COMMIT_FAILED_CWSIV0162", new Object[]{sIException}, null), (Throwable)sIException);
            }
            catch (SIErrorException sIErrorException) {
                if (TRACE.isEntryEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
                }
                throw new ResourceException(NLS.getFormattedMessage("CONTAINER_COMMIT_FAILED_CWSIV0162", new Object[]{sIErrorException}, null), (Throwable)sIErrorException);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"commitApplicationLocalTransaction");
        }
    }

    void rollbackApplicationLocalTransaction() throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"rollbackApplicationLocalTransaction");
        }
        if (this._applicationLocalTransaction != null) {
            SIUncoordinatedTransaction sIUncoordinatedTransaction = this._applicationLocalTransaction.getUncoordinatedTransaction();
            try {
                sIUncoordinatedTransaction.rollback();
            }
            catch (SIException sIException) {
                if (TRACE.isEntryEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                }
                throw new ResourceException(NLS.getFormattedMessage("CONTAINER_ROLLBACK_FAILED_CWSIV0163", new Object[]{sIException}, null), (Throwable)sIException);
            }
            catch (SIErrorException sIErrorException) {
                if (TRACE.isEntryEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
                }
                throw new ResourceException(NLS.getFormattedMessage("CONTAINER_ROLLBACK_FAILED_CWSIV0163", new Object[]{sIErrorException}, null), (Throwable)sIErrorException);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"rollbackApplicationLocalTransaction");
        }
    }

    public boolean isCoreConnectionInValid() {
        return this._delegateConnection == null;
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/impl/SibRaConnection.java, SIB.ra, WAS602.SIB, o0610.11 1.22.1.1");
        }
    }

    private final class SibRaUncoordinatedTransaction
    implements SIUncoordinatedTransaction {
        private final SIUncoordinatedTransaction _delegateUncoordinatedTransaction;

        private SibRaUncoordinatedTransaction(SIUncoordinatedTransaction sIUncoordinatedTransaction) throws SIResourceException {
            if (TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaUncoordinatedTransaction", (Object)sIUncoordinatedTransaction);
            }
            this._delegateUncoordinatedTransaction = sIUncoordinatedTransaction;
            SibRaConnection.this.getAssociatedManagedConnection().localTransactionStarted(SibRaConnection.this);
            if (TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaUncoordinatedTransaction");
            }
        }

        private SIUncoordinatedTransaction getUncoordinatedTransaction() {
            return this._delegateUncoordinatedTransaction;
        }

        public void commit() throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
            if (TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"commit");
            }
            this._delegateUncoordinatedTransaction.commit();
            SibRaConnection.this._applicationLocalTransaction = null;
            SibRaConnection.this.getAssociatedManagedConnection().localTransactionCommitted(SibRaConnection.this);
            if (TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"commit");
            }
        }

        public void rollback() throws SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
            if (TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"rollback");
            }
            this._delegateUncoordinatedTransaction.rollback();
            SibRaConnection.this._applicationLocalTransaction = null;
            SibRaConnection.this.getAssociatedManagedConnection().localTransactionRolledBack(SibRaConnection.this);
            if (TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"rollback");
            }
        }
    }
}

