/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.psb.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.MQRequestReplyUtils;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.psb.config.InboundProfile;
import com.ibm.ws.sib.psb.config.OutboundProfile;
import com.ibm.ws.sib.psb.config.brokers.impl.EBReqReplHelper;
import com.ibm.ws.sib.psb.config.brokers.impl.SIBReqReplHelper;
import com.ibm.ws.sib.psb.impl.DistinctReplyMappingHelper;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.jms.JMSException;

public abstract class RequestReplyHelper {
    private static TraceComponent tc = SibTr.register((Class)RequestReplyHelper.class, (String)"SIBPsb", (String)"com.ibm.ws.sib.psb.CWSILMessages");
    private static Map rrHelpers = null;
    protected static final String TOPIC_SEPARATOR = "/";
    protected static final String PSB_REPLY_PREFIX = "_SPSBReply";

    public RequestReplyHelper() {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.psb.impl/src/com/ibm/ws/sib/psb/impl/RequestReplyHelper.java, SIB.psb, WAS602.SIB, o0610.11 1.10");
        }
    }

    public static RequestReplyHelper getRequestReplyHelper(int n) {
        Integer n2 = new Integer(n);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRequestReplyHelper", (Object)n2);
        }
        if (rrHelpers == null) {
            rrHelpers = new HashMap(3);
            rrHelpers.put(new Integer(2), new EBReqReplHelper());
            rrHelpers.put(new Integer(1), new SIBReqReplHelper());
        }
        RequestReplyHelper requestReplyHelper = null;
        requestReplyHelper = (RequestReplyHelper)rrHelpers.get(n2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRequestReplyHelper", (Object)requestReplyHelper);
        }
        return requestReplyHelper;
    }

    protected abstract boolean isTemporaryTopic(String var1);

    protected abstract String addReplyIdentifier(String var1, OutboundProfile var2);

    protected abstract String addRoutingInfo(String var1, SIBusMessage var2, InboundProfile var3);

    protected abstract String removeReplyIdentifier(String var1, InboundProfile var2);

    protected abstract SIBusMessage parseRoutingInfo(String var1, OutboundProfile var2, SIBusMessage var3, SIUncoordinatedTransaction var4) throws SIException, SIErrorException;

    protected abstract void updateOutboundMsgAttributes(SIBusMessage var1, OutboundProfile var2);

    public DistinctReplyMappingHelper getReplyMappingHelper() {
        return new DistinctRMHImpl();
    }

    public final SIBusMessage processReplyData(SIBusMessage sIBusMessage, InboundProfile inboundProfile, OutboundProfile outboundProfile) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processReplyData", (Object)new Object[]{sIBusMessage, inboundProfile, outboundProfile});
        }
        SIBusMessage sIBusMessage2 = sIBusMessage;
        String string = sIBusMessage.getReplyDiscriminator();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("original reply topic: " + string));
        }
        if (this.isTemporaryTopic(string)) {
            object = this.getReplySubscriptionTopicName(outboundProfile);
            object = this.addRoutingInfo((String)object + TOPIC_SEPARATOR, sIBusMessage, inboundProfile);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Final reply topic: " + (String)object));
            }
            sIBusMessage.setReplyDiscriminator((String)object);
        }
        object = RequestReplyHelper.getRequestReplyHelper(outboundProfile.getBrokerType());
        ((RequestReplyHelper)object).updateOutboundMsgAttributes(sIBusMessage, outboundProfile);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processReplyData", (Object)sIBusMessage2);
        }
        return sIBusMessage2;
    }

    public final SIBusMessage unprocessTopicData(SIBusMessage sIBusMessage, InboundProfile inboundProfile, OutboundProfile outboundProfile, SIUncoordinatedTransaction sIUncoordinatedTransaction) throws SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unprocessTopicData", (Object)new Object[]{sIBusMessage, inboundProfile, outboundProfile, sIUncoordinatedTransaction});
        }
        SIBusMessage sIBusMessage2 = sIBusMessage;
        String string = sIBusMessage.getDiscriminator();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("topic: " + string));
        }
        if (string != null && string.startsWith(PSB_REPLY_PREFIX)) {
            String string2 = string.substring(PSB_REPLY_PREFIX.length() + TOPIC_SEPARATOR.length());
            RequestReplyHelper requestReplyHelper = RequestReplyHelper.getRequestReplyHelper(inboundProfile.getBrokerType());
            String string3 = requestReplyHelper.removeReplyIdentifier(string2, inboundProfile);
            if (string3.startsWith(TOPIC_SEPARATOR)) {
                string3 = string3.substring(TOPIC_SEPARATOR.length());
            }
            sIBusMessage2 = this.parseRoutingInfo(string3, outboundProfile, sIBusMessage2, sIUncoordinatedTransaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unprocessTopicData", (Object)sIBusMessage2);
        }
        return sIBusMessage2;
    }

    public final String getReplySubscriptionTopicName(OutboundProfile outboundProfile) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReplySubscriptionTopicName", (Object)outboundProfile);
        }
        String string = "_SPSBReply/";
        RequestReplyHelper requestReplyHelper = RequestReplyHelper.getRequestReplyHelper(outboundProfile.getBrokerType());
        string = requestReplyHelper.addReplyIdentifier(string, outboundProfile);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReplySubscriptionTopicName", (Object)string);
        }
        return string;
    }

    public final void updateJMSDestination(JsJmsMessage jsJmsMessage, Map map) {
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"updateJMSDestination", (Object)new Object[]{jsJmsMessage, map});
            }
            try {
                MQRequestReplyUtils.getInstance().updateJMSDestinationProperty(jsJmsMessage, "JMSDestination", map);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"RequestReplyHelper.updateJMSDestinationTopic", (String)"updateJMSDestinationTopic#1", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)jMSException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateJMSDestination");
        }
    }

    protected String[] tokenizeWithConditions(String string, String string2, int n) {
        int n2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"tokenizeWithConditions", (Object)new Object[]{string, string2, new Integer(n)});
        }
        String[] stringArray = null;
        Vector<String> vector = new Vector<String>();
        String string3 = string;
        boolean bl = true;
        while (vector.size() < n - 1) {
            n2 = string3.indexOf(string2);
            if (n2 != -1) {
                String string4 = string3.substring(0, n2);
                vector.add(string4);
                string3 = string3.substring(n2 + 1);
                continue;
            }
            bl = false;
            break;
        }
        if (bl) {
            vector.add(string3);
        }
        stringArray = vector.toArray(new String[0]);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Returning array of size " + stringArray.length));
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                SibTr.debug((TraceComponent)tc, (String)("  elt: " + stringArray[n2]));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"tokenizeWithConditions");
        }
        return stringArray;
    }

    class DistinctRMHImpl
    implements DistinctReplyMappingHelper {
        private Vector profileIdentifiers = new Vector();

        DistinctRMHImpl() {
        }

        public boolean isDistinctReplyMappingRequired(OutboundProfile outboundProfile) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"isDistinctReplyMappingRequired", (Object)outboundProfile);
            }
            boolean bl = false;
            String string = "";
            string = RequestReplyHelper.this.addReplyIdentifier(string, outboundProfile);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Checking: " + string));
            }
            if (this.profileIdentifiers.contains(string)) {
                bl = false;
            } else {
                bl = true;
                this.profileIdentifiers.add(string);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"isDistinctReplyMappingRequired", (Object)new Boolean(bl));
            }
            return bl;
        }
    }
}

