/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.psb.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.mqcontrol.MQBrokerCommand;
import com.ibm.ws.sib.mfp.mqcontrol.MQBrokerControlMessage;
import com.ibm.ws.sib.mfp.mqcontrol.MQBrokerMessageFactory;
import com.ibm.ws.sib.mfp.mqinterop.util.HexString;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.psb.PubSubController;
import com.ibm.ws.sib.psb.config.InboundProfile;
import com.ibm.ws.sib.psb.config.MappingProfile;
import com.ibm.ws.sib.psb.config.OutboundProfile;
import com.ibm.ws.sib.psb.config.brokers.EBInboundProfile;
import com.ibm.ws.sib.psb.config.brokers.EBOutboundProfile;
import com.ibm.ws.sib.psb.impl.CommonCallback;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import java.util.ArrayList;

public class EB_PubSubController
implements PubSubController {
    private static final TraceComponent tc = SibTr.register((Class)EB_PubSubController.class, (String)"SIBPsb", (String)"com.ibm.ws.sib.psb.CWSILMessages");

    public void openSubscription(InboundProfile inboundProfile) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"openSubscription");
        }
        try {
            if (inboundProfile == null || !(inboundProfile instanceof EBInboundProfile)) {
                throw new IllegalArgumentException("Expected EBInboundProfile, got " + inboundProfile);
            }
            inboundProfile.setStatus(1);
            EBInboundProfile eBInboundProfile = (EBInboundProfile)inboundProfile;
            SICoreConnection sICoreConnection = eBInboundProfile.getConnection();
            byte[] byArray = eBInboundProfile.getCorrelId();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("CorrelID from profile: " + (byArray == null ? "null" : HexString.hexString((byte[])byArray))));
            }
            MQBrokerControlMessage mQBrokerControlMessage = MQBrokerMessageFactory.instance().createBrokerControlMessage(MQBrokerCommand.REGISTER_SUBSCRIBER);
            int n = 12294;
            mQBrokerControlMessage.setOptions(n);
            String string = eBInboundProfile.getSubscriberQueue().getName();
            EB_PubSubController.setupControlMessage(mQBrokerControlMessage, sICoreConnection, eBInboundProfile, string, string);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Sending register subscription request to event broker for topic " + eBInboundProfile.getInboundEBConvertedTopic() + ", correlId " + HexString.hexString((byte[])byArray)));
            }
            SIDestinationAddress sIDestinationAddress = EB_PubSubController.createSIDestAddressForMQQueue(eBInboundProfile.getBrokerControlName(), eBInboundProfile.getRemoteQMName(), eBInboundProfile.getForeignBusName());
            sICoreConnection.send((SIBusMessage)mQBrokerControlMessage, null, sIDestinationAddress, DestinationType.QUEUE, null, null);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Subscribe request successfully sent.");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"EB_PubSubController.openSubscription", (String)"openSubscription#1");
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"EB_PubSubController.openSubscription", (String)"openSubscription#2");
            inboundProfile.subscriptionOpened(false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"openSubscription");
        }
    }

    public void createConsumer(InboundProfile inboundProfile) {
        block10: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"createConsumer");
            }
            if (inboundProfile == null || !(inboundProfile instanceof EBInboundProfile)) {
                throw new IllegalArgumentException("Expected EBInboundProfile, got " + inboundProfile);
            }
            EBInboundProfile eBInboundProfile = (EBInboundProfile)inboundProfile;
            try {
                if (eBInboundProfile.getConsumer() == null) {
                    SICoreConnection sICoreConnection = inboundProfile.getConnection();
                    MPCoreConnection mPCoreConnection = (MPCoreConnection)sICoreConnection;
                    JsDestinationAddress jsDestinationAddress = eBInboundProfile.getSubscriberQueue().getDestAddress();
                    ConsumerSession consumerSession = mPCoreConnection.createSystemConsumerSession((SIDestinationAddress)jsDestinationAddress, DestinationType.QUEUE, null, Reliability.ASSURED_PERSISTENT, false, true, Reliability.NONE, false);
                    eBInboundProfile.setConsumer(consumerSession);
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"The consumer has already been set up, so we do not create it again.");
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.psb.impl.EB_PubSubController.createConsumer", (String)"createConsumer#1", (Object)this);
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.psb.impl.EB_PubSubController.createConsumer", (String)"createConsumer#2", (Object)this);
                if (!tc.isEventEnabled()) break block10;
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConsumer");
        }
    }

    public void createCallback(MappingProfile mappingProfile) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createCallback");
        }
        if (mappingProfile == null) {
            throw new IllegalArgumentException("Cannot create callback without a mapping profile");
        }
        OutboundProfile outboundProfile = mappingProfile.getOutboundProfile();
        if (outboundProfile.getMessageCallBack() == null) {
            CommonCallback commonCallback = new CommonCallback(mappingProfile);
            outboundProfile.setMessageCallback(commonCallback);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createCallback");
        }
    }

    public void createProducer(OutboundProfile outboundProfile) {
        block11: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"createProducer");
            }
            if (outboundProfile == null || !(outboundProfile instanceof EBOutboundProfile)) {
                throw new IllegalArgumentException("Expected EBOutboundProfile, got " + outboundProfile);
            }
            EBOutboundProfile eBOutboundProfile = (EBOutboundProfile)outboundProfile;
            try {
                if (eBOutboundProfile.getProducer() == null) {
                    SICoreConnection sICoreConnection = outboundProfile.getConnection();
                    SIDestinationAddress sIDestinationAddress = EB_PubSubController.createSIDestAddressForMQQueue(eBOutboundProfile.getBrokerStreamName(), eBOutboundProfile.getRemoteQMName(), eBOutboundProfile.getForeignBusName());
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("brokerStreamName: " + sIDestinationAddress.getDestinationName()));
                        SibTr.debug((TraceComponent)tc, (String)("  foreignBusName: " + sIDestinationAddress.getBusName()));
                    }
                    ProducerSession producerSession = sICoreConnection.createProducerSession(sIDestinationAddress, DestinationType.QUEUE, null, null);
                    eBOutboundProfile.setProducer(producerSession);
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"The producer has already been set up, so we do not create it again.");
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.psb.impl.EB_PubSubController.createProducer", (String)"createProducer#1", (Object)this);
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.psb.impl.EB_PubSubController.createProducer", (String)"createProducer#2", (Object)this);
                if (!tc.isEventEnabled()) break block11;
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createProducer");
        }
    }

    public void closeProducer(OutboundProfile outboundProfile) {
        block6: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"closeProducer");
            }
            if (outboundProfile == null || !(outboundProfile instanceof EBOutboundProfile)) {
                throw new IllegalArgumentException("Expected EBOutboundProfile, got " + outboundProfile);
            }
            try {
                ProducerSession producerSession = outboundProfile.getProducer();
                if (producerSession != null) {
                    producerSession.close();
                    outboundProfile.setProducer(null);
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.psb.impl.EB_PubSubController.closeProducer", (String)"closeProducer#1", (Object)this);
                if (!tc.isEventEnabled()) break block6;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeProducer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeConsumer(InboundProfile inboundProfile) {
        try {
            block8: {
                try {
                    if (tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"closeConsumer(InboundProfile)");
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("inbound : " + inboundProfile));
                    }
                    if (inboundProfile == null) throw new IllegalArgumentException("Expected EBInboundProfile, got " + inboundProfile);
                    if (!(inboundProfile instanceof EBInboundProfile)) {
                        throw new IllegalArgumentException("Expected EBInboundProfile, got " + inboundProfile);
                    }
                    ConsumerSession consumerSession = inboundProfile.getConsumer();
                    if (consumerSession == null) break block8;
                    consumerSession.close();
                    inboundProfile.setConsumer(null);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.psb.impl.EB_PubSubController.closeConsumer", (String)"closeConsumer#1", (Object)this);
                    if (tc.isEventEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                    }
                    Object var4_5 = null;
                    if (!tc.isEntryEnabled()) return;
                    SibTr.exit((TraceComponent)tc, (String)"closeConsumer(InboundProfile)");
                    return;
                }
            }
            Object var4_4 = null;
            if (!tc.isEntryEnabled()) return;
            SibTr.exit((TraceComponent)tc, (String)"closeConsumer(InboundProfile)");
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit((TraceComponent)tc, (String)"closeConsumer(InboundProfile)");
            throw throwable;
        }
    }

    public void closeSubscription(InboundProfile inboundProfile) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeSubscription(InboundProfile)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("inbound : " + inboundProfile));
        }
        if (inboundProfile == null || !(inboundProfile instanceof EBInboundProfile)) {
            throw new IllegalArgumentException("Expected EBInboundProfile, got " + inboundProfile);
        }
        EBInboundProfile eBInboundProfile = (EBInboundProfile)inboundProfile;
        SICoreConnection sICoreConnection = eBInboundProfile.getConnection();
        String string = eBInboundProfile.getSubscriberQueue().getName();
        EB_PubSubController.closeSubscription(eBInboundProfile, sICoreConnection, string, string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeSubscription(InboundProfile)");
        }
    }

    private static void setupControlMessage(MQBrokerControlMessage mQBrokerControlMessage, SICoreConnection sICoreConnection, EBInboundProfile eBInboundProfile, String string, String string2) {
        String string3;
        byte[] byArray;
        String string4;
        String string5;
        block5: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"setupControlMessage");
            }
            string5 = eBInboundProfile.getVirtualQMName();
            string4 = eBInboundProfile.getSubscriptionPoint();
            byArray = eBInboundProfile.getCorrelId();
            string3 = null;
            try {
                string3 = sICoreConnection.getResolvedUserid();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.psb.impl.EB_PubSubController.setupControlMessage", (String)"EB_PubSubController.setupControlMessage");
                if (!tc.isDebugEnabled()) break block5;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(eBInboundProfile.getInboundEBConvertedTopic());
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("topic: " + arrayList.get(0)));
            SibTr.debug((TraceComponent)tc, (String)("subscriberQueue: " + string));
            SibTr.debug((TraceComponent)tc, (String)("replyQueueName: " + string2));
            SibTr.debug((TraceComponent)tc, (String)("replyQueueManager: " + string5));
            SibTr.debug((TraceComponent)tc, (String)("subscriptionPoint: " + string4));
            SibTr.debug((TraceComponent)tc, (String)("userName: " + string3));
            SibTr.debug((TraceComponent)tc, (String)("correlID: " + (byArray == null ? "null" : HexString.hexString((byte[])byArray))));
        }
        mQBrokerControlMessage.setTopics(arrayList);
        mQBrokerControlMessage.setQueueName(string);
        mQBrokerControlMessage.setSubscriptionPoint(string4);
        mQBrokerControlMessage.setReplyQueueName(string2);
        mQBrokerControlMessage.setQueueManagerName(string5);
        mQBrokerControlMessage.setReplyQueueManagerName(string5);
        EB_PubSubController.setupControlMessageApiHeader((JsApiMessage)mQBrokerControlMessage, byArray, byArray, string3);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setupControlMessage");
        }
    }

    protected static void setupControlMessageApiHeader(JsApiMessage jsApiMessage, byte[] byArray, byte[] byArray2, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setupControlMessageApiHeader");
        }
        jsApiMessage.setApiMessageIdAsBytes(byArray);
        jsApiMessage.setCorrelationIdAsBytes(byArray2);
        jsApiMessage.setApiUserId(string);
        jsApiMessage.setTimestamp(System.currentTimeMillis());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setupControlMessageApiHeader");
        }
    }

    public static SIDestinationAddress createSIDestAddressForMQQueue(String string, String string2, String string3) throws Exception {
        SIDestinationAddress sIDestinationAddress;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"createSIDestAddressForMQQueue");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("       queue: " + string));
                SibTr.debug((TraceComponent)tc, (String)("queueManager: " + string2));
                SibTr.debug((TraceComponent)tc, (String)("  foreignBus: " + string3));
            }
            SIDestinationAddress sIDestinationAddress2 = null;
            String string4 = string + "@" + string2;
            sIDestinationAddress = sIDestinationAddress2 = SIDestinationAddressFactory.getInstance().createSIDestinationAddress(string4, string3);
            Object var7_7 = null;
        }
        catch (Exception exception) {
            try {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.psb.impl.EB_PubSubController.createSIDestAddressForMQQueue", (String)"EB_PubSubController.createSIDestAddressForMQQueue");
                throw exception;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var7_8 = null;
                    if (!tc.isEntryEnabled()) break block7;
                    SibTr.exit((TraceComponent)tc, (String)"createSIDestAddressForMQQueue");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSIDestAddressForMQQueue");
        }
        return sIDestinationAddress;
    }

    protected static void closeSubscription(EBInboundProfile eBInboundProfile, SICoreConnection sICoreConnection, String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeSubscription");
        }
        try {
            eBInboundProfile.setStatus(4);
            MQBrokerControlMessage mQBrokerControlMessage = MQBrokerMessageFactory.instance().createBrokerControlMessage(MQBrokerCommand.DEREGISTER_SUBSCRIBER);
            int n = 6;
            mQBrokerControlMessage.setOptions(n);
            EB_PubSubController.setupControlMessage(mQBrokerControlMessage, sICoreConnection, eBInboundProfile, string, string2);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Sending deregister subscription to event broker for topic " + eBInboundProfile.getInboundEBConvertedTopic() + ", correlId " + HexString.hexString((byte[])eBInboundProfile.getCorrelId())));
            }
            SIDestinationAddress sIDestinationAddress = EB_PubSubController.createSIDestAddressForMQQueue(eBInboundProfile.getBrokerControlName(), eBInboundProfile.getRemoteQMName(), eBInboundProfile.getForeignBusName());
            sICoreConnection.send((SIBusMessage)mQBrokerControlMessage, null, sIDestinationAddress, DestinationType.QUEUE, null, null);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"EB_PubSubController.closeSubscription", (String)"closeSubscription#1");
            eBInboundProfile.subscriptionClosed(false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeSubscription");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.psb.impl/src/com/ibm/ws/sib/psb/impl/EB_PubSubController.java, SIB.psb, WAS602.SIB, o0610.11 1.47");
        }
    }
}

