/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.psb.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.psb.config.InboundProfile;
import com.ibm.ws.sib.psb.config.MappingProfile;
import com.ibm.ws.sib.psb.config.OutboundProfile;
import com.ibm.ws.sib.psb.impl.RequestReplyHelper;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;

public class CommonCallback
implements AsynchConsumerCallback {
    private static final TraceComponent tc = SibTr.register((Class)CommonCallback.class, (String)"SIBPsb", (String)"com.ibm.ws.sib.psb.CWSILMessages");
    private MappingProfile profile = null;
    private OutboundProfile outbound = null;
    private InboundProfile inbound = null;
    private ProducerSession producer = null;
    private String tranMessageType = null;
    private boolean alwaysUseTransaction = false;

    public CommonCallback(MappingProfile mappingProfile) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"CommonCallback(MappingProfile)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("_profile : " + mappingProfile));
        }
        this.profile = mappingProfile;
        this.outbound = this.profile.getOutboundProfile();
        this.inbound = this.profile.getInboundProfile();
        this.producer = this.outbound.getProducer();
        this.tranMessageType = this.profile.getTransactionalitySettings().getMessageType();
        if ("ALL".equals(this.tranMessageType)) {
            this.alwaysUseTransaction = true;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("alwaysUseTransaction is " + this.alwaysUseTransaction));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"CommonCallback(MappingProfile)", (Object)this);
        }
    }

    public final void consumeMessages(LockedMessageEnumeration lockedMessageEnumeration) {
        block40: {
            block39: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"consumeMessages(LockedMessageEnumeration)");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("lockedMessages : " + lockedMessageEnumeration));
                }
                SIUncoordinatedTransaction sIUncoordinatedTransaction = null;
                try {
                    SIBusMessage sIBusMessage;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("message count is " + lockedMessageEnumeration.getRemainingMessageCount()));
                    }
                    RequestReplyHelper requestReplyHelper = RequestReplyHelper.getRequestReplyHelper(this.inbound.getBrokerType());
                    RequestReplyHelper requestReplyHelper2 = RequestReplyHelper.getRequestReplyHelper(this.outbound.getBrokerType());
                    while ((sIBusMessage = lockedMessageEnumeration.nextLocked()) != null) {
                        Reliability reliability;
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("message received is " + sIBusMessage));
                        }
                        SIUncoordinatedTransaction sIUncoordinatedTransaction2 = null;
                        boolean bl = true;
                        if (!this.alwaysUseTransaction) {
                            if ("PERSISTENT".equals(this.tranMessageType)) {
                                reliability = sIBusMessage.getReliability();
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("message reliability is " + reliability));
                                }
                                bl = CommonCallback.isPersistent(reliability);
                            } else {
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Unknown message type: " + this.tranMessageType));
                                }
                                bl = true;
                            }
                        } else if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Always use a transaction to process message.");
                        }
                        if (sIUncoordinatedTransaction == null && bl) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Creating a transaction (first time in this invocation)");
                            }
                            reliability = this.outbound.getConnection();
                            sIUncoordinatedTransaction = reliability.createUncoordinatedTransaction();
                        }
                        if (bl) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Receiving this message under a transaction");
                            }
                            sIUncoordinatedTransaction2 = sIUncoordinatedTransaction;
                        } else {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Receiving this message outside a transaction");
                            }
                            sIUncoordinatedTransaction2 = null;
                        }
                        reliability = null;
                        JsJmsMessage jsJmsMessage = this.inbound.convertInboundToCanonicalForm(sIBusMessage);
                        if (jsJmsMessage != null) {
                            reliability = this.outbound.convertCanonicalFormToOutbound(jsJmsMessage);
                            if (reliability != null) {
                                reliability = requestReplyHelper.processReplyData((SIBusMessage)reliability, this.inbound, this.outbound);
                            }
                            if (reliability != null) {
                                reliability = requestReplyHelper2.unprocessTopicData((SIBusMessage)reliability, this.inbound, this.outbound, sIUncoordinatedTransaction2);
                            }
                        }
                        if (reliability != null) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Send the message");
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("destination: " + this.producer.getDestinationAddress()));
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("      topic: " + reliability.getDiscriminator()));
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("reversePath: " + reliability.getReverseRoutingPath()));
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)(" replyTopic: " + reliability.getReplyDiscriminator()));
                            }
                            this.producer.send((SIBusMessage)reliability, (SITransaction)sIUncoordinatedTransaction2);
                        } else if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"No message was returned from processMessage");
                        }
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Delete the message from the LME");
                        }
                        lockedMessageEnumeration.deleteCurrent((SITransaction)sIUncoordinatedTransaction2);
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"All messages for this LME have been processed.");
                    }
                    if (sIUncoordinatedTransaction != null) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Commit the transaction");
                        }
                        sIUncoordinatedTransaction.commit();
                    }
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.psb.impl.CommonCallback.consumeMessages", (String)"consumeMessages#1", (Object)this);
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIException));
                    }
                    if (sIUncoordinatedTransaction == null) break block39;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Try to commit the transaction following the exception");
                    }
                    try {
                        sIUncoordinatedTransaction.commit();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.psb.impl.CommonCallback.consumeMessages", (String)"consumeMessages#2", (Object)this);
                        if (!tc.isEventEnabled()) break block39;
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                    }
                }
            }
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Call unlock in case there are still messages locked");
                }
                lockedMessageEnumeration.getConsumerSession().unlockAll();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.psb.impl.CommonCallback.consumeMessages", (String)"consumeMessages#3", (Object)this);
                if (!tc.isEventEnabled()) break block40;
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"consumeMessages(LockedMessageEnumeration)");
        }
    }

    public MappingProfile getProfile() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProfile()");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("return MappingProfile : " + this.profile));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProfile()");
        }
        return this.profile;
    }

    public OutboundProfile getOutbound() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getOutbound()");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("return OutboundProfile : " + this.outbound));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getOutbound()");
        }
        return this.outbound;
    }

    public InboundProfile getInbound() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getInbound()");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("return InboundProfile : " + this.inbound));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getInbound()");
        }
        return this.inbound;
    }

    public ProducerSession getProducer() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProducer()");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("return ProducerSession : " + this.producer));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProducer()");
        }
        return this.producer;
    }

    public static boolean isPersistent(Reliability reliability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isPersistent(Reliability)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("reliability : " + reliability));
        }
        boolean bl = false;
        if (reliability == Reliability.ASSURED_PERSISTENT || reliability == Reliability.RELIABLE_PERSISTENT) {
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return boolean : " + bl));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isPersistent(Reliability)");
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.psb.impl/src/com/ibm/ws/sib/psb/impl/CommonCallback.java, SIB.psb, WAS602.SIB, o0610.11 1.20");
        }
    }
}

