/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.psb.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.exception.WsRuntimeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.MessageStoreInterface;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.psb.BridgeController;
import com.ibm.ws.sib.psb.DestinationManager;
import com.ibm.ws.sib.psb.MappingProfileRegistry;
import com.ibm.ws.sib.psb.PSBFactory;
import com.ibm.ws.sib.psb.PSBFactoryPoint;
import com.ibm.ws.sib.psb.PubSubController;
import com.ibm.ws.sib.psb.ReceiptManager;
import com.ibm.ws.sib.psb.admin.BridgeControllerAdmin;
import com.ibm.ws.sib.psb.config.BrokerItemStream;
import com.ibm.ws.sib.psb.config.InboundProfile;
import com.ibm.ws.sib.psb.config.MappingProfile;
import com.ibm.ws.sib.psb.config.OutboundProfile;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;

public class BridgeControllerImpl
implements BridgeController {
    private static final TraceComponent tc = SibTr.register((Class)BridgeControllerImpl.class, (String)"SIBPsb", (String)"com.ibm.ws.sib.psb.CWSILMessages");
    private BridgeControllerAdmin adminConfig = null;
    private PSBFactory factory = null;
    private MappingProfileRegistry registry = null;
    private SICoreConnection coreConnection = null;
    private ReceiptManager receiptManager = null;
    private BrokerItemStream stateStream = null;
    private boolean wasStarted = false;
    private JsMessagingEngine engine;
    private String mqLinkName;
    private String mqLinkUuid;
    private String brokerQMgrName;

    public BridgeControllerImpl(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"BridgeControllerImpl");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("adminConfig: " + object));
        }
        if (object == null || !(object instanceof BridgeControllerAdmin)) {
            throw new IllegalArgumentException("BridgeControllerImpl, invalid 'adminConfig' parameter " + this.adminConfig + ".");
        }
        this.adminConfig = (BridgeControllerAdmin)object;
        this.engine = this.adminConfig.getEngine();
        this.mqLinkName = this.adminConfig.getMQLinkName();
        this.mqLinkUuid = this.adminConfig.getMQLinkUuid();
        this.brokerQMgrName = this.adminConfig.getBrokerQMgrName();
        this.factory = PSBFactoryPoint.getInstance();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"BridgeControllerImpl");
        }
    }

    public SICoreConnection getCoreConnection() throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCoreConnection()");
        }
        if (this.coreConnection == null) {
            throw new IllegalStateException("core connection is null, call start() before this method.");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return SICoreConnection : " + this.coreConnection));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCoreConnection()");
        }
        return this.coreConnection;
    }

    public BrokerItemStream getStateStream() throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStateStream()");
        }
        if (this.stateStream == null) {
            throw new IllegalStateException("state stream is null, call start() before this method.");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return ItemStream : " + this.stateStream));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStateStream()");
        }
        return this.stateStream;
    }

    public MappingProfileRegistry getMappingRegistry() throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMappingRegistry()");
        }
        if (this.registry == null) {
            throw new IllegalStateException("registry is null, call start() before this method.");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return MappingProfileRegistry : " + this.registry));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMappingRegistry()");
        }
        return this.registry;
    }

    public PubSubController getPubSubController(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubController");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("brokerType: " + n));
        }
        PubSubController pubSubController = this.factory.getPubSubController(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPubSubController");
        }
        return pubSubController;
    }

    public DestinationManager getDestinationManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationManager");
        }
        DestinationManager destinationManager = this.factory.getDestinationManager();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("returns: " + destinationManager));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationManager");
        }
        return destinationManager;
    }

    public void start() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        MappingProfile[] mappingProfileArray;
        MappingProfile[] mappingProfileArray2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start()");
        }
        try {
            this.coreConnection = this.factory.createLocalConnection(this.engine);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"BridgeController.start", (String)"start#1");
            if (tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            }
            throw new WsRuntimeException((Throwable)sIException);
        }
        try {
            mappingProfileArray2 = this.factory.getItemStreamManager();
            mappingProfileArray = (MappingProfile[])this.coreConnection;
            ItemStream itemStream = mappingProfileArray.getMQLinkPubSubBridgeItemStream(this.mqLinkUuid);
            object5 = (MessageStoreInterface)this.engine.getMessageStore();
            object4 = object5.getTransactionFactory();
            object3 = object4.createAutoCommitTransaction();
            object2 = this.getBrokerItemStreamName();
            this.stateStream = mappingProfileArray2.open((String)object2, itemStream, (Transaction)object3);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"BridgeController.start", (String)"start#2");
            if (tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            }
            throw new WsRuntimeException((Throwable)sIException);
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"BridgeController.start", (String)"start#3");
            if (tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            }
            throw new WsRuntimeException((Throwable)((Object)messageStoreException));
        }
        this.registry = this.factory.createProfileRegistry(this);
        this.receiptManager = this.factory.getReceiptManager();
        mappingProfileArray2 = this.factory.getAdminReader().process(this.adminConfig, this);
        this.registry.merge(mappingProfileArray2);
        mappingProfileArray = this.registry.getInactiveProfiles();
        for (int i = 0; i < mappingProfileArray.length; ++i) {
            object5 = mappingProfileArray[i];
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("inactive profile " + i + " is " + object5));
            }
            object4 = object5.getInboundProfile();
            object4.setCleanup(true);
            int n = object4.getBrokerType();
            object2 = this.getPubSubController(n);
            object2.createConsumer((InboundProfile)object4);
            object = object5.getOutboundProfile();
            int n2 = object.getBrokerType();
            PubSubController pubSubController = this.getPubSubController(n2);
            pubSubController.createCallback((MappingProfile)object5);
            object2.openSubscription((InboundProfile)object4);
            this.receiptManager.registerMessageCallback((MappingProfile)object5);
            object2.closeSubscription((InboundProfile)object4);
        }
        MappingProfile[] mappingProfileArray3 = this.registry.getActiveProfiles();
        for (int i = 0; i < mappingProfileArray3.length; ++i) {
            object4 = mappingProfileArray3[i];
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("active profile " + i + " is " + object4));
            }
            object3 = object4.getInboundProfile();
            int n = object3.getBrokerType();
            object = this.getPubSubController(n);
            object.createConsumer((InboundProfile)object3);
            OutboundProfile outboundProfile = object4.getOutboundProfile();
            int n3 = outboundProfile.getBrokerType();
            PubSubController pubSubController = this.getPubSubController(n3);
            pubSubController.createProducer(outboundProfile);
            pubSubController.createCallback((MappingProfile)object4);
            object.openSubscription((InboundProfile)object3);
            this.receiptManager.registerMessageCallback((MappingProfile)object4);
        }
        this.wasStarted = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start()");
        }
    }

    public void stop() {
        MappingProfile[] mappingProfileArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        if ((mappingProfileArray = this.registry.getActiveProfiles()) != null) {
            for (int i = 0; i < mappingProfileArray.length; ++i) {
                if (this.receiptManager != null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("theProfiles[" + i + "]: " + mappingProfileArray[i]));
                    }
                    this.receiptManager.deregister(mappingProfileArray[i]);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)"ReceiptManager is null (error case)");
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"registry.getProfiles returned null (prohibited by javadoc)");
        }
    }

    public String getBrokerItemStreamName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBrokerItemStreamName()");
        }
        String string = "PSB." + this.mqLinkUuid + "." + this.brokerQMgrName;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return String : " + string));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBrokerItemStreamName()");
        }
        return string;
    }

    public JsMessagingEngine getEngine() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEngine()");
        }
        JsMessagingEngine jsMessagingEngine = this.engine;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return JsMessagingEngine : " + jsMessagingEngine));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEngine()");
        }
        return jsMessagingEngine;
    }

    public boolean wasStarted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"wasStarted()");
        }
        boolean bl = this.wasStarted;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return boolean : " + bl));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"wasStarted()");
        }
        return bl;
    }

    public String getMQLinkUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQLinkUuid()");
        }
        String string = this.mqLinkUuid;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return String : " + string));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMQLinkUuid()");
        }
        return string;
    }

    public BridgeControllerAdmin getBridgeControllerAdmin() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBridgeControllerAdmin");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBridgeControllerAdmin");
        }
        return this.adminConfig;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.psb.impl/src/com/ibm/ws/sib/psb/impl/BridgeControllerImpl.java, SIB.psb, WAS602.SIB, o0610.11 1.43");
        }
    }
}

