/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.psb.config.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.admin.SIBPSBSubscription;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.psb.BridgeController;
import com.ibm.ws.sib.psb.DestinationManager;
import com.ibm.ws.sib.psb.PubSubController;
import com.ibm.ws.sib.psb.config.BrokerItemStream;
import com.ibm.ws.sib.psb.config.DestinationData;
import com.ibm.ws.sib.psb.config.InboundProfile;
import com.ibm.ws.sib.psb.config.MappingProfile;
import com.ibm.ws.sib.psb.config.OutboundProfile;
import com.ibm.ws.sib.psb.config.TransactionalitySettings;
import com.ibm.ws.sib.psb.config.brokers.EBInboundProfile;
import com.ibm.ws.sib.psb.config.brokers.EBOutboundProfile;
import com.ibm.ws.sib.psb.config.brokers.SIBInboundProfile;
import com.ibm.ws.sib.psb.config.brokers.SIBOutboundProfile;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MappingProfileImpl
extends Item
implements MappingProfile {
    private static final TraceComponent tc = SibTr.register((Class)MappingProfileImpl.class, (String)"SIBPsb", (String)"com.ibm.ws.sib.psb.CWSILMessages");
    private static final long serialVersionUID = 6763369417168956113L;
    private InboundProfile inbound = null;
    private OutboundProfile outbound = null;
    private TransactionalitySettings transactionality = null;
    private transient boolean active = false;
    private transient BridgeController bridgeController = null;
    private transient BrokerItemStream itemStream = null;
    private transient MappingProfile linkedProfile = null;

    public MappingProfileImpl() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MappingProfileImpl()");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MappingProfileImpl()");
        }
    }

    public MappingProfileImpl(BridgeController bridgeController, InboundProfile inboundProfile, OutboundProfile outboundProfile, TransactionalitySettings transactionalitySettings) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MappingProfileImpl(BridgeController, InboundProfile, OutboundProfile, TransactionalitySettings)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("bridgeController : " + bridgeController));
            SibTr.debug((TraceComponent)tc, (String)("InboundProfile : " + inboundProfile));
            SibTr.debug((TraceComponent)tc, (String)("OutboundProfile : " + outboundProfile));
            SibTr.debug((TraceComponent)tc, (String)("TransactionalitySettings : " + transactionalitySettings));
        }
        if (inboundProfile == null) {
            throw new IllegalArgumentException("null InboundProfile");
        }
        if (outboundProfile == null) {
            throw new IllegalArgumentException("null OutboundProfile");
        }
        if (transactionalitySettings == null) {
            throw new IllegalArgumentException("null TransactionalitySettings");
        }
        this.setBridgeController(bridgeController);
        this.inbound = inboundProfile;
        this.outbound = outboundProfile;
        this.transactionality = transactionalitySettings;
        if (this.inbound != null) {
            this.inbound.setMappingProfile(this);
        }
        if (this.outbound != null) {
            this.outbound.setMappingProfile(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MappingProfileImpl(BridgeController, InboundProfile, OutboundProfile, TransactionalitySettings)");
        }
    }

    public InboundProfile getInboundProfile() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInboundProfile");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("inbound: " + this.inbound));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getInboundProfile");
        }
        return this.inbound;
    }

    public OutboundProfile getOutboundProfile() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getOutboundProfile");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("outbound: " + this.outbound));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getOutboundProfile");
        }
        return this.outbound;
    }

    public void setActive(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setActive");
        }
        this.active = bl;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("active: " + this.active));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setActive");
        }
    }

    public boolean isActive() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isActive");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("profile: " + this));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("returns: " + this.active));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isActive");
        }
        return this.active;
    }

    public TransactionalitySettings getTransactionalitySettings() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionalitySettings");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("returns: " + this.transactionality));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransactionalitySettings");
        }
        return this.transactionality;
    }

    public DestinationData[] getDestinations() {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinations");
        }
        DestinationData[] destinationDataArray = this.inbound.getDestinations();
        DestinationData[] destinationDataArray2 = this.outbound.getDestinations();
        int n2 = 0;
        if (destinationDataArray != null) {
            n2 += destinationDataArray.length;
        }
        if (destinationDataArray2 != null) {
            n2 += destinationDataArray2.length;
        }
        DestinationData[] destinationDataArray3 = new DestinationData[n2];
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"inbound destinations");
        }
        if (destinationDataArray != null) {
            for (n = 0; n < destinationDataArray.length; ++n) {
                destinationDataArray3[n] = destinationDataArray[n];
                if (!tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("allDests[" + n + "]: " + destinationDataArray3[n]));
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"outbound destinations");
        }
        if (destinationDataArray2 != null) {
            for (n = 0; n < destinationDataArray2.length; ++n) {
                int n3 = destinationDataArray.length + n;
                destinationDataArray3[n3] = destinationDataArray2[n];
                if (!tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("allDests[" + n3 + "]: " + destinationDataArray3[n3]));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinations");
        }
        return destinationDataArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add() {
        try {
            try {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"add()");
                }
                this.itemStream.addItem(this);
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"MappingProfileImpl.add", (String)"add#1");
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                }
                Object var3_2 = null;
                if (!tc.isEntryEnabled()) return;
                SibTr.exit((TraceComponent)tc, (String)"add()");
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit((TraceComponent)tc, (String)"add()");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((TraceComponent)tc, (String)"add()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() throws IllegalStateException {
        try {
            try {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"save()");
                }
                ((BrokerItemStream)((Object)this.getItemStream())).requestItemUpdate(this);
            }
            catch (NotInMessageStore notInMessageStore) {
                FFDCFilter.processException((Throwable)((Object)notInMessageStore), (String)"MappingProfileImpl.save", (String)"save#1");
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)notInMessageStore));
                }
                Object var3_2 = null;
                if (!tc.isEntryEnabled()) return;
                SibTr.exit((TraceComponent)tc, (String)"save()");
                return;
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"MappingProfileImpl.save", (String)"save#2");
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                }
                Object var3_3 = null;
                if (!tc.isEntryEnabled()) return;
                SibTr.exit((TraceComponent)tc, (String)"save()");
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit((TraceComponent)tc, (String)"save()");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((TraceComponent)tc, (String)"save()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove() throws IllegalStateException {
        try {
            try {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"remove()");
                }
                ((BrokerItemStream)((Object)this.getItemStream())).removeItem(this);
            }
            catch (NotInMessageStore notInMessageStore) {
                FFDCFilter.processException((Throwable)((Object)notInMessageStore), (String)"MappingProfileImpl.remove", (String)"remove#1");
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)notInMessageStore));
                }
                Object var3_2 = null;
                if (!tc.isEntryEnabled()) return;
                SibTr.exit((TraceComponent)tc, (String)"remove()");
                return;
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"MappingProfileImpl.remove", (String)"remove#2");
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                }
                Object var3_3 = null;
                if (!tc.isEntryEnabled()) return;
                SibTr.exit((TraceComponent)tc, (String)"remove()");
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit((TraceComponent)tc, (String)"remove()");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((TraceComponent)tc, (String)"remove()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItemStream(BrokerItemStream brokerItemStream) {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"setItemStream(ItemStream)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("itemStream : " + brokerItemStream));
            }
            this.itemStream = brokerItemStream;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setItemStream(ItemStream)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setItemStream(ItemStream)");
        }
    }

    public BridgeController getBridgeController() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBridgeController");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("bridgeController: " + this.bridgeController));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBridgeController");
        }
        return this.bridgeController;
    }

    public void setBridgeController(BridgeController bridgeController) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setBridgeController(BridgeController)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("bridgeController : " + bridgeController));
        }
        this.bridgeController = bridgeController;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setBridgeController(BridgeController)");
        }
    }

    public void setTransactionalitySettings(TransactionalitySettings transactionalitySettings) {
        this.transactionality = transactionalitySettings;
    }

    public void close() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close()");
        }
        if (this.bridgeController == null) {
            throw new IllegalStateException("null BridgeController");
        }
        PubSubController pubSubController = this.getBridgeController().getPubSubController(this.getInboundProfile().getBrokerType());
        pubSubController.closeConsumer(this.getInboundProfile());
        PubSubController pubSubController2 = this.getBridgeController().getPubSubController(this.getOutboundProfile().getBrokerType());
        pubSubController2.closeProducer(this.getOutboundProfile());
        DestinationManager destinationManager = this.bridgeController.getDestinationManager();
        SICoreConnection sICoreConnection = this.bridgeController.getCoreConnection();
        DestinationData[] destinationDataArray = this.getDestinations();
        for (int i = 0; i < destinationDataArray.length; ++i) {
            if (destinationDataArray[i].getDestAddress() == null) continue;
            destinationManager.deleteDestination(destinationDataArray[i], sICoreConnection);
        }
        this.bridgeController.getMappingRegistry().deleteProfile(this);
        this.remove();
        this.setActive(false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close()");
        }
    }

    public MappingProfile getLinkedMapping() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkedMapping");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("returns: " + this.linkedProfile));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinkedMapping");
        }
        return this.linkedProfile;
    }

    public void setLinkedMapping(MappingProfile mappingProfile) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setLinkedMapping");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("mappingProfile: " + mappingProfile));
        }
        this.linkedProfile = mappingProfile;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setLinkedMapping");
        }
    }

    public SIBPSBSubscription toSIBPSBSubscription() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"toSIBPSBSubscription()");
        }
        SIBPSBSubscription sIBPSBSubscription = new SIBPSBSubscription();
        InboundProfile inboundProfile = this.getInboundProfile();
        OutboundProfile outboundProfile = this.getOutboundProfile();
        sIBPSBSubscription.setTopicName(inboundProfile.getInboundTopic());
        sIBPSBSubscription.setMessageCount(new Long(0L));
        switch (inboundProfile.getStatus()) {
            case 2: {
                sIBPSBSubscription.setStatus("ACTIVE");
                break;
            }
            case 1: 
            case 4: {
                sIBPSBSubscription.setStatus("INDOUBT");
                break;
            }
            case 3: 
            case 6: {
                sIBPSBSubscription.setStatus("INDOUBT");
                break;
            }
            case 0: 
            case 5: {
                sIBPSBSubscription.setStatus("INDOUBT");
                break;
            }
            default: {
                sIBPSBSubscription.setStatus("INDOUBT");
            }
        }
        if (inboundProfile instanceof SIBInboundProfile) {
            sIBPSBSubscription.setTopicSpace(((SIBInboundProfile)inboundProfile).getTopicSpace());
            sIBPSBSubscription.setDirection("TO_MQ");
        }
        if (outboundProfile instanceof SIBOutboundProfile) {
            sIBPSBSubscription.setTopicSpace(((SIBOutboundProfile)outboundProfile).getTopicSpace());
            sIBPSBSubscription.setDirection("FROM_MQ");
        }
        if (inboundProfile instanceof EBInboundProfile) {
            sIBPSBSubscription.setSubscriptionPoint(((EBInboundProfile)inboundProfile).getSubscriptionPoint());
        }
        if (outboundProfile instanceof EBOutboundProfile) {
            sIBPSBSubscription.setBrokerStreamQueue(((EBOutboundProfile)outboundProfile).getBrokerStreamName());
        }
        if (inboundProfile instanceof SIBInboundProfile && outboundProfile instanceof SIBOutboundProfile) {
            String string = "";
            string = string + ((SIBInboundProfile)inboundProfile).getTopicSpace();
            string = string + ",";
            string = string + ((SIBOutboundProfile)outboundProfile).getTopicSpace();
            sIBPSBSubscription.setTopicSpace(string);
            sIBPSBSubscription.setDirection(null);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return SIBPSBSubscription : " + sIBPSBSubscription));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"toSIBPSBSubscription()");
        }
        return sIBPSBSubscription;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MappingProfileImpl mappingProfileImpl = (MappingProfileImpl)object;
        if (!((Object)this.inbound).equals(mappingProfileImpl.inbound)) {
            return false;
        }
        return ((Object)this.outbound).equals(mappingProfileImpl.outbound);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.inbound.hashCode();
        n = 37 * n + this.outbound.hashCode();
        return n;
    }

    public int getStorageStrategy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStorageStrategy()");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"return int : 4");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStorageStrategy()");
        }
        return 4;
    }

    public byte[] getPersistentData() throws PersistentDataEncodingException {
        byte[] byArray;
        byte[] byArray2 = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getPersistentData()");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            byArray = byArray2 = byteArrayOutputStream.toByteArray();
            Object var6_6 = null;
        }
        catch (IOException iOException) {
            try {
                FFDCFilter.processException((Throwable)iOException, (String)"MappingProfileImpl.getPersistentData", (String)"getPersistentData#1");
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)iOException);
                }
                throw new PersistentDataEncodingException("MappingProfileImpl.getPersistentData() could not write byte[]", iOException);
            }
            catch (Throwable throwable) {
                block9: {
                    Object var6_7 = null;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("return byte[] : " + byArray2));
                    }
                    if (!tc.isEntryEnabled()) break block9;
                    SibTr.exit((TraceComponent)tc, (String)"getPersistentData()");
                }
                throw throwable;
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return byte[] : " + byArray2));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData()");
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void restore(byte[] byArray) throws PersistentDataEncodingException {
        try {
            try {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"restore()");
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                MappingProfileImpl mappingProfileImpl = (MappingProfileImpl)objectInputStream.readObject();
                this.inbound = mappingProfileImpl.inbound;
                this.outbound = mappingProfileImpl.outbound;
                this.transactionality = mappingProfileImpl.transactionality;
                this.inbound.setMappingProfile(this);
                this.outbound.setMappingProfile(this);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"MappingProfileImpl.restore", (String)"restore#1");
                if (!tc.isEventEnabled()) throw new PersistentDataEncodingException("MappingProfileImpl.restore() io exception", iOException);
                SibTr.exception((TraceComponent)tc, (Exception)iOException);
                throw new PersistentDataEncodingException("MappingProfileImpl.restore() io exception", iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"MappingProfileImpl.restore", (String)"restore#2");
                if (!tc.isEventEnabled()) throw new PersistentDataEncodingException("MappingProfileImpl.restore() class not found exception", classNotFoundException);
                SibTr.exception((TraceComponent)tc, (Exception)classNotFoundException);
                throw new PersistentDataEncodingException("MappingProfileImpl.restore() class not found exception", classNotFoundException);
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit((TraceComponent)tc, (String)"restore()");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((TraceComponent)tc, (String)"restore()");
    }

    public String toString() {
        return "MappingProfile: inbound = " + this.inbound + " outbound = " + this.outbound;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.psb.impl/src/com/ibm/ws/sib/psb/config/impl/MappingProfileImpl.java, SIB.psb, WAS602.SIB, o0610.11 1.40");
        }
    }
}

