/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.psb.config.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.psb.config.BrokerItemStream;
import com.ibm.ws.sib.psb.config.DestinationData;
import com.ibm.ws.sib.psb.config.InboundProfile;
import com.ibm.ws.sib.psb.config.MappingProfile;
import com.ibm.ws.sib.psb.impl.PSBFactoryImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;

public abstract class InboundProfileImpl
implements InboundProfile {
    private static TraceComponent tc = SibTr.register((Class)InboundProfileImpl.class, (String)"SIBPsb", (String)"com.ibm.ws.sib.psb.CWSILMessages");
    private static final long serialVersionUID = 4205359701176965389L;
    private String topic = null;
    private int brokerType = 0;
    private DestinationData[] dests = null;
    private MappingProfile parent = null;
    private boolean cleanup = false;
    private int status = 0;
    private transient ConsumerSession consumer = null;
    private transient boolean deleteStreamOnConfirm = true;
    private transient SICoreConnection siCoreConnection = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InboundProfileImpl(String string, int n, DestinationData[] destinationDataArray) {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"InboundProfileImpl");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Creating InboundProfile for  topic " + string + ", brokerType " + n));
            }
            if (string == null || "".equals(string)) {
                throw new IllegalArgumentException("The specified topic '" + string + "' is not allowed");
            }
            if (n != 2 && n != 1) {
                throw new IllegalArgumentException("The supplied broker type is not supported: " + n);
            }
            if (destinationDataArray == null) {
                throw new IllegalArgumentException("It is not valid to supply null as the DestinationData[] parameter.");
            }
            this.topic = string;
            this.brokerType = n;
            this.dests = destinationDataArray;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"InboundProfileImpl");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"InboundProfileImpl");
        }
    }

    public String getInboundTopic() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInboundTopic");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return inbound topic : " + this.topic));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getInboundTopic");
        }
        return this.topic;
    }

    public int getBrokerType() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBrokerType");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return brokerType : " + (this.brokerType == 2 ? "EventBroker" : (this.brokerType == 1 ? "Jetstream" : "Unknown"))));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBrokerType");
        }
        return this.brokerType;
    }

    public ConsumerSession getConsumer() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumer");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return consumer : " + this.consumer));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConsumer");
        }
        return this.consumer;
    }

    public void setConsumer(ConsumerSession consumerSession) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setConsumer");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Set consumer to : " + consumerSession));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setConsumer");
        }
        this.consumer = consumerSession;
    }

    public DestinationData[] getDestinations() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinations");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return destinations : " + this.dests));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinations");
        }
        return this.dests;
    }

    public void setDestinations(DestinationData[] destinationDataArray) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestinations");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Setting destinations to " + destinationDataArray));
        }
        if (this.dests != null && this.dests.length > 0) {
            throw new IllegalStateException("profile already has destinations");
        }
        this.dests = destinationDataArray;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestinations");
        }
    }

    public MappingProfile getMappingProfile() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMappingProfile");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return mapping profile : " + this.parent));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMappingProfile");
        }
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SICoreConnection getConnection() {
        Object object;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getConnection");
            }
            if (this.siCoreConnection == null) {
                if (this.parent == null) {
                    throw new IllegalStateException("The parent mapping profile has not yet been set.");
                }
                object = this.parent.getBridgeController();
                if (object != null) {
                    this.siCoreConnection = object.getCoreConnection();
                } else {
                    throw new IllegalStateException("Bridge controller is not set on the mapping profile");
                }
            }
            object = this.siCoreConnection;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block10: {
                Object var3_3 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("return SICoreConnection : " + this.siCoreConnection));
                }
                if (!tc.isEntryEnabled()) break block10;
                SibTr.exit((TraceComponent)tc, (String)"getConnection");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return SICoreConnection : " + this.siCoreConnection));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConnection");
        }
        return object;
    }

    public void setMappingProfile(MappingProfile mappingProfile) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMappingProfile");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Set parent profile to : " + mappingProfile));
        }
        if (mappingProfile == null) {
            throw new IllegalArgumentException("Cannot set parent mapping profile to null");
        }
        this.parent = mappingProfile;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMappingProfile");
        }
    }

    public boolean isCleanup() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isCleanup");
        }
        boolean bl = this.cleanup;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isCleanup", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void setCleanup(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCleanup", (Object)new Boolean(bl));
        }
        this.cleanup = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCleanup");
        }
    }

    public void subscriptionOpened(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"subscriptionOpened(boolean)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("opened : " + bl));
        }
        if (bl) {
            this.setStatus(2);
        } else {
            this.setStatus(3);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"subscriptionOpened(boolean)");
        }
    }

    public void subscriptionClosed(boolean bl) {
        block10: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"subscriptionClosed(boolean)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("closed : " + bl));
            }
            try {
                if (bl) {
                    this.setStatus(5);
                    MappingProfile mappingProfile = this.getMappingProfile();
                    mappingProfile.close();
                    if (this.deleteStreamOnConfirm) {
                        BrokerItemStream brokerItemStream = mappingProfile.getBridgeController().getStateStream();
                        if (brokerItemStream.isEmpty()) {
                            brokerItemStream.remove();
                        }
                    } else {
                        this.deleteStreamOnConfirm = true;
                    }
                } else {
                    this.setStatus(6);
                }
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"InboundProfileImpl.subscriptionClosed", (String)"subscriptionClosed#1");
                if (!tc.isEventEnabled()) break block10;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"subscriptionClosed(boolean)");
        }
    }

    public int getStatus() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStatus");
        }
        int n = this.status;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return : " + n + "  " + PSBFactoryImpl.getStatusString(n)));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStatus");
        }
        return n;
    }

    public void setStatus(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStatus(int)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("status : " + n + "  " + PSBFactoryImpl.getStatusString(n)));
        }
        this.status = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setStatus(int)");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        InboundProfileImpl inboundProfileImpl = (InboundProfileImpl)object;
        if (this.brokerType != inboundProfileImpl.brokerType) {
            return false;
        }
        if (!this.topic.equals(inboundProfileImpl.topic)) {
            return false;
        }
        if (this.dests.length > 1) {
            throw new IllegalStateException("inbound profile has more than one destination");
        }
        return true;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.brokerType;
        n = 37 * n + this.topic.hashCode();
        return n;
    }

    protected void verifyParameter(String string, String string2) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("The value of '" + string + "' is not allowed for parameter " + string2);
        }
    }

    public String toString() {
        return "Inbound profile for brokerType=" + this.brokerType + ", topic=" + this.topic;
    }

    public void leaveStateStream() {
        this.deleteStreamOnConfirm = false;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.psb.impl/src/com/ibm/ws/sib/psb/config/impl/InboundProfileImpl.java, SIB.psb, WAS602.SIB, o0610.11 1.25");
        }
    }
}

