/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.psb.config.brokers.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIMessageException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.psb.config.InboundProfile;
import com.ibm.ws.sib.psb.config.OutboundProfile;
import com.ibm.ws.sib.psb.config.brokers.SIBInboundProfile;
import com.ibm.ws.sib.psb.config.brokers.SIBOutboundProfile;
import com.ibm.ws.sib.psb.impl.RequestReplyHelper;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SIBReqReplHelper
extends RequestReplyHelper {
    private static TraceComponent tc = SibTr.register((Class)SIBReqReplHelper.class, (String)"SIBPsb", (String)"com.ibm.ws.sib.psb.CWSILMessages");

    public SIBReqReplHelper() {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.psb.impl/src/com/ibm/ws/sib/psb/config/brokers/impl/SIBReqReplHelper.java, SIB.psb, WAS602.SIB, o0610.11 1.12");
        }
    }

    protected boolean isTemporaryTopic(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTemporaryTopic", (Object)string);
        }
        boolean bl = false;
        if (string != null && string.startsWith("_T")) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isTemporaryTopic", (Object)new Boolean(bl));
        }
        return bl;
    }

    protected String addReplyIdentifier(String string, OutboundProfile outboundProfile) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addReplyIdentifier", (Object)new Object[]{string, outboundProfile});
        }
        String string2 = "";
        if (string != null) {
            string2 = string;
        }
        if (!(outboundProfile instanceof SIBOutboundProfile)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"PSB - INVALID STATE - got passed the wrong type of profile.");
            }
            throw new IllegalStateException();
        }
        SIBOutboundProfile sIBOutboundProfile = (SIBOutboundProfile)outboundProfile;
        string2 = string2 + sIBOutboundProfile.getProfileIdentifier() + "/" + sIBOutboundProfile.getTopicSpace();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addReplyIdentifier", (Object)string2);
        }
        return string2;
    }

    protected String addRoutingInfo(String string, SIBusMessage sIBusMessage, InboundProfile inboundProfile) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addRoutingInfo", (Object)new Object[]{string, sIBusMessage, inboundProfile});
        }
        String string2 = "";
        if (string != null) {
            string2 = string;
        }
        if (!(inboundProfile instanceof SIBInboundProfile)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"PSB - INVALID STATE - got passed the wrong type of profile.");
            }
            throw new IllegalStateException();
        }
        String string3 = sIBusMessage.getReplyDiscriminator();
        string2 = string2 + string3 + "/" + string3;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addRoutingInfo", (Object)string2);
        }
        return string2;
    }

    protected String removeReplyIdentifier(String string, InboundProfile inboundProfile) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeReplyIdentifier", (Object)new Object[]{string, inboundProfile});
        }
        String string2 = null;
        String[] stringArray = this.tokenizeWithConditions(string, "/", 3);
        string2 = stringArray.length == 3 ? stringArray[2] : string;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeReplyIdentifier", (Object)string2);
        }
        return string2;
    }

    protected SIBusMessage parseRoutingInfo(String string, OutboundProfile outboundProfile, SIBusMessage sIBusMessage, SIUncoordinatedTransaction sIUncoordinatedTransaction) throws SIException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"parseRoutingInfo", (Object)new Object[]{string, outboundProfile, sIBusMessage, sIUncoordinatedTransaction});
        }
        SIBusMessage sIBusMessage2 = null;
        String[] stringArray = this.tokenizeWithConditions(string, "/", 2);
        if (stringArray.length == 2) {
            SIDestinationAddress sIDestinationAddress;
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            sIBusMessage.setDiscriminator(string3);
            if (sIBusMessage instanceof JsJmsMessage) {
                sIDestinationAddress = new HashMap(2);
                sIDestinationAddress.put("topicName", string3);
                sIDestinationAddress.put("topicSpace", string3);
                this.updateJMSDestination((JsJmsMessage)sIBusMessage, (Map)sIDestinationAddress);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Could not update JMSDestination field - it isn't a JsJmsMessage message.");
            }
            try {
                sIDestinationAddress = SIDestinationAddressFactory.getInstance().createSIDestinationAddress(string2, null);
                SICoreConnection sICoreConnection = outboundProfile.getConnection();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Send the reply message");
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("destination: " + sIDestinationAddress));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("      topic: " + string3));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("reversePath: " + sIBusMessage.getReverseRoutingPath()));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)(" replyTopic: " + sIBusMessage.getReplyDiscriminator()));
                }
                sICoreConnection.send(sIBusMessage, (SITransaction)sIUncoordinatedTransaction, sIDestinationAddress, DestinationType.TOPICSPACE, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.psb.config.brokers.impl.SIBReqReplHelper.parseRoutingInfo", (String)"parseRoutingInfo#1", (Object)this);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"parseRoutingInfo", (Object)((Object)sIException));
                }
                throw sIException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.psb.config.brokers.impl.SIBReqReplHelper.parseRoutingInfo", (String)"routingInfo#2", (Object)this);
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Routing information was not in the format expected - throw exception to force retry.");
            }
            throw new SIMessageException();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"parseRoutingInfo", sIBusMessage2);
        }
        return sIBusMessage2;
    }

    protected void updateOutboundMsgAttributes(SIBusMessage sIBusMessage, OutboundProfile outboundProfile) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateOutboundMsgAttributes");
        }
        String string = sIBusMessage.getReplyDiscriminator();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("reply topic: " + string));
        }
        if (string != null && !"".equals(string)) {
            if (outboundProfile instanceof SIBOutboundProfile) {
                SIBOutboundProfile sIBOutboundProfile = (SIBOutboundProfile)outboundProfile;
                List list = sIBusMessage.getReverseRoutingPath();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("routingInfo RRP: " + list));
                }
                if (list.size() == 1) {
                    try {
                        ArrayList<SIDestinationAddress> arrayList = new ArrayList<SIDestinationAddress>(1);
                        SIDestinationAddress sIDestinationAddress = SIDestinationAddressFactory.getInstance().createSIDestinationAddress(sIBOutboundProfile.getTopicSpace(), null);
                        arrayList.add(sIDestinationAddress);
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("NEW routingInfo RRP: " + arrayList));
                        }
                        sIBusMessage.setReverseRoutingPath(arrayList);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.psb.config.brokers.impl.SIBReqReplHelper.updateOutboundMsgAttributes", (String)"updateOutboundMsgAttributes#1", (Object)this);
                        if (tc.isDebugEnabled()) {
                            SibTr.exception((TraceComponent)tc, (Exception)exception);
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("The wrong type of profile was passed: " + outboundProfile.getClass()));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateOutboundMsgAttributes");
        }
    }
}

