/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils.linkedlist;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.utils.linkedlist.Cursor;
import com.ibm.ws.sib.processor.utils.linkedlist.Entry;
import com.ibm.ws.sib.utils.ras.SibTr;

public class LinkedList {
    protected Entry first = null;
    protected Entry last = null;
    protected Cursor firstTopCursor = null;
    protected Cursor firstBottomCursor = null;
    private static final TraceComponent tc = SibTr.register((Class)LinkedList.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;

    public Cursor newCursor(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"newCursor", (Object)string);
        }
        Cursor cursor = new Cursor(string, this, true);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"newCursor", (Object)cursor);
        }
        return cursor;
    }

    public Cursor newCursorAtBottom(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"newCursorAtBottom", (Object)string);
        }
        Cursor cursor = new Cursor(string, this, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"newCursorAtBottom", (Object)cursor);
        }
        return cursor;
    }

    public Entry put(Entry entry) {
        return this.insertAtBottom(entry);
    }

    public Entry insertAtBottom(Entry entry) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"insertAtBottom", (Object)new Object[]{entry});
        }
        if (entry.parentList == null) {
            if (this.last == null) {
                entry.previous = null;
                entry.next = null;
                this.first = entry;
                this.last = entry;
                entry.parentList = this;
            } else {
                this.insertAfter(entry, this.last);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"insertAtBottom", (Object)entry);
            }
            return entry;
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList", "1:176:1.16"}, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList.insertAtBottom", (String)"1:182:1.16", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList", "1:189:1.16"});
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"insertAtBottom", (Object)((Object)sIErrorException));
        }
        throw sIErrorException;
    }

    public Entry insertAtTop(Entry entry) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"insertAtTop", (Object)new Object[]{entry});
        }
        if (entry.parentList == null) {
            if (this.first == null) {
                entry.previous = null;
                entry.next = null;
                this.last = entry;
            } else {
                entry.previous = null;
                entry.next = this.first;
                this.first.previous = entry;
            }
            this.first = entry;
            entry.parentList = this;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"insertAtTop", (Object)entry);
            }
            return entry;
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList", "1:249:1.16"}, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList.insertAtTop", (String)"1:255:1.16", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList", "1:262:1.16"});
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"insertAtTop", (Object)((Object)sIErrorException));
        }
        throw sIErrorException;
    }

    public Entry insertAfter(Entry entry, Entry entry2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"insertAfter", (Object)new Object[]{entry, entry2});
        }
        Entry entry3 = null;
        if (entry != null && entry2 != null) {
            entry3 = entry2.forceInsertAfter(entry);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"insertAfter", (Object)entry3);
        }
        return entry3;
    }

    public boolean contains(Entry entry) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"contains", (Object)new Object[]{entry});
        }
        boolean bl2 = bl = entry != null && entry.parentList == this;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"contains");
        }
        return bl;
    }

    public Entry remove(Entry entry) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{entry});
        }
        Entry entry2 = null;
        if (!this.contains(entry)) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList", "1:338:1.16"}, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList.remove", (String)"1:344:1.16", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList", "1:351:1.16"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"remove", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        entry2 = entry.forceRemove();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove", (Object)entry2);
        }
        return entry2;
    }

    public Entry getFirst() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getFirst");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getFirst", (Object)this.first);
        }
        return this.first;
    }

    public Entry getLast() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLast");
            SibTr.exit((TraceComponent)tc, (String)"getLast", (Object)this.last);
        }
        return this.last;
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transfer(LinkedList linkedList) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"transfer", (Object)new Object[]{linkedList});
        }
        LinkedList linkedList2 = linkedList;
        synchronized (linkedList2) {
            Entry entry = linkedList.first;
            while (entry != null) {
                this.insertAtBottom(entry.forceRemove());
                entry = linkedList.first;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"transfer");
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("Head");
        Cursor cursor = this.firstTopCursor;
        while (cursor != null) {
            stringBuffer.append("\n");
            stringBuffer.append(string);
            stringBuffer.append("\\-->");
            stringBuffer.append(cursor);
            cursor = (Cursor)cursor.next;
        }
        String string2 = string + "  ";
        Entry entry = this.first;
        while (entry != null) {
            stringBuffer.append("\n");
            stringBuffer.append(entry.toString(string2));
            entry = entry.next;
        }
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("Tail");
        cursor = this.firstBottomCursor;
        while (cursor != null) {
            stringBuffer.append("\n");
            stringBuffer.append(string);
            stringBuffer.append("\\-->");
            stringBuffer.append(cursor);
            cursor = (Cursor)cursor.next;
        }
        return stringBuffer.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/utils/linkedlist/LinkedList.java, SIB.processor, WAS602.SIB, o0610.11 1.16");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

