/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils.am;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.StoppableThread;
import com.ibm.ws.sib.processor.utils.StoppableThreadCache;
import com.ibm.ws.sib.processor.utils.am.GroupAlarmListener;
import com.ibm.ws.sib.processor.utils.am.MPAlarmImpl;
import com.ibm.ws.sib.processor.utils.am.MPAlarmThread;
import com.ibm.ws.sib.processor.utils.linkedlist.Entry;
import com.ibm.ws.sib.processor.utils.linkedlist.LinkedList;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ObjectPool;
import java.util.HashMap;
import java.util.Iterator;

public class MPAlarmManager
implements StoppableThread {
    private static final TraceComponent tc = SibTr.register((Class)MPAlarmManager.class, (String)"SIBUtils", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private boolean _cancelAll = false;
    private long _nextAlarm = MPAlarmThread.SUSPEND;
    private MPAlarmThread _alarmThread;
    private LinkedList _pendingAlarms;
    private LinkedList _firedAlarms;
    private Object _firedAlarmsLock = new Object();
    private Object _pendingAlarmsLock = new Object();
    private ObjectPool _alarmPool;
    private int _percentLateDefault = 50;
    private long _batchAlarmTime = -1L;
    private HashMap _groupListeners;
    private long index = 0L;

    public MPAlarmManager(MessageProcessor messageProcessor, int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MPAlarmManager", (Object)new Object[]{messageProcessor, new Integer(n), new Integer(n2)});
        }
        this.index = 0L;
        this._pendingAlarms = new LinkedList();
        this._firedAlarms = new LinkedList();
        this._percentLateDefault = n;
        this._alarmPool = new ObjectPool("MPAlarmPool", n2);
        this._groupListeners = new HashMap();
        this._alarmThread = new MPAlarmThread(this);
        try {
            messageProcessor.startNewSystemThread(this._alarmThread);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.sib.processor.utils.am.MPAlarmManager", (String)"1:191:1.18", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)interruptedException);
        }
        messageProcessor.getStoppableThreadCache().registerThread(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MPAlarmManager", (Object)this);
        }
    }

    public int getPercentLateDefault() {
        return this._percentLateDefault;
    }

    public Alarm create(long l, AlarmListener alarmListener) {
        return this.create(l, this._percentLateDefault, alarmListener, null);
    }

    public Alarm create(long l, AlarmListener alarmListener, Object object) {
        return this.create(l, this._percentLateDefault, alarmListener, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Alarm create(long l, int n, AlarmListener alarmListener, Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"create", (Object)new Object[]{new Long(l), new Integer(n), alarmListener, object});
        }
        long l2 = System.currentTimeMillis() + l;
        long l3 = l2 + l / 100L * (long)n;
        MPAlarmImpl mPAlarmImpl = (MPAlarmImpl)this._alarmPool.remove();
        if (mPAlarmImpl == null) {
            mPAlarmImpl = new MPAlarmImpl(l2, l3, alarmListener, object, this.index++);
        } else {
            mPAlarmImpl.reset(l2, l3, alarmListener, object, this.index++);
        }
        Object object2 = this._pendingAlarmsLock;
        synchronized (object2) {
            MPAlarmImpl mPAlarmImpl2 = (MPAlarmImpl)this._pendingAlarms.getLast();
            if (mPAlarmImpl2 == null) {
                this._pendingAlarms.put(mPAlarmImpl);
            } else {
                if (mPAlarmImpl2.time() > l2) {
                    while ((mPAlarmImpl2 = mPAlarmImpl2.previous()) != null && mPAlarmImpl2.time() > l2) {
                    }
                }
                if (mPAlarmImpl2 == null) {
                    this._pendingAlarms.insertAtTop(mPAlarmImpl);
                } else {
                    this._pendingAlarms.insertAfter(mPAlarmImpl, mPAlarmImpl2);
                }
            }
            if (this._nextAlarm == MPAlarmThread.SUSPEND || l2 < this._nextAlarm) {
                this._nextAlarm = l2;
            }
            if (tc.isDebugEnabled()) {
                long l4 = System.currentTimeMillis();
                SibTr.debug((TraceComponent)tc, (String)("now " + l4 + "Alarm Start : " + alarmListener + " - " + (l2 - l4) + " (" + (l3 - l4) + ")"));
                SibTr.debug((TraceComponent)tc, (String)("" + this._pendingAlarms));
            }
        }
        this._alarmThread.requestNextWakeup(this._nextAlarm);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"create", (Object)mPAlarmImpl);
        }
        return mPAlarmImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancelAll() {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cancelAll");
        }
        this._cancelAll = true;
        LinkedList linkedList = null;
        LinkedList linkedList2 = null;
        Object object2 = this._firedAlarmsLock;
        synchronized (object2) {
            object = this._pendingAlarmsLock;
            synchronized (object) {
                linkedList = this._pendingAlarms;
                this._pendingAlarms = new LinkedList();
                linkedList2 = this._firedAlarms;
                this._firedAlarms = new LinkedList();
                this._nextAlarm = MPAlarmThread.SUSPEND;
                this._cancelAll = false;
            }
        }
        object2 = (MPAlarmImpl)linkedList.getFirst();
        while (object2 != null) {
            object = ((MPAlarmImpl)object2).next();
            ((MPAlarmImpl)object2).cancel();
            linkedList.remove((Entry)object2);
            this._alarmPool.add(object2);
            object2 = object;
        }
        object2 = (MPAlarmImpl)linkedList2.getFirst();
        while (object2 != null) {
            object = ((MPAlarmImpl)object2).next();
            ((MPAlarmImpl)object2).cancel();
            linkedList2.remove((Entry)object2);
            this._alarmPool.add(object2);
            object2 = object;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cancelAll");
        }
    }

    public void stopThread(StoppableThreadCache stoppableThreadCache) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopThread");
        }
        this.cancelAll();
        this._alarmThread.finishAlarmThread();
        stoppableThreadCache.deregisterThread(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopThread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long fireInternalAlarm() {
        long l = System.currentTimeMillis();
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fireInternalAlarm", (Object)new Long(l));
        }
        Object object = this._firedAlarmsLock;
        synchronized (object) {
            Object object2;
            Object object3 = this._pendingAlarmsLock;
            synchronized (object3) {
                object2 = (MPAlarmImpl)this._pendingAlarms.getFirst();
                while (!(this._cancelAll || object2 == null || ((MPAlarmImpl)object2).time() > l && ((MPAlarmImpl)object2).time() > this._batchAlarmTime)) {
                    this._pendingAlarms.remove((Entry)object2);
                    this._firedAlarms.put((Entry)object2);
                    if (this._batchAlarmTime == -1L || ((MPAlarmImpl)object2).latest() < this._batchAlarmTime) {
                        this._batchAlarmTime = ((MPAlarmImpl)object2).latest();
                    }
                    object2 = (MPAlarmImpl)this._pendingAlarms.getFirst();
                }
                object2 = (MPAlarmImpl)this._firedAlarms.getLast();
                if (object2 != null && ((MPAlarmImpl)object2).time() < this._batchAlarmTime) {
                    this._batchAlarmTime = ((MPAlarmImpl)object2).time();
                }
            }
            if (l >= this._batchAlarmTime) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Pending " + this._pendingAlarms));
                    SibTr.debug((TraceComponent)tc, (String)("Firing " + this._firedAlarms));
                }
                object3 = (MPAlarmImpl)this._firedAlarms.getFirst();
                while (!this._cancelAll && object3 != null) {
                    this._firedAlarms.remove((Entry)object3);
                    if (((MPAlarmImpl)object3).active()) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Alarm Fire : " + object3));
                        }
                        if (!((MPAlarmImpl)object3).hasGroupListener()) {
                            ((MPAlarmImpl)object3).listener().alarm(((MPAlarmImpl)object3).context());
                        } else if (!this._groupListeners.containsKey(((GroupAlarmListener)((MPAlarmImpl)object3).listener()).getGroupUuid())) {
                            this._groupListeners.put(((GroupAlarmListener)((MPAlarmImpl)object3).listener()).getGroupUuid(), ((MPAlarmImpl)object3).listener());
                            ((GroupAlarmListener)((MPAlarmImpl)object3).listener()).beginGroupAlarm(((MPAlarmImpl)object3).context());
                        } else {
                            ((GroupAlarmListener)((MPAlarmImpl)object3).listener()).addContext(((MPAlarmImpl)object3).context());
                        }
                    }
                    this._alarmPool.add(object3);
                    object3 = (MPAlarmImpl)this._firedAlarms.getFirst();
                }
                if (this._groupListeners.size() > 0) {
                    object2 = this._groupListeners.keySet();
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        GroupAlarmListener groupAlarmListener = (GroupAlarmListener)this._groupListeners.get(iterator.next());
                        groupAlarmListener.alarm(null);
                    }
                    this._groupListeners.clear();
                }
                this._batchAlarmTime = -1L;
            }
            object3 = this._pendingAlarmsLock;
            synchronized (object3) {
                this._nextAlarm = this._batchAlarmTime > -1L ? this._batchAlarmTime : ((object2 = (MPAlarmImpl)this._pendingAlarms.getFirst()) == null ? MPAlarmThread.SUSPEND : ((MPAlarmImpl)object2).time());
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"fireInternalAlarm", (Object)new Long(this._nextAlarm));
            }
            return this._nextAlarm;
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/utils/am/MPAlarmManager.java, SIB.processor, WAS602.SIB, o0610.11 1.18");
        }
    }
}

