/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils.am;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutEntry;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutProcessor;
import com.ibm.ws.sib.processor.utils.am.GroupAlarmListener;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.processor.utils.linkedlist.LinkedList;
import com.ibm.ws.sib.processor.utils.linkedlist.SimpleLinkedListEntry;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ObjectPool;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BatchedTimeoutManager
implements GroupAlarmListener {
    private ObjectPool linkedListEntryPool;
    private SIBUuid12 uuid = new SIBUuid12();
    private long delta;
    private int percentLate;
    protected LinkedList activeEntries;
    private static final TraceComponent tc = SibTr.register((Class)BatchedTimeoutManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MPAlarmManager am;
    private BatchedTimeoutProcessor handler;
    private ArrayList timedout;
    private boolean isStopped;
    private LockManager btmLockManager = new LockManager();
    private LockManager timeoutLockManager = new LockManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchedTimeoutManager(int n, long l, List list, BatchedTimeoutProcessor batchedTimeoutProcessor, MessageProcessor messageProcessor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"BatchedTimeoutManager", (Object)new Object[]{new Integer(n), new Long(l), list, batchedTimeoutProcessor, messageProcessor});
        }
        this.btmLockManager.lockExclusive();
        try {
            this.am = messageProcessor.getAlarmManager();
            this.linkedListEntryPool = messageProcessor.getBatchedTimeoutManagerEntryPool();
            this.delta = l;
            long l2 = this.delta / (long)(n - 1);
            this.percentLate = (int)(100L * l2 / this.delta);
            this.timedout = new ArrayList(10);
            this.activeEntries = new LinkedList();
            this.isStopped = true;
            this.handler = batchedTimeoutProcessor;
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.addTimeoutEntry((BatchedTimeoutEntry)iterator.next());
                }
            }
        }
        finally {
            this.btmLockManager.unlockExclusive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"BatchedTimeoutManager", (Object)this);
        }
    }

    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
        }
        this.btmLockManager.lock();
        this.timeoutLockManager.lockExclusive();
        if (!this.timedout.isEmpty() && !this.isStopped) {
            this.btmLockManager.unlock();
            ArrayList arrayList = this.timedout;
            this.timedout = new ArrayList();
            this.timeoutLockManager.unlockExclusive();
            this.handler.processTimedoutEntries(arrayList);
            this.restartEntries(arrayList);
        } else {
            this.timeoutLockManager.unlockExclusive();
            this.btmLockManager.unlock();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    private void restartEntries(List list) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restartEntries", (Object)new Object[]{list});
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BatchedTimeoutEntry batchedTimeoutEntry = (BatchedTimeoutEntry)iterator.next();
            LinkedListEntry linkedListEntry = batchedTimeoutEntry.getEntry();
            if (linkedListEntry == null || !this.activeEntries.contains(linkedListEntry)) continue;
            this.startNewAlarm(linkedListEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startTimer");
        }
        this.btmLockManager.lockExclusive();
        try {
            if (this.isStopped) {
                this.isStopped = false;
                for (LinkedListEntry linkedListEntry = (LinkedListEntry)this.activeEntries.getFirst(); linkedListEntry != null && this.activeEntries.contains(linkedListEntry); linkedListEntry = (LinkedListEntry)linkedListEntry.getNext()) {
                    this.startNewAlarm(linkedListEntry);
                }
            }
        }
        finally {
            this.btmLockManager.unlockExclusive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startTimer");
        }
    }

    private void startNewAlarm(LinkedListEntry linkedListEntry) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startNewAlarm", (Object)new Object[]{linkedListEntry});
        }
        linkedListEntry.alarm = this.am.create(this.delta, this.percentLate, this, linkedListEntry);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startNewAlarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopTimer");
        }
        this.btmLockManager.lockExclusive();
        try {
            if (!this.isStopped) {
                this.isStopped = true;
                for (LinkedListEntry linkedListEntry = (LinkedListEntry)this.activeEntries.getFirst(); linkedListEntry != null && this.activeEntries.contains(linkedListEntry); linkedListEntry = (LinkedListEntry)linkedListEntry.getNext()) {
                    if (linkedListEntry.alarm == null) continue;
                    linkedListEntry.alarm.cancel();
                    linkedListEntry.alarm = null;
                }
            }
        }
        finally {
            this.btmLockManager.unlockExclusive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopTimer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close");
        }
        this.btmLockManager.lockExclusive();
        try {
            this.stopTimer();
            this.activeEntries = null;
        }
        finally {
            this.btmLockManager.unlockExclusive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimeoutEntry(BatchedTimeoutEntry batchedTimeoutEntry) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addTimeoutEntry", (Object)batchedTimeoutEntry);
        }
        this.btmLockManager.lockExclusive();
        try {
            LinkedListEntry linkedListEntry = (LinkedListEntry)this.linkedListEntryPool.remove();
            if (linkedListEntry == null) {
                linkedListEntry = new LinkedListEntry();
            }
            linkedListEntry.bte = batchedTimeoutEntry;
            batchedTimeoutEntry.setEntry(linkedListEntry);
            this.activeEntries.put(linkedListEntry);
            if (!this.isStopped) {
                this.startNewAlarm(linkedListEntry);
            }
        }
        finally {
            this.btmLockManager.unlockExclusive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addTimeoutEntry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimeoutEntry(BatchedTimeoutEntry batchedTimeoutEntry) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeTimeoutEntry", (Object)batchedTimeoutEntry);
        }
        this.btmLockManager.lockExclusive();
        try {
            LinkedListEntry linkedListEntry = batchedTimeoutEntry.getEntry();
            if (this.activeEntries.contains(linkedListEntry)) {
                this.activeEntries.remove(linkedListEntry);
                batchedTimeoutEntry.setEntry(null);
                if (linkedListEntry.alarm != null) {
                    linkedListEntry.alarm.cancel();
                    linkedListEntry.alarm = null;
                }
                linkedListEntry.bte = null;
                this.linkedListEntryPool.add((Object)linkedListEntry);
            }
        }
        finally {
            this.btmLockManager.unlockExclusive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeTimeoutEntry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginGroupAlarm(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"beginGroupAlarm", (Object)new Object[]{object});
        }
        LinkedListEntry linkedListEntry = (LinkedListEntry)object;
        this.btmLockManager.lock();
        this.timeoutLockManager.lockExclusive();
        try {
            if (!this.isStopped && this.activeEntries.contains(linkedListEntry)) {
                this.timedout.clear();
                linkedListEntry.alarm = null;
                this.timedout.add(linkedListEntry.bte);
            }
        }
        finally {
            this.timeoutLockManager.unlockExclusive();
            this.btmLockManager.unlock();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"beginGroupAlarm");
        }
    }

    public void addContext(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addContext", (Object)new Object[]{object});
        }
        LinkedListEntry linkedListEntry = (LinkedListEntry)object;
        this.btmLockManager.lock();
        if (!this.isStopped && this.activeEntries.contains(linkedListEntry)) {
            linkedListEntry.alarm = null;
            this.timeoutLockManager.lockExclusive();
            this.timedout.add(linkedListEntry.bte);
            this.timeoutLockManager.unlockExclusive();
        }
        this.btmLockManager.unlock();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addContext");
        }
    }

    public SIBUuid12 getGroupUuid() {
        return this.uuid;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/utils/am/BatchedTimeoutManager.java, SIB.processor, WAS602.SIB, o0610.11 1.18");
        }
    }

    public static class LinkedListEntry
    extends SimpleLinkedListEntry {
        Alarm alarm;
        public BatchedTimeoutEntry bte;

        public synchronized String toString(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.parentList == null) {
                stringBuffer.append("LinkedListEntry not in list");
            } else {
                stringBuffer.append(string);
                stringBuffer.append("LinkedListEntry(" + this.bte + ")\n");
                stringBuffer.append(string + string + "\\->" + this.alarm);
            }
            return stringBuffer.toString();
        }
    }
}

