/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.interfaces.StoppableThread;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Iterator;

public final class StoppableThreadCache {
    private static final TraceComponent tc = SibTr.register((Class)StoppableThreadCache.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ArrayList _threadCache;

    public StoppableThreadCache() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"StoppableThreadCache");
        }
        this._threadCache = new ArrayList();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"StoppableThreadCache", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerThread(StoppableThread stoppableThread) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerThread", (Object)stoppableThread);
        }
        StoppableThreadCache stoppableThreadCache = this;
        synchronized (stoppableThreadCache) {
            this._threadCache.add(stoppableThread);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerThread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterThread(StoppableThread stoppableThread) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterThread", (Object)stoppableThread);
        }
        StoppableThreadCache stoppableThreadCache = this;
        synchronized (stoppableThreadCache) {
            this._threadCache.remove(stoppableThread);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterThread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllThreads() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopAllThreads");
        }
        StoppableThreadCache stoppableThreadCache = this;
        synchronized (stoppableThreadCache) {
            Iterator iterator = ((ArrayList)this._threadCache.clone()).iterator();
            while (iterator.hasNext()) {
                StoppableThread stoppableThread = (StoppableThread)iterator.next();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Attempting to stop thread " + stoppableThread));
                }
                stoppableThread.stopThread(this);
                iterator.remove();
                this._threadCache.remove(stoppableThread);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopAllThreads");
        }
    }

    public ArrayList getThreads() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getThreads");
            SibTr.exit((TraceComponent)tc, (String)"getThreads", (Object)this._threadCache);
        }
        return this._threadCache;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/utils/StoppableThreadCache.java, SIB.processor, WAS602.SIB, o0610.11 1.1");
        }
    }
}

