/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.admin.JsAdminUtils;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsDestinationAddressFactory;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class SIMPUtils {
    public static final int UUID_LENGTH_8 = 8;
    public static final int UUID_LENGTH_12 = 12;
    private static final TraceComponent tc = SibTr.register((Class)SIMPUtils.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public static String pad(String string, int n) {
        if (string.length() < n) {
            StringBuffer stringBuffer = new StringBuffer(n);
            stringBuffer.append(string);
            for (int i = string.length(); i < n; ++i) {
                stringBuffer = stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }
        if (string.length() > n) {
            return string.substring(0, n);
        }
        return string;
    }

    public static SIBUuid12 createSIBUuid12(String string) {
        return new SIBUuid12(SIMPUtils.pad(string, 12).getBytes());
    }

    public static JsDestinationAddress createJsSystemDestinationAddress(String string, SIBUuid8 sIBUuid8) {
        JsDestinationAddressFactory jsDestinationAddressFactory = (JsDestinationAddressFactory)MessageProcessor.getSingletonInstance("JsDestinationAddressFactory");
        return jsDestinationAddressFactory.createJsSystemDestinationAddress(string, sIBUuid8);
    }

    public static JsDestinationAddress createJsSystemDestinationAddress(String string, SIBUuid8 sIBUuid8, String string2) {
        JsDestinationAddressFactory jsDestinationAddressFactory = (JsDestinationAddressFactory)MessageProcessor.getSingletonInstance("JsDestinationAddressFactory");
        return jsDestinationAddressFactory.createJsSystemDestinationAddress(string, sIBUuid8, string2);
    }

    public static JsDestinationAddress createJsDestinationAddress(String string, SIBUuid8 sIBUuid8) {
        JsDestinationAddressFactory jsDestinationAddressFactory = (JsDestinationAddressFactory)MessageProcessor.getSingletonInstance("JsDestinationAddressFactory");
        return jsDestinationAddressFactory.createJsDestinationAddress(string, sIBUuid8 != null, sIBUuid8);
    }

    public static JsDestinationAddress createJsDestinationAddress(String string, SIBUuid8 sIBUuid8, String string2) {
        JsDestinationAddressFactory jsDestinationAddressFactory = (JsDestinationAddressFactory)MessageProcessor.getSingletonInstance("JsDestinationAddressFactory");
        return jsDestinationAddressFactory.createJsDestinationAddress(string, sIBUuid8 != null, sIBUuid8, string2);
    }

    public static JsDestinationAddress createMediationDestinationAddress(String string) {
        JsDestinationAddressFactory jsDestinationAddressFactory = (JsDestinationAddressFactory)MessageProcessor.getSingletonInstance("JsDestinationAddressFactory");
        return jsDestinationAddressFactory.createJsMediationdestinationAddress(string);
    }

    public static SIBUuid8 parseME(String string) {
        int n;
        SIBUuid8 sIBUuid8 = null;
        if (string != null && (string.startsWith("_P") || string.startsWith("_T") || string.startsWith("_Q")) && (n = string.indexOf(95, 2)) > 1) {
            String string2;
            if (string.startsWith("_P")) {
                string2 = string.substring(n + 1);
            } else {
                int n2 = n + 1;
                int n3 = n2 + 16;
                string2 = string.substring(n2, n3);
            }
            sIBUuid8 = new SIBUuid8(string2);
        }
        return sIBUuid8;
    }

    public static String parseTempPrefix(String string) {
        int n;
        String string2 = null;
        if ((string != null && string.startsWith("_T") || string.startsWith("_Q")) && (n = string.indexOf(95, 2)) > 1) {
            string2 = string.substring(2, n);
        }
        return string2;
    }

    public static String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        String string = byteArrayOutputStream.toString();
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        boolean bl = true;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isSpaceChar(cArray[i])) {
                if (bl) {
                    cArray[n++] = cArray[i];
                }
                bl = false;
                continue;
            }
            if (!Character.isWhitespace(cArray[i])) {
                bl = true;
                cArray[n++] = cArray[i];
                continue;
            }
            if (!bl) continue;
            cArray[n++] = 32;
            bl = false;
        }
        return new String(cArray, 0, n);
    }

    public static String longArrayToString(long[] lArray) {
        String string = "[";
        if (lArray != null) {
            for (int i = 0; i < lArray.length; ++i) {
                string = i == 0 ? string + lArray[i] : string + "," + lArray[i];
            }
        }
        string = string + "]";
        return string;
    }

    public static String messageHandleArrayToString(SIMessageHandle[] sIMessageHandleArray) {
        String string = "[";
        if (sIMessageHandleArray != null) {
            for (int i = 0; i < sIMessageHandleArray.length; ++i) {
                string = i == 0 ? string + sIMessageHandleArray[i].toString() : string + "," + sIMessageHandleArray[i].toString();
            }
        }
        string = string + "]";
        return string;
    }

    public static String getMENameFromUuid(String string) {
        String string2 = JsAdminUtils.getMENameByUuid((String)string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/utils/SIMPUtils.java, SIB.processor, WAS602.SIB, o0610.11 1.22");
        }
    }
}

