/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.NoSuchElementException;

public class PriorityQueue {
    private static final int DEFAULT_START_SIZE = 16;
    protected int size;
    protected PriorityQueueNode[] elements;
    private static final TraceComponent tc = SibTr.register((Class)PriorityQueue.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public PriorityQueue() {
        this(16);
    }

    public PriorityQueue(int n) {
        this.elements = n != 0 ? new PriorityQueueNode[n] : null;
        this.size = 0;
    }

    protected final int parent(int n) {
        return (n - 1) / 2;
    }

    protected final int left(int n) {
        return n * 2 + 1;
    }

    protected final int right(int n) {
        return n * 2 + 2;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final int size() {
        return this.size;
    }

    public final void put(long l, Object object) {
        PriorityQueueNode priorityQueueNode = new PriorityQueueNode(l, object);
        if (this.size == this.elements.length) {
            PriorityQueueNode[] priorityQueueNodeArray = new PriorityQueueNode[2 * this.size];
            System.arraycopy(this.elements, 0, priorityQueueNodeArray, 0, this.size);
            this.elements = priorityQueueNodeArray;
        }
        int n = this.size++;
        this.setElement(priorityQueueNode, n);
        this.moveUp(n);
    }

    protected void moveUp(int n) {
        PriorityQueueNode priorityQueueNode = this.elements[n];
        long l = priorityQueueNode.priority;
        while (n > 0 && this.elements[this.parent((int)n)].priority > l) {
            this.setElement(this.elements[this.parent(n)], n);
            n = this.parent(n);
        }
        this.setElement(priorityQueueNode, n);
    }

    public final Object getMin() throws NoSuchElementException {
        PriorityQueueNode priorityQueueNode = null;
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        priorityQueueNode = this.elements[0];
        this.setElement(this.elements[--this.size], 0);
        this.heapify(0);
        return priorityQueueNode.value;
    }

    protected final void setElement(PriorityQueueNode priorityQueueNode, int n) {
        this.elements[n] = priorityQueueNode;
        priorityQueueNode.pos = n;
    }

    protected void heapify(int n) {
        int n2 = -1;
        int n3 = n;
        while (n3 != n2) {
            n2 = n3;
            int n4 = this.left(n2);
            int n5 = this.right(n2);
            n3 = n4 < this.size && this.elements[n4].priority < this.elements[n2].priority ? n4 : n2;
            if (n5 < this.size && this.elements[n5].priority < this.elements[n3].priority) {
                n3 = n5;
            }
            if (n3 == n2) continue;
            PriorityQueueNode priorityQueueNode = this.elements[n3];
            this.setElement(this.elements[n2], n3);
            this.setElement(priorityQueueNode, n2);
        }
    }

    protected PriorityQueueNode minNode() throws NoSuchElementException {
        if (this.size > 0) {
            return this.elements[0];
        }
        throw new NoSuchElementException();
    }

    public Object minElement() throws NoSuchElementException {
        return this.minNode().value;
    }

    public long minPriority() throws NoSuchElementException {
        return this.minNode().priority;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/utils/PriorityQueue.java, SIB.processor, WAS602.SIB, o0610.11 1.16");
        }
    }

    class PriorityQueueNode {
        public long priority;
        public int pos;
        public Object value;

        public PriorityQueueNode(long l, Object object) {
            this.priority = l;
            this.value = object;
        }
    }
}

