/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class LockManager {
    private static final TraceComponent tc = SibTr.register((Class)LockManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Object iMutex = new Object();
    private boolean iExclusivelyLocked = false;
    private int iLockCount = 0;
    private int iExclusiveLockCount = 0;
    Thread iExclusiveLockHolder = null;

    public synchronized void lock() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"lock", (Object)this);
        }
        boolean bl = false;
        while (!this.tryLock()) {
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Waiting for lock");
                }
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLock() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"tryLock", (Object)this);
        }
        boolean bl = false;
        Object object = this.iMutex;
        synchronized (object) {
            if (!this.iExclusivelyLocked) {
                ++this.iLockCount;
                bl = true;
            } else if (this.iExclusiveLockHolder == Thread.currentThread()) {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"tryLock", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unlock() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlock", (Object)this);
        }
        Object object = this.iMutex;
        synchronized (object) {
            if (this.iExclusivelyLocked && this.iExclusiveLockHolder == Thread.currentThread()) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"unlock");
                }
                return;
            }
            if (--this.iLockCount == 0) {
                this.notifyAll();
            }
            if (this.iLockCount < 0) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"unlock", (Object)"SIErrorException");
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.utils.LockManager", "1:196:1.19"});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.utils.LockManager", "1:203:1.19"}, null));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlock");
        }
    }

    public synchronized void lockExclusive() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"lockExclusive", (Object)this);
        }
        boolean bl = false;
        while (!this.tryLockExclusive()) {
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Waiting to get exclusive lock");
                }
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        while (this.iLockCount > 0) {
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Waiting for lock count to reach 0 " + this.iLockCount));
                }
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"lockExclusive");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLockExclusive() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"tryLockExclusive", (Object)this);
        }
        boolean bl = false;
        Object object = this.iMutex;
        synchronized (object) {
            if (!this.iExclusivelyLocked) {
                this.iExclusivelyLocked = true;
                this.iExclusiveLockHolder = Thread.currentThread();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Got exclusive lock for thread " + this.iExclusiveLockHolder));
                }
                bl = true;
                ++this.iExclusiveLockCount;
            } else if (this.iExclusiveLockHolder == Thread.currentThread()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Already hold exclusive lock " + (this.iExclusiveLockCount + 1)));
                }
                bl = true;
                ++this.iExclusiveLockCount;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"tryLockExclusive", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unlockExclusive() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockExclusive", (Object)this);
        }
        Object object = this.iMutex;
        synchronized (object) {
            if (Thread.currentThread() == this.iExclusiveLockHolder) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Unlocking current thread " + (this.iExclusiveLockCount - 1)));
                }
                if (--this.iExclusiveLockCount == 0) {
                    this.iExclusivelyLocked = false;
                    this.iExclusiveLockHolder = null;
                    this.notifyAll();
                }
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Thread not the current thread to unlock exclusively");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockExclusive");
        }
    }
}

