/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class AliasChainValidator {
    private static final TraceComponent tc = SibTr.register((Class)AliasChainValidator.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    private Collector collector = new Collector();

    public CompoundName getFirstInChain() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getFirstInChain");
        }
        CompoundName compoundName = this.collector.getFirst();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getFirstInChain", (Object)compoundName);
        }
        return compoundName;
    }

    public void validate(String string, String string2) throws SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"validate", (Object)new Object[]{string, string2});
        }
        if (this.collector.contains(string, string2)) {
            String string3 = this.toStringPlus(string, string2);
            CompoundName compoundName = this.getFirstInChain();
            String string4 = nls.getFormattedMessage("ALIAS_CIRCULAR_DEPENDENCY_ERROR_CWSIP0621", new Object[]{compoundName, string3, string2}, null);
            SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException = new SINotPossibleInCurrentConfigurationException(string4);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sINotPossibleInCurrentConfigurationException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"validate", (Object)string4);
            }
            throw sINotPossibleInCurrentConfigurationException;
        }
        this.collector.add(string, string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"validate");
        }
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"toString");
        }
        Set set = this.collector.keySet();
        Iterator iterator = set.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" -> ");
        }
        String string = stringBuffer.toString();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"toString", (Object)string);
        }
        return string;
    }

    public String toStringPlus(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(this.toString());
        String string3 = new CompoundName(string, string2).toString();
        stringBuffer.append(" -> ");
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/utils/AliasChainValidator.java, SIB.processor, WAS602.SIB, o0610.11 1.15");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }

    private class Collector
    extends LinkedHashMap {
        private static final long serialVersionUID = 2130290956123711056L;

        private Collector() {
        }

        private void add(String string, String string2) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"add", (Object)new Object[]{string, string2});
            }
            AliasChainValidator.this.collector.put(CompoundName.compound(string, string2), new CompoundName(string, string2));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"add");
            }
        }

        private boolean contains(String string, String string2) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"contains", (Object)new Object[]{string, string2});
            }
            boolean bl = AliasChainValidator.this.collector.containsKey(CompoundName.compound(string, string2));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"contains", (Object)new Boolean(bl));
            }
            return bl;
        }

        private CompoundName getFirst() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getFirst");
            }
            CompoundName compoundName = null;
            Collection collection = AliasChainValidator.this.collector.values();
            if (collection != null) {
                compoundName = (CompoundName)collection.toArray()[0];
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getFirst", (Object)compoundName);
            }
            return compoundName;
        }
    }

    public static class CompoundName {
        private String destName;
        private String busName;
        private static final String SEPERATOR = ":";

        public CompoundName(String string, String string2) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"CompoundName", (Object)new Object[]{string, string2});
            }
            this.destName = string;
            this.busName = string2;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"CompoundName", (Object)this);
            }
        }

        public static String compound(String string, String string2) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"compound");
            }
            String string3 = string + SEPERATOR + string2;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"compound", (Object)string3);
            }
            return string3;
        }

        public String getBusName() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getBusName");
                SibTr.exit((TraceComponent)tc, (String)"getBusName", (Object)this.busName);
            }
            return this.busName;
        }

        public String getDestName() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getDestName");
                SibTr.exit((TraceComponent)tc, (String)"getDestName", (Object)this.destName);
            }
            return this.destName;
        }

        public String toString() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"toString");
            }
            String string = CompoundName.compound(this.destName, this.busName);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"toString", (Object)string);
            }
            return string;
        }
    }
}

