/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.stats;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.impl.AbstractInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.stats.MessageProcessorInstrumentation;
import com.ibm.ws.sib.processor.stats.SIMPInstrumentation;
import com.ibm.ws.sib.processor.stats.WSSIBTopicspaceStats;
import com.ibm.ws.sib.processor.stats.interfaces.AbstractInputHandlerInstrumentor;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;

public class TopicspaceInstrumentation
extends SIMPInstrumentation
implements WSSIBTopicspaceStats,
StatisticActionListener,
AbstractInputHandlerInstrumentor {
    static TraceComponent tc = SibTr.register((Class)TopicspaceInstrumentation.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected StatsInstance stats;
    protected String statsName;
    private SPICountStatistic localPublisherAttachesCount;
    private SPICountStatistic localPublisherCount;
    private SPICountStatistic subscriptionCountTotal;
    private SPICountStatistic subscriptionCountNonDurable;
    private SPICountStatistic subscriptionCountDurable;
    private SPICountStatistic messagesPublishedTotal;
    private SPICountStatistic messagesPublishedBestEffort;
    private SPICountStatistic messagesPublishedExpress;
    private SPICountStatistic messagesPublishedReliableNonPersistent;
    private SPICountStatistic messagesPublishedReliablePersistent;
    private SPICountStatistic messagesPublishedAssured;
    private SPICountStatistic subscriptionHitsTotal;
    private SPICountStatistic subscriptionHitsBestEffort;
    private SPICountStatistic subscriptionHitsExpress;
    private SPICountStatistic subscriptionHitsReliableNonPersistent;
    private SPICountStatistic subscriptionHitsReliablePersistent;
    private SPICountStatistic subscriptionHitsAssured;
    private SPICountStatistic messagesExpiredReport;
    private SPICountStatistic localOldestPublication;
    private SPICountStatistic incompletePublicationCount;
    protected AbstractInputHandler instrumentedAIH;
    protected BaseDestinationHandler instrumentedDH;
    protected PubSubMessageItemStream instrumentedMIS;
    String durableSubscriptionStatsGroupName;
    StatsGroup durableSubscriptionStatsGroup;

    public TopicspaceInstrumentation(MessageProcessor messageProcessor, BaseDestinationHandler baseDestinationHandler, PubSubMessageItemStream pubSubMessageItemStream, AbstractInputHandler abstractInputHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"TopicspaceInstrumentation", (Object)new Object[]{messageProcessor, baseDestinationHandler, pubSubMessageItemStream, abstractInputHandler});
        }
        if (!StatsFactory.isPMIEnabled()) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"TopicspaceInstrumentation");
            }
            return;
        }
        this.instrumentedDH = baseDestinationHandler;
        this.instrumentedMIS = pubSubMessageItemStream;
        this.instrumentedAIH = abstractInputHandler;
        MessageProcessorInstrumentation messageProcessorInstrumentation = messageProcessor.getStats();
        TopicspaceInstrumentation topicspaceInstrumentation = this;
        try {
            this.stats = StatsFactory.createStatsInstance((String)this.instrumentedDH.getName(), (StatsGroup)messageProcessorInstrumentation.getTopicspaceStatsGroup(), null, (StatisticActionListener)topicspaceInstrumentation);
        }
        catch (StatsFactoryException statsFactoryException) {
            FFDCFilter.processException((Throwable)statsFactoryException, (String)"com.ibm.ws.sib.processor.stats.TopicspaceInstrumentation.TopicspaceInstrumentation", (String)"1:225:1.68", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)statsFactoryException));
        }
        try {
            this.durableSubscriptionStatsGroup = StatsFactory.createStatsGroup((String)"Durable Subscriptions", (String)"/com/ibm/ws/sib/processor/stats/static/DurableSubscriptionStats.xml", (StatsInstance)this.stats, null);
        }
        catch (StatsFactoryException statsFactoryException) {
            FFDCFilter.processException((Throwable)statsFactoryException, (String)"com.ibm.ws.sib.processor.stats.TopicspaceInstrumentation.TopicspaceInstrumentation", (String)"1:246:1.68", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)statsFactoryException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"TopicspaceInstrumentation", (Object)this);
        }
    }

    public void statisticCreated(SPIStatistic sPIStatistic) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"statisticCreated", (Object)sPIStatistic);
        }
        int n = sPIStatistic.getId();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("id = " + n));
        }
        switch (n) {
            case 1: {
                this.localPublisherAttachesCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 2: {
                this.localPublisherCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 3: {
                this.subscriptionCountTotal = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 4: {
                this.subscriptionCountNonDurable = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 5: {
                this.subscriptionCountDurable = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 7: {
                this.messagesPublishedTotal = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 8: {
                this.messagesPublishedBestEffort = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 9: {
                this.messagesPublishedExpress = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 10: {
                this.messagesPublishedReliableNonPersistent = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 11: {
                this.messagesPublishedReliablePersistent = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 12: {
                this.messagesPublishedAssured = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 13: {
                this.subscriptionHitsTotal = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 14: {
                this.subscriptionHitsBestEffort = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 15: {
                this.subscriptionHitsExpress = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 16: {
                this.subscriptionHitsReliableNonPersistent = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 17: {
                this.subscriptionHitsReliablePersistent = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 18: {
                this.subscriptionHitsAssured = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 19: {
                this.messagesExpiredReport = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 20: {
                this.localOldestPublication = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 21: {
                this.incompletePublicationCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)"Invalid id specified!");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"statisticCreated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatisticOnRequest(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateStatisticOnRequest", (Object)new Integer(n));
        }
        switch (n) {
            case 2: {
                int n2 = this.instrumentedAIH.getProducerCount();
                SPICountStatistic sPICountStatistic = this.localPublisherCount;
                synchronized (sPICountStatistic) {
                    this.localPublisherCount.setCount((long)n2);
                }
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)("LOCAL_PUBLISHER_COUNT: " + n2));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
                break;
            }
            case 3: {
                long l = this.instrumentedDH.getSubscriptionIndex().getTotalSubscriptions();
                SPICountStatistic sPICountStatistic = this.subscriptionCountTotal;
                synchronized (sPICountStatistic) {
                    this.subscriptionCountTotal.setCount(l);
                }
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)("SUBSCRIPTION_COUNT_TOTAL: " + l));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
                break;
            }
            case 4: {
                long l = this.instrumentedDH.getSubscriptionIndex().getNonDurableSubscriptions();
                SPICountStatistic sPICountStatistic = this.subscriptionCountNonDurable;
                synchronized (sPICountStatistic) {
                    this.subscriptionCountNonDurable.setCount(l);
                }
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)("SUBSCRIPTION_COUNT_NONDURABLE: " + l));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
                break;
            }
            case 5: {
                long l = this.instrumentedDH.getSubscriptionIndex().getDurableSubscriptions();
                SPICountStatistic sPICountStatistic = this.subscriptionCountDurable;
                synchronized (sPICountStatistic) {
                    this.subscriptionCountDurable.setCount(l);
                }
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)("SUBSCRIPTION_COUNT_DURABLE: " + l));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
                break;
            }
            case 20: {
                MessageItem messageItem = null;
                try {
                    messageItem = (MessageItem)this.instrumentedMIS.findOldestItem();
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.stats.TopicspaceInstrumentation.updateStatisticOnRequest", (String)"1:463:1.68", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                }
                long l = 0L;
                if (null != messageItem) {
                    l = messageItem.calculateWaitTimeUpdate(System.currentTimeMillis());
                }
                SPICountStatistic sPICountStatistic = this.localOldestPublication;
                synchronized (sPICountStatistic) {
                    this.localOldestPublication.setCount(l);
                }
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)("LOCAL_OLDEST_PUBLICATION: " + l));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
                break;
            }
            case 21: {
                long l = this.instrumentedMIS.countAvailablePublications();
                SPICountStatistic sPICountStatistic = this.incompletePublicationCount;
                synchronized (sPICountStatistic) {
                    this.incompletePublicationCount.setCount(l);
                }
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)("INCOMPLETE_PUBLICATION_COUNT: " + l));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)("Invalid updateStatisticOnRequest id " + n + "specified!"));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateStatisticOnRequest");
        }
    }

    public void onAttachProducer() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"onAttachProducer");
        }
        if (this.localPublisherAttachesCount != null && this.localPublisherAttachesCount.isEnabled()) {
            this.localPublisherAttachesCount.increment();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("LOCAL_PUBLISHER_ATTACHES: " + this.localPublisherAttachesCount.getCount()));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"onAttachProducer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFanOut(SIMPMessage sIMPMessage) {
        Reliability reliability;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"onFanOut", (Object)sIMPMessage);
        }
        long l = -1L;
        long l2 = ((MessageItem)sIMPMessage).getFanOut();
        if (null != this.messagesPublishedTotal && this.messagesPublishedTotal.isEnabled()) {
            if (l < 0L) {
                l = System.currentTimeMillis();
            }
            reliability = this.messagesPublishedTotal;
            synchronized (reliability) {
                this.messagesPublishedTotal.increment(l, 1L);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("MESSAGES_PUBLISHED_TOTAL: " + this.messagesPublishedTotal.getCount()));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
            }
        }
        if (this.subscriptionHitsTotal != null && this.subscriptionHitsTotal.isEnabled()) {
            if (l < 0L) {
                l = System.currentTimeMillis();
            }
            reliability = this.subscriptionHitsTotal;
            synchronized (reliability) {
                this.subscriptionHitsTotal.increment(l, l2);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("SUBSCRIPTION_HITS_TOTAL: " + this.subscriptionHitsTotal.getCount()));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
            }
        }
        if (Reliability.BEST_EFFORT_NONPERSISTENT == (reliability = sIMPMessage.getReliability())) {
            SPICountStatistic sPICountStatistic;
            if (null != this.messagesPublishedBestEffort && this.messagesPublishedBestEffort.isEnabled()) {
                if (l < 0L) {
                    l = System.currentTimeMillis();
                }
                sPICountStatistic = this.messagesPublishedBestEffort;
                synchronized (sPICountStatistic) {
                    this.messagesPublishedBestEffort.increment(l, 1L);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MESSAGES_PUBLISHED_BEST_EFFORT: " + this.messagesPublishedBestEffort.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
                }
            }
            if (this.subscriptionHitsBestEffort != null && this.subscriptionHitsBestEffort.isEnabled()) {
                if (l < 0L) {
                    l = System.currentTimeMillis();
                }
                sPICountStatistic = this.subscriptionHitsBestEffort;
                synchronized (sPICountStatistic) {
                    this.subscriptionHitsBestEffort.increment(l, l2);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("SUBSCRIPTION_HITS_BEST_EFFORT: " + this.subscriptionHitsBestEffort.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
                }
            }
        } else if (Reliability.EXPRESS_NONPERSISTENT == reliability) {
            SPICountStatistic sPICountStatistic;
            if (null != this.messagesPublishedExpress && this.messagesPublishedExpress.isEnabled()) {
                if (l < 0L) {
                    l = System.currentTimeMillis();
                }
                sPICountStatistic = this.messagesPublishedExpress;
                synchronized (sPICountStatistic) {
                    this.messagesPublishedExpress.increment(l, 1L);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MESSAGES_PUBLISHED_EXPRESS: " + this.messagesPublishedExpress.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
                }
            }
            if (this.subscriptionHitsExpress != null && this.subscriptionHitsExpress.isEnabled()) {
                if (l < 0L) {
                    l = System.currentTimeMillis();
                }
                sPICountStatistic = this.subscriptionHitsExpress;
                synchronized (sPICountStatistic) {
                    this.subscriptionHitsExpress.increment(l, l2);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("SUBSCRIPTION_HITS_EXPRESS: " + this.subscriptionHitsExpress.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
                }
            }
        } else if (Reliability.RELIABLE_NONPERSISTENT == reliability) {
            SPICountStatistic sPICountStatistic;
            if (null != this.messagesPublishedReliableNonPersistent && this.messagesPublishedReliableNonPersistent.isEnabled()) {
                if (l < 0L) {
                    l = System.currentTimeMillis();
                }
                sPICountStatistic = this.messagesPublishedReliableNonPersistent;
                synchronized (sPICountStatistic) {
                    this.messagesPublishedReliableNonPersistent.increment(l, 1L);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MESSAGES_PUBLISHED_RELIABLE_NONPERSISTENT: " + this.messagesPublishedReliableNonPersistent.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
                }
            }
            if (this.subscriptionHitsReliableNonPersistent != null && this.subscriptionHitsReliableNonPersistent.isEnabled()) {
                if (l < 0L) {
                    l = System.currentTimeMillis();
                }
                sPICountStatistic = this.subscriptionHitsReliableNonPersistent;
                synchronized (sPICountStatistic) {
                    this.subscriptionHitsReliableNonPersistent.increment(l, l2);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("SUBSCRIPTION_HITS_RELIABLE_NONPERSISTENT: " + this.subscriptionHitsReliableNonPersistent.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
                }
            }
        } else if (Reliability.RELIABLE_PERSISTENT == reliability) {
            SPICountStatistic sPICountStatistic;
            if (null != this.messagesPublishedReliablePersistent && this.messagesPublishedReliablePersistent.isEnabled()) {
                if (l < 0L) {
                    l = System.currentTimeMillis();
                }
                sPICountStatistic = this.messagesPublishedReliablePersistent;
                synchronized (sPICountStatistic) {
                    this.messagesPublishedReliablePersistent.increment(l, 1L);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MESSAGES_PUBLISHED_RELIABLE_PERSISTENT: " + this.messagesPublishedReliablePersistent.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
                }
            }
            if (this.subscriptionHitsReliablePersistent != null && this.subscriptionHitsReliablePersistent.isEnabled()) {
                if (l < 0L) {
                    l = System.currentTimeMillis();
                }
                sPICountStatistic = this.subscriptionHitsReliablePersistent;
                synchronized (sPICountStatistic) {
                    this.subscriptionHitsReliablePersistent.increment(l, l2);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("SUBSCRIPTION_HITS_RELIABLE_PERSISTENT: " + this.subscriptionHitsReliablePersistent.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
                }
            }
        } else if (Reliability.ASSURED_PERSISTENT == reliability) {
            SPICountStatistic sPICountStatistic;
            if (null != this.messagesPublishedAssured && this.messagesPublishedAssured.isEnabled()) {
                if (l < 0L) {
                    l = System.currentTimeMillis();
                }
                sPICountStatistic = this.messagesPublishedAssured;
                synchronized (sPICountStatistic) {
                    this.messagesPublishedAssured.increment(l, 1L);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MESSAGES_PUBLISHED_ASSURED: " + this.messagesPublishedAssured.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
                }
            }
            if (this.subscriptionHitsAssured != null && this.subscriptionHitsAssured.isEnabled()) {
                if (l < 0L) {
                    l = System.currentTimeMillis();
                }
                sPICountStatistic = this.subscriptionHitsAssured;
                synchronized (sPICountStatistic) {
                    this.subscriptionHitsAssured.increment(l, l2);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("SUBSCRIPTION_HITS_ASSURED: " + this.subscriptionHitsReliablePersistent.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"onFanOut");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExpiryReport() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"onExpiryReport");
        }
        if (this.messagesExpiredReport != null && this.messagesExpiredReport.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.messagesExpiredReport;
            synchronized (sPICountStatistic) {
                this.messagesExpiredReport.increment();
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("MESSAGES_EXPIRED_REPORT: " + this.messagesExpiredReport.getCount()));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedDH.getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedDH.getUuid()));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"onExpiryReport");
        }
    }

    public StatsGroup getDurableSubscriptionStatsGroup() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDurableSubscriptionStatsGroup");
            SibTr.exit((TraceComponent)tc, (String)"getDurableSubscriptionStatsGroup", (Object)this.durableSubscriptionStatsGroup);
        }
        return this.durableSubscriptionStatsGroup;
    }

    public void terminate() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"terminate");
        }
        TopicspaceInstrumentation.terminate(this.stats);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"terminate");
        }
    }

    public SPIStatistic getStatistic(int n) {
        switch (n) {
            case 1: {
                return this.localPublisherAttachesCount;
            }
            case 2: {
                return this.localPublisherCount;
            }
            case 3: {
                return this.subscriptionCountTotal;
            }
            case 4: {
                return this.subscriptionCountNonDurable;
            }
            case 5: {
                return this.subscriptionCountDurable;
            }
            case 7: {
                return this.messagesPublishedTotal;
            }
            case 8: {
                return this.messagesPublishedBestEffort;
            }
            case 9: {
                return this.messagesPublishedExpress;
            }
            case 10: {
                return this.messagesPublishedReliableNonPersistent;
            }
            case 11: {
                return this.messagesPublishedReliablePersistent;
            }
            case 12: {
                return this.messagesPublishedAssured;
            }
            case 13: {
                return this.subscriptionHitsTotal;
            }
            case 14: {
                return this.subscriptionHitsBestEffort;
            }
            case 15: {
                return this.subscriptionHitsExpress;
            }
            case 16: {
                return this.subscriptionHitsReliableNonPersistent;
            }
            case 17: {
                return this.subscriptionHitsReliablePersistent;
            }
            case 18: {
                return this.subscriptionHitsAssured;
            }
            case 19: {
                return this.messagesExpiredReport;
            }
            case 20: {
                return this.localOldestPublication;
            }
            case 21: {
                return this.incompletePublicationCount;
            }
        }
        return null;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/stats/TopicspaceInstrumentation.java, SIB.processor, WAS602.SIB, o0610.11 1.68");
        }
    }
}

