/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.stats;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.impl.AbstractInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.stats.MessageProcessorInstrumentation;
import com.ibm.ws.sib.processor.stats.SIMPInstrumentation;
import com.ibm.ws.sib.processor.stats.WSSIBQueueStats;
import com.ibm.ws.sib.processor.stats.interfaces.AbstractInputHandlerInstrumentor;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import com.ibm.wsspi.pmi.stat.SPITimeStatistic;

public class QueueInstrumentation
extends SIMPInstrumentation
implements WSSIBQueueStats,
StatisticActionListener,
AbstractInputHandlerInstrumentor {
    private static TraceComponent tc = SibTr.register((Class)QueueInstrumentation.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected StatsInstance stats;
    protected String statsName;
    protected SPICountStatistic producerAttaches;
    protected SPICountStatistic producerCount;
    protected SPICountStatistic consumerAttaches;
    protected SPICountStatistic consumerCount;
    protected SPICountStatistic messagesProducedTotal;
    protected SPICountStatistic messagesProducedBestEffort;
    protected SPICountStatistic messagesProducedExpress;
    protected SPICountStatistic messagesProducedReliableNonPersistent;
    protected SPICountStatistic messagesProducedReliablePersistent;
    protected SPICountStatistic messagesProducedAssured;
    protected SPICountStatistic messagesConsumedTotal;
    protected SPICountStatistic messagesConsumedBestEffort;
    protected SPICountStatistic messagesConsumedExpress;
    protected SPICountStatistic messagesConsumedReliableNonPersistent;
    protected SPICountStatistic messagesConsumedReliablePersistent;
    protected SPICountStatistic messagesConsumedAssured;
    protected SPICountStatistic messagesExpiredReport;
    protected SPITimeStatistic aggregateMessageWaitTime;
    protected SPITimeStatistic localMessageWaitTime;
    protected SPICountStatistic localOldestMessage;
    protected SPICountStatistic availableMessageCount;
    protected SPICountStatistic unavailableMessageCount;
    protected AbstractInputHandler instrumentedAIH;
    protected ConsumerDispatcher instrumentedCD;
    protected PtoPMessageItemStream instrumentedLoc;

    public QueueInstrumentation(MessageProcessor messageProcessor, BaseDestinationHandler baseDestinationHandler, PtoPMessageItemStream ptoPMessageItemStream, AbstractInputHandler abstractInputHandler, ConsumerDispatcher consumerDispatcher) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"QueueInstrumentation", (Object)new Object[]{messageProcessor, baseDestinationHandler, ptoPMessageItemStream, abstractInputHandler, consumerDispatcher});
        }
        if (!StatsFactory.isPMIEnabled()) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"QueueInstrumentation");
            }
            return;
        }
        this.instrumentedLoc = ptoPMessageItemStream;
        this.instrumentedAIH = abstractInputHandler;
        this.instrumentedCD = consumerDispatcher;
        MessageProcessorInstrumentation messageProcessorInstrumentation = messageProcessor.getStats();
        QueueInstrumentation queueInstrumentation = this;
        try {
            this.stats = StatsFactory.createStatsInstance((String)baseDestinationHandler.getName(), (StatsGroup)messageProcessorInstrumentation.getQueueStatsGroup(), null, (StatisticActionListener)queueInstrumentation);
        }
        catch (StatsFactoryException statsFactoryException) {
            FFDCFilter.processException((Throwable)statsFactoryException, (String)"com.ibm.ws.sib.processor.stats.QueueInstrumentation.QueueInstrumentation", (String)"1:219:1.68", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)statsFactoryException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"QueueInstrumentation", (Object)this);
        }
    }

    public void statisticCreated(SPIStatistic sPIStatistic) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"statisticCreated");
        }
        int n = sPIStatistic.getId();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("id = " + n));
        }
        switch (n) {
            case 1: {
                this.producerAttaches = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 2: {
                this.producerCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 3: {
                this.consumerAttaches = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 4: {
                this.consumerCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 5: {
                this.messagesProducedTotal = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 6: {
                this.messagesProducedBestEffort = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 7: {
                this.messagesProducedExpress = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 8: {
                this.messagesProducedReliableNonPersistent = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 9: {
                this.messagesProducedReliablePersistent = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 10: {
                this.messagesProducedAssured = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 11: {
                this.messagesConsumedTotal = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 12: {
                this.messagesConsumedBestEffort = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 13: {
                this.messagesConsumedExpress = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 14: {
                this.messagesConsumedReliableNonPersistent = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 15: {
                this.messagesConsumedReliablePersistent = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 16: {
                this.messagesConsumedAssured = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 17: {
                this.messagesExpiredReport = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 18: {
                this.aggregateMessageWaitTime = (SPITimeStatistic)sPIStatistic;
                break;
            }
            case 19: {
                this.localMessageWaitTime = (SPITimeStatistic)sPIStatistic;
                break;
            }
            case 20: {
                this.localOldestMessage = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 21: {
                this.availableMessageCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 22: {
                this.unavailableMessageCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)"Invalid id specified!");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"statisticCreated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatisticOnRequest(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateStatisticOnRequest", (Object)new Integer(n));
        }
        switch (n) {
            case 2: {
                int n2 = this.instrumentedAIH.getProducerCount();
                SPICountStatistic sPICountStatistic = this.producerCount;
                synchronized (sPICountStatistic) {
                    this.producerCount.setCount((long)n2);
                }
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)("PRODUCER_COUNT: " + n2));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
                break;
            }
            case 4: {
                int n3 = this.instrumentedCD.getConsumerCount();
                SPICountStatistic sPICountStatistic = this.consumerCount;
                synchronized (sPICountStatistic) {
                    this.consumerCount.setCount((long)n3);
                }
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)("CONSUMER_COUNT: " + n3));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
                break;
            }
            case 20: {
                MessageItem messageItem = null;
                try {
                    messageItem = (MessageItem)this.instrumentedLoc.findOldestItem();
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.stats.QueueInstrumentation.updateStatisticOnRequest", (String)"1:403:1.68", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                }
                long l = 0L;
                if (null != messageItem) {
                    l = messageItem.calculateWaitTimeUpdate(System.currentTimeMillis());
                }
                SPICountStatistic sPICountStatistic = this.localOldestMessage;
                synchronized (sPICountStatistic) {
                    this.localOldestMessage.setCount(l);
                }
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)("LOCAL_OLDEST_MESSAGE: " + l));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
                break;
            }
            case 21: {
                long l = this.instrumentedLoc.getStatistics().getAvailableItemCount();
                SPICountStatistic sPICountStatistic = this.availableMessageCount;
                synchronized (sPICountStatistic) {
                    this.availableMessageCount.setCount(l);
                }
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)("AVAILABLE_MESSAGE_COUNT: " + l));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
                break;
            }
            case 22: {
                long l = this.instrumentedLoc.getStatistics().getUnavailableItemCount();
                SPICountStatistic sPICountStatistic = this.unavailableMessageCount;
                synchronized (sPICountStatistic) {
                    this.unavailableMessageCount.setCount(l);
                }
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)("UNAVAILABLE_MESSAGE_COUNT: " + l));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)("Invalid updateStatisticOnRequest id " + n + "specified!"));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateStatisticOnRequest");
        }
    }

    public void onAttachProducer() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"onAttachProducer");
        }
        if (this.producerAttaches != null && this.producerAttaches.isEnabled()) {
            this.producerAttaches.increment();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("PRODUCER_ATTACHES: " + this.producerAttaches.getCount()));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"onAttachProducer");
        }
    }

    public void onAttachConsumer() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"onAttachConsumer");
        }
        if (this.consumerAttaches != null && this.consumerAttaches.isEnabled()) {
            this.consumerAttaches.increment();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("CONSUMER_ATTACHES: " + this.consumerAttaches.getCount()));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"onAttachConsumer");
        }
    }

    public void onProduce(SIMPMessage sIMPMessage) {
        Reliability reliability;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"onProduce", (Object)sIMPMessage);
        }
        long l = -1L;
        if (null != this.messagesProducedTotal && this.messagesProducedTotal.isEnabled()) {
            if (l < 0L) {
                l = System.currentTimeMillis();
            }
            this.messagesProducedTotal.increment(l, 1L);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("MESSAGES_PRODUCED_TOTAL: " + this.messagesProducedTotal.getCount()));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
            }
        }
        if (Reliability.BEST_EFFORT_NONPERSISTENT == (reliability = sIMPMessage.getReliability())) {
            if (null != this.messagesProducedBestEffort && this.messagesProducedBestEffort.isEnabled()) {
                if (l < 0L) {
                    l = System.currentTimeMillis();
                }
                this.messagesProducedBestEffort.increment(l, 1L);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MESSAGES_PRODUCED_BEST_EFFORT: " + this.messagesProducedBestEffort.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
                }
            }
        } else if (Reliability.EXPRESS_NONPERSISTENT == reliability) {
            if (null != this.messagesProducedExpress && this.messagesProducedExpress.isEnabled()) {
                if (l < 0L) {
                    l = System.currentTimeMillis();
                }
                this.messagesProducedExpress.increment(l, 1L);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MESSAGES_PRODUCED_EXPRESS: " + this.messagesProducedExpress.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
                }
            }
        } else if (Reliability.RELIABLE_NONPERSISTENT == reliability) {
            if (null != this.messagesProducedReliableNonPersistent && this.messagesProducedReliableNonPersistent.isEnabled()) {
                if (l < 0L) {
                    l = System.currentTimeMillis();
                }
                this.messagesProducedReliableNonPersistent.increment(l, 1L);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MESSAGES_PRODUCED_RELIABLE_NONPERSISTENT: " + this.messagesProducedReliableNonPersistent.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
                }
            }
        } else if (Reliability.RELIABLE_PERSISTENT == reliability) {
            if (null != this.messagesProducedReliablePersistent && this.messagesProducedReliablePersistent.isEnabled()) {
                if (l < 0L) {
                    l = System.currentTimeMillis();
                }
                this.messagesProducedReliablePersistent.increment(l, 1L);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MESSAGES_PRODUCED_RELIABLE_PERSISTENT: " + this.messagesProducedReliablePersistent.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
                }
            }
        } else if (Reliability.ASSURED_PERSISTENT == reliability && null != this.messagesProducedAssured && this.messagesProducedAssured.isEnabled()) {
            if (l < 0L) {
                l = System.currentTimeMillis();
            }
            this.messagesProducedAssured.increment(l, 1L);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("MESSAGES_PRODUCED_ASSURED: " + this.messagesProducedAssured.getCount()));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"onProduce");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConsume(SIMPMessage sIMPMessage) {
        Reliability reliability;
        SPITimeStatistic sPITimeStatistic;
        long l;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"onConsume", (Object)sIMPMessage);
        }
        long l2 = -1L;
        if (null != this.localMessageWaitTime && this.localMessageWaitTime.isEnabled()) {
            l = sIMPMessage.getLatestWaitTimeUpdate();
            sPITimeStatistic = this.localMessageWaitTime;
            synchronized (sPITimeStatistic) {
                this.localMessageWaitTime.add(l);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("LOCAL_MESSAGE_WAIT_TIME: " + this.localMessageWaitTime.getMean()));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
            }
        }
        if (null != this.aggregateMessageWaitTime && this.aggregateMessageWaitTime.isEnabled()) {
            l = sIMPMessage.getAggregateWaitTime();
            sPITimeStatistic = this.aggregateMessageWaitTime;
            synchronized (sPITimeStatistic) {
                this.aggregateMessageWaitTime.add(l);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("AGGREGATE_MESSAGE_WAIT_TIME: " + this.aggregateMessageWaitTime.getMean()));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
            }
        }
        if (null != this.messagesConsumedTotal && this.messagesConsumedTotal.isEnabled()) {
            if (l2 < 0L) {
                l2 = System.currentTimeMillis();
            }
            SPICountStatistic sPICountStatistic = this.messagesConsumedTotal;
            synchronized (sPICountStatistic) {
                this.messagesConsumedTotal.increment(l2, 1L);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("MESSAGES_CONSUMED_TOTAL: " + this.messagesConsumedTotal.getCount()));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
            }
        }
        if (Reliability.BEST_EFFORT_NONPERSISTENT == (reliability = sIMPMessage.getReliability())) {
            if (null != this.messagesConsumedBestEffort && this.messagesConsumedBestEffort.isEnabled()) {
                if (l2 < 0L) {
                    l2 = System.currentTimeMillis();
                }
                SPICountStatistic sPICountStatistic = this.messagesConsumedBestEffort;
                synchronized (sPICountStatistic) {
                    this.messagesConsumedBestEffort.increment(l2, 1L);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MESSAGES_CONSUMED_BEST_EFFORT: " + this.messagesConsumedBestEffort.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
                }
            }
        } else if (Reliability.EXPRESS_NONPERSISTENT == reliability) {
            if (null != this.messagesConsumedExpress && this.messagesConsumedExpress.isEnabled()) {
                if (l2 < 0L) {
                    l2 = System.currentTimeMillis();
                }
                SPICountStatistic sPICountStatistic = this.messagesConsumedExpress;
                synchronized (sPICountStatistic) {
                    this.messagesConsumedExpress.increment(l2, 1L);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MESSAGES_CONSUMED_EXPRESS: " + this.messagesConsumedExpress.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
                }
            }
        } else if (Reliability.RELIABLE_NONPERSISTENT == reliability) {
            if (null != this.messagesConsumedReliableNonPersistent && this.messagesConsumedReliableNonPersistent.isEnabled()) {
                if (l2 < 0L) {
                    l2 = System.currentTimeMillis();
                }
                SPICountStatistic sPICountStatistic = this.messagesConsumedReliableNonPersistent;
                synchronized (sPICountStatistic) {
                    this.messagesConsumedReliableNonPersistent.increment(l2, 1L);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MESSAGES_CONSUMED_RELIABLE_NONPERSISTENT: " + this.messagesConsumedReliableNonPersistent.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
                }
            }
        } else if (Reliability.RELIABLE_PERSISTENT == reliability) {
            if (null != this.messagesConsumedReliablePersistent && this.messagesConsumedReliablePersistent.isEnabled()) {
                if (l2 < 0L) {
                    l2 = System.currentTimeMillis();
                }
                SPICountStatistic sPICountStatistic = this.messagesConsumedReliablePersistent;
                synchronized (sPICountStatistic) {
                    this.messagesConsumedReliablePersistent.increment(l2, 1L);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MESSAGES_CONSUMED_RELIABLE_PERSISTENT: " + this.messagesConsumedReliablePersistent.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
                }
            }
        } else if (Reliability.ASSURED_PERSISTENT == reliability && null != this.messagesConsumedAssured && this.messagesConsumedAssured.isEnabled()) {
            if (l2 < 0L) {
                l2 = System.currentTimeMillis();
            }
            SPICountStatistic sPICountStatistic = this.messagesConsumedAssured;
            synchronized (sPICountStatistic) {
                this.messagesConsumedAssured.increment(l2, 1L);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("MESSAGES_CONSUMED_ASSURED: " + this.messagesConsumedAssured.getCount()));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"onConsume");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExpiryReport() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"onExpiryReport");
        }
        if (this.messagesExpiredReport != null && this.messagesExpiredReport.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.messagesExpiredReport;
            synchronized (sPICountStatistic) {
                this.messagesExpiredReport.increment();
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("MESSAGES_EXPIRED_REPORT: " + this.messagesExpiredReport.getCount()));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.instrumentedCD.getDestination().getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.instrumentedCD.getDestination().getUuid()));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"onExpiryReport");
        }
    }

    public void terminate() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"terminate");
        }
        QueueInstrumentation.terminate(this.stats);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"terminate");
        }
    }

    public SPIStatistic getStatistic(int n) {
        switch (n) {
            case 1: {
                return this.producerAttaches;
            }
            case 2: {
                return this.producerCount;
            }
            case 3: {
                return this.consumerAttaches;
            }
            case 4: {
                return this.consumerCount;
            }
            case 5: {
                return this.messagesProducedTotal;
            }
            case 6: {
                return this.messagesProducedBestEffort;
            }
            case 7: {
                return this.messagesProducedExpress;
            }
            case 8: {
                return this.messagesProducedReliableNonPersistent;
            }
            case 9: {
                return this.messagesProducedReliablePersistent;
            }
            case 10: {
                return this.messagesProducedAssured;
            }
            case 11: {
                return this.messagesConsumedTotal;
            }
            case 12: {
                return this.messagesConsumedBestEffort;
            }
            case 13: {
                return this.messagesConsumedExpress;
            }
            case 14: {
                return this.messagesConsumedReliableNonPersistent;
            }
            case 15: {
                return this.messagesConsumedReliablePersistent;
            }
            case 16: {
                return this.messagesConsumedAssured;
            }
            case 17: {
                return this.messagesExpiredReport;
            }
            case 18: {
                return this.localMessageWaitTime;
            }
            case 19: {
                return this.localMessageWaitTime;
            }
            case 20: {
                return this.localOldestMessage;
            }
            case 21: {
                return this.availableMessageCount;
            }
            case 22: {
                return this.unavailableMessageCount;
            }
        }
        return null;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/stats/QueueInstrumentation.java, SIB.processor, WAS602.SIB, o0610.11 1.68");
        }
    }
}

