/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.processor.UndeliverableReturnCode;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.AORequested;
import com.ibm.ws.sib.processor.impl.AOStream;
import com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.AOValue;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AOProtocolItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.runtime.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.SIMPReceivedMessageRequestInfo;
import com.ibm.ws.sib.processor.runtime.SIMPTransmitMessageRequestControllable;
import com.ibm.ws.sib.processor.runtime.anycast.ReceivedMessageRequestInfo;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import java.io.PrintStream;

public class TransmitMessageRequest
extends AbstractControlAdapter
implements SIMPTransmitMessageRequestControllable {
    private long tick;
    private SIMPItemStream itemStream;
    private AOStream aoStream;
    private MessageProcessor messageProcessor;
    private DestinationHandler destination;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static TraceComponent tc = SibTr.register((Class)TransmitMessageRequest.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public TransmitMessageRequest(long l, AOProtocolItemStream aOProtocolItemStream, AOStream aOStream, MessageProcessor messageProcessor, DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"TransmitMessageRequest", (Object)new Object[]{new Long(l), aOProtocolItemStream, aOStream, messageProcessor, destinationHandler});
        }
        this.tick = l;
        this.itemStream = aOProtocolItemStream;
        this.aoStream = aOStream;
        this.messageProcessor = messageProcessor;
        this.destination = destinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"TransmitMessageRequest");
        }
    }

    private long getMessageID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageID");
        }
        long l = -1L;
        TickRange tickRange = this.getTickRange();
        if (tickRange.value instanceof AOValue) {
            l = ((AOValue)tickRange.value).getMsgId();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageID", (Object)new Long(l));
        }
        return l;
    }

    private TickRange getTickRange() {
        return this.aoStream.getTickRange(this.tick);
    }

    public JsMessage getJsMessage() throws SIMPControllableNotFoundException, SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getJsMessage");
        }
        this.assertValidControllable();
        SIMPMessage sIMPMessage = this.getSIMPMessage();
        if (sIMPMessage == null) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"TransmitMessageRequest.assertValidControllable", "1:172:1.33", this.aoStream.getID()}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getJsMessage", (Object)sIMPMessage.getMessage());
        }
        return sIMPMessage.getMessage();
    }

    public String getState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState");
        }
        String string = null;
        TickRange tickRange = this.getTickRange();
        byte by = tickRange.type;
        switch (by) {
            case 1: {
                string = SIMPTransmitMessageRequestControllable.State.REQUEST.toString();
                break;
            }
            case 5: {
                string = SIMPTransmitMessageRequestControllable.State.ACKNOWLEDGED.toString();
                break;
            }
            case 7: {
                string = SIMPTransmitMessageRequestControllable.State.ACKNOWLEDGED.toString();
                break;
            }
            case 6: {
                string = SIMPTransmitMessageRequestControllable.State.REJECT.toString();
                break;
            }
            case 3: {
                string = ((AOValue)tickRange.value).removing ? SIMPTransmitMessageRequestControllable.State.REMOVING.toString() : SIMPTransmitMessageRequestControllable.State.PENDING_ACKNOWLEDGEMENT.toString();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getState", (Object)string);
        }
        return string;
    }

    public long getStartTick() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStateTick");
        }
        long l = this.getTickRange().startstamp;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStartTick", (Object)new Long(l));
        }
        return l;
    }

    public long getEndTick() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEndTick");
        }
        long l = this.getTickRange().endstamp;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEndTick", (Object)new Long(l));
        }
        return l;
    }

    public void removeMessage(boolean bl) throws SIMPControllableNotFoundException, SIMPRuntimeOperationFailedException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeMessage");
        }
        this.assertValidControllable();
        SIMPTransactionManager sIMPTransactionManager = this.messageProcessor.getTXManager();
        ExternalLocalTransaction externalLocalTransaction = sIMPTransactionManager.createLocalTransaction();
        SIMPMessage sIMPMessage = this.getSIMPMessage();
        long l = this.getMessageID();
        if (!bl) {
            ExceptionDestinationHandlerImpl exceptionDestinationHandlerImpl = new ExceptionDestinationHandlerImpl(this.destination);
            object = exceptionDestinationHandlerImpl.handleUndeliverableMessage((SIBusMessage)sIMPMessage.getMessage(), null, externalLocalTransaction, 36, new String[]{"" + l, this.destination.toString(), this.messageProcessor.getMessagingEngineName()});
            if (object == UndeliverableReturnCode.OK || object == UndeliverableReturnCode.DISCARD) {
                bl = true;
            } else {
                SIMPRuntimeOperationFailedException sIMPRuntimeOperationFailedException = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"QueuedMessage.removeMessage", "1:312:1.33", object}, null));
                SibTr.exception((TraceComponent)tc, (Exception)sIMPRuntimeOperationFailedException);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeMessage", (Object)sIMPRuntimeOperationFailedException);
                }
                throw sIMPRuntimeOperationFailedException;
            }
        }
        if (bl) {
            try {
                this.aoStream.syncRemoveValueTick(this.tick, externalLocalTransaction);
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.runtime.QueuedMessage.removeMessage", (String)"1:334:1.33", (Object)this);
                object = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"QueuedMessage.removeMessage", "1:342:1.33", messageStoreException, new Long(l)}, null), (Throwable)((Object)messageStoreException));
                SibTr.exception((TraceComponent)tc, (Exception)object);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeMessage", (Object)object);
                }
                throw object;
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.runtime.QueuedMessage.removeMessage", (String)"1:356:1.33", (Object)this);
                object = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"QueuedMessage.removeMessage", "1:364:1.33", sIException, new Long(l)}, null), sIException);
                SibTr.exception((TraceComponent)tc, (Exception)object);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeMessage", (Object)object);
                }
                throw object;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeMessage");
        }
    }

    public String getId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)("" + this.aoStream.getID()));
        }
        return "" + this.aoStream.getID() + ":" + this.tick;
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName");
        }
        return null;
    }

    public void formatState(PrintStream printStream, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"formatState", (Object)new Object[]{printStream, bl});
            SibTr.exit((TraceComponent)tc, (String)"formatState");
        }
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this.aoStream.itemStream == null || this.tick < 0L) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"QueuedMessage.assertValidControllable", "1:432:1.33", new Long(this.aoStream.getID())}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public void registerControlAdapterAsMBean() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    public void deregisterControlAdapterMBean() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
            SibTr.exit((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
    }

    public void runtimeEventOccurred(RuntimeEvent runtimeEvent) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"runtimeEventOccurred", (Object)runtimeEvent);
            SibTr.exit((TraceComponent)tc, (String)"runtimeEventOccurred");
        }
    }

    public String getTransactionId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionId");
        }
        String string = null;
        PersistentTranId persistentTranId = this.itemStream.getTransactionId();
        if (persistentTranId != null) {
            string = persistentTranId.toString();
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionId", (Object)string);
        }
        return string;
    }

    private SIMPMessage getSIMPMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIMPMessage");
        }
        SIMPMessage sIMPMessage = null;
        sIMPMessage = (SIMPMessage)((Object)this.itemStream.findById(this.getMessageID()));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIMPMessage", (Object)sIMPMessage);
        }
        return sIMPMessage;
    }

    public long getTick() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTick");
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTick", (Object)new Long(this.tick));
        }
        return this.tick;
    }

    public SIMPReceivedMessageRequestInfo getRequestMessageInfo() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRequestMessageInfo");
        }
        ReceivedMessageRequestInfo receivedMessageRequestInfo = null;
        Object object = this.aoStream.getTickRange((long)this.tick).value;
        if (object instanceof AORequested) {
            AORequested aORequested = (AORequested)object;
            receivedMessageRequestInfo = new ReceivedMessageRequestInfo(aORequested.startTime, aORequested.expiryInterval, aORequested.aock.getSelectionCriterias(), this.aoStream.getDMEVersion(), aORequested.tick);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRequestMessageInfo", receivedMessageRequestInfo);
        }
        return receivedMessageRequestInfo;
    }

    public synchronized void cancelMessageRequest(boolean bl) {
        block12: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"cancelMessageRequest", (Object)new Boolean(bl));
            }
            SIMPTransactionManager sIMPTransactionManager = this.messageProcessor.getTXManager();
            ExternalLocalTransaction externalLocalTransaction = sIMPTransactionManager.createLocalTransaction();
            MessageItem messageItem = (MessageItem)this.getSIMPMessage();
            if (bl) {
                try {
                    if (messageItem != null) {
                        this.aoStream.syncRemoveValueTick(this.tick, externalLocalTransaction);
                        break block12;
                    }
                    this.aoStream.expiredRequest(this.tick, true);
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.runtime.TransmitMessageRequest.cancelMessageRequest", (String)"1:609:1.33", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.TransmitMessageRequest.cancelMessageRequest", "1:614:1.33", SIMPUtils.getStackTrace((Throwable)((Object)messageStoreException))});
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.runtime.TransmitMessageRequest.cancelMessageRequest", (String)"1:623:1.33", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.TransmitMessageRequest.cancelMessageRequest", "1:628:1.33", SIMPUtils.getStackTrace(sIException)});
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                }
            } else {
                this.aoStream.expiredRequest(this.tick, true);
                if (messageItem != null && messageItem.isInStore()) {
                    try {
                        long l = messageItem.getLockID();
                        if (l != -2L) {
                            externalLocalTransaction = sIMPTransactionManager.createLocalTransaction();
                            messageItem.unlock(l, externalLocalTransaction);
                        }
                    }
                    catch (MessageStoreException messageStoreException) {
                        FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.runtime.TransmitMessageRequest.cancelMessageRequest", (String)"1:656:1.33", (Object)this);
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.TransmitMessageRequest.cancelMessageRequest", "1:661:1.33", SIMPUtils.getStackTrace((Throwable)((Object)messageStoreException))});
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cancelMessageRequest");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/TransmitMessageRequest.java, SIB.processor, WAS602.SIB, o0610.11 1.33");
        }
    }
}

