/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.processor.UndeliverableReturnCode;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.gd.SourceStream;
import com.ibm.ws.sib.processor.gd.Stream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProtocolItemStream;
import com.ibm.ws.sib.processor.runtime.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.QueuedMessage;
import com.ibm.ws.sib.processor.runtime.SIMPTransmitMessageControllable;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.PrintStream;
import java.util.Date;

public class TransmitMessage
extends AbstractControlAdapter
implements SIMPTransmitMessageControllable {
    private Stream _stream;
    private long _tick;
    private long _previousTick;
    private MessageItem _message;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)TransmitMessage.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public TransmitMessage(MessageItem messageItem, Stream stream) {
        this._tick = messageItem.getMessage().getGuaranteedValueValueTick();
        this._stream = stream;
        this._message = messageItem;
        this._previousTick = this._message.getMessage().getGuaranteedValueStartTick() - 1L;
    }

    public TransmitMessage(long l, StreamSet streamSet) {
        ProtocolItemStream protocolItemStream = (ProtocolItemStream)streamSet.getItemStream();
        MessageItem messageItem = (MessageItem)protocolItemStream.findById(l);
        this._tick = messageItem.getMessage().getGuaranteedValueValueTick();
        this._stream = streamSet.getStream(messageItem.getPriority(), messageItem.getReliability());
        this._message = messageItem;
        this._previousTick = this._message.getMessage().getGuaranteedValueStartTick() - 1L;
    }

    private TickRange getTickRange() {
        return this._stream.getTickRange(this._tick);
    }

    public SIMPMessage getSIMPMessage() {
        return this._message;
    }

    public JsMessage getJsMessage() throws SIMPControllableNotFoundException, SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getJsMessage");
        }
        this.assertValidControllable();
        JsMessage jsMessage = this._message.getMessage();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getJsMessage", (Object)jsMessage);
        }
        return jsMessage;
    }

    public String getState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState");
        }
        TickRange tickRange = this.getTickRange();
        long l = Long.MAX_VALUE;
        if (this._stream instanceof SourceStream) {
            l = ((SourceStream)this._stream).getFirstMsgOutsideWindow();
        }
        SIMPTransmitMessageControllable.State state = SIMPTransmitMessageControllable.State.COMPLETE;
        if (tickRange.type == 2) {
            state = SIMPTransmitMessageControllable.State.COMMITTING;
        } else if (tickRange.type == 3 && this._tick < l) {
            state = SIMPTransmitMessageControllable.State.PENDING_ACKNOWLEDGEMENT;
        } else if (tickRange.type == 3 && this._tick >= l) {
            state = SIMPTransmitMessageControllable.State.PENDING_SEND;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getState", (Object)state);
        }
        return state.toString();
    }

    public long getStartTick() {
        return this._tick;
    }

    public long getEndTick() {
        return this._tick;
    }

    public void removeMessage(boolean bl) throws SIMPControllableNotFoundException, SIMPRuntimeOperationFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeMessage");
        }
        this.assertValidControllable();
        try {
            this._stream.writeSilenceForced(this._tick);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.runtime.TransmitMessage.removeMessage", (String)"1:209:1.26", (Object)this);
            SIMPRuntimeOperationFailedException sIMPRuntimeOperationFailedException = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"TransmitMessage.removeMessage", "1:217:1.26", sIException, new Long(this._tick)}, null), sIException);
            SibTr.exception((TraceComponent)tc, (Exception)sIMPRuntimeOperationFailedException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeMessage", (Object)sIMPRuntimeOperationFailedException);
            }
            throw sIMPRuntimeOperationFailedException;
        }
        QueuedMessage queuedMessage = (QueuedMessage)this._message.getControlAdapter();
        queuedMessage.removeMessage(bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeMessage");
        }
    }

    public UndeliverableReturnCode copyMessageToExceptionDestination() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"copyMessageToExceptionDestination");
        }
        QueuedMessage queuedMessage = (QueuedMessage)this._message.getControlAdapter();
        UndeliverableReturnCode undeliverableReturnCode = queuedMessage.copyMessageToExceptionDestination(null);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"copyMessageToExceptionDestination", (Object)undeliverableReturnCode);
        }
        return undeliverableReturnCode;
    }

    public long getSequenceID() {
        return this._tick;
    }

    public Date getProducedTime() {
        Date date = new Date(this._message.getMessage().getTimestamp());
        return date;
    }

    public long getPreviousSequenceId() {
        return this._previousTick;
    }

    public String getId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        String string = new Long(this._message.getID()).toString();
        SibTr.exit((TraceComponent)tc, (String)"getId", (Object)string);
        return string;
    }

    public String getName() {
        return null;
    }

    public void formatState(PrintStream printStream, boolean bl) {
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        TickRange tickRange = this.getTickRange();
        if (tickRange.type != 2 && tickRange.type != 3) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"TransmitMessage.assertValidControllable", "1:320:1.26", new Long(this._tick)}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            throw sIMPControllableNotFoundException;
        }
    }

    public void dereferenceControllable() {
        this._tick = -1L;
        this._stream = null;
    }

    public void registerControlAdapterAsMBean() {
    }

    public void deregisterControlAdapterMBean() {
    }

    public void runtimeEventOccurred(RuntimeEvent runtimeEvent) {
    }

    public String getTransactionId() {
        String string = null;
        SIMPMessage sIMPMessage = this.getSIMPMessage();
        PersistentTranId persistentTranId = sIMPMessage.getTransactionId();
        if (persistentTranId != null) {
            string = persistentTranId.toString();
        }
        return string;
    }

    public void putMessageToExceptionDestination() {
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/TransmitMessage.java, SIB.processor, WAS602.SIB, o0610.11 1.26");
        }
    }

    class TransmitID {
        Reliability reliability;
        int priority;
        long tick;

        TransmitID(String string) {
            String[] stringArray = string.split(":");
            this.reliability = Reliability.getReliabilityByName((String)stringArray[0]);
            this.priority = Integer.parseInt(stringArray[1]);
            this.tick = Long.parseLong(stringArray[2]);
        }

        public int getPriority() {
            return this.priority;
        }

        public Reliability getReliability() {
            return this.reliability;
        }

        public long getTickValue() {
            return this.tick;
        }
    }
}

