/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TargetStream;
import com.ibm.ws.sib.processor.gd.TargetStreamManager;
import com.ibm.ws.sib.processor.runtime.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.DeliveryStreamType;
import com.ibm.ws.sib.processor.runtime.SIMPInboundReceiverControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.TargetStreamControllableIterator;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.PrintStream;
import java.util.Iterator;

public class TargetStreamSetControl
extends AbstractControlAdapter
implements SIMPInboundReceiverControllable {
    private TargetStreamManager tsm;
    private StreamSet streamSet;
    private SIBUuid12 streamID;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)TargetStreamSetControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public TargetStreamSetControl(StreamSet streamSet) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"TargetStreamSetControl", (Object)new Object[]{streamSet});
        }
        this.streamSet = streamSet;
        this.streamID = streamSet.getStreamID();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"TargetStreamSetControl", (Object)this);
        }
    }

    public void requestFlushAtSource(boolean bl) throws SIMPRuntimeOperationFailedException, SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"requestFlushAtSource", (Object)new Boolean(bl));
        }
        this.assertValidControllable();
        Cellule cellule = this.streamSet.getCellule();
        SIBUuid12 sIBUuid12 = this.streamSet.getDestUuid();
        SIBUuid8 sIBUuid8 = this.streamSet.getBusUuid();
        try {
            this.tsm.requestFlushAtSource(cellule, sIBUuid12, sIBUuid8, this.streamID, bl);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.runtime.TargetStreamSetControl.requestFlushAtSource", (String)"1:111:1.5", (Object)this);
            SIMPRuntimeOperationFailedException sIMPRuntimeOperationFailedException = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"TargetStreamSetControl.requestFlushAtSource", "1:119:1.5", sIException, this.streamID}, null), sIException);
            SibTr.exception((TraceComponent)tc, (Exception)sIMPRuntimeOperationFailedException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"requestFlushAtSource", (Object)sIMPRuntimeOperationFailedException);
            }
            throw sIMPRuntimeOperationFailedException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requestFlushAtSource");
        }
    }

    public long getLastTickReceived() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLastTickReceived");
        }
        this.assertValidControllable();
        long l = 0L;
        Iterator iterator = this.streamSet.iterator();
        while (iterator.hasNext()) {
            TargetStream targetStream = (TargetStream)iterator.next();
            long l2 = targetStream.getLastKnownTick();
            l = l2 > l ? l2 : l;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLastTickReceived", (Object)new Long(l));
        }
        return l;
    }

    public void forceFlushAtTarget() throws SIMPRuntimeOperationFailedException, SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceFlushAtTarget");
        }
        this.assertValidControllable();
        try {
            this.tsm.forceFlush(this.streamID);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.runtime.TargetStreamSetControl.forceFlushAtTarget", (String)"1:190:1.5", (Object)this);
            SIMPRuntimeOperationFailedException sIMPRuntimeOperationFailedException = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"TargetStreamSetControl.forceFlushAtTarget", "1:198:1.5", sIException, this.streamID}, null), sIException);
            SibTr.exception((TraceComponent)tc, (Exception)sIMPRuntimeOperationFailedException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTarget", (Object)sIMPRuntimeOperationFailedException);
            }
            throw sIMPRuntimeOperationFailedException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTarget");
        }
    }

    public DeliveryStreamType getType() {
        return null;
    }

    public void formatState(PrintStream printStream, boolean bl) {
    }

    public String getName() {
        return null;
    }

    public String getId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        String string = this.streamID.toString();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)string);
        }
        return string;
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this.streamSet == null || this.tsm == null) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"TargetStreamSetControl.assertValidControllable", "1:266:1.5", this.streamID}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable", (Object)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable", (Object)this.tsm);
        }
        this.streamSet = null;
        this.tsm = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public void runtimeEventOccurred(RuntimeEvent runtimeEvent) {
    }

    public void setTargetStreamManager(TargetStreamManager targetStreamManager) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setTargetStreamManager", (Object)targetStreamManager);
        }
        this.tsm = targetStreamManager;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setTargetStreamManager");
        }
    }

    public long getNumberOfMessagesReceived() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfMessagesReceived");
        }
        Iterator iterator = this.streamSet.iterator();
        long l = 0L;
        while (iterator.hasNext()) {
            TargetStream targetStream = (TargetStream)iterator.next();
            l += targetStream.getNumberOfMessagesReceived();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfMessagesReceived", (Object)new Long(l));
        }
        return l;
    }

    public long getDepth() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDepth");
        }
        Iterator iterator = this.streamSet.iterator();
        long l = 0L;
        while (iterator.hasNext()) {
            TargetStream targetStream = (TargetStream)iterator.next();
            l += (long)targetStream.getAllMessagesOnStream().size();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDepth", (Object)new Long(l));
        }
        return l;
    }

    public SIMPIterator getStreams() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreams");
        }
        Iterator iterator = this.streamSet.iterator();
        TargetStreamControllableIterator targetStreamControllableIterator = new TargetStreamControllableIterator(iterator);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreams", (Object)targetStreamControllableIterator);
        }
        return targetStreamControllableIterator;
    }

    public String getRemoteEngineUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
        }
        String string = this.streamSet.getRemoteEngineUUID();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)string);
        }
        return string;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/TargetStreamSetControl.java, SIB.processor, WAS602.SIB, o0610.11 1.5");
        }
    }
}

