/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.gd.TargetStream;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.BaseMessageItemStream;
import com.ibm.ws.sib.processor.runtime.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.ReceivedMessage;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryReceiverControllable;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryStreamReceiverControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPReceivedMessageControllable;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;

public class TargetStreamControl
extends AbstractControlAdapter
implements SIMPDeliveryStreamReceiverControllable {
    private static final TraceComponent tc = SibTr.register((Class)TargetStreamControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    private TargetStream _targetStream;
    private SIBUuid12 _streamSetID;
    private Reliability _targetStreamReliability;
    private int _priority;
    private String _remoteEngineUUID;

    public TargetStreamControl(String string, TargetStream targetStream, SIBUuid12 sIBUuid12, Reliability reliability, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"TargetStreamControl", (Object)new Object[]{this._targetStream, this._streamSetID, this._targetStreamReliability, new Integer(this._priority)});
        }
        this._remoteEngineUUID = string;
        this._targetStream = targetStream;
        this._streamSetID = sIBUuid12;
        this._targetStreamReliability = reliability;
        this._priority = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"TargetStreamControl", (Object)this);
        }
    }

    public SIMPDeliveryReceiverControllable.StreamState getStreamState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamState");
        }
        TargetStream.TargetStreamState targetStreamState = this._targetStream.getStreamState();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)targetStreamState);
        }
        return targetStreamState;
    }

    public SIBUuid12 getStreamID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamID");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamID", (Object)this._streamSetID);
        }
        return this._streamSetID;
    }

    public Reliability getReliability() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReliability");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReliability", (Object)this._targetStreamReliability);
        }
        return this._targetStreamReliability;
    }

    public int getPriority() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPriority");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPriority", (Object)new Integer(this._priority));
        }
        return this._priority;
    }

    public int getNumberOfActiveMessages() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfActiveMessages");
        }
        int n = (int)this._targetStream.countAllMessagesOnStream();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfActiveMessages", (Object)new Integer(n));
        }
        return n;
    }

    public String getRemoteEngineUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)this._remoteEngineUUID);
        }
        return this._remoteEngineUUID;
    }

    public String getName() {
        return null;
    }

    public void formatState(PrintStream printStream, boolean bl) {
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this._targetStream = null;
        this._streamSetID = null;
        this._priority = -1;
        this._targetStreamReliability = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public void runtimeEventOccurred(RuntimeEvent runtimeEvent) {
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this._targetStream == null || this._streamSetID == null || this._targetStreamReliability == null) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"TargetStreamControl.assertValidControllable", "1:223:1.17", this._streamSetID}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable", (Object)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    public String getId() {
        String string = this._targetStream.getID();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)string);
        }
        return string;
    }

    public SIMPIterator getReceivedMessageIterator() {
        LinkedList<ReceivedMessage> linkedList = new LinkedList<ReceivedMessage>();
        Iterator iterator = this._targetStream.getAllMessagesOnStream().iterator();
        while (iterator.hasNext()) {
            MessageItem messageItem = (MessageItem)iterator.next();
            BaseDestinationHandler baseDestinationHandler = ((BaseMessageItemStream)messageItem.getItemStream()).getDestinationHandler();
            ReceivedMessage receivedMessage = new ReceivedMessage(messageItem, baseDestinationHandler.getMessageProcessor(), baseDestinationHandler);
            linkedList.add(receivedMessage);
        }
        return new BasicSIMPIterator(linkedList.iterator());
    }

    public SIMPReceivedMessageControllable getReceivedMessageByID(String string) {
        ReceivedMessage receivedMessage = null;
        SIMPIterator sIMPIterator = this.getReceivedMessageIterator();
        while (sIMPIterator.hasNext()) {
            ReceivedMessage receivedMessage2 = (ReceivedMessage)sIMPIterator.next();
            String string2 = receivedMessage2.getId();
            if (!string2.equals(string)) continue;
            receivedMessage = receivedMessage2;
            break;
        }
        return receivedMessage;
    }

    public long getLastDeliveredMessageSequenceId() {
        return this._targetStream.getLastKnownTick();
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/TargetStreamControl.java, SIB.processor, WAS602.SIB, o0610.11 1.17");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

