/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.gd.AIStream;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.runtime.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.DeliveryStreamType;
import com.ibm.ws.sib.processor.runtime.IndoubtAction;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryReceiverControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteConsumerReceiverControllable;
import com.ibm.ws.sib.processor.runtime.anycast.AIStreamIterator;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.PrintStream;

public class RemoteConsumerReceiver
extends AbstractControlAdapter
implements SIMPRemoteConsumerReceiverControllable {
    private AIStream aiStream;
    private DestinationHandler destinationHandler;
    private SIBUuid8 dme;
    private AnycastInputHandler anycastIH;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static TraceComponent tc = SibTr.register((Class)RemoteConsumerReceiver.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public RemoteConsumerReceiver(AIStream aIStream, DestinationHandler destinationHandler, SIBUuid8 sIBUuid8, AnycastInputHandler anycastInputHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RemoteConsumerReceiver", (Object)new Object[]{aIStream, destinationHandler, anycastInputHandler});
        }
        this.aiStream = aIStream;
        this.destinationHandler = destinationHandler;
        this.dme = sIBUuid8;
        this.anycastIH = anycastInputHandler;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"RemoteConsumerReceiver");
        }
    }

    public SIMPIterator getRemoteMessageRequestIterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteMessageRequestIterator");
        }
        AIStreamIterator aIStreamIterator = new AIStreamIterator(this.aiStream);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteMessageRequestIterator", (Object)aIStreamIterator);
        }
        return aIStreamIterator;
    }

    public void requestFlushAtSource(IndoubtAction indoubtAction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"requestFlushAtSource", (Object)indoubtAction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requestFlushAtSource");
        }
    }

    public long getLastTickReceived() throws SIMPRuntimeOperationFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLastTickReceived");
        }
        try {
            this.assertValidControllable();
        }
        catch (SIMPControllableNotFoundException sIMPControllableNotFoundException) {
            FFDCFilter.processException((Throwable)sIMPControllableNotFoundException, (String)"com.ibm.ws.sib.processor.runtime.RemoteConsumerReceiver.getLastTickReceived", (String)"1:167:1.33", (Object)this);
            SIMPRuntimeOperationFailedException sIMPRuntimeOperationFailedException = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"RemoteConsumerReceiver.getLastTickReceived", "1:175:1.33", sIMPControllableNotFoundException, this.aiStream.getStreamId()}, null), sIMPControllableNotFoundException);
            SibTr.exception((TraceComponent)tc, (Exception)sIMPRuntimeOperationFailedException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getLastTickReceived", (Object)sIMPRuntimeOperationFailedException);
            }
            throw sIMPRuntimeOperationFailedException;
        }
        long l = this.aiStream.getStateStream().getCompletedPrefix();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLastTickReceived", (Object)new Long(l));
        }
        return l;
    }

    public void forceFlushAtTarget() throws SIMPRuntimeOperationFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceFlushAtTarget");
        }
        try {
            this.assertValidControllable();
        }
        catch (SIMPControllableNotFoundException sIMPControllableNotFoundException) {
            FFDCFilter.processException((Throwable)sIMPControllableNotFoundException, (String)"com.ibm.ws.sib.processor.runtime.RemoteConsumerReceiver.forceFlushAtTarget", (String)"1:210:1.33", (Object)this);
            SIMPRuntimeOperationFailedException sIMPRuntimeOperationFailedException = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"RemoteConsumerReceiver.forceFlushAtTarget", "1:218:1.33", sIMPControllableNotFoundException, this.aiStream.getStreamId()}, null), sIMPControllableNotFoundException);
            SibTr.exception((TraceComponent)tc, (Exception)sIMPRuntimeOperationFailedException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTarget", (Object)sIMPRuntimeOperationFailedException);
            }
            throw sIMPRuntimeOperationFailedException;
        }
        AnycastInputHandler anycastInputHandler = this.destinationHandler.getAnycastInputHandler(this.dme);
        if (anycastInputHandler != null) {
            anycastInputHandler.forceFlushAtTarget();
            try {
                ((BaseDestinationHandler)this.destinationHandler).removeAnycastInputHandlerAndRCD(this.dme);
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.runtime.RemoteConsumerReceiver.forceFlushAtTarget", (String)"1:242:1.33", (Object)this);
                SIMPRuntimeOperationFailedException sIMPRuntimeOperationFailedException = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"RemoteConsumerReceiver.forceFlushAtTarget", "1:250:1.33", sIResourceException, this.aiStream.getStreamId()}, null), sIResourceException);
                SibTr.exception((TraceComponent)tc, (Exception)sIMPRuntimeOperationFailedException);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTarget", (Object)sIMPRuntimeOperationFailedException);
                }
                throw sIMPRuntimeOperationFailedException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTarget");
        }
    }

    public DeliveryStreamType getType() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getType");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getType", (Object)DeliveryStreamType.ANYCAST_TARGET);
        }
        return DeliveryStreamType.ANYCAST_TARGET;
    }

    public String getId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        String string = this.aiStream.getStreamId().toString();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId");
        }
        return string;
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", null);
        }
        return null;
    }

    public void formatState(PrintStream printStream, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"formatState", (Object)new Object[]{printStream, new Boolean(bl)});
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"formatState");
        }
    }

    public void cancelAllRequests() {
        try {
            this.forceFlushAtTarget();
        }
        catch (SIMPRuntimeOperationFailedException sIMPRuntimeOperationFailedException) {
            FFDCFilter.processException((Throwable)sIMPRuntimeOperationFailedException, (String)"com.ibm.ws.sib.processor.runtime.RemoteConsumerReceiver.cancelAllRequests", (String)"1:332:1.33", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.RemoteConsumerReceiver.cancelAllRequests", "1:337:1.33", SIMPUtils.getStackTrace(sIMPRuntimeOperationFailedException)});
            SibTr.exception((TraceComponent)tc, (Exception)sIMPRuntimeOperationFailedException);
        }
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this.aiStream == null || this.aiStream.getAIProtocolItemStream() == null) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"RemoteConsumerReceiver.assertValidControllable", "1:358:1.33", this.aiStream}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public void registerControlAdapterAsMBean() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    public void deregisterControlAdapterMBean() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
    }

    public void runtimeEventOccurred(RuntimeEvent runtimeEvent) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"runtimeEventOccurred", (Object)runtimeEvent);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"runtimeEventOccurred");
        }
    }

    public int getNumberOfActiveRequests() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfActiveRequests");
        }
        int n = (int)(this.getNumberOfRequestsIssued() - this.getNumberOfCompletedRequests());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfActiveRequests", (Object)new Integer(n));
        }
        return n;
    }

    public long getNumberOfCompletedRequests() {
        long l = this.anycastIH.getCompletedRequestCount();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfCompletedRequests", (Object)new Long(l));
        }
        return l;
    }

    public long getNumberOfRequestsIssued() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfRequestsIssued");
        }
        long l = this.anycastIH.getTotalSentRequests();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfRequestsIssued", (Object)new Long(l));
        }
        return l;
    }

    public SIBUuid12 getStreamID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamID");
        }
        SIBUuid12 sIBUuid12 = this.aiStream.getStreamId();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamID", (Object)sIBUuid12);
        }
        return sIBUuid12;
    }

    public SIMPDeliveryReceiverControllable.StreamState getStreamState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamState");
        }
        AIStream.AIStreamState aIStreamState = this.aiStream.getStreamState();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)aIStreamState);
        }
        return aIStreamState;
    }

    public String getRemoteEngineUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
        }
        String string = this.dme.toString();
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)string);
        }
        return string;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/RemoteConsumerReceiver.java, SIB.processor, WAS602.SIB, o0610.11 1.33");
        }
    }
}

