/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.processor.UndeliverableReturnCode;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.runtime.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.SIMPQueuedMessageControllable;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.PrintStream;

public class QueuedMessage
extends AbstractControlAdapter
implements SIMPQueuedMessageControllable {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)QueuedMessage.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private long _messageID;
    private ItemStream _itemStream = null;
    private ReferenceStream _refStream = null;
    private DestinationHandler _destinationHandler;
    private SIMPTransactionManager _txManager;
    private MessageProcessor _messageProcessor;

    public QueuedMessage(SIMPMessage sIMPMessage, DestinationHandler destinationHandler, ItemStream itemStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"QueuedMessage", (Object)new Object[]{sIMPMessage, destinationHandler, itemStream});
        }
        this._messageID = sIMPMessage.getID();
        this._itemStream = itemStream;
        this._destinationHandler = destinationHandler;
        this._messageProcessor = this._destinationHandler.getMessageProcessor();
        this._txManager = this._messageProcessor.getTXManager();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"QueuedMessage", (Object)this);
        }
    }

    public QueuedMessage(SIMPMessage sIMPMessage, DestinationHandler destinationHandler, ReferenceStream referenceStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"QueuedMessage", (Object)new Object[]{sIMPMessage, destinationHandler, referenceStream});
        }
        this._messageID = sIMPMessage.getID();
        this._refStream = referenceStream;
        this._destinationHandler = destinationHandler;
        this._messageProcessor = this._destinationHandler.getMessageProcessor();
        this._txManager = this._messageProcessor.getTXManager();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"QueuedMessage", (Object)this);
        }
    }

    public JsMessage getJsMessage() throws SIMPControllableNotFoundException, SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getJsMessage");
        }
        this.assertValidControllable();
        SIMPMessage sIMPMessage = this.getSIMPMessage();
        if (sIMPMessage == null) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"QueuedMessage.getJsMessage", "1:160:1.41", new Long(this._messageID)}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getJsMessage", (Object)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getJsMessage");
        }
        return sIMPMessage.getMessage();
    }

    private SIMPMessage getSIMPMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIMPMessage");
        }
        SIMPMessage sIMPMessage = null;
        if (this._itemStream != null) {
            sIMPMessage = (SIMPMessage)((Object)this._itemStream.findById(this._messageID));
        } else if (this._refStream != null) {
            sIMPMessage = (SIMPMessage)((Object)this._refStream.findById(this._messageID));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIMPMessage", (Object)sIMPMessage);
        }
        return sIMPMessage;
    }

    public String getState() throws SIMPException {
        AbstractItem abstractItem;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState");
        }
        this.assertValidControllable();
        SIMPMessage sIMPMessage = this.getSIMPMessage();
        if (sIMPMessage != null && !(abstractItem = (AbstractItem)((Object)sIMPMessage)).isAvailable()) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getState", (Object)"LOCKED");
            }
            return "LOCKED";
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getState", (Object)"UNLOCKED");
        }
        return "UNLOCKED";
    }

    public String getTransactionId() throws SIMPException {
        PersistentTranId persistentTranId;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionId");
        }
        this.assertValidControllable();
        String string = null;
        SIMPMessage sIMPMessage = this.getSIMPMessage();
        if (sIMPMessage != null && (persistentTranId = sIMPMessage.getTransactionId()) != null) {
            string = persistentTranId.toString();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransactionId", string);
        }
        return string;
    }

    public UndeliverableReturnCode copyMessageToExceptionDestination(ExternalLocalTransaction externalLocalTransaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"copyMessageToExceptionDestination");
        }
        MessageItem messageItem = (MessageItem)this.getSIMPMessage();
        ExceptionDestinationHandlerImpl exceptionDestinationHandlerImpl = new ExceptionDestinationHandlerImpl(this._destinationHandler);
        UndeliverableReturnCode undeliverableReturnCode = exceptionDestinationHandlerImpl.handleUndeliverableMessage(messageItem, externalLocalTransaction, 36, new String[]{"" + this._messageID, this._destinationHandler.toString(), this._messageProcessor.getMessagingEngineName()}, true);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"copyMessageToExceptionDestination", (Object)undeliverableReturnCode);
        }
        return undeliverableReturnCode;
    }

    public void removeMessage(boolean bl) throws SIMPControllableNotFoundException, SIMPRuntimeOperationFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeMessage", (Object)new Object[]{new Boolean(bl)});
        }
        this.assertValidControllable();
        ExternalLocalTransaction externalLocalTransaction = this._txManager.createLocalTransaction();
        MessageItem messageItem = (MessageItem)this.getSIMPMessage();
        if (!bl) {
            UndeliverableReturnCode undeliverableReturnCode = this.copyMessageToExceptionDestination(externalLocalTransaction);
            if (undeliverableReturnCode == UndeliverableReturnCode.OK || undeliverableReturnCode == UndeliverableReturnCode.DISCARD) {
                bl = true;
            } else {
                SIMPRuntimeOperationFailedException sIMPRuntimeOperationFailedException = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"QueuedMessage.removeMessage", "1:304:1.41", undeliverableReturnCode}, null));
                SibTr.exception((TraceComponent)tc, (Exception)sIMPRuntimeOperationFailedException);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeMessage", (Object)sIMPRuntimeOperationFailedException);
                }
                throw sIMPRuntimeOperationFailedException;
            }
        }
        if (bl) {
            try {
                if (messageItem.isInStore()) {
                    if (messageItem.getLockID() == -2L) {
                        long l = this._messageProcessor.getMessageStore().getUniqueLockID(1);
                        messageItem.lockItemIfAvailable(l);
                    }
                    messageItem.remove(externalLocalTransaction, messageItem.getLockID());
                }
            }
            catch (Exception exception) {
                SIMPRuntimeOperationFailedException sIMPRuntimeOperationFailedException = null;
                if (messageItem.isAdding()) {
                    sIMPRuntimeOperationFailedException = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("MESSAGE_INDOUBT_WARNING_CWSIP0361", new Object[]{new Long(this._messageID), this._destinationHandler.getName()}, null), exception);
                } else {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.runtime.QueuedMessage.removeMessage", (String)"1:354:1.41", (Object)this);
                    sIMPRuntimeOperationFailedException = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"QueuedMessage.removeMessage", "1:362:1.41", exception, new Long(this._messageID)}, null), exception);
                }
                SibTr.exception((TraceComponent)tc, (Exception)sIMPRuntimeOperationFailedException);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeMessage", (Object)sIMPRuntimeOperationFailedException);
                }
                throw sIMPRuntimeOperationFailedException;
            }
        }
        try {
            externalLocalTransaction.commit();
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.runtime.QueuedMessage.removeMessage", (String)"1:382:1.41", (Object)this);
            SIMPRuntimeOperationFailedException sIMPRuntimeOperationFailedException = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"QueuedMessage.removeMessage", "1:390:1.41", sIException, new Long(this._messageID)}, null), sIException);
            SibTr.exception((TraceComponent)tc, (Exception)sIMPRuntimeOperationFailedException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeMessage", (Object)sIMPRuntimeOperationFailedException);
            }
            throw sIMPRuntimeOperationFailedException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeMessage");
        }
    }

    public String getId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)new Long(this._messageID));
        }
        return "" + this._messageID;
    }

    public String getName() {
        return null;
    }

    public void formatState(PrintStream printStream, boolean bl) {
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this._messageID == -1L) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"QueuedMessage.assertValidControllable", "1:446:1.41", new Long(this._messageID)}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable", (Object)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this._messageID = -1L;
        this._destinationHandler = null;
        this._messageProcessor = null;
        this._itemStream = null;
        this._refStream = null;
        this._txManager = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public void registerControlAdapterAsMBean() {
    }

    public void deregisterControlAdapterMBean() {
    }

    public void runtimeEventOccurred(RuntimeEvent runtimeEvent) {
    }

    public long getSequenceID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSequenceID");
        }
        long l = 0L;
        SIMPMessage sIMPMessage = this.getSIMPMessage();
        if (sIMPMessage != null) {
            l = sIMPMessage.getMessage().getGuaranteedValueValueTick();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSequenceID", (Object)new Long(l));
        }
        return l;
    }

    public long getPreviousSequenceId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPreviousSequenceId");
        }
        long l = 0L;
        SIMPMessage sIMPMessage = this.getSIMPMessage();
        if (sIMPMessage != null) {
            l = sIMPMessage.getMessage().getGuaranteedValueStartTick() - 1L;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPreviousSequenceId", (Object)new Long(l));
        }
        return l;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/QueuedMessage.java, SIB.processor, WAS602.SIB, o0610.11 1.41");
        }
    }
}

