/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPInvalidRuntimeIDException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.indexes.DestinationIndex;
import com.ibm.ws.sib.processor.impl.indexes.DestinationTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.ForeignBusTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.LinkTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.SubscriptionIndex;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableSubscription;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.runtime.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.ControllableIterator;
import com.ibm.ws.sib.processor.runtime.KnownDurableSubscription;
import com.ibm.ws.sib.processor.runtime.LocalQueuePointIterator;
import com.ibm.ws.sib.processor.runtime.LocalSubscriptionControl;
import com.ibm.ws.sib.processor.runtime.MediationPointIterator;
import com.ibm.ws.sib.processor.runtime.Queue;
import com.ibm.ws.sib.processor.runtime.RemoteQueuePointIterator;
import com.ibm.ws.sib.processor.runtime.SIMPControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPLocalQueuePointControllable;
import com.ibm.ws.sib.processor.runtime.SIMPLocalSubscriptionControllable;
import com.ibm.ws.sib.processor.runtime.SIMPLocalTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.SIMPMediationPointControllable;
import com.ibm.ws.sib.processor.runtime.SIMPMessageHandlerControllable;
import com.ibm.ws.sib.processor.runtime.SIMPMessageProcessorControllable;
import com.ibm.ws.sib.processor.runtime.SIMPQueueControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteMediationPointControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteQueuePointControllable;
import com.ibm.ws.sib.processor.runtime.SIMPTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.Topicspace;
import com.ibm.ws.sib.processor.runtime.anycast.AttachedRemoteSubscriberIterator;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Map;

public class MessageProcessorControl
extends AbstractControlAdapter
implements SIMPMessageProcessorControllable {
    private static final TraceComponent tc = SibTr.register((Class)MessageProcessorControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    private static final TraceNLS nls_cwsik;
    private DestinationIndex destinationIndex;
    private MessageProcessor messageProcessor;
    private DestinationManager destinationManager;

    public MessageProcessorControl(MessageProcessor messageProcessor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageProcessorControl", (Object)new Object[]{messageProcessor});
        }
        this.messageProcessor = messageProcessor;
        this.destinationManager = messageProcessor.getDestinationManager();
        this.destinationIndex = this.destinationManager.getDestinationIndex();
    }

    public SIMPIterator getForeignBusIterator() {
        ForeignBusTypeFilter foreignBusTypeFilter = new ForeignBusTypeFilter();
        SIMPIterator sIMPIterator = this.destinationManager.getForeignBusIndex().iterator(foreignBusTypeFilter);
        return new ControllableIterator(sIMPIterator);
    }

    public SIMPIterator getVirtualLinkIterator() {
        LinkTypeFilter linkTypeFilter = new LinkTypeFilter();
        SIMPIterator sIMPIterator = this.destinationManager.getLinkIndex().iterator(linkTypeFilter);
        return new ControllableIterator(sIMPIterator);
    }

    public SIMPIterator getQueueIterator() {
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.QUEUE = Boolean.TRUE;
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        return new ControllableIterator(sIMPIterator);
    }

    public SIMPIterator getLocalQueueIterator() {
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.QUEUE = Boolean.TRUE;
        destinationTypeFilter.LOCAL = Boolean.TRUE;
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        return new ControllableIterator(sIMPIterator);
    }

    public SIMPIterator getRemoteQueueIterator() {
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.QUEUE = Boolean.TRUE;
        destinationTypeFilter.REMOTE = Boolean.TRUE;
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        return new ControllableIterator(sIMPIterator);
    }

    public SIMPIterator getTopicSpaceIterator() {
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.QUEUE = Boolean.FALSE;
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        return new ControllableIterator(sIMPIterator);
    }

    public SIMPIterator getLocalQueuePointIterator() {
        return new LocalQueuePointIterator(this.getLocalQueueIterator());
    }

    public SIMPIterator getRemoteQueuePointIterator() {
        return new RemoteQueuePointIterator(this.getRemoteQueueIterator());
    }

    public SIMPIterator getKnownDurableSubscriptionsIterator() {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getKnownDurableSubscriptionsIterator");
        }
        SIMPIterator sIMPIterator = this.getTopicSpaceIterator();
        LinkedList<KnownDurableSubscription> linkedList = new LinkedList<KnownDurableSubscription>();
        while (sIMPIterator.hasNext()) {
            try {
                object = (Topicspace)sIMPIterator.next();
                SIMPIterator sIMPIterator2 = ((Topicspace)object).getDurableSubscriptionIterator();
                while (sIMPIterator2.hasNext()) {
                    linkedList.add(new KnownDurableSubscription((LocalSubscriptionControl)sIMPIterator2.next()));
                }
            }
            catch (SIMPException sIMPException) {
                FFDCFilter.processException((Throwable)sIMPException, (String)"com.ibm.ws.sib.processor.impl.MessageProcessorControl.getKnownDurableSubscriptionsIterator", (String)"1:240:1.45", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessorControl.getKnownDurableSubscriptionsIterator", "1:245:1.45", SIMPUtils.getStackTrace(sIMPException)});
            }
        }
        object = new BasicSIMPIterator(linkedList.iterator());
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getKnownDurableSubscriptionsIterator", (Object)object);
        }
        return object;
    }

    public SIMPIterator getConnectionsIterator() {
        return null;
    }

    public SIMPQueueControllable getQueueControlByID(String string) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueueControlByID", (Object)new Object[]{string});
        }
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.QUEUE = Boolean.TRUE;
        SIMPQueueControllable sIMPQueueControllable = (SIMPQueueControllable)this.getMessageHandlerControlByID(string, destinationTypeFilter);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueueControlByID", (Object)sIMPQueueControllable);
        }
        return sIMPQueueControllable;
    }

    private SIMPMessageHandlerControllable getMessageHandlerControlByID(String string, DestinationTypeFilter destinationTypeFilter) throws SIMPInvalidRuntimeIDException, SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageHandlerControlByID", (Object)new Object[]{string});
        }
        SIBUuid12 sIBUuid12 = null;
        try {
            sIBUuid12 = new SIBUuid12(string);
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.sib.processor.impl.MessageProcessorControl.getMessageHandlerControlByID", (String)"1:306:1.45", (Object)this);
            SIMPInvalidRuntimeIDException sIMPInvalidRuntimeIDException = new SIMPInvalidRuntimeIDException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"MessageProcessorControl.getMessageHandlerControlByID", "1:314:1.45", numberFormatException, string}, null), numberFormatException);
            SibTr.exception((TraceComponent)tc, (Exception)sIMPInvalidRuntimeIDException);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"MessageProcessorControl.getMessageHandlerControlByID", "1:322:1.45", numberFormatException, string});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMessageHandlerControlByID", (Object)sIMPInvalidRuntimeIDException);
            }
            throw sIMPInvalidRuntimeIDException;
        }
        DestinationHandler destinationHandler = this.destinationIndex.findByUuid(sIBUuid12, destinationTypeFilter);
        SIMPMessageHandlerControllable sIMPMessageHandlerControllable = null;
        if (destinationHandler == null) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_15", new Object[]{string, this.messageProcessor.getMessagingEngineName()}, null));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMessageHandlerControlByID", (Object)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        sIMPMessageHandlerControllable = (SIMPMessageHandlerControllable)((Object)destinationHandler.getControlAdapter());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageHandlerControlByID", (Object)sIMPMessageHandlerControllable);
        }
        return sIMPMessageHandlerControllable;
    }

    public SIMPQueueControllable getQueueControlByName(String string, String string2) throws SIMPControllableNotFoundException, SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueueControlByName", (Object)new Object[]{string, string2});
        }
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.VISIBLE = Boolean.TRUE;
        DestinationHandler destinationHandler = this.destinationIndex.findByName(string, string2, destinationTypeFilter);
        if (destinationHandler == null) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_15", new Object[]{string, this.messageProcessor.getMessagingEngineName()}, null));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueueControlByName", (Object)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueueControlByName");
        }
        return (SIMPQueueControllable)((Object)destinationHandler.getControlAdapter());
    }

    public SIMPTopicSpaceControllable getTopicSpaceControlByID(String string) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpaceControlByID", (Object)new Object[]{string});
        }
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.QUEUE = Boolean.FALSE;
        SIMPTopicSpaceControllable sIMPTopicSpaceControllable = (SIMPTopicSpaceControllable)this.getMessageHandlerControlByID(string, destinationTypeFilter);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpaceControlByID", (Object)sIMPTopicSpaceControllable);
        }
        return sIMPTopicSpaceControllable;
    }

    private SIMPControllable findControllableFromItemStream(SIMPItemStream sIMPItemStream, String string) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findControllableFromMsgStore", (Object)new Object[]{string});
        }
        ControllableResource controllableResource = null;
        ControlAdapter controlAdapter = null;
        try {
            controllableResource = (ControllableResource)((Object)sIMPItemStream.findById(Long.parseLong(string)));
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.sib.processor.impl.MessageProcessorControl.findControllableFromMsgStore", (String)"1:432:1.45", (Object)this);
            SIMPInvalidRuntimeIDException sIMPInvalidRuntimeIDException = new SIMPInvalidRuntimeIDException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"MessageProcessorControl.findControllableFromMsgStore", "1:440:1.45", numberFormatException, string}, null), numberFormatException);
            SibTr.exception((TraceComponent)tc, (Exception)sIMPInvalidRuntimeIDException);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"MessageProcessorControl.findControllableFromMsgStore", "1:448:1.45", numberFormatException, string});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"findControllableFromMsgStore", (Object)sIMPInvalidRuntimeIDException);
            }
            throw sIMPInvalidRuntimeIDException;
        }
        if (controllableResource == null) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"MessageProcessorControl.findControllableFromMsgStore", "1:462:1.45", string}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"findControllableFromMsgStore", (Object)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        controlAdapter = controllableResource.getControlAdapter();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findControllableFromMsgStore", (Object)controlAdapter);
        }
        return controlAdapter;
    }

    public SIMPLocalQueuePointControllable getLocalQueuePointControlByID(String string) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        DestinationHandler destinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalQueuePointControlByID", (Object)new Object[]{string});
        }
        SIMPLocalQueuePointControllable sIMPLocalQueuePointControllable = null;
        String[] stringArray = string.split("_QUEUE_");
        if (stringArray.length > 0 && (destinationHandler = this.destinationManager.getDestinationInternal(new SIBUuid12(stringArray[0]), false)) != null) {
            try {
                sIMPLocalQueuePointControllable = (SIMPLocalQueuePointControllable)this.findControllableFromItemStream((SIMPItemStream)((Object)destinationHandler), stringArray[1]);
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.sib.processor.runtime.MessageProcessorControl.getLocalQueuePointControlByID", (String)"1:513:1.45", (Object)this);
                SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"MessageProcessorControl.getLocalQueuePointControlByID", "1:521:1.45", string}, null));
                SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getLocalQueuePointControlByID", (Object)sIMPControllableNotFoundException);
                }
                throw sIMPControllableNotFoundException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalQueuePointControlByID");
        }
        return sIMPLocalQueuePointControllable;
    }

    public SIMPRemoteQueuePointControllable getRemoteQueuePointControlByID(String string) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteQueuePointControlByID", (Object)new Object[]{string});
        }
        SIMPRemoteQueuePointControllable sIMPRemoteQueuePointControllable = null;
        String[] stringArray = string.split("_REMOTE_QUEUE_");
        DestinationHandler destinationHandler = null;
        if (stringArray.length > 0 && (destinationHandler = this.destinationManager.getDestinationInternal(new SIBUuid12(stringArray[0]), true)) != null && (object = destinationHandler.getControlAdapter()) instanceof Queue) {
            sIMPRemoteQueuePointControllable = ((Queue)object).getRemoteQueuePointControlByMEUuid(stringArray[1]);
        }
        if (destinationHandler == null || sIMPRemoteQueuePointControllable == null) {
            object = new SIMPControllableNotFoundException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_15", new Object[]{string, this.messageProcessor.getMessagingEngineName()}, null));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getRemoteQueuePointControlByID", (Object)object);
            }
            throw object;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteQueuePointControlByID");
        }
        return sIMPRemoteQueuePointControllable;
    }

    public SIMPRemoteMediationPointControllable getRemoteMediationPointControlByID(String string) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteMediationPointControlByID", (Object)new Object[]{string});
        }
        SIMPRemoteMediationPointControllable sIMPRemoteMediationPointControllable = null;
        String[] stringArray = string.split("_REMOTE_MEDIATION_");
        DestinationHandler destinationHandler = null;
        if (stringArray.length > 0 && (destinationHandler = this.destinationManager.getDestinationInternal(new SIBUuid12(stringArray[0]), true)) != null) {
            object = destinationHandler.getControlAdapter();
            if (object instanceof Queue) {
                sIMPRemoteMediationPointControllable = ((Queue)object).getRemoteMediationPointControlByMEUuid(stringArray[1]);
            } else if (object instanceof Topicspace) {
                sIMPRemoteMediationPointControllable = ((Topicspace)object).getRemoteMediationPointControlByMEUuid(stringArray[1]);
            }
        }
        if (destinationHandler == null || sIMPRemoteMediationPointControllable == null) {
            object = new SIMPControllableNotFoundException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_15", new Object[]{string, this.messageProcessor.getMessagingEngineName()}, null));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getRemoteMediationPointControlByID", (Object)object);
            }
            throw object;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteMediationPointControlByID", sIMPRemoteMediationPointControllable);
        }
        return sIMPRemoteMediationPointControllable;
    }

    public SIMPIterator getMediationPointIterator() {
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.ALIAS = Boolean.FALSE;
        destinationTypeFilter.FOREIGN_DESTINATION = Boolean.FALSE;
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        return new MediationPointIterator(sIMPIterator);
    }

    public SIMPMediationPointControllable getMediationPointControlByID(String string) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        DestinationHandler destinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMediationPointControlByID", (Object)new Object[]{string});
        }
        SIMPMediationPointControllable sIMPMediationPointControllable = null;
        String[] stringArray = string.split("_MEDIATION_");
        if (stringArray.length > 0 && (destinationHandler = this.destinationManager.getDestinationInternal(new SIBUuid12(stringArray[0]), false)) != null) {
            try {
                sIMPMediationPointControllable = (SIMPMediationPointControllable)this.findControllableFromItemStream((SIMPItemStream)((Object)destinationHandler), stringArray[1]);
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.sib.processor.runtime.MessageProcessorControl.getMediationPointControlByID", (String)"1:679:1.45", (Object)this);
                SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"MessageProcessorControl.getMediationPointControlByID", "1:687:1.45", string}, null));
                SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getMediationPointControlByID", (Object)sIMPControllableNotFoundException);
                }
                throw sIMPControllableNotFoundException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMediationPointControlByID");
        }
        return sIMPMediationPointControllable;
    }

    public SIMPIterator getAliasIterator() {
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.ALIAS = Boolean.TRUE;
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        return new ControllableIterator(sIMPIterator);
    }

    public SIMPIterator getForeignDestinationIterator() {
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.FOREIGN_DESTINATION = Boolean.TRUE;
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        return new ControllableIterator(sIMPIterator);
    }

    public void formatState(PrintStream printStream, boolean bl) {
    }

    public String getId() {
        return "" + this.messageProcessor.getID();
    }

    public String getName() {
        return this.messageProcessor.getMessagingEngineName();
    }

    public SIMPIterator getLocalSubscriptionIterator() throws SIMPException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalSubscriptionIterator");
        }
        SIMPIterator sIMPIterator = this.getTopicSpaceIterator();
        SubscriptionIndex subscriptionIndex = new SubscriptionIndex();
        while (sIMPIterator.hasNext()) {
            object = (Topicspace)sIMPIterator.next();
            SIMPIterator sIMPIterator2 = ((Topicspace)object).getInternalLocalSubscriptionIterator();
            while (sIMPIterator2.hasNext()) {
                subscriptionIndex.put((ControllableSubscription)sIMPIterator2.next());
            }
        }
        object = new ControllableIterator(subscriptionIndex.iterator());
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalSubscriptionIterator", (Object)object);
        }
        return object;
    }

    public SIMPLocalSubscriptionControllable getLocalSubscriptionControlByID(String string) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalSubscriptionControlByID");
        }
        SIMPIterator sIMPIterator = this.getTopicSpaceIterator();
        SIMPLocalSubscriptionControllable sIMPLocalSubscriptionControllable = null;
        while (sIMPIterator.hasNext()) {
            Topicspace topicspace = (Topicspace)sIMPIterator.next();
            SIMPIterator sIMPIterator2 = topicspace.getLocalSubscriptionIterator();
            while (sIMPIterator2.hasNext()) {
                SIMPLocalSubscriptionControllable sIMPLocalSubscriptionControllable2 = (SIMPLocalSubscriptionControllable)sIMPIterator2.next();
                if (!sIMPLocalSubscriptionControllable2.getId().equals(string)) continue;
                sIMPLocalSubscriptionControllable = sIMPLocalSubscriptionControllable2;
                break;
            }
            if (sIMPLocalSubscriptionControllable == null) continue;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalSubscriptionControlByID", sIMPLocalSubscriptionControllable);
        }
        return sIMPLocalSubscriptionControllable;
    }

    public SIMPIterator getRemoteSubscriptionIterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteSubscriptionIterator");
        }
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.QUEUE = Boolean.FALSE;
        LinkedList linkedList = new LinkedList();
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        while (sIMPIterator.hasNext()) {
            BaseDestinationHandler baseDestinationHandler = (BaseDestinationHandler)sIMPIterator.next();
            Map map = baseDestinationHandler.getPseudoDurableAIHMap();
            linkedList.add(map.values());
        }
        sIMPIterator = new AttachedRemoteSubscriberIterator(linkedList);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteSubscriptionIterator", (Object)sIMPIterator);
        }
        return sIMPIterator;
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkValidControllable");
        }
        if (this.messageProcessor == null) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"MessageProcessorControl.assertValidControllable", "1:858:1.45", null}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkValidControllable");
        }
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this.messageProcessor = null;
        this.destinationIndex = null;
        this.destinationManager = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public void registerControlAdapterAsMBean() {
    }

    public void deregisterControlAdapterMBean() {
    }

    public void runtimeEventOccurred(RuntimeEvent runtimeEvent) {
    }

    public void resetDestination(String string) throws SIMPRuntimeOperationFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetMessageHandler", (Object)string);
        }
        try {
            this.destinationManager.resetDestination(string);
        }
        catch (Exception exception) {
            throw new SIMPRuntimeOperationFailedException(exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetMessageHandler");
        }
    }

    public void resetLink(String string) throws SIMPRuntimeOperationFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetLink", (Object)string);
        }
        try {
            this.destinationManager.resetLink(string);
        }
        catch (Exception exception) {
            throw new SIMPRuntimeOperationFailedException(exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetLink");
        }
    }

    public SIMPIterator getLocalTopicSpaceControllables() {
        LinkedList<SIMPLocalTopicSpaceControllable> linkedList = new LinkedList<SIMPLocalTopicSpaceControllable>();
        SIMPIterator sIMPIterator = this.getTopicSpaceIterator();
        while (sIMPIterator.hasNext()) {
            SIMPTopicSpaceControllable sIMPTopicSpaceControllable = (SIMPTopicSpaceControllable)sIMPIterator.next();
            linkedList.add(sIMPTopicSpaceControllable.getLocalTopicSpaceControl());
        }
        return new ControllableIterator(linkedList.iterator());
    }

    public SIMPIterator getRemoteTopicSpaceControllables() {
        LinkedList linkedList = new LinkedList();
        SIMPIterator sIMPIterator = this.getTopicSpaceIterator();
        while (sIMPIterator.hasNext()) {
            SIMPTopicSpaceControllable sIMPTopicSpaceControllable = (SIMPTopicSpaceControllable)sIMPIterator.next();
            SIMPIterator sIMPIterator2 = sIMPTopicSpaceControllable.getRemoteTopicSpaceIterator();
            while (sIMPIterator2.hasNext()) {
                linkedList.add(sIMPIterator2.next());
            }
        }
        return new BasicSIMPIterator(linkedList.iterator());
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/MessageProcessorControl.java, SIB.processor, WAS602.SIB, o0610.11 1.45");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
        nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    }
}

