/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.ControllableType;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.processor.MediationState;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPInvalidRuntimeIDException;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.mediation.MediationStateMachine;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.MediationInputItemStream;
import com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter;
import com.ibm.ws.sib.processor.runtime.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPMediationPointControllable;
import com.ibm.ws.sib.processor.runtime.SIMPMessageHandlerControllable;
import com.ibm.ws.sib.processor.runtime.SIMPQueuedMessageControllable;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.mediation.runtime.StopReason;
import java.io.PrintStream;
import java.util.ArrayList;

public class MediationPointControl
extends AbstractRegisteredControlAdapter
implements SIMPMediationPointControllable {
    private SIMPMessageHandlerControllable messageHandlerControllable;
    private String id;
    private String messageHandlerName;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static TraceComponent tc = SibTr.register((Class)MediationPointControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private volatile MediationInputItemStream itemStream = null;

    public MediationPointControl(MediationInputItemStream mediationInputItemStream, MessageProcessor messageProcessor) {
        super(messageProcessor, ControllableType.MEDIATION_POINT);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MediationPointControl", (Object)new Object[]{mediationInputItemStream, messageProcessor});
        }
        this.itemStream = mediationInputItemStream;
        this.messageHandlerControllable = (SIMPMessageHandlerControllable)((Object)this.itemStream.getDestinationHandler().getControlAdapter());
        this.messageHandlerName = this.messageHandlerControllable.getName();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MediationPointControl", (Object)this);
        }
    }

    public MediationState getMediationCurrentState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMediationCurrentState");
        }
        MediationState mediationState = MediationState.STOPPED;
        if (this.itemStream != null) {
            mediationState = this.itemStream.getMediationCurrentState();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMediationCurrentState", (Object)mediationState);
        }
        return mediationState;
    }

    public StopReason getMediationStopReason() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMediationStopReason");
        }
        StopReason stopReason = null;
        if (this.itemStream != null) {
            stopReason = this.itemStream.getMediationStopReason();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMediationStopReason", (Object)stopReason);
        }
        return stopReason;
    }

    public void stopMediation() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopMediation");
        }
        this.itemStream.mbeanEventStop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopMediation");
        }
    }

    public void startMediation() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startMediation");
        }
        this.itemStream.mbeanEventStart();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startMediation");
        }
    }

    public DestinationDefinition getActiveDestinationDefinition() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getActiveDestinationDefinition");
        }
        DestinationDefinition destinationDefinition = null;
        destinationDefinition = this.itemStream.getActiveDestinationDefinition();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getActiveDestinationDefinition");
        }
        return destinationDefinition;
    }

    public void setDestinationHighMsgs(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestinationHighMsgs", (Object)new Long(l));
        }
        this.itemStream.setDestHighMsgs(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestinationHighMsgs");
        }
    }

    public void setDestinationLowMsgs(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestinationLowMsgs", (Object)new Long(l));
        }
        this.itemStream.setDestLowMsgs(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestinationLowMsgs");
        }
    }

    public long getDestinationHighMsgs() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHighMsgs");
        }
        long l = this.itemStream.getDestHighMsgs();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHighMsgs", (Object)new Long(l));
        }
        return l;
    }

    public long getDestinationLowMsgs() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationLowMsgs");
        }
        long l = this.itemStream.getDestLowMsgs();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationLowMsgs", (Object)new Long(l));
        }
        return l;
    }

    public void setSendAllowed(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSendAllowed", (Object)new Boolean(bl));
        }
        this.itemStream.setSendAllowed(bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setSendAllowed");
        }
    }

    public boolean isSendAllowed() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSendAllowed");
        }
        boolean bl = this.itemStream.isSendAllowed();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSendAllowed");
        }
        return bl;
    }

    public SIMPMessageHandlerControllable getMessageHandler() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageHandler");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageHandler", (Object)this.messageHandlerControllable);
        }
        return this.messageHandlerControllable;
    }

    public MediationStateMachine getStateMachine() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStateMachine");
        }
        MediationStateMachine mediationStateMachine = null;
        if (this.itemStream != null) {
            mediationStateMachine = this.itemStream.getStateMachine();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStateMachine", (Object)mediationStateMachine);
        }
        return mediationStateMachine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIMPIterator getQueuedMessageIterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuedMessageIterator");
        }
        ArrayList<ControlAdapter> arrayList = new ArrayList<ControlAdapter>();
        NonLockingCursor nonLockingCursor = null;
        try {
            nonLockingCursor = this.itemStream.newNonLockingItemCursor(null);
            nonLockingCursor.allowUnavailableItems();
            MessageItem messageItem = (MessageItem)nonLockingCursor.next();
            while (messageItem != null) {
                messageItem.forceCurrentMEArrivalTimeToJsMessage();
                arrayList.add(messageItem.getControlAdapter());
                messageItem = (MessageItem)nonLockingCursor.next();
            }
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.runtime.MediationPointControl.getQueuedMessageIterator", (String)"1:400:1.43", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.MediationPointControl.getQueuedMessageIterator", "1:405:1.43", SIMPUtils.getStackTrace((Throwable)((Object)messageStoreException))});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
        }
        finally {
            if (nonLockingCursor != null) {
                nonLockingCursor.finished();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageIterator");
        }
        return new BasicSIMPIterator(arrayList.iterator());
    }

    public SIMPQueuedMessageControllable getQueuedMessageByID(String string) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuedMessageByID", (Object)new Object[]{string});
        }
        long l = -1L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.sib.processor.runtime.MediationPointControl.getQueuedMessageByID", (String)"1:439:1.43", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.MediationPointControl.getQueuedMessageByID", "1:444:1.43", SIMPUtils.getStackTrace(numberFormatException)});
            SibTr.exception((TraceComponent)tc, (Exception)numberFormatException);
            throw new SIMPInvalidRuntimeIDException(numberFormatException);
        }
        SIMPMessage sIMPMessage = null;
        sIMPMessage = (SIMPMessage)((Object)this.itemStream.findById(l));
        if (sIMPMessage == null) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"MediationPointControl.getQueuedMessageByID", "1:461:1.43", string}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageByID");
        }
        return (SIMPQueuedMessageControllable)((Object)sIMPMessage.getControlAdapter());
    }

    public void formatState(PrintStream printStream, boolean bl) {
    }

    public String getName() {
        return this.messageHandlerName;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.messageHandlerControllable.getUUID() + "_MEDIATION_" + this.itemStream.getID();
        }
        return this.id;
    }

    public long getNumberOfQueuedMessages() {
        return this.itemStream.getStatistics().getTotalItemCount();
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkValidControllable");
        }
        if (this.itemStream == null || !this.itemStream.isInStore()) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"MediationPointControl.assertValidControllable", "1:527:1.43", this.id}, null));
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkValidControllable");
        }
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        super.dereferenceControllable();
        this.itemStream = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public synchronized void postEvent(RuntimeEvent runtimeEvent) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"postEvent");
        }
        this.runtimeEventOccurred(runtimeEvent);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"postEvent");
        }
    }

    public String getUuid() {
        LocalizationDefinition localizationDefinition = this.itemStream.getLocalizationDefinition();
        String string = null;
        if (localizationDefinition != null) {
            string = localizationDefinition.getUuid();
        }
        return string;
    }

    public String getConfigId() {
        LocalizationDefinition localizationDefinition = this.itemStream.getLocalizationDefinition();
        String string = null;
        if (localizationDefinition != null) {
            string = localizationDefinition.getConfigId();
        }
        return string;
    }

    public String getRemoteEngineUuid() {
        return this.getMessageProcessor().getMessagingEngineUuid().toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/MediationPointControl.java, SIB.processor, WAS602.SIB, o0610.11 1.43");
        }
    }
}

