/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.ControllableType;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPInvalidRuntimeIDException;
import com.ibm.ws.sib.processor.gd.TargetStreamManager;
import com.ibm.ws.sib.processor.impl.AOBrowserSession;
import com.ibm.ws.sib.processor.impl.AOBrowserSessionKey;
import com.ibm.ws.sib.processor.impl.AnycastOutputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.ProducerInputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPLocalMsgsItemStream;
import com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter;
import com.ibm.ws.sib.processor.runtime.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.LocalQueueMessageFlow;
import com.ibm.ws.sib.processor.runtime.RemoteConsumerTransmit;
import com.ibm.ws.sib.processor.runtime.SIMPInboundReceiverControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPLocalQueuePointControllable;
import com.ibm.ws.sib.processor.runtime.SIMPMessageHandlerControllable;
import com.ibm.ws.sib.processor.runtime.SIMPQueuedMessageControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteConsumerTransmitControllable;
import com.ibm.ws.sib.processor.runtime.anycast.AnycastOutputStreamIterator;
import com.ibm.ws.sib.processor.runtime.anycast.RemoteBrowserIterator;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class LocalQueuePoint
extends AbstractRegisteredControlAdapter
implements SIMPLocalQueuePointControllable {
    private BaseDestinationHandler destinationHandler;
    private ProducerInputHandler inputHandler;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static TraceComponent tc = SibTr.register((Class)LocalQueuePoint.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private PtoPLocalMsgsItemStream itemStream;
    private SIMPMessageHandlerControllable handlerControl;
    private String messageHandlerName;
    private String id;

    public LocalQueuePoint(MessageProcessor messageProcessor, PtoPLocalMsgsItemStream ptoPLocalMsgsItemStream) {
        super(messageProcessor, ControllableType.QUEUE_POINT);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LocalQueuePoint", (Object)new Object[]{messageProcessor, ptoPLocalMsgsItemStream});
        }
        this.itemStream = ptoPLocalMsgsItemStream;
        this.destinationHandler = ptoPLocalMsgsItemStream.getDestinationHandler();
        this.handlerControl = (SIMPMessageHandlerControllable)((Object)this.destinationHandler.getControlAdapter());
        this.inputHandler = (ProducerInputHandler)this.destinationHandler.getInputHandler();
        this.messageHandlerName = this.handlerControl.getName();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LocalQueuePoint", (Object)this);
        }
    }

    public void setDestinationHighMsgs(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestinationHighMsgs", (Object)new Long(l));
        }
        this.itemStream.setDestHighMsgs(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestinationHighMsgs");
        }
    }

    public void setDestinationLowMsgs(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestinationLowMsgs", (Object)new Long(l));
        }
        this.itemStream.setDestHighMsgs(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestinationLowMsgs");
        }
    }

    public long getDestinationHighMsgs() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHighMsgs");
        }
        long l = this.itemStream.getDestHighMsgs();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHighMsgs", (Object)new Long(l));
        }
        return l;
    }

    public long getDestinationLowMsgs() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationLowMsgs");
        }
        long l = this.itemStream.getDestLowMsgs();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationLowMsgs", (Object)new Long(l));
        }
        return l;
    }

    public boolean isSendAllowed() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSendAllowed");
        }
        boolean bl = this.itemStream.isSendAllowed();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSendAllowed", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void setSendAllowed(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSendAllowed", (Object)new Boolean(bl));
        }
        this.itemStream.setSendAllowed(bl);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSendAllowed", (Object)new Boolean(bl));
        }
    }

    public SIMPMessageHandlerControllable getMessageHandler() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageHandler");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageHandler", (Object)this.handlerControl);
        }
        return this.handlerControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIMPIterator getQueuedMessageIterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuedMessageIterator");
        }
        ArrayList<ControlAdapter> arrayList = new ArrayList<ControlAdapter>();
        NonLockingCursor nonLockingCursor = null;
        try {
            nonLockingCursor = this.itemStream.newNonLockingItemCursor(null);
            nonLockingCursor.allowUnavailableItems();
            MessageItem messageItem = (MessageItem)nonLockingCursor.next();
            while (messageItem != null) {
                try {
                    messageItem.forceCurrentMEArrivalTimeToJsMessage();
                    arrayList.add(messageItem.getControlAdapter());
                    messageItem = (MessageItem)nonLockingCursor.next();
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.runtime.LocalQueuePoint.getQueuedMessageIterator", (String)"1:293:1.44.1.1", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.LocalQueuePoint.getQueuedMessageIterator", "1:297:1.44.1.1", SIMPUtils.getStackTrace((Throwable)((Object)messageStoreException))});
                }
                catch (NotInMessageStore notInMessageStore) {}
            }
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.runtime.LocalQueuePoint.getQueuedMessageIterator", (String)"1:314:1.44.1.1", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.LocalQueuePoint.getQueuedMessageIterator", "1:319:1.44.1.1", SIMPUtils.getStackTrace((Throwable)((Object)messageStoreException))});
        }
        finally {
            if (nonLockingCursor != null) {
                nonLockingCursor.finished();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageIterator");
        }
        return new BasicSIMPIterator(arrayList.iterator());
    }

    public SIMPQueuedMessageControllable getQueuedMessageByID(String string) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuedMessageByID", (Object)new Object[]{string});
        }
        long l = -1L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.sib.processor.runtime.LocalQueuePoint.getQueuedMessageByID", (String)"1:353:1.44.1.1", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageByID", (Object)"SIMPInvalidRuntimeIDException");
            }
            throw new SIMPInvalidRuntimeIDException(numberFormatException);
        }
        AbstractItem abstractItem = this.itemStream.findById(l);
        SIMPMessage sIMPMessage = null;
        if (abstractItem instanceof SIMPMessage) {
            sIMPMessage = (SIMPMessage)((Object)abstractItem);
        }
        if (sIMPMessage == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageByID", (Object)"SIMPControllableNotFoundException");
            }
            throw new SIMPControllableNotFoundException(nls.getFormattedMessage("MESSAGE_EXISTS_ERROR_CWSIP0572", new Object[]{string, this.destinationHandler.getName()}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageByID");
        }
        return (SIMPQueuedMessageControllable)((Object)sIMPMessage.getControlAdapter());
    }

    public SIMPIterator getPtoPInboundReceiverIterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPtoPInboundReceiverIterator");
        }
        TargetStreamManager targetStreamManager = this.inputHandler.getTargetStreamManager();
        SIMPIterator sIMPIterator = targetStreamManager.getTargetStreamSetControlIterator();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPtoPInboundReceiverIterator", (Object)sIMPIterator);
        }
        return sIMPIterator;
    }

    public void formatState(PrintStream printStream, boolean bl) {
    }

    public String getName() {
        return this.messageHandlerName;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.destinationHandler.getUuid() + "_QUEUE_" + this.itemStream.getID();
        }
        return this.id;
    }

    public long getNumberOfQueuedMessages() {
        return this.itemStream.getStatistics().getTotalItemCount();
    }

    public synchronized void registerControlAdapterAsMBean() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
        if (!this.isRegistered() && !this.getMessageHandler().isTemporary()) {
            super.registerControlAdapterAsMBean();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkValidControllable");
        }
        if (this.itemStream == null || !this.itemStream.isInStore()) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"LocalQueuePoint.assertValidControllable", "1:482:1.44.1.1", this.id}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkValidControllable");
        }
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        super.dereferenceControllable();
        this.itemStream = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public String getUuid() {
        LocalizationDefinition localizationDefinition = this.itemStream.getLocalizationDefinition();
        String string = null;
        if (localizationDefinition != null) {
            string = localizationDefinition.getUuid();
        }
        return string;
    }

    public String getConfigId() {
        LocalizationDefinition localizationDefinition = this.itemStream.getLocalizationDefinition();
        String string = null;
        if (localizationDefinition != null) {
            string = localizationDefinition.getConfigId();
        }
        return string;
    }

    public String getRemoteEngineUuid() {
        return this.itemStream.getMessagingEngineUuid().toString();
    }

    public String toString() {
        return ((SIMPMessageHandlerControllable)((Object)this.itemStream.getDestinationHandler().getControlAdapter())).getName();
    }

    public SIMPIterator getRemoteBrowserReceiverIterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteBrowserReceiverIterator");
        }
        AnycastOutputHandler anycastOutputHandler = this.destinationHandler.getAnycastOutputHandler();
        Hashtable hashtable = anycastOutputHandler.getBrowserSessions();
        Set set = hashtable.keySet();
        ArrayList<AOBrowserSession> arrayList = new ArrayList<AOBrowserSession>();
        RemoteBrowserIterator remoteBrowserIterator = set.iterator();
        while (remoteBrowserIterator.hasNext()) {
            AOBrowserSessionKey aOBrowserSessionKey = (AOBrowserSessionKey)remoteBrowserIterator.next();
            AOBrowserSession aOBrowserSession = (AOBrowserSession)hashtable.get(aOBrowserSessionKey);
            arrayList.add(aOBrowserSession);
        }
        remoteBrowserIterator = new RemoteBrowserIterator(arrayList.iterator());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteBrowserReceiverIterator", (Object)remoteBrowserIterator);
        }
        return remoteBrowserIterator;
    }

    public SIMPIterator getRemoteConsumerTransmitIterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteConsumerTransmitIterator");
        }
        AnycastOutputHandler anycastOutputHandler = this.destinationHandler.getAnycastOutputHandler();
        Iterator iterator = anycastOutputHandler.getIteratorOverAOStreams();
        AnycastOutputStreamIterator anycastOutputStreamIterator = new AnycastOutputStreamIterator(iterator, this.destinationHandler.getMessageProcessor(), this.destinationHandler);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteConsumerTransmitIterator", (Object)anycastOutputStreamIterator);
        }
        return anycastOutputStreamIterator;
    }

    public SIMPIterator getLocalQueueMessageFlow() {
        Object object;
        LinkedList<LocalQueueMessageFlow> linkedList = new LinkedList<LocalQueueMessageFlow>();
        SIMPIterator sIMPIterator = this.getPtoPInboundReceiverIterator();
        while (sIMPIterator.hasNext()) {
            Object object2;
            object = (SIMPInboundReceiverControllable)sIMPIterator.next();
            String string = object.getRemoteEngineUuid();
            Object object3 = null;
            SIMPIterator sIMPIterator2 = this.getRemoteConsumerTransmitIterator();
            while (sIMPIterator2.hasNext()) {
                object2 = (RemoteConsumerTransmit)sIMPIterator2.next();
                if (!((RemoteConsumerTransmit)object3).getRemoteEngineUuid().equals(string)) continue;
                object3 = object2;
                break;
            }
            object2 = SIMPUtils.getMENameFromUuid(string);
            LocalQueueMessageFlow localQueueMessageFlow = new LocalQueueMessageFlow((String)object2, string, (SIMPRemoteConsumerTransmitControllable)object3, (SIMPInboundReceiverControllable)object);
            linkedList.add(localQueueMessageFlow);
        }
        object = new BasicSIMPIterator(linkedList.iterator());
        return object;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/LocalQueuePoint.java, SIB.processor, WAS602.SIB, o0610.11 1.44.1.1");
        }
    }
}

