/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.gd.InternalOutputStream;
import com.ibm.ws.sib.processor.gd.InternalOutputStreamManager;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.impl.AnycastOutputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProtocolItemStream;
import com.ibm.ws.sib.processor.runtime.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.DeliveryStreamType;
import com.ibm.ws.sib.processor.runtime.IndoubtAction;
import com.ibm.ws.sib.processor.runtime.InternalOutputStreamControl;
import com.ibm.ws.sib.processor.runtime.InternalOutputStreamControllableIterator;
import com.ibm.ws.sib.processor.runtime.QueuedMessage;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPPubSubOutboundTransmitControllable;
import com.ibm.ws.sib.processor.runtime.SIMPTransmitMessageControllable;
import com.ibm.ws.sib.processor.runtime.TransmitMessage;
import com.ibm.ws.sib.processor.runtime.anycast.AnycastOutputStreamIterator;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;

public class InternalOutputStreamSetControl
extends AbstractControlAdapter
implements SIMPPubSubOutboundTransmitControllable {
    private static final TraceComponent tc = SibTr.register((Class)InternalOutputStreamSetControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    private StreamSet _streamSet;
    private String _remoteMEUuid;
    private InternalOutputStreamManager _ioStreamManager;

    public InternalOutputStreamSetControl(StreamSet streamSet) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"InternalOutputStreamSetControl", (Object)new Object[]{streamSet});
        }
        this._streamSet = streamSet;
        this._remoteMEUuid = streamSet.getRemoteEngineUUID();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"InternalOutputStreamSetControl", (Object)this);
        }
    }

    public SIMPIterator getTransmitMessagesIterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransmitMessagesIterator");
        }
        InternalOutputStreamSetXmitMessageIterator internalOutputStreamSetXmitMessageIterator = null;
        internalOutputStreamSetXmitMessageIterator = new InternalOutputStreamSetXmitMessageIterator();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransmitMessagesIterator", (Object)internalOutputStreamSetXmitMessageIterator);
        }
        return internalOutputStreamSetXmitMessageIterator;
    }

    public SIMPTransmitMessageControllable getTransmitMessageByID(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransmitMessageByID", (Object)string);
        }
        TransmitMessage transmitMessage = new TransmitMessage(new Long(string), this._streamSet);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransmitMessageByID", (Object)transmitMessage);
        }
        return transmitMessage;
    }

    public DeliveryStreamType getType() {
        return DeliveryStreamType.PUBSUB_SOURCE;
    }

    public String getId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId");
        }
        return this._streamSet.getStreamID().toString();
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)this._streamSet.toString());
        }
        return this._streamSet.toString();
    }

    public void formatState(PrintStream printStream, boolean bl) {
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this._streamSet == null) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"InternalOutputStreamControl.assertValidControllable", "1:319:1.11", this._streamSet}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable", (Object)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this._streamSet = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public void registerControlAdapterAsMBean() {
    }

    public void deregisterControlAdapterMBean() {
    }

    public void runtimeEventOccurred(RuntimeEvent runtimeEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMessagesAtSource(IndoubtAction indoubtAction) throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clearMessagesAtSource");
        }
        this.assertValidControllable();
        StreamSet streamSet = this._streamSet;
        synchronized (streamSet) {
            Object object;
            ArrayList<SIMPMessage> arrayList = new ArrayList<SIMPMessage>();
            if (indoubtAction != IndoubtAction.INDOUBT_LEAVE) {
                boolean bl = false;
                if (indoubtAction == IndoubtAction.INDOUBT_DELETE) {
                    bl = true;
                }
                object = this.getTransmitMessagesIterator();
                TransmitMessage transmitMessage = null;
                String string = null;
                while (object.hasNext()) {
                    SIMPMessage sIMPMessage;
                    transmitMessage = (TransmitMessage)object.next();
                    string = transmitMessage.getState();
                    if (string.equals(SIMPTransmitMessageControllable.State.COMMITTING.toString()) || (sIMPMessage = transmitMessage.getSIMPMessage()) == null) continue;
                    arrayList.add(sIMPMessage);
                    QueuedMessage queuedMessage = (QueuedMessage)sIMPMessage.getControlAdapter();
                    if (bl) continue;
                    queuedMessage.copyMessageToExceptionDestination(null);
                }
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (SIMPMessage)iterator.next();
                this._ioStreamManager.removeMessage(this._streamSet, (SIMPMessage)object);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clearMessagesAtSource");
        }
    }

    public boolean containsGuesses() {
        return false;
    }

    public void forceFlushAtSource() {
    }

    public int getCurrentMaxIndoubtMessages(int n, int n2) {
        return 0;
    }

    public SIMPIterator getStreams() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreams");
        }
        Iterator iterator = this._streamSet.iterator();
        InternalOutputStreamControllableIterator internalOutputStreamControllableIterator = new InternalOutputStreamControllableIterator(iterator);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreams", (Object)internalOutputStreamControllableIterator);
        }
        return internalOutputStreamControllableIterator;
    }

    public long getTotalOutboundMessages() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTotalOutboundMessages");
        }
        long l = 0L;
        SIMPIterator sIMPIterator = this.getStreams();
        while (sIMPIterator.hasNext()) {
            InternalOutputStreamControl internalOutputStreamControl = (InternalOutputStreamControl)sIMPIterator.next();
            l += internalOutputStreamControl.getNumberOfMessagesSent();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTotalOutboundMessages", (Object)new Long(l));
        }
        return l;
    }

    public SIMPIterator getAttatchedRemoteSubscribers() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAttatchedRemoteSubscribers");
        }
        AnycastOutputStreamIterator anycastOutputStreamIterator = null;
        ProtocolItemStream protocolItemStream = (ProtocolItemStream)this._streamSet.getItemStream();
        BaseDestinationHandler baseDestinationHandler = protocolItemStream.getDestinationHandler();
        if (baseDestinationHandler instanceof BaseDestinationHandler) {
            BaseDestinationHandler baseDestinationHandler2 = baseDestinationHandler;
            MessageProcessor messageProcessor = baseDestinationHandler2.getMessageProcessor();
            AnycastOutputHandler anycastOutputHandler = baseDestinationHandler2.getAnycastOutputHandler();
            Iterator iterator = anycastOutputHandler.getIteratorOverAOStreams();
            anycastOutputStreamIterator = new AnycastOutputStreamIterator(iterator, messageProcessor, baseDestinationHandler2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAttatchedRemoteSubscribers", anycastOutputStreamIterator);
        }
        return anycastOutputStreamIterator;
    }

    public long getDepth() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDepth");
        }
        long l = 0L;
        SIMPIterator sIMPIterator = this.getStreams();
        while (sIMPIterator.hasNext()) {
            InternalOutputStreamControl internalOutputStreamControl = (InternalOutputStreamControl)sIMPIterator.next();
            l += (long)internalOutputStreamControl.getNumberOfActiveMessages();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDepth", (Object)new Long(l));
        }
        return l;
    }

    public String getRemoteEngineUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)this._remoteMEUuid);
        }
        return this._remoteMEUuid;
    }

    public void deleteAllMessages() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteAllMessages");
        }
        try {
            this.clearMessagesAtSource(IndoubtAction.INDOUBT_DELETE);
        }
        catch (SIMPControllableNotFoundException sIMPControllableNotFoundException) {
            FFDCFilter.processException((Throwable)sIMPControllableNotFoundException, (String)"com.ibm.ws.sib.processor.runtime.InternalOutputStreamSetControl.deleteAllMessages", (String)"1:605:1.11", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.InternalOutputStreamSetControl.deleteAllMessages", "1:610:1.11", SIMPUtils.getStackTrace(sIMPControllableNotFoundException)});
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
        }
        catch (MessageStoreRuntimeException messageStoreRuntimeException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreRuntimeException), (String)"com.ibm.ws.sib.processor.runtime.InternalOutputStreamSetControl.deleteAllMessages", (String)"1:619:1.11", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.InternalOutputStreamSetControl.deleteAllMessages", "1:624:1.11", SIMPUtils.getStackTrace((Throwable)((Object)messageStoreRuntimeException))});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreRuntimeException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteAllMessages");
        }
    }

    public void moveAllMessages() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveAllMessages");
        }
        try {
            this.clearMessagesAtSource(IndoubtAction.INDOUBT_EXCEPTION);
        }
        catch (SIMPControllableNotFoundException sIMPControllableNotFoundException) {
            FFDCFilter.processException((Throwable)sIMPControllableNotFoundException, (String)"com.ibm.ws.sib.processor.runtime.InternalOutputStreamSetControl.moveAllMessages", (String)"1:648:1.11", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.InternalOutputStreamSetControl.moveAllMessages", "1:654:1.11", SIMPUtils.getStackTrace(sIMPControllableNotFoundException)});
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
        }
        catch (MessageStoreRuntimeException messageStoreRuntimeException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreRuntimeException), (String)"com.ibm.ws.sib.processor.runtime.InternalOutputStreamSetControl.moveAllMessages", (String)"1:663:1.11", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.InternalOutputStreamSetControl.moveAllMessages", "1:668:1.11", SIMPUtils.getStackTrace((Throwable)((Object)messageStoreRuntimeException))});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreRuntimeException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveAllMessages");
        }
    }

    public void setInternalOutputStreamManager(InternalOutputStreamManager internalOutputStreamManager) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setInternalOutputStreamManager", (Object)internalOutputStreamManager);
        }
        this._ioStreamManager = internalOutputStreamManager;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setInternalOutputStreamManager");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/InternalOutputStreamSetControl.java, SIB.processor, WAS602.SIB, o0610.11 1.11");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }

    private class InternalOutputStreamSetXmitMessageIterator
    implements SIMPIterator {
        Iterator streamSetIterator = null;
        InternalOutputStream currentStream = null;
        Iterator currentStreamMsgIterator = null;

        public InternalOutputStreamSetXmitMessageIterator() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"InternalOutputStreamSetXmitMessageIterator");
            }
            this.streamSetIterator = InternalOutputStreamSetControl.this._streamSet.iterator();
            this.moveToNextStream();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"InternalOutputStreamSetXmitMessageIterator", (Object)this);
            }
        }

        private void moveToNextStream() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"moveToNextStream");
            }
            boolean bl = true;
            while (bl) {
                if (this.streamSetIterator.hasNext()) {
                    this.currentStream = (InternalOutputStream)this.streamSetIterator.next();
                    this.currentStreamMsgIterator = this.currentStream.getAllMessageItemsOnStream(true).iterator();
                    if (!this.currentStreamMsgIterator.hasNext()) continue;
                    bl = false;
                    continue;
                }
                bl = false;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"moveToNextStream");
            }
        }

        public Object next() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"next");
            }
            if (!this.currentStreamMsgIterator.hasNext()) {
                this.moveToNextStream();
            }
            MessageItem messageItem = (MessageItem)this.currentStreamMsgIterator.next();
            TransmitMessage transmitMessage = null;
            if (messageItem != null) {
                transmitMessage = new TransmitMessage(messageItem, this.currentStream);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"next", (Object)transmitMessage);
            }
            return transmitMessage;
        }

        public boolean hasNext() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"hasNext");
            }
            if (!this.currentStreamMsgIterator.hasNext()) {
                this.moveToNextStream();
            }
            boolean bl = this.currentStreamMsgIterator.hasNext();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"hasNext", (Object)new Boolean(bl));
            }
            return bl;
        }

        public void remove() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"remove");
            }
            InvalidOperationException invalidOperationException = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"InternalOutputStreamSetControl.InternalOutputStreamSetXmitMessageIterator.remove", "1:196:1.11", this}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)invalidOperationException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"remove", (Object)((Object)invalidOperationException));
            }
            throw invalidOperationException;
        }

        public void finished() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"finished");
            }
            this.streamSetIterator = null;
            this.currentStream = null;
            this.currentStreamMsgIterator = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"finished");
            }
        }
    }
}

