/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.admin.ControllableType;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.gd.AIStream;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter;
import com.ibm.ws.sib.processor.runtime.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.RemoteConsumerReceiver;
import com.ibm.ws.sib.processor.runtime.RemoteTopicSpaceControl;
import com.ibm.ws.sib.processor.runtime.SIMPAttachedRemoteSubscriberControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteConsumerReceiverControllable;
import com.ibm.ws.sib.processor.runtime.SIMPTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.Topicspace;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class AttachedRemoteSubscriberControl
extends AbstractRegisteredControlAdapter
implements SIMPAttachedRemoteSubscriberControllable {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)AttachedRemoteSubscriberControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final String HANDLER_NAME = "AttachedRemoteSubscriber";
    private String _remoteDurableName;
    private BaseDestinationHandler _destinationHandler;
    private MessageProcessor _messageProcessor;
    private AnycastInputHandler _anycastInputHandler;
    private Topicspace _topicspace;
    private RemoteTopicSpaceControl _remoteTopicSpaceControl;

    public AttachedRemoteSubscriberControl(String string, AnycastInputHandler anycastInputHandler, MessageProcessor messageProcessor, RemoteTopicSpaceControl remoteTopicSpaceControl) {
        super(messageProcessor, ControllableType.REMOTE_SUBSCRIPTION_POINT);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AttachedRemoteSubscriberControl", (Object)new Object[]{string, anycastInputHandler, messageProcessor, remoteTopicSpaceControl});
        }
        this._remoteDurableName = string;
        this._anycastInputHandler = anycastInputHandler;
        this._destinationHandler = anycastInputHandler.getBaseDestinationHandler();
        this._messageProcessor = messageProcessor;
        this._remoteTopicSpaceControl = remoteTopicSpaceControl;
        this.registerControlAdapterAsMBean();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AttachedRemoteSubscriberControl", (Object)this);
        }
    }

    public SIMPTopicSpaceControllable getTopicSpace() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpace");
        }
        if (this._topicspace == null) {
            this._topicspace = new Topicspace(this._messageProcessor, this._destinationHandler);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpace", (Object)this._topicspace);
        }
        return this._topicspace;
    }

    public RemoteTopicSpaceControl getRemoteTopicSpaceControl() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteTopicSpaceControl");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteTopicSpaceControl", (Object)this._remoteTopicSpaceControl);
        }
        return this._remoteTopicSpaceControl;
    }

    public String getRemoteEngineUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
        }
        String string = this._anycastInputHandler.getLocalisationME().getUuid().toString();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)string);
        }
        return string;
    }

    public SIMPRemoteConsumerReceiverControllable getRemoteConsumerReceiver() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteConsumerReceiver");
        }
        AIStream aIStream = this._anycastInputHandler.getAIStream();
        SIBUuid8 sIBUuid8 = this._messageProcessor.getMessagingEngineUuid();
        RemoteConsumerReceiver remoteConsumerReceiver = null;
        if (aIStream != null) {
            remoteConsumerReceiver = new RemoteConsumerReceiver(aIStream, this._destinationHandler, sIBUuid8, this._anycastInputHandler);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteConsumerReceiver", remoteConsumerReceiver);
        }
        return remoteConsumerReceiver;
    }

    public SIMPIterator getConsumerIterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerIterator");
        }
        InvalidOperationException invalidOperationException = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"AttachedRemoteSubscriberControl.getConsumerIterator", "1:189:1.26", this}, null));
        SibTr.exception((TraceComponent)tc, (Exception)((Object)invalidOperationException));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConsumerIterator");
        }
        throw invalidOperationException;
    }

    public void formatState(PrintStream printStream, boolean bl) {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"formatState", (Object)new Object[]{printStream, new Boolean(bl)});
        }
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this._destinationHandler == null || this._messageProcessor == null || this._anycastInputHandler == null || this._remoteTopicSpaceControl == null) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"AttachedRemoteSubscriberControl.assertValidControllable", "1:228:1.26"}, null));
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable", (Object)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this._remoteDurableName = null;
        this._anycastInputHandler = null;
        this._destinationHandler = null;
        this._messageProcessor = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public synchronized void registerControlAdapterAsMBean() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
        if (!this.isRegistered()) {
            super.registerControlAdapterAsMBean();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    public void deregisterControlAdapterMBean() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
        super.deregisterControlAdapterMBean();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
    }

    public void runtimeEventOccurred(RuntimeEvent runtimeEvent) {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"runtimeEventOccurred", (Object)runtimeEvent);
        }
    }

    public String getName() {
        return "AttachedRemoteSubscriber." + this._remoteDurableName;
    }

    public String getId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)this._remoteDurableName);
        }
        return this._remoteDurableName;
    }

    public SIMPIterator getTopicNameIterator() {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicNameIterator");
        }
        List<Object> list = null;
        if (this._anycastInputHandler.getAIStream() != null) {
            object = this._anycastInputHandler.getRCD().getConsumerDispatcherState().getTopics();
            list = Arrays.asList(object);
        } else {
            list = new LinkedList();
        }
        object = new BasicSIMPIterator(list.iterator());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopicNameIterator", (Object)object);
        }
        return object;
    }

    public void clearAllTopics() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clearAllTopics");
        }
        this._anycastInputHandler.forceFlushAtTarget();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clearAllTopics");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/AttachedRemoteSubscriberControl.java, SIB.processor, WAS602.SIB, o0610.11 1.26");
        }
    }
}

