/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.proxyhandler;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageType;
import com.ibm.ws.sib.mfp.control.SubscriptionMessage;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.SecurityContext;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.proxyhandler.MESubscription;
import com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler;
import com.ibm.ws.sib.processor.proxyhandler.Neighbour;
import com.ibm.ws.sib.processor.proxyhandler.Neighbours;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import java.util.ArrayList;
import java.util.Iterator;

public class NeighbourProxyListener
implements AsynchConsumerCallback {
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private static final TraceComponent tc = SibTr.register((Class)NeighbourProxyListener.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Neighbours iNeighbours;
    private MultiMEProxyHandler iProxyHandler;
    private ArrayList iAddTopics;
    private ArrayList iAddTopicSpaces;
    private ArrayList iAddTopicSpaceMappings;
    private ArrayList iDeleteTopics;
    private ArrayList iDeleteTopicSpaces;
    private DestinationManager iDestinationManager;

    NeighbourProxyListener(Neighbours neighbours, MultiMEProxyHandler multiMEProxyHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"NeighbourProxyListener", (Object)new Object[]{neighbours, multiMEProxyHandler});
        }
        this.iNeighbours = neighbours;
        this.iProxyHandler = multiMEProxyHandler;
        this.iDestinationManager = this.iProxyHandler.getMessageProcessor().getDestinationManager();
        this.iAddTopics = new ArrayList();
        this.iAddTopicSpaces = new ArrayList();
        this.iAddTopicSpaceMappings = new ArrayList();
        this.iDeleteTopics = new ArrayList();
        this.iDeleteTopicSpaces = new ArrayList();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"NeighbourProxyListener", (Object)this);
        }
    }

    public void consumeMessages(LockedMessageEnumeration lockedMessageEnumeration) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"consumeMessages", (Object)new Object[]{lockedMessageEnumeration});
        }
        SIBusMessage sIBusMessage = null;
        while (lockedMessageEnumeration.hasNext()) {
            try {
                sIBusMessage = lockedMessageEnumeration.nextLocked();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener.consumeMessages", (String)"1:202:1.67", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            }
            if (sIBusMessage != null && ((JsMessage)sIBusMessage).getJsMessageType() != MessageType.SUBSCRIPTION) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Message On incorrect Destination, expecting message of Type " + MessageType.SUBSCRIPTION + " received " + ((JsMessage)sIBusMessage).getJsMessageType()));
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"consumeMessages");
                }
                return;
            }
            if (sIBusMessage == null) continue;
            SubscriptionMessage subscriptionMessage = null;
            try {
                subscriptionMessage = ((JsMessage)sIBusMessage).makeInboundSubscriptionMessage();
            }
            catch (IncorrectMessageTypeException incorrectMessageTypeException) {
                FFDCFilter.processException((Throwable)incorrectMessageTypeException, (String)"com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener.consumeMessages", (String)"1:238:1.67", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)incorrectMessageTypeException));
            }
            ExternalLocalTransaction externalLocalTransaction = null;
            try {
                externalLocalTransaction = this.iProxyHandler.getTransactionManager().createLocalTransaction();
                switch (subscriptionMessage.getSubscriptionMessageType().toInt()) {
                    case 2: {
                        this.handleCreateProxySubscription(subscriptionMessage, externalLocalTransaction);
                        break;
                    }
                    case 3: {
                        this.handleDeleteProxySubscription(subscriptionMessage, externalLocalTransaction);
                        break;
                    }
                    case 1: {
                        this.handleResetState(subscriptionMessage, externalLocalTransaction, false);
                        break;
                    }
                    case 4: {
                        this.handleResetState(subscriptionMessage, externalLocalTransaction, true);
                        break;
                    }
                    case 5: {
                        this.handleResetState(subscriptionMessage, externalLocalTransaction, false);
                        break;
                    }
                }
                lockedMessageEnumeration.deleteCurrent((SITransaction)externalLocalTransaction);
                externalLocalTransaction.commit();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener.consumeMessages", (String)"1:308:1.67", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                this.handleRollback(subscriptionMessage, externalLocalTransaction);
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener.consumeMessages", (String)"1:321:1.67", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)runtimeException);
                this.handleRollback(subscriptionMessage, externalLocalTransaction);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"consumeMessages", (Object)runtimeException);
                }
                throw runtimeException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"consumeMessages");
        }
    }

    void handleRollback(SubscriptionMessage subscriptionMessage, ExternalLocalTransaction externalLocalTransaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleRollback", (Object)new Object[]{subscriptionMessage, externalLocalTransaction});
        }
        try {
            if (externalLocalTransaction != null) {
                try {
                    externalLocalTransaction.rollback();
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener.handleRollback", (String)"1:365:1.67", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                }
            }
            switch (subscriptionMessage.getSubscriptionMessageType().toInt()) {
                case 2: {
                    this.iProxyHandler.remoteUnsubscribeEvent(this.iAddTopicSpaces, this.iAddTopics, subscriptionMessage.getBus(), externalLocalTransaction, false);
                    break;
                }
                case 3: {
                    this.iProxyHandler.remoteSubscribeEvent(this.iDeleteTopicSpaces, this.iDeleteTopics, subscriptionMessage.getBus(), externalLocalTransaction, false);
                    break;
                }
                case 1: {
                    this.iProxyHandler.remoteUnsubscribeEvent(this.iAddTopicSpaces, this.iAddTopics, subscriptionMessage.getBus(), externalLocalTransaction, false);
                    this.iProxyHandler.remoteSubscribeEvent(this.iDeleteTopicSpaces, this.iDeleteTopics, subscriptionMessage.getBus(), externalLocalTransaction, false);
                    break;
                }
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener.handleRollback", (String)"1:425:1.67", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleRollback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleResetState(SubscriptionMessage subscriptionMessage, Transaction transaction, boolean bl) throws SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleResetState", (Object)new Object[]{subscriptionMessage, transaction, new Boolean(bl)});
        }
        boolean bl2 = false;
        boolean bl3 = true;
        String string = null;
        boolean bl4 = false;
        Iterator iterator = subscriptionMessage.getTopics().iterator();
        Iterator iterator2 = subscriptionMessage.getTopicSpaces().iterator();
        Iterator iterator3 = subscriptionMessage.getTopicSpaceMappings().iterator();
        byte[] byArray = subscriptionMessage.getMEUUID();
        SIBUuid8 sIBUuid8 = new SIBUuid8(byArray);
        String string2 = subscriptionMessage.getBusName();
        Neighbour neighbour = this.iNeighbours.getNeighbour(sIBUuid8);
        if (neighbour == null) {
            this.iProxyHandler.getLockManager().lockExclusive();
            try {
                ExternalLocalTransaction externalLocalTransaction = this.iProxyHandler.getMessageProcessor().getTXManager().createLocalTransaction();
                this.iProxyHandler.createNeighbour(sIBUuid8, string2, transaction);
                externalLocalTransaction.commit();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Created Messaging Engine " + sIBUuid8 + " on bus " + string2));
                }
                neighbour = this.iNeighbours.getNeighbour(sIBUuid8);
                if (!bl) {
                    neighbour.sendRequestProxySubscriptions();
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener.handleResetState", (String)"1:507:1.67", (Object)this);
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"handleResetState", (Object)"Unable to create Neighbour so exiting");
                }
                return;
            }
            finally {
                this.iProxyHandler.getLockManager().unlockExclusive();
            }
        }
        if (neighbour.wasProxyRequestSent()) {
            neighbour.setRequestedProxySubscriptionsResponded();
        }
        boolean bl5 = false;
        if (this.iNeighbours.getAllBuses().length > 1) {
            bl5 = true;
            this.iAddTopics.clear();
            this.iAddTopicSpaces.clear();
            this.iAddTopicSpaceMappings.clear();
            this.iDeleteTopics.clear();
            this.iDeleteTopicSpaces.clear();
        }
        neighbour.markAllProxies();
        while (iterator.hasNext()) {
            boolean bl6;
            Object object;
            String string3 = (String)iterator.next();
            String string4 = (String)iterator3.next();
            String string5 = (String)iterator2.next();
            SIBUuid12 sIBUuid12 = null;
            bl2 = false;
            bl3 = true;
            string = null;
            bl4 = false;
            if (!string2.equals(this.iProxyHandler.getMessageProcessor().getMessagingEngineBus())) {
                object = this.iDestinationManager.getDestination(string4, false);
                if (object == null) {
                    bl2 = true;
                } else {
                    if (this.iProxyHandler.getMessageProcessor().isBusSecure()) {
                        try {
                            if (!subscriptionMessage.isSecurityUseridSentBySystem()) {
                                string = subscriptionMessage.getSecurityUserid();
                                bl4 = bl3 = this.checkDestinationAccess((DestinationHandler)object, string3, string);
                            }
                        }
                        catch (SIException sIException) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Caught exception " + (Object)((Object)sIException)));
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        sIBUuid12 = object.getUuid();
                    }
                }
            } else {
                sIBUuid12 = new SIBUuid12(string5);
            }
            if (bl2 || !bl3 || (object = neighbour.proxyRegistered(sIBUuid12, string4, string3, string5, transaction, bl4, string)) == null || !(bl6 = this.iNeighbours.createProxy(neighbour, this.iDestinationManager.getDestinationInternal(sIBUuid12, false), (MESubscription)object, sIBUuid12, string3, false)) || !bl5) continue;
            this.iAddTopics.add(string3);
            this.iAddTopicSpaces.add(sIBUuid12);
            this.iAddTopicSpaceMappings.add(string5);
        }
        neighbour.sweepMarkedProxies(this.iDeleteTopicSpaces, this.iDeleteTopics, transaction, bl5);
        if (bl5 && this.iDeleteTopics.size() > 0) {
            this.iProxyHandler.unsubscribeEvent(this.iDeleteTopicSpaces, this.iDeleteTopics, string2, transaction);
        }
        if (bl5 && this.iAddTopics.size() > 0) {
            this.iProxyHandler.subscribeEvent(this.iAddTopicSpaces, this.iAddTopics, string2, transaction);
        }
        if (bl) {
            neighbour.sendReplyMessage();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleResetState");
        }
    }

    void handleDeleteProxySubscription(SubscriptionMessage subscriptionMessage, Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleDeleteProxySubscription", (Object)new Object[]{subscriptionMessage, transaction});
        }
        Iterator iterator = subscriptionMessage.getTopics().iterator();
        Iterator iterator2 = subscriptionMessage.getTopicSpaces().iterator();
        Iterator iterator3 = subscriptionMessage.getTopicSpaceMappings().iterator();
        byte[] byArray = subscriptionMessage.getMEUUID();
        SIBUuid8 sIBUuid8 = new SIBUuid8(byArray);
        String string = subscriptionMessage.getBusName();
        this.deleteProxySubscription(iterator, iterator2, iterator3, sIBUuid8, string, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleDeleteProxySubscription");
        }
    }

    public void deleteProxySubscription(Iterator iterator, Iterator iterator2, Iterator iterator3, SIBUuid8 sIBUuid8, String string, Transaction transaction) throws SIResourceException {
        Neighbour neighbour;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteProxySubscription", (Object)new Object[]{iterator, iterator2, iterator3, sIBUuid8, string, transaction});
        }
        if ((neighbour = this.iNeighbours.getNeighbour(sIBUuid8)) == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteProxySubscription", (Object)"Unknown neighbour");
            }
            return;
        }
        boolean bl = false;
        if (this.iNeighbours.getAllBuses().length > 1) {
            bl = true;
            this.iDeleteTopics.clear();
            this.iDeleteTopicSpaces.clear();
        }
        while (iterator.hasNext()) {
            boolean bl2;
            Object object;
            String string2 = (String)iterator.next();
            String string3 = (String)iterator3.next();
            String string4 = (String)iterator2.next();
            SIBUuid12 sIBUuid12 = null;
            if (!string.equals(this.iProxyHandler.getMessageProcessor().getMessagingEngineBus())) {
                block13: {
                    object = null;
                    try {
                        object = this.iDestinationManager.getDestination(string3, false);
                    }
                    catch (SIException sIException) {
                        if (!tc.isDebugEnabled()) break block13;
                        SibTr.debug((TraceComponent)tc, (String)("Destination not found " + string3));
                    }
                }
                if (object == null) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteProxySubscription", (Object)("Destination not found " + string3));
                    }
                    return;
                }
                sIBUuid12 = object.getUuid();
            } else {
                sIBUuid12 = new SIBUuid12(string4);
            }
            if ((object = neighbour.proxyDeregistered(sIBUuid12, string2, transaction)) == null || !(bl2 = this.iNeighbours.deleteProxy(this.iDestinationManager.getDestinationInternal(sIBUuid12, false), (MESubscription)object, neighbour, sIBUuid12, string2, true, false)) || !bl) continue;
            this.iDeleteTopics.add(string2);
            this.iDeleteTopicSpaces.add(sIBUuid12);
        }
        if (bl && this.iDeleteTopics.size() > 0) {
            this.iProxyHandler.unsubscribeEvent(this.iDeleteTopicSpaces, this.iDeleteTopics, string, transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteProxySubscription");
        }
    }

    protected void handleCreateProxySubscription(SubscriptionMessage subscriptionMessage, Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleCreateProxySubscription", (Object)new Object[]{subscriptionMessage, transaction});
        }
        boolean bl = true;
        String string = null;
        boolean bl2 = false;
        Iterator iterator = subscriptionMessage.getTopics().iterator();
        Iterator iterator2 = subscriptionMessage.getTopicSpaces().iterator();
        Iterator iterator3 = subscriptionMessage.getTopicSpaceMappings().iterator();
        byte[] byArray = subscriptionMessage.getMEUUID();
        SIBUuid8 sIBUuid8 = new SIBUuid8(byArray);
        String string2 = subscriptionMessage.getBusName();
        Neighbour neighbour = this.iNeighbours.getNeighbour(sIBUuid8);
        if (neighbour == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"handleCreateProxySubscription", (Object)"Unknown neighbour");
            }
            return;
        }
        boolean bl3 = false;
        if (this.iNeighbours.getAllBuses().length > 1) {
            bl3 = true;
            this.iAddTopics.clear();
            this.iAddTopicSpaces.clear();
            this.iAddTopicSpaceMappings.clear();
        }
        while (iterator.hasNext()) {
            boolean bl4;
            Object object;
            String string3 = (String)iterator.next();
            String string4 = (String)iterator3.next();
            String string5 = (String)iterator2.next();
            SIBUuid12 sIBUuid12 = null;
            bl = true;
            string = null;
            bl2 = false;
            if (!string2.equals(this.iProxyHandler.getMessageProcessor().getMessagingEngineBus())) {
                block19: {
                    object = null;
                    try {
                        object = this.iDestinationManager.getDestination(string4, false);
                    }
                    catch (SIException sIException) {
                        if (!tc.isDebugEnabled()) break block19;
                        SibTr.debug((TraceComponent)tc, (String)("Destination not found " + string4));
                    }
                }
                if (object == null) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"handleCreateProxySubscription", (Object)("Topic Space " + string4 + " not found"));
                    }
                    return;
                }
                if (this.iProxyHandler.getMessageProcessor().isBusSecure()) {
                    try {
                        if (!subscriptionMessage.isSecurityUseridSentBySystem()) {
                            string = subscriptionMessage.getSecurityUserid();
                            bl2 = bl = this.checkDestinationAccess((DestinationHandler)object, string3, string);
                        }
                    }
                    catch (SIException sIException) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Caught exception " + (Object)((Object)sIException)));
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    sIBUuid12 = object.getUuid();
                }
            } else {
                sIBUuid12 = new SIBUuid12(string5);
            }
            if (!bl || (object = neighbour.proxyRegistered(sIBUuid12, string4, string3, string5, transaction, bl2, string)) == null || !(bl4 = this.iNeighbours.createProxy(neighbour, this.iDestinationManager.getDestinationInternal(sIBUuid12, false), (MESubscription)object, sIBUuid12, string3, false)) || !bl3) continue;
            this.iAddTopics.add(string3);
            this.iAddTopicSpaces.add(sIBUuid12);
            this.iAddTopicSpaceMappings.add(string5);
        }
        if (bl3 && this.iAddTopics.size() > 0) {
            this.iProxyHandler.subscribeEvent(this.iAddTopicSpaces, this.iAddTopics, string2, transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleCreateProxySubscription");
        }
    }

    private boolean checkDestinationAccess(DestinationHandler destinationHandler, String string, String string2) throws SIDiscriminatorSyntaxException {
        SecurityContext securityContext;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDestinationAccess", (Object)new Object[]{destinationHandler, string, string2});
        }
        boolean bl = true;
        if (string2 == null) {
            string2 = "";
        }
        if (!destinationHandler.checkDestinationAccess(securityContext = new SecurityContext(string2, string), OperationType.SEND)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"checkDestinationAccess", (Object)"not authorized to produce to this destination");
            }
            String string3 = nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_18", new Object[]{destinationHandler.getName(), string2}, null);
            this.iProxyHandler.getMessageProcessor().getAccessChecker().fireDestinationAccessNotAuthorizedEvent(destinationHandler.getName(), string2, OperationType.SEND, string3);
            bl = false;
        }
        if (bl && string != null && !this.iProxyHandler.getMessageProcessor().getMessageProcessorMatching().isWildCarded(string) && !destinationHandler.checkDiscriminatorAccess(securityContext, OperationType.SEND)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"checkDestinationAccess", (Object)"not authorized to produce to this discriminator");
            }
            SibTr.audit((TraceComponent)tc, (String)nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_20", new Object[]{destinationHandler.getName(), string, string2}, null));
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess", (Object)new Boolean(bl));
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/proxyhandler/NeighbourProxyListener.java, SIB.processor, WAS602.SIB, o0610.11 1.67");
        }
    }
}

