/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.proxyhandler;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsAdminUtils;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.SubscriptionMessage;
import com.ibm.ws.sib.mfp.control.SubscriptionMessageType;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.ProducerSessionImpl;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.proxyhandler.BusGroup;
import com.ibm.ws.sib.processor.proxyhandler.MESubscription;
import com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler;
import com.ibm.ws.sib.processor.proxyhandler.Neighbours;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public final class Neighbour
extends SIMPItemStream
implements AlarmListener {
    private static final TraceComponent tc = SibTr.register((Class)Neighbour.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int PERSISTENT_VERSION = 1;
    private String iBusId;
    private BusGroup iBusGroup;
    private Hashtable iProxies;
    private MultiMEProxyHandler iProxyHandler;
    private JsDestinationAddress iRemoteQueue;
    private ProducerSessionImpl iProducerSession;
    private SIBUuid8 iMEUuid;
    private Neighbours iNeighbours;
    private DestinationManager iDestinationManager;
    private HashSet iPubSubOutputHandlers;
    private static final int REQUEST_TIMER = 300000;
    private boolean iRequestSent = false;
    private boolean iAlarmCancelled;
    private Alarm iAlarm;

    public Neighbour() {
    }

    Neighbour(MultiMEProxyHandler multiMEProxyHandler, SIBUuid8 sIBUuid8, String string, Neighbours neighbours) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Neighbour", (Object)new Object[]{multiMEProxyHandler, sIBUuid8, string, neighbours});
        }
        this.iMEUuid = sIBUuid8;
        this.iBusId = string;
        this.intialiseNonPersistent(multiMEProxyHandler, neighbours);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"Neighbour", (Object)this);
        }
    }

    protected void intialiseNonPersistent(MultiMEProxyHandler multiMEProxyHandler, Neighbours neighbours) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"intialiseNonPersistent");
        }
        this.iProxyHandler = multiMEProxyHandler;
        this.iNeighbours = neighbours;
        this.iDestinationManager = this.iProxyHandler.getMessageProcessor().getDestinationManager();
        this.iRemoteQueue = SIMPUtils.createJsSystemDestinationAddress("SIMP.PROXY.QUEUE", this.iMEUuid, this.iBusId);
        if (this.iMEUuid == null) {
            this.iMEUuid = this.iRemoteQueue.getME();
        }
        this.iProxies = new Hashtable();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"intialiseNonPersistent");
        }
    }

    public final SIBUuid8 getUUID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUUID");
            SibTr.exit((TraceComponent)tc, (String)"getUUID", (Object)this.iMEUuid);
        }
        return this.iMEUuid;
    }

    public final String getBusId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBusId");
            SibTr.exit((TraceComponent)tc, (String)"getBusId", (Object)this.iBusId);
        }
        return this.iBusId;
    }

    BusGroup getBus() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBus");
            SibTr.exit((TraceComponent)tc, (String)"getBus", (Object)this.iBusGroup);
        }
        return this.iBusGroup;
    }

    Hashtable getRegisteredProxies() {
        return this.iProxies;
    }

    void setBus(BusGroup busGroup) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setBus");
        }
        this.iBusGroup = busGroup;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setBus");
        }
    }

    void sendResetProxySubscriptions() throws SIResourceException {
        SubscriptionMessage subscriptionMessage;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendResetProxySubscriptions");
        }
        if ((subscriptionMessage = this.iBusGroup.generateResetSubscriptionMessage()) != null) {
            this.sendToNeighbour((JsMessage)subscriptionMessage, null);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("No subscriptions to forward to ME " + this.iMEUuid.toString()));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendResetProxySubscriptions");
        }
    }

    void sendRequestProxySubscriptions() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequestProxySubscriptions");
        }
        SubscriptionMessage subscriptionMessage = this.iBusGroup.generateResetSubscriptionMessage();
        subscriptionMessage.setSubscriptionMessageType(SubscriptionMessageType.REQUEST);
        if (subscriptionMessage != null) {
            this.sendToNeighbour((JsMessage)subscriptionMessage, null);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("No subscriptions to forward to ME " + this.iMEUuid.toString()));
        }
        this.setRequestedProxySubscriptions();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequestProxySubscriptions");
        }
    }

    void sendReplyMessage() throws SIResourceException {
        SubscriptionMessage subscriptionMessage;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendReplyMessage");
        }
        if ((subscriptionMessage = this.iBusGroup.generateReplySubscriptionMessage()) != null) {
            this.sendToNeighbour((JsMessage)subscriptionMessage, null);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("No subscriptions to forward to ME " + this.iMEUuid.toString()));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendReplyMessage");
        }
    }

    private synchronized void createProducerSession() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createProducerSession");
        }
        if (this.iProducerSession == null) {
            try {
                this.iProducerSession = (ProducerSessionImpl)this.iProxyHandler.getMessageProcessor().getSystemConnection().createSystemProducerSession((SIDestinationAddress)this.iRemoteQueue, null, null, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbour.createProducerSession", (String)"1:487:1.91", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createProducerSession", (Object)"SIResourceException");
                }
                throw new SIResourceException((Throwable)sIException);
            }
        }
    }

    MESubscription proxyRegistered(SIBUuid12 sIBUuid12, String string, String string2, String string3, Transaction transaction, boolean bl, String string4) throws SIResourceException {
        String string5;
        MESubscription mESubscription;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"proxyRegistered", (Object)new Object[]{sIBUuid12, string, string2, string3, transaction, new Boolean(bl), string4});
        }
        if ((mESubscription = (MESubscription)this.iProxies.get(string5 = BusGroup.subscriptionKey(sIBUuid12, string2))) != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Unmarking subscription " + mESubscription));
            }
            mESubscription.unmark();
            boolean bl2 = this.checkForeignSecurityAttributesChanged(mESubscription, bl, string4);
            if (bl2) {
                try {
                    mESubscription.requestUpdate(transaction);
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbour.proxyRegistered", (String)"1:573:1.91", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:580:1.91", messageStoreException});
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"proxyRegistered", (Object)"SIResourceException");
                    }
                    throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:590:1.91", messageStoreException}, null), (Throwable)((Object)messageStoreException));
                }
            }
            mESubscription = null;
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Subscription being created");
            }
            mESubscription = new MESubscription(sIBUuid12, string, string2, string3, bl, string4);
            try {
                this.addItem(mESubscription, transaction);
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbour.proxyRegistered", (String)"1:625:1.91", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:632:1.91", messageStoreException});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"proxyRegistered", (Object)"SIResourceException");
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:642:1.91", messageStoreException}, null), (Throwable)((Object)messageStoreException));
            }
            this.iProxies.put(string5, mESubscription);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"proxyRegistered", (Object)mESubscription);
        }
        return mESubscription;
    }

    protected void removeSubscription(SIBUuid12 sIBUuid12, String string) {
        String string2 = BusGroup.subscriptionKey(sIBUuid12, string);
        this.iProxies.remove(string2);
    }

    MESubscription proxyDeregistered(SIBUuid12 sIBUuid12, String string, Transaction transaction) throws SIResourceException {
        String string2;
        MESubscription mESubscription;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"proxyDeregistered", (Object)new Object[]{sIBUuid12, string, transaction});
        }
        if ((mESubscription = (MESubscription)this.iProxies.get(string2 = BusGroup.subscriptionKey(sIBUuid12, string))) != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Subscription " + mESubscription + " being removed"));
            }
            try {
                mESubscription.remove(transaction, mESubscription.getLockID());
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbour.proxyDeregistered", (String)"1:720:1.91", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:727:1.91", messageStoreException});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"proxyDeregistered", (Object)"SIResourceException");
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:737:1.91", messageStoreException}, null), (Throwable)((Object)messageStoreException));
            }
            this.iProxies.remove(string2);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"No Subscription to be removed");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"proxyDeregistered", (Object)mESubscription);
        }
        return mESubscription;
    }

    protected void addSubscription(SIBUuid12 sIBUuid12, String string, MESubscription mESubscription) {
        String string2 = BusGroup.subscriptionKey(sIBUuid12, string);
        this.iProxies.put(string2, mESubscription);
    }

    protected MESubscription getSubscription(SIBUuid12 sIBUuid12, String string) {
        return (MESubscription)this.iProxies.get(BusGroup.subscriptionKey(sIBUuid12, string));
    }

    void markAllProxies() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"markAllProxies");
        }
        Enumeration enumeration = this.iProxies.elements();
        while (enumeration.hasMoreElements()) {
            MESubscription mESubscription = (MESubscription)enumeration.nextElement();
            mESubscription.mark();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"markAllProxies");
        }
    }

    void sweepMarkedProxies(List list, List list2, Transaction transaction, boolean bl) throws SIResourceException, SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sweepMarkedProxies", (Object)new Object[]{list, list2, transaction, new Boolean(bl)});
        }
        Enumeration enumeration = this.iProxies.elements();
        while (enumeration.hasMoreElements()) {
            MESubscription mESubscription = (MESubscription)enumeration.nextElement();
            if (!mESubscription.isMarked()) continue;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Subscription " + mESubscription + " being removed"));
            }
            this.proxyDeregistered(mESubscription.getTopicSpaceUuid(), mESubscription.getTopic(), transaction);
            boolean bl2 = this.iNeighbours.deleteProxy(this.iDestinationManager.getDestinationInternal(mESubscription.getTopicSpaceUuid(), false), mESubscription, this, mESubscription.getTopicSpaceUuid(), mESubscription.getTopic(), true, false);
            String string = BusGroup.subscriptionKey(mESubscription.getTopicSpaceUuid(), mESubscription.getTopic());
            this.iProxies.remove(string);
            if (!bl || !bl2) continue;
            list2.add(mESubscription.getTopic());
            list.add(mESubscription.getTopicSpaceUuid());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sweepMarkedProxies");
        }
    }

    void sendToNeighbour(JsMessage jsMessage, Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendToNeighbour", (Object)new Object[]{jsMessage, transaction});
        }
        if (this.iProducerSession == null) {
            this.createProducerSession();
        }
        try {
            this.iProducerSession.send((SIBusMessage)jsMessage, (SITransaction)transaction);
        }
        catch (SIException sIException) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            if (!(sIException instanceof SIResourceException)) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbour.sendToNeighbour", (String)"1:923:1.91", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:930:1.91", sIException});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"sendToNeighbour", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:941:1.91", sIException}, null), (Throwable)sIException);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendToNeighbour", (Object)"SIResourceException");
            }
            throw (SIResourceException)((Object)sIException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendToNeighbour");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoverSubscriptions(MultiMEProxyHandler multiMEProxyHandler) throws MessageStoreException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"recoverSubscriptions", (Object)multiMEProxyHandler);
        }
        this.iProxyHandler = multiMEProxyHandler;
        this.iProxies = new Hashtable();
        NonLockingCursor nonLockingCursor = null;
        try {
            nonLockingCursor = this.newNonLockingItemCursor(new ClassEqualsFilter(MESubscription.class));
            AbstractItem abstractItem = null;
            while ((abstractItem = nonLockingCursor.next()) != null) {
                MESubscription mESubscription = null;
                mESubscription = (MESubscription)abstractItem;
                String string = BusGroup.subscriptionKey(mESubscription.getTopicSpaceUuid(), mESubscription.getTopic());
                this.iProxies.put(string, mESubscription);
                this.iNeighbours.createProxy(this, this.iDestinationManager.getDestinationInternal(mESubscription.getTopicSpaceUuid(), false), mESubscription, mESubscription.getTopicSpaceUuid(), mESubscription.getTopic(), true);
                mESubscription.eventPostCommitAdd(null);
            }
        }
        finally {
            if (nonLockingCursor != null) {
                nonLockingCursor.finished();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"recoverSubscriptions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteDestination() throws SIConnectionLostException, SIResourceException, SIErrorException {
        block11: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deleteDestination");
            }
            if (this.iProducerSession != null) {
                this.iProducerSession.close();
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Removing destination " + this.iRemoteQueue.getDestinationName()));
            }
            try {
                this.iDestinationManager.deleteSystemDestination(this.iRemoteQueue);
            }
            catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                if (!tc.isDebugEnabled()) break block11;
                SibTr.debug((TraceComponent)tc, (String)("Destination " + this.iRemoteQueue + " already deleted"));
            }
        }
        Neighbour neighbour = this;
        synchronized (neighbour) {
            if (!this.iAlarmCancelled) {
                if (this.iAlarm != null) {
                    this.iAlarm.cancel();
                }
                this.iAlarmCancelled = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteDestination");
        }
    }

    public String toString() {
        return this.iMEUuid + ":" + this.iBusId;
    }

    public boolean equals(Neighbour neighbour) {
        boolean bl = false;
        if (this.iMEUuid.equals((Object)neighbour.getUUID())) {
            bl = true;
        }
        return bl;
    }

    public void restore(ObjectInputStream objectInputStream, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{objectInputStream, new Integer(n)});
        }
        try {
            HashMap hashMap = (HashMap)objectInputStream.readObject();
            byte[] byArray = (byte[])hashMap.get("iMEUuid");
            this.iMEUuid = new SIBUuid8(byArray);
            this.iBusId = (String)hashMap.get("iBusId");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbour.restore", (String)"1:1108:1.91", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:1115:1.91", exception});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:1125:1.91", exception}, null), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public int getPersistentVersion() {
        return 1;
    }

    public void getPersistentData(ObjectOutputStream objectOutputStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)objectOutputStream);
        }
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("iMEUuid", this.iMEUuid.toByteArray());
            hashMap.put("iBusId", this.iBusId);
            objectOutputStream.writeObject(hashMap);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbour.getPersistentData", (String)"1:1167:1.91", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)iOException);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:1174:1.91", iOException});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbour", "1:1184:1.91", iOException}, null), (Throwable)iOException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    public boolean okToForward(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"okToForward", (Object)string);
        }
        boolean bl = false;
        if (string == null) {
            bl = true;
        } else if (!string.equals(this.iBusId)) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"okToForward", (Object)new Boolean(bl));
        }
        return bl;
    }

    protected void addPubSubOutputHandler(PubSubOutputHandler pubSubOutputHandler) {
        if (this.iPubSubOutputHandlers == null) {
            this.iPubSubOutputHandlers = new HashSet();
        }
        this.iPubSubOutputHandlers.add(pubSubOutputHandler);
    }

    protected HashSet getPubSubOutputHandlers() {
        return this.iPubSubOutputHandlers;
    }

    public void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        formattedWriter.write(this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRequestedProxySubscriptions() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRequestedProxySubscriptions");
        }
        MPAlarmManager mPAlarmManager = this.iProxyHandler.getMessageProcessor().getAlarmManager();
        this.iAlarm = mPAlarmManager.create(300000L, this);
        Neighbour neighbour = this;
        synchronized (neighbour) {
            this.iRequestSent = true;
            this.iAlarmCancelled = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRequestedProxySubscriptions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRequestedProxySubscriptionsResponded() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRequestedProxySubscriptionsResponded");
        }
        Object object = this;
        synchronized (object) {
            this.iRequestSent = false;
            if (!this.iAlarmCancelled) {
                this.iAlarm.cancel();
            }
            this.iAlarmCancelled = true;
        }
        object = JsAdminUtils.getMENameByUuid((String)this.iMEUuid.toString());
        if (object == null) {
            object = this.iMEUuid.toString();
        }
        SibTr.push((Object)this.iProxyHandler.getMessageProcessor().getMessagingEngine());
        SibTr.info((TraceComponent)tc, (String)"NEIGHBOUR_REPLY_RECIEVED_INFO_CWSIP0382", (Object)new Object[]{object});
        SibTr.pop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRequestedProxySubscriptionsResponded");
        }
    }

    boolean wasProxyRequestSent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"wasProxyRequestSent");
            SibTr.exit((TraceComponent)tc, (String)"wasProxyRequestSent", (Object)new Boolean(this.iRequestSent));
        }
        return this.iRequestSent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
        }
        Neighbour neighbour = this;
        synchronized (neighbour) {
            if (this.iRequestSent) {
                String string = JsAdminUtils.getMENameByUuid((String)this.iMEUuid.toString());
                if (string == null) {
                    string = this.iMEUuid.toString();
                }
                SibTr.push((Object)this.iProxyHandler.getMessageProcessor().getMessagingEngine());
                SibTr.warning((TraceComponent)tc, (String)"NO_NEIGHBOUR_REPLY_WARNING_CWSIP0381", (Object)new Object[]{string});
                SibTr.pop();
            }
            this.iAlarmCancelled = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteSystemDestinations() throws SIConnectionLostException, SIResourceException, SIErrorException {
        Neighbour neighbour;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteSystemDestinations");
        }
        if (this.iProducerSession != null) {
            this.iProducerSession.close();
        }
        List list = this.iDestinationManager.getAllSystemDestinations(this.iMEUuid);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            neighbour = (JsDestinationAddress)iterator.next();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Removing destination " + neighbour.getDestinationName()));
            }
            try {
                this.iDestinationManager.deleteSystemDestination((JsDestinationAddress)neighbour);
            }
            catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                if (!tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("Destination " + neighbour + " already deleted"));
            }
        }
        neighbour = this;
        synchronized (neighbour) {
            if (!this.iAlarmCancelled) {
                if (this.iAlarm != null) {
                    this.iAlarm.cancel();
                }
                this.iAlarmCancelled = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestinations");
        }
    }

    private boolean checkForeignSecurityAttributesChanged(MESubscription mESubscription, boolean bl, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkForeignSecurityAttributesChanged", (Object)new Object[]{mESubscription, new Boolean(bl), string});
        }
        boolean bl2 = false;
        if (bl) {
            if (mESubscription.isForeignSecuredProxy()) {
                if (string != null) {
                    if (mESubscription.getMESubUserId() != null) {
                        if (!string.equals(mESubscription.getMESubUserId())) {
                            mESubscription.setMESubUserId(string);
                            bl2 = true;
                        }
                    } else {
                        mESubscription.setMESubUserId(string);
                        bl2 = true;
                    }
                } else if (mESubscription.getMESubUserId() != null) {
                    mESubscription.setMESubUserId(null);
                    bl2 = true;
                }
            } else {
                mESubscription.setForeignSecuredProxy(true);
                mESubscription.setMESubUserId(string);
                bl2 = true;
            }
        } else if (mESubscription.isForeignSecuredProxy()) {
            mESubscription.setForeignSecuredProxy(false);
            mESubscription.setMESubUserId(null);
            bl2 = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkForeignSecurityAttributesChanged", (Object)new Boolean(bl2));
        }
        return bl2;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/proxyhandler/Neighbour.java, SIB.processor, WAS602.SIB, o0610.11 1.91");
        }
    }
}

