/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.matching;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.matchspace.BadMessageFormatMatchingException;
import com.ibm.ws.sib.matchspace.Conjunction;
import com.ibm.ws.sib.matchspace.EvalCache;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.InvalidTopicSyntaxException;
import com.ibm.ws.sib.matchspace.MatchSpace;
import com.ibm.ws.sib.matchspace.MatchSpaceKey;
import com.ibm.ws.sib.matchspace.MatchTarget;
import com.ibm.ws.sib.matchspace.Matching;
import com.ibm.ws.sib.matchspace.MatchingException;
import com.ibm.ws.sib.matchspace.Operator;
import com.ibm.ws.sib.matchspace.QuerySyntaxException;
import com.ibm.ws.sib.matchspace.SearchResults;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.tools.Evaluator;
import com.ibm.ws.sib.matchspace.tools.MatchParser;
import com.ibm.ws.sib.matchspace.tools.PositionAssigner;
import com.ibm.ws.sib.matchspace.tools.Resolver;
import com.ibm.ws.sib.matchspace.tools.Transformer;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.processor.exceptions.SIMPDiscriminatorSyntaxException;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerKey;
import com.ibm.ws.sib.processor.impl.ControllableProxySubscription;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.matching.JSResolver;
import com.ibm.ws.sib.processor.matching.MatchingConsumerDispatcher;
import com.ibm.ws.sib.processor.matching.MatchingConsumerPoint;
import com.ibm.ws.sib.processor.matching.MessageProcessorSearchResults;
import com.ibm.ws.sib.processor.matching.TopicAcl;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MessageProcessorMatching {
    private static final TraceComponent tc = SibTr.register((Class)MessageProcessorMatching.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    public static boolean unitTestMode = false;
    private MatchParser _parser;
    private Map _targets = new HashMap();
    private Matching _matching = null;
    private Identifier _rootId;
    private MatchSpace _matchSpace = null;
    private Resolver _defaultResolver = null;
    private JSResolver _simessageResolver = null;
    private JSResolver _jmsResolver = null;
    private PositionAssigner _positionAssigner = null;
    private MessageProcessor _messageProcessor;
    private boolean _isBusSecure = false;

    public MessageProcessorMatching() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageProcessorMatching");
        }
        this._matching = this.getMatchingInstance();
        this._rootId = this._matching.createIdentifier("topic");
        this._rootId.setType(3);
        this._defaultResolver = this._matching.createMinimalResolver();
        this._simessageResolver = new JSResolver(SelectorDomain.SIMESSAGE);
        this._jmsResolver = new JSResolver(SelectorDomain.JMS);
        this._positionAssigner = this._matching.createPositionAssigner();
        this._defaultResolver.resolve(this._rootId, this._positionAssigner);
        this._matchSpace = this._matching.createMatchSpace(this._rootId, true);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageProcessorMatching", (Object)this);
        }
    }

    public MessageProcessorMatching(MessageProcessor messageProcessor) {
        this();
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageProcessorMatching", (Object)messageProcessor);
        }
        this._messageProcessor = messageProcessor;
        this._isBusSecure = messageProcessor.isBusSecure();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageProcessorMatching", (Object)this);
        }
    }

    private Matching getMatchingInstance() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMatchingInstance", (Object)new Boolean(unitTestMode));
        }
        Matching matching = null;
        if (unitTestMode) {
            try {
                matching = Matching.getInstance();
            }
            catch (Exception exception) {}
        } else {
            matching = (Matching)MessageProcessor.getSingletonInstance("Matching");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMatchingInstance", (Object)matching);
        }
        return matching;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTarget(Object object, String string, String string2, SelectorDomain selectorDomain, Resolver resolver, MatchTarget matchTarget, Selector selector) throws InvalidTopicSyntaxException, QuerySyntaxException, MatchingException {
        Selector selector2;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addTarget", (Object)new Object[]{object, string, string2, selectorDomain, resolver, matchTarget});
        }
        this._matchSpace.checkTopicSyntax(string);
        Operator operator = this._matching.createTopicLikeOperator((Selector)this._rootId, string);
        Transformer transformer = Matching.getTransformer();
        if (string2 != null && string2.trim().length() != 0) {
            try {
                object2 = this;
                synchronized (object2) {
                    if (selector == null) {
                        this._parser = selectorDomain.equals((Object)SelectorDomain.JMS) ? this._matching.primeMatchParser(this._parser, string2, true) : this._matching.primeMatchParser(this._parser, string2, false);
                        selector2 = this._parser.getSelector();
                        if (selector2.getType() == 2) {
                            if (tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"addTarget", (Object)"QuerySyntaxException");
                            }
                            throw new QuerySyntaxException(string2);
                        }
                        if (resolver == null) {
                            resolver = this._defaultResolver;
                        }
                        if ((selector2 = transformer.resolve(selector2, resolver, this._positionAssigner)).getType() == 2) {
                            if (tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"addTarget", (Object)"QuerySyntaxException");
                            }
                            throw new QuerySyntaxException(string2);
                        }
                    } else {
                        selector2 = selector;
                    }
                    operator = this._matching.createOperator(46, (Selector)operator, selector2);
                }
            }
            catch (RuntimeException runtimeException) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"addTarget", (Object)"QuerySyntaxException");
                }
                throw new QuerySyntaxException(runtimeException.getMessage());
            }
        }
        if ((object2 = transformer.organizeTests(transformer.DNF((Selector)operator))) == null) {
            object2 = new Conjunction[]{null};
        }
        selector2 = new MatchTarget[((Conjunction[])object2).length];
        for (int i = 0; i < ((Selector)selector2).length; ++i) {
            selector2[i] = i == 0 ? matchTarget : matchTarget.duplicate();
            this._matchSpace.addTarget(object2[i], (MatchTarget)selector2[i]);
        }
        Map map = this._targets;
        synchronized (map) {
            this._targets.put(object, new Target((Conjunction[])object2, (MatchTarget[])selector2));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addTarget");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTarget(Object object) throws MatchingException {
        Map map = this._targets;
        synchronized (map) {
            Target target = (Target)this._targets.get(object);
            if (target == null) {
                throw new MatchingException();
            }
            for (int i = 0; i < target.targets.length; ++i) {
                this._matchSpace.removeTarget(target.expr[i], target.targets[i]);
            }
            this._targets.remove(object);
        }
    }

    public void addConsumerPointMatchTarget(ConsumerKey consumerKey, SIBUuid12 sIBUuid12, SelectionCriteria selectionCriteria) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addConsumerPointMatchTarget", (Object)new Object[]{consumerKey, sIBUuid12, selectionCriteria});
        }
        MatchingConsumerPoint matchingConsumerPoint = new MatchingConsumerPoint(consumerKey);
        String string = null;
        string = selectionCriteria != null && selectionCriteria.getDiscriminator() != null ? this.buildAddTopicExpression(sIBUuid12, selectionCriteria.getDiscriminator()) : sIBUuid12.toString();
        try {
            String string2 = null;
            SelectorDomain selectorDomain = SelectorDomain.SIMESSAGE;
            JSResolver jSResolver = null;
            if (selectionCriteria != null) {
                string2 = selectionCriteria.getSelectorString();
                selectorDomain = selectionCriteria.getSelectorDomain();
                if (string2 != null && string2.trim().length() != 0) {
                    jSResolver = selectorDomain.equals((Object)SelectorDomain.JMS) ? this._jmsResolver : this._simessageResolver;
                }
            }
            this.addTarget(consumerKey, string, string2, selectorDomain, jSResolver, matchingConsumerPoint, consumerKey.getSelector());
        }
        catch (QuerySyntaxException querySyntaxException) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)querySyntaxException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addConsumerPointMatchTarget", (Object)"SISelectorSyntaxException");
            }
            throw new SISelectorSyntaxException(nls.getFormattedMessage("INVALID_SELECTOR_ERROR_CWSIP0371", new Object[]{this.selectorAsString(selectionCriteria)}, null));
        }
        catch (InvalidTopicSyntaxException invalidTopicSyntaxException) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)invalidTopicSyntaxException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addConsumerPointMatchTarget", (Object)"SIDiscriminatorSyntaxException");
            }
            String string3 = selectionCriteria != null && selectionCriteria.getDiscriminator() != null ? selectionCriteria.getDiscriminator() : sIBUuid12.toString();
            throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{string3}, null));
        }
        catch (MatchingException matchingException) {
            FFDCFilter.processException((Throwable)matchingException, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.addConsumerPointMatchTarget", (String)"1:524:1.90", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addConsumerPointMatchTarget", (Object)"SIErrorException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:533:1.90", matchingException});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:541:1.90", matchingException}, null), (Throwable)matchingException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addConsumerPointMatchTarget");
        }
    }

    public MessageProcessorSearchResults retrieveMatchingConsumerPoints(SIBUuid12 sIBUuid12, JsMessage jsMessage, MessageProcessorSearchResults messageProcessorSearchResults) throws SIDiscriminatorSyntaxException {
        block11: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"retrieveMatchingConsumerPoints", (Object)new Object[]{sIBUuid12, jsMessage, messageProcessorSearchResults});
            }
            try {
                messageProcessorSearchResults.reset();
                EvalCache evalCache = this._matching.createEvalCache();
                String string = jsMessage.getDiscriminator();
                if (string != null) {
                    try {
                        this._matchSpace.checkEventTopicSyntax(string);
                        String string2 = this.buildSendTopicExpression(sIBUuid12, string);
                        this.search(string2, (MatchSpaceKey)jsMessage, evalCache, messageProcessorSearchResults);
                        break block11;
                    }
                    catch (InvalidTopicSyntaxException invalidTopicSyntaxException) {
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingConsumerPoints", (Object)((Object)invalidTopicSyntaxException));
                        }
                        throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{string}, null));
                    }
                }
                this.search(sIBUuid12.toString(), (MatchSpaceKey)jsMessage, evalCache, messageProcessorSearchResults);
            }
            catch (BadMessageFormatMatchingException badMessageFormatMatchingException) {
                FFDCFilter.processException((Throwable)badMessageFormatMatchingException, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.retrieveMatchingConsumerPoints", (String)"1:622:1.90", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)badMessageFormatMatchingException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingConsumerPoints", (Object)((Object)badMessageFormatMatchingException));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:633:1.90", badMessageFormatMatchingException});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:641:1.90", badMessageFormatMatchingException}, null), (Throwable)badMessageFormatMatchingException);
            }
            catch (MatchingException matchingException) {
                FFDCFilter.processException((Throwable)matchingException, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.retrieveMatchingConsumerPoints", (String)"1:652:1.90", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)matchingException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingConsumerPoints", (Object)"SIErrorException");
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:663:1.90", matchingException});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:671:1.90", matchingException}, null), (Throwable)matchingException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingConsumerPoints");
        }
        return messageProcessorSearchResults;
    }

    public void removeConsumerPointMatchTarget(ConsumerKey consumerKey) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumerPointMatchTarget", (Object)consumerKey);
        }
        try {
            this.removeTarget(consumerKey);
        }
        catch (MatchingException matchingException) {
            FFDCFilter.processException((Throwable)matchingException, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.removeConsumerPointMatchTarget", (String)"1:704:1.90", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)matchingException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeConsumerPointMatchTarget", (Object)"SICoreException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:715:1.90", matchingException});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:723:1.90", matchingException}, null), (Throwable)matchingException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumerPointMatchTarget");
        }
    }

    public void addConsumerDispatcherMatchTarget(ConsumerDispatcher consumerDispatcher, SIBUuid12 sIBUuid12, SelectionCriteria selectionCriteria) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addConsumerDispatcherMatchTarget", (Object)new Object[]{consumerDispatcher, sIBUuid12, selectionCriteria});
        }
        String string = this.buildAddTopicExpression(sIBUuid12, selectionCriteria == null ? null : selectionCriteria.getDiscriminator());
        try {
            String string2 = null;
            SelectorDomain selectorDomain = SelectorDomain.SIMESSAGE;
            JSResolver jSResolver = null;
            if (selectionCriteria != null) {
                string2 = selectionCriteria.getSelectorString();
                selectorDomain = selectionCriteria.getSelectorDomain();
                if (string2 != null && string2.trim().length() != 0) {
                    jSResolver = selectorDomain.equals((Object)SelectorDomain.JMS) ? this._jmsResolver : this._simessageResolver;
                }
            }
            MatchingConsumerDispatcher matchingConsumerDispatcher = new MatchingConsumerDispatcher(consumerDispatcher);
            this.addTarget(consumerDispatcher, string, string2, selectorDomain, jSResolver, matchingConsumerDispatcher, null);
            consumerDispatcher.setIsInMatchSpace();
        }
        catch (QuerySyntaxException querySyntaxException) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)querySyntaxException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addConsumerDispatcherMatchTarget", (Object)"SISelectorSyntaxException");
            }
            throw new SISelectorSyntaxException(nls.getFormattedMessage("INVALID_SELECTOR_ERROR_CWSIP0371", new Object[]{this.selectorAsString(selectionCriteria)}, null));
        }
        catch (InvalidTopicSyntaxException invalidTopicSyntaxException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addConsumerDispatcherMatchTarget", (Object)((Object)invalidTopicSyntaxException));
            }
            throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{selectionCriteria == null ? null : selectionCriteria.getDiscriminator()}, null));
        }
        catch (MatchingException matchingException) {
            FFDCFilter.processException((Throwable)matchingException, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.addConsumerDispatcherMatchTarget", (String)"1:830:1.90", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addConsumerDispatcherMatchTarget", (Object)"SIErrorException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:839:1.90", matchingException});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:847:1.90", matchingException}, null), (Throwable)matchingException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addConsumerDispatcherMatchTarget");
        }
    }

    public ControllableProxySubscription addPubSubOutputHandlerMatchTarget(PubSubOutputHandler pubSubOutputHandler, SIBUuid12 sIBUuid12, String string, boolean bl, String string2) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addPubSubOutputHandlerMatchTarget", (Object)new Object[]{pubSubOutputHandler, sIBUuid12, string, new Boolean(bl), string2});
        }
        String string3 = this.buildAddTopicExpression(sIBUuid12, string);
        ControllableProxySubscription controllableProxySubscription = new ControllableProxySubscription(pubSubOutputHandler, string3, bl, string2);
        try {
            this.addTarget((Object)controllableProxySubscription, string3, null, null, null, controllableProxySubscription, null);
        }
        catch (QuerySyntaxException querySyntaxException) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)querySyntaxException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addPubSubOutputHandlerMatchTarget", (Object)((Object)querySyntaxException));
            }
            throw new SISelectorSyntaxException(nls.getFormattedMessage("INVALID_SELECTOR_ERROR_CWSIP0371", new Object[]{null}, null));
        }
        catch (InvalidTopicSyntaxException invalidTopicSyntaxException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addPubSubOutputHandlerMatchTarget", (Object)((Object)invalidTopicSyntaxException));
            }
            throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{string}, null));
        }
        catch (MatchingException matchingException) {
            FFDCFilter.processException((Throwable)matchingException, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.addPubSubOutputHandlerMatchTarget", (String)"1:935:1.90", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)matchingException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addPubSubOutputHandlerMatchTarget", (Object)((Object)matchingException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:946:1.90", matchingException});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:954:1.90", matchingException}, null), (Throwable)matchingException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addPubSubOutputHandlerMatchTarget", (Object)((Object)controllableProxySubscription));
        }
        return controllableProxySubscription;
    }

    public MessageProcessorSearchResults retrieveMatchingOutputHandlers(DestinationHandler destinationHandler, String string, MatchSpaceKey matchSpaceKey, MessageProcessorSearchResults messageProcessorSearchResults) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"retrieveMatchingOutputHandlers", (Object)new Object[]{destinationHandler, string, matchSpaceKey, messageProcessorSearchResults});
        }
        SIBUuid12 sIBUuid12 = destinationHandler.getBaseUuid();
        String string2 = this.buildSendTopicExpression(sIBUuid12, string);
        try {
            this._matchSpace.checkEventTopicSyntax(string2);
        }
        catch (InvalidTopicSyntaxException invalidTopicSyntaxException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingOutputHandlers", (Object)((Object)invalidTopicSyntaxException));
            }
            throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{string}, null));
        }
        try {
            messageProcessorSearchResults.reset();
            if (this._isBusSecure) {
                messageProcessorSearchResults.setTopicSpace(destinationHandler);
            }
            EvalCache evalCache = this._matching.createEvalCache();
            this.search(string2, matchSpaceKey, evalCache, messageProcessorSearchResults);
        }
        catch (BadMessageFormatMatchingException badMessageFormatMatchingException) {
            FFDCFilter.processException((Throwable)badMessageFormatMatchingException, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.retrieveMatchingOutputHandlers", (String)"1:1045:1.90", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)badMessageFormatMatchingException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingOutputHandlers", (Object)((Object)badMessageFormatMatchingException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1056:1.90", badMessageFormatMatchingException});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1064:1.90", badMessageFormatMatchingException}, null), (Throwable)badMessageFormatMatchingException);
        }
        catch (MatchingException matchingException) {
            FFDCFilter.processException((Throwable)matchingException, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.retrieveMatchingOutputHandlers", (String)"1:1075:1.90", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)matchingException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingOutputHandlers", (Object)((Object)matchingException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1086:1.90", matchingException});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1094:1.90", matchingException}, null), (Throwable)matchingException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingOutputHandlers", (Object)messageProcessorSearchResults);
        }
        return messageProcessorSearchResults;
    }

    public void removeConsumerDispatcherMatchTarget(ConsumerDispatcher consumerDispatcher) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumerDispatcherMatchTarget", (Object)consumerDispatcher);
        }
        try {
            this.removeTarget(consumerDispatcher);
        }
        catch (MatchingException matchingException) {
            FFDCFilter.processException((Throwable)matchingException, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.removeConsumerDispatcherMatchTarget", (String)"1:1129:1.90", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)matchingException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeConsumerDispatcherMatchTarget", (Object)"SICoreException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1140:1.90", matchingException});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1148:1.90", matchingException}, null), (Throwable)matchingException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumerDispatcherMatchTarget");
        }
    }

    public void removePubSubOutputHandlerMatchTarget(ControllableProxySubscription controllableProxySubscription) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removePubSubOutputHandlerMatchTarget", (Object)((Object)controllableProxySubscription));
        }
        try {
            this.removeTarget((Object)controllableProxySubscription);
        }
        catch (MatchingException matchingException) {
            FFDCFilter.processException((Throwable)matchingException, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.removePubSubOutputHandlerMatchTarget", (String)"1:1180:1.90", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)matchingException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1187:1.90", matchingException});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removePubSubOutputHandlerMatchTarget", (Object)"SICoreException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1198:1.90", matchingException}, null), (Throwable)matchingException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removePubSubOutputHandlerMatchTarget");
        }
    }

    private String buildSendTopicExpression(SIBUuid12 sIBUuid12, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"buildSendTopicExpression", (Object)new Object[]{sIBUuid12, string});
        }
        String string2 = null;
        string2 = string == null || string.trim().length() == 0 ? sIBUuid12.toString() : sIBUuid12.toString() + '/' + string;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"buildSendTopicExpression", (Object)string2);
        }
        return string2;
    }

    private String buildAddTopicExpression(SIBUuid12 sIBUuid12, String string) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"buildAddTopicExpression", (Object)new Object[]{sIBUuid12, string});
        }
        String string2 = null;
        if (string == null) {
            string2 = sIBUuid12.toString() + "//.";
        } else if (string.trim().length() == 0) {
            string2 = sIBUuid12.toString();
        } else if (string.startsWith("//")) {
            string2 = sIBUuid12.toString() + string;
        } else {
            if (string.startsWith("/")) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"buildAddTopicExpression", (Object)"SISelectorSyntaxException");
                }
                throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{string}, null));
            }
            string2 = sIBUuid12.toString() + '/' + string;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"buildAddTopicExpression", (Object)string2);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAllCDMatchTargets() {
        ArrayList arrayList;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllCDMatchTargets");
        }
        Map map = this._targets;
        synchronized (map) {
            arrayList = new ArrayList(this._targets.size());
            Iterator iterator = this._targets.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (!(k instanceof ConsumerDispatcher)) continue;
                arrayList.add(k);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllCDMatchTargets");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAllCDMatchTargetsForTopicSpace(String string) {
        ArrayList arrayList;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllCDMatchTargetsForTopicSpace");
        }
        Map map = this._targets;
        synchronized (map) {
            arrayList = new ArrayList(this._targets.size());
            Iterator iterator = this._targets.keySet().iterator();
            while (iterator.hasNext()) {
                String string2;
                Object k = iterator.next();
                if (!(k instanceof ConsumerDispatcher) || !(string2 = ((ConsumerDispatcher)k).getDestination().getName()).equals(string)) continue;
                arrayList.add(k);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllCDMatchTargetsForTopicSpace");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAllPubSubOutputHandlerMatchTargets() {
        ArrayList<OutputHandler> arrayList;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllPubSubOutputHandlerMatchTargets");
        }
        Map map = this._targets;
        synchronized (map) {
            arrayList = new ArrayList<OutputHandler>(this._targets.size());
            Iterator iterator = this._targets.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (!(k instanceof ControllableProxySubscription)) continue;
                arrayList.add(((ControllableProxySubscription)((Object)k)).getOutputHandler());
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllPubSubOutputHandlerMatchTargets", arrayList);
        }
        return arrayList;
    }

    public Selector parseDiscriminator(String string) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"parseDiscriminator", (Object)string);
        }
        Operator operator = null;
        try {
            if (string != null) {
                this._matchSpace.checkTopicSyntax(string);
                operator = this._matching.createTopicLikeOperator((Selector)this._rootId, string);
            }
        }
        catch (InvalidTopicSyntaxException invalidTopicSyntaxException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"parseDiscriminator", (Object)((Object)invalidTopicSyntaxException));
            }
            throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{string}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"parseDiscriminator", operator);
        }
        return operator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selector parseSelector(String string, SelectorDomain selectorDomain) throws SISelectorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"parseSelector", (Object)new Object[]{string, selectorDomain});
        }
        Selector selector = null;
        Transformer transformer = Matching.getTransformer();
        JSResolver jSResolver = null;
        try {
            MessageProcessorMatching messageProcessorMatching = this;
            synchronized (messageProcessorMatching) {
                if (selectorDomain.equals((Object)SelectorDomain.JMS)) {
                    jSResolver = this._jmsResolver;
                    this._parser = this._matching.primeMatchParser(this._parser, string, true);
                } else {
                    jSResolver = this._simessageResolver;
                    this._parser = this._matching.primeMatchParser(this._parser, string, false);
                }
                selector = this._parser.getSelector();
                if (selector.getType() == 2) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"parseSelector", (Object)"SISelectorSyntaxException");
                    }
                    throw new SISelectorSyntaxException(nls.getFormattedMessage("INVALID_SELECTOR_ERROR_CWSIP0371", new Object[]{string}, null));
                }
                if ((selector = transformer.resolve(selector, (Resolver)jSResolver, this._positionAssigner)).getType() == 2) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"parseSelector", (Object)"SISelectorSyntaxException");
                    }
                    throw new SISelectorSyntaxException(nls.getFormattedMessage("INVALID_SELECTOR_ERROR_CWSIP0371", new Object[]{string}, null));
                }
            }
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.parseSelector", (String)"1:1532:1.90", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"parseSelector", (Object)"SISelectorSyntaxException");
            }
            throw new SISelectorSyntaxException(nls.getFormattedMessage("INVALID_SELECTOR_ERROR_CWSIP0371", new Object[]{null}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"parseSelector", (Object)selector);
        }
        return selector;
    }

    public boolean evaluateMessage(Selector selector, Selector selector2, SIBusMessage sIBusMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"evaluateMessage", (Object)new Object[]{selector, sIBusMessage});
        }
        boolean bl = false;
        Object object = null;
        boolean bl2 = true;
        EvalCache evalCache = EvalCache.DUMMY;
        try {
            Evaluator evaluator = Matching.getEvaluator();
            if (selector2 != null) {
                bl2 = false;
                String string = sIBusMessage.getDiscriminator();
                DiscriminatorMatchSpaceKey discriminatorMatchSpaceKey = new DiscriminatorMatchSpaceKey(string);
                object = evaluator.eval(selector2, (MatchSpaceKey)discriminatorMatchSpaceKey, evalCache, false);
                if (object != null && ((Boolean)object).booleanValue()) {
                    bl2 = true;
                }
            }
            if (selector != null && bl2) {
                object = evaluator.eval(selector, (MatchSpaceKey)sIBusMessage, evalCache, false);
            }
        }
        catch (BadMessageFormatMatchingException badMessageFormatMatchingException) {
            FFDCFilter.processException((Throwable)badMessageFormatMatchingException, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.evaluateMessage", (String)"1:1602:1.90", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)badMessageFormatMatchingException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"evaluateMessage", (Object)"SICoreException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1612:1.90", badMessageFormatMatchingException});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1622:1.90", badMessageFormatMatchingException}, null), (Throwable)badMessageFormatMatchingException);
        }
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        } else if (object == null) {
            bl = false;
        } else {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"evaluateMessage", (Object)"SICoreException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1648:1.90"});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1655:1.90"}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"evaluateMessage", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void addTopicAcl(SIBUuid12 sIBUuid12, TopicAcl topicAcl) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addTopicAcl", (Object)new Object[]{sIBUuid12, topicAcl});
        }
        String string = null;
        String string2 = "";
        if (sIBUuid12 != null) {
            string2 = this.buildAddTopicExpression(sIBUuid12, topicAcl.getTopic());
        }
        string = topicAcl.getTopic() != null ? string2 + "//." : string2;
        try {
            this.addTarget((Object)topicAcl, string, null, null, null, topicAcl, null);
        }
        catch (QuerySyntaxException querySyntaxException) {
        }
        catch (InvalidTopicSyntaxException invalidTopicSyntaxException) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)invalidTopicSyntaxException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addTopicAcl", (Object)"SIDiscriminatorSyntaxException");
            }
            throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{string2}, null));
        }
        catch (MatchingException matchingException) {
            FFDCFilter.processException((Throwable)matchingException, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.addTopicAcl", (String)"1:1730:1.90", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addTopicAcl", (Object)"SIErrorException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1738:1.90", matchingException});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1746:1.90", matchingException}, null), (Throwable)matchingException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addTopicAcl");
        }
    }

    public MessageProcessorSearchResults retrieveMatchingTopicAcls(DestinationHandler destinationHandler, String string, JsMessage jsMessage, MessageProcessorSearchResults messageProcessorSearchResults) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"retrieveMatchingTopicAcls", (Object)new Object[]{destinationHandler, string, jsMessage, messageProcessorSearchResults});
        }
        SIBUuid12 sIBUuid12 = destinationHandler.getBaseUuid();
        String string2 = this.buildSendTopicExpression(sIBUuid12, string);
        try {
            this._matchSpace.checkEventTopicSyntax(string2);
        }
        catch (InvalidTopicSyntaxException invalidTopicSyntaxException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingTopicAcls", (Object)((Object)invalidTopicSyntaxException));
            }
            SIMPDiscriminatorSyntaxException sIMPDiscriminatorSyntaxException = new SIMPDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{string2}, null));
            sIMPDiscriminatorSyntaxException.setExceptionReason(901);
            sIMPDiscriminatorSyntaxException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1803:1.90", SIMPUtils.getStackTrace(invalidTopicSyntaxException)});
            throw sIMPDiscriminatorSyntaxException;
        }
        try {
            EvalCache evalCache = this._matching.createEvalCache();
            messageProcessorSearchResults.reset();
            if (this._isBusSecure) {
                messageProcessorSearchResults.setTopicSpace(destinationHandler);
            }
            this.search(string2, (MatchSpaceKey)jsMessage, evalCache, messageProcessorSearchResults);
        }
        catch (BadMessageFormatMatchingException badMessageFormatMatchingException) {
            FFDCFilter.processException((Throwable)badMessageFormatMatchingException, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.retrieveMatchingTopicAcls", (String)"1:1835:1.90", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)badMessageFormatMatchingException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingTopicAcls", (Object)((Object)badMessageFormatMatchingException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1846:1.90", badMessageFormatMatchingException});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1854:1.90", badMessageFormatMatchingException}, null), (Throwable)badMessageFormatMatchingException);
        }
        catch (MatchingException matchingException) {
            FFDCFilter.processException((Throwable)matchingException, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.retrieveMatchingTopicAcls", (String)"1:1865:1.90", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)matchingException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingTopicAcls", (Object)"SIErrorException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1875:1.90", matchingException});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1883:1.90", matchingException}, null), (Throwable)matchingException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingTopicAcls");
        }
        return messageProcessorSearchResults;
    }

    public boolean isWildCarded(String string) {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isWildCarded", (Object)string);
        }
        try {
            this._matchSpace.checkEventTopicSyntax(string);
        }
        catch (InvalidTopicSyntaxException invalidTopicSyntaxException) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isWildCarded", (Object)new Boolean(bl));
        }
        return bl;
    }

    private String selectorAsString(SelectionCriteria selectionCriteria) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"selectorAsString", (Object)selectionCriteria);
        }
        String string = "";
        if (selectionCriteria != null && selectionCriteria.getSelectorDomain() != null) {
            string = selectionCriteria.getSelectorDomain().toString() + ":";
            if (selectionCriteria.getSelectorString() != null) {
                string = string + selectionCriteria.getSelectorString();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"selectorAsString", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTopicAcls() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeAllTopicAcls");
        }
        ArrayList<Object> arrayList = null;
        try {
            Map map = this._targets;
            synchronized (map) {
                Object object;
                arrayList = new ArrayList<Object>(this._targets.size());
                Iterator iterator = this._targets.keySet().iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (!(object instanceof TopicAcl)) continue;
                    arrayList.add(object);
                }
                object = arrayList.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    this.removeTarget(e);
                }
            }
        }
        catch (MatchingException matchingException) {
            FFDCFilter.processException((Throwable)matchingException, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.removeAllTopicAcls", (String)"1:1986:1.90", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)matchingException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeAllTopicAcls", (Object)"SICoreException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1997:1.90", matchingException});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2005:1.90", matchingException}, null), (Throwable)matchingException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeAllTopicAcls");
        }
    }

    public void search(String string, MatchSpaceKey matchSpaceKey, EvalCache evalCache, MessageProcessorSearchResults messageProcessorSearchResults) throws BadMessageFormatMatchingException, MatchingException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"search", (Object)new Object[]{string, matchSpaceKey, evalCache, messageProcessorSearchResults});
        }
        if (this._isBusSecure) {
            int n = this._messageProcessor.getDiscriminatorAccessChecker().getAclRefreshVersion();
            boolean bl = true;
            while (bl) {
                this._matchSpace.search((Object)string, matchSpaceKey, evalCache, (SearchResults)messageProcessorSearchResults);
                int n2 = this._messageProcessor.getDiscriminatorAccessChecker().getAclRefreshVersion();
                if (n2 == n) {
                    bl = false;
                    continue;
                }
                n = n2;
            }
        } else {
            this._matchSpace.search((Object)string, matchSpaceKey, evalCache, (SearchResults)messageProcessorSearchResults);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"search");
        }
    }

    private class DiscriminatorMatchSpaceKey
    implements MatchSpaceKey {
        private String value;

        public DiscriminatorMatchSpaceKey(String string) {
            this.value = string;
        }

        public Object getIdentifierValue(Identifier identifier, boolean bl) {
            return this.value;
        }
    }

    private static class Target {
        private Conjunction[] expr;
        private MatchTarget[] targets;

        Target(Conjunction[] conjunctionArray, MatchTarget[] matchTargetArray) {
            this.expr = conjunctionArray;
            this.targets = matchTargetArray;
        }
    }
}

