/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.io.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.MEConnection;
import com.ibm.ws.sib.comms.NoCapacityException;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.processor.io.impl.JsMessageWrapper;
import com.ibm.ws.sib.processor.io.impl.MPIO;
import com.ibm.ws.sib.processor.utils.Enumarray;
import com.ibm.ws.sib.processor.utils.Queue;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.CellulePair;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.util.List;
import java.util.Vector;

public class MessageBuffer {
    protected static final int NUM_QUEUES = 16;
    protected static final int NUM_TRIMMABLE = 10;
    protected static long ALLOWED_SIZE_OF_A_QUEUE = 50000L;
    protected static boolean ENABLE_QUEUE_FAIRNESS = true;
    protected MEConnection m_connection;
    protected MPIO parent;
    protected int fairMarker = 15;
    protected int lowestPriorityWithCapacity;
    protected Queue[] m_outQueues = new Queue[16];
    protected int[] m_outQueueMessages = new int[16];
    protected boolean[] queueBackLog = new boolean[16];
    private long currentQueueLength = 0L;
    private long numCutThru = 0L;
    private long numQueued = 0L;
    private long numSent = 0L;
    private long numRerouted = 0L;
    private long numTrimmed = 0L;
    private long[] currentQueueSize = new long[16];
    protected final int CONTROL_MESSAGE_SIZE = 200;
    private boolean processingCapacityChange = false;
    private static final TraceComponent tc = SibTr.register((Class)MessageBuffer.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public MessageBuffer(MEConnection mEConnection, MPIO mPIO) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageBuffer", (Object)new Object[]{mEConnection, mPIO});
        }
        for (int i = 0; i < 16; ++i) {
            this.m_outQueues[i] = new Queue();
            this.m_outQueueMessages[i] = 0;
        }
        this.lowestPriorityWithCapacity = 0;
        this.m_connection = mEConnection;
        this.parent = mPIO;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageBuffer", (Object)this);
        }
    }

    public synchronized void resetConnection(MEConnection mEConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetConnection", (Object)new Object[]{this, mEConnection});
        }
        this.m_connection = mEConnection;
        this.processCapacityChange();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetConnection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendOrEnqueue(JsMessageWrapper jsMessageWrapper) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendOrEnqueue", (Object)new Object[]{this, jsMessageWrapper});
        }
        int n = jsMessageWrapper.priority;
        List list = null;
        int n2 = 0;
        try {
            list = jsMessageWrapper.jsMsg != null ? jsMessageWrapper.jsMsg.encode((Object)this.m_connection) : jsMessageWrapper.cMsg.encode((Object)this.m_connection);
        }
        catch (MessageEncodeFailedException messageEncodeFailedException) {
            FFDCFilter.processException((Throwable)messageEncodeFailedException, (String)"com.ibm.ws.sib.processor.io.impl.MessageBuffer.sendOrEnqueue", (String)"1:212:1.36", (Object)this);
            if (jsMessageWrapper.jsMsg != null) {
                String string = null;
                try {
                    string = this.parent.getMessageProcessor().getDestinationManager().getDestination(jsMessageWrapper.jsMsg.getGuaranteedTargetDestinationDefinitionUUID(), true).getName();
                }
                catch (SIException sIException) {
                    string = jsMessageWrapper.jsMsg.getGuaranteedTargetDestinationDefinitionUUID().toString();
                }
                SibTr.error((TraceComponent)tc, (String)"ENCODE_FAIL_ERROR_CWSIP0281", (Object)new Object[]{jsMessageWrapper.jsMsg.getGuaranteedTargetMessagingEngineUUID(), string, new Long(jsMessageWrapper.jsMsg.getGuaranteedValueValueTick()), jsMessageWrapper.jsMsg.getGuaranteedStreamUUID()});
            }
            if (tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageEncodeFailedException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendOrEnqueue");
            }
            return;
        }
        MessageBuffer messageBuffer = this;
        synchronized (messageBuffer) {
            if (n >= this.lowestPriorityWithCapacity) {
                try {
                    if (jsMessageWrapper.jsMsg != null) {
                        this.m_connection.send(list, n, false);
                    } else {
                        this.m_connection.send(list, n, true);
                    }
                    ++this.numCutThru;
                    ++this.numSent;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"sendOrEnqueue", (Object)"Message accepted by Comms");
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"sendOrEnqueue");
                    }
                    return;
                }
                catch (NoCapacityException noCapacityException) {
                    if (tc.isDebugEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)noCapacityException));
                    }
                }
                catch (SIConnectionDroppedException sIConnectionDroppedException) {
                    this.parent.error(this.m_connection, sIConnectionDroppedException);
                }
                catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
                    this.parent.error(this.m_connection, sIConnectionUnavailableException);
                }
                catch (SIConnectionLostException sIConnectionLostException) {
                    this.parent.error(this.m_connection, sIConnectionLostException);
                }
                catch (MessageEncodeFailedException messageEncodeFailedException) {
                    this.parent.error(this.m_connection, messageEncodeFailedException);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"sendOrEnqueue");
                    }
                    return;
                }
            }
            if (jsMessageWrapper.jsMsg != null) {
                try {
                    n2 = jsMessageWrapper.jsMsg.getEncodedLength();
                }
                catch (MessageEncodeFailedException messageEncodeFailedException) {
                    this.parent.error(this.m_connection, messageEncodeFailedException);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"sendOrEnqueue");
                    }
                    return;
                }
                jsMessageWrapper.updateJsMessageWithEncodedForm(list, n2);
            } else {
                n2 = 200;
                jsMessageWrapper.updateCntrlMessageWithEncodedForm(list, n2);
            }
            if (n < 10 && ALLOWED_SIZE_OF_A_QUEUE >= 0L && this.currentQueueSize[n] + (long)n2 >= ALLOWED_SIZE_OF_A_QUEUE) {
                ++this.numTrimmed;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"sendOrEnqueue", (Object)("Message trimmed (" + this.numTrimmed + ")"));
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"sendOrEnqueue", (Object)("Message trimmed (" + this.numTrimmed + "): " + jsMessageWrapper));
                }
                return;
            }
            this.m_outQueues[n].enqueue(jsMessageWrapper);
            ++this.currentQueueLength;
            int n3 = n;
            this.m_outQueueMessages[n3] = this.m_outQueueMessages[n3] + 1;
            ++this.numQueued;
            int n4 = n;
            this.currentQueueSize[n4] = this.currentQueueSize[n4] + (long)n2;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"sendOrEnqueue", (Object)("Message queued \n" + this.currentQueueLength + "messages currently queued (" + this.m_outQueueMessages[n] + " at priority " + n + ") " + this.numQueued + " messages queued ever"));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendOrEnqueue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processCapacityChange() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processCapacityChange", (Object)this);
        }
        int n = this.m_connection.getLowestPriorityWithCapacity();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Current lowest priority: " + this.lowestPriorityWithCapacity + ", new lowest priority: " + n));
        }
        if (n != this.lowestPriorityWithCapacity) {
            if (n > this.lowestPriorityWithCapacity) {
                this.lowestPriorityWithCapacity = n;
            } else {
                this.lowestPriorityWithCapacity = n;
                if (!this.processingCapacityChange) {
                    this.processingCapacityChange = true;
                    try {
                        int n2 = 15;
                        int n3 = 16 - n;
                        if (ENABLE_QUEUE_FAIRNESS) {
                            if (this.fairMarker >= n) {
                                n2 = this.fairMarker;
                            }
                            this.fairMarker = (this.fairMarker + 16 - 1) % 16;
                        }
                        int n4 = n2;
                        for (int i = 0; i < n3; ++i) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Checking priority queue " + n4 + " for messages..."));
                                SibTr.debug((TraceComponent)tc, (String)(this.m_outQueueMessages[n4] + " messages currently queued"));
                            }
                            Queue queue = this.m_outQueues[n4];
                            while (!queue.isEmpty() && n4 >= n) {
                                JsMessageWrapper jsMessageWrapper = (JsMessageWrapper)queue.peek();
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Processing message: " + jsMessageWrapper));
                                }
                                try {
                                    if (jsMessageWrapper.encodedJsMessage != null) {
                                        this.m_connection.send(jsMessageWrapper.encodedJsMessage, n4, false);
                                    } else {
                                        this.m_connection.send(jsMessageWrapper.encodedCntlMessage, n4, true);
                                    }
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)tc, (String)"Message accepted by Comms");
                                    }
                                    queue.dequeue();
                                    int n5 = n4;
                                    this.m_outQueueMessages[n5] = this.m_outQueueMessages[n5] - 1;
                                    --this.currentQueueLength;
                                    ++this.numSent;
                                    if (jsMessageWrapper.messageSize > 0) {
                                        int n6 = n4;
                                        this.currentQueueSize[n6] = this.currentQueueSize[n6] - (long)jsMessageWrapper.messageSize;
                                    }
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)tc, (String)(this.currentQueueLength + "messages currently queued (" + this.m_outQueueMessages[n4] + " at priority " + n4 + ") " + this.numQueued + " messages queued ever"));
                                    }
                                    if (n == this.lowestPriorityWithCapacity) continue;
                                    n = this.lowestPriorityWithCapacity;
                                    n3 = 16 - n;
                                    i = 0;
                                    n4 = 15;
                                    if (!tc.isDebugEnabled()) break;
                                    SibTr.debug((TraceComponent)tc, (String)("New capacity is " + this.lowestPriorityWithCapacity));
                                    break;
                                }
                                catch (NoCapacityException noCapacityException) {
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)tc, (String)("Exception from send: " + (Object)((Object)noCapacityException)));
                                    }
                                    n = this.m_connection.getLowestPriorityWithCapacity();
                                    n3 = 16 - n;
                                    i = 0;
                                    n4 = 15;
                                    this.lowestPriorityWithCapacity = n;
                                    if (!tc.isDebugEnabled()) break;
                                    SibTr.debug((TraceComponent)tc, (String)("New capacity is " + this.lowestPriorityWithCapacity));
                                    break;
                                }
                                catch (SIConnectionDroppedException sIConnectionDroppedException) {
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)tc, (String)("Exception from send: " + (Object)((Object)sIConnectionDroppedException)));
                                    }
                                    this.parent.error(this.m_connection, sIConnectionDroppedException);
                                }
                                catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)tc, (String)("Exception from send: " + (Object)((Object)sIConnectionUnavailableException)));
                                    }
                                    this.parent.error(this.m_connection, sIConnectionUnavailableException);
                                }
                                catch (SIConnectionLostException sIConnectionLostException) {
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)tc, (String)("Exception from send: " + (Object)((Object)sIConnectionLostException)));
                                    }
                                    this.parent.error(this.m_connection, sIConnectionLostException);
                                }
                                catch (MessageEncodeFailedException messageEncodeFailedException) {
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)tc, (String)("Exception from send: " + (Object)((Object)messageEncodeFailedException)));
                                    }
                                    this.parent.error(this.m_connection, messageEncodeFailedException);
                                }
                            }
                            n4 = n4 == n ? 15 : n4 - 1;
                        }
                    }
                    finally {
                        this.processingCapacityChange = false;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processCapacityChange");
        }
    }

    public synchronized Queue extractNonRoutable(Cellule[] celluleArray, MessagingEngine[] messagingEngineArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"extractNonRoutable", (Object)new Object[]{this, new Enumarray(celluleArray), new Enumarray(messagingEngineArray)});
        }
        Queue queue = new Queue();
        for (int i = 15; i >= 0; --i) {
            Queue queue2 = new Queue();
            block1: while (!this.m_outQueues[i].isEmpty()) {
                int n;
                JsMessageWrapper jsMessageWrapper = (JsMessageWrapper)this.m_outQueues[i].dequeue();
                if (jsMessageWrapper.ptpTarget != null) {
                    for (n = 0; n < messagingEngineArray.length; ++n) {
                        if (!messagingEngineArray[n].equals(jsMessageWrapper.ptpTarget)) continue;
                        int n2 = i;
                        this.m_outQueueMessages[n2] = this.m_outQueueMessages[n2] - 1;
                        --this.currentQueueLength;
                        ++this.numRerouted;
                        if (jsMessageWrapper.messageSize > 0) {
                            int n3 = i;
                            this.currentQueueSize[n3] = this.currentQueueSize[n3] - (long)jsMessageWrapper.messageSize;
                        }
                        queue.enqueue(jsMessageWrapper);
                        continue block1;
                    }
                    queue2.enqueue(jsMessageWrapper);
                    continue;
                }
                Vector<CellulePair> vector = new Vector<CellulePair>();
                Vector<CellulePair> vector2 = new Vector<CellulePair>();
                block3: for (n = 0; n < jsMessageWrapper.pubsubTarget.length; ++n) {
                    for (int j = 0; j < celluleArray.length; ++j) {
                        if (!jsMessageWrapper.pubsubTarget[n].target.equals(celluleArray[j])) continue;
                        vector.add(jsMessageWrapper.pubsubTarget[n]);
                        continue block3;
                    }
                    vector2.add(jsMessageWrapper.pubsubTarget[n]);
                }
                if (vector.size() > 0) {
                    Object[] objectArray = new CellulePair[vector.size()];
                    JsMessage jsMessage = null;
                    JsMessageWrapper jsMessageWrapper2 = null;
                    vector.copyInto(objectArray);
                    if (jsMessageWrapper.isJsMessage) {
                        jsMessage = jsMessageWrapper.createCopyJsMessage();
                    }
                    if (jsMessage != null) {
                        jsMessageWrapper2 = JsMessageWrapper.wrapPubSub(jsMessage, jsMessageWrapper.priority, (CellulePair[])objectArray, jsMessageWrapper.upstream);
                        queue.enqueue(jsMessageWrapper2);
                    }
                    if (vector2.size() == 0) {
                        int n4 = i;
                        this.m_outQueueMessages[n4] = this.m_outQueueMessages[n4] - 1;
                        --this.currentQueueLength;
                        ++this.numRerouted;
                        if (jsMessageWrapper2.messageSize <= 0) continue;
                        int n5 = i;
                        this.currentQueueSize[n5] = this.currentQueueSize[n5] - (long)jsMessageWrapper2.messageSize;
                        continue;
                    }
                    Object[] objectArray2 = new CellulePair[vector2.size()];
                    vector2.copyInto(objectArray2);
                    jsMessageWrapper.pubsubTarget = objectArray2;
                    queue2.enqueue(jsMessageWrapper);
                    continue;
                }
                queue2.enqueue(jsMessageWrapper);
            }
            this.m_outQueues[i] = queue2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"extractNonRoutable", (Object)queue);
        }
        return queue;
    }

    public synchronized Queue extractAll() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"extractAll", (Object)this);
        }
        Queue queue = new Queue();
        for (int i = 15; i >= 0; --i) {
            while (!this.m_outQueues[i].isEmpty()) {
                JsMessageWrapper jsMessageWrapper = (JsMessageWrapper)this.m_outQueues[i].dequeue();
                queue.enqueue(jsMessageWrapper);
                int n = i;
                this.m_outQueueMessages[n] = this.m_outQueueMessages[n] - 1;
                --this.currentQueueLength;
                if (jsMessageWrapper.messageSize <= 0) continue;
                int n2 = i;
                this.currentQueueSize[n2] = this.currentQueueSize[n2] - (long)jsMessageWrapper.messageSize;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"extractAll", (Object)queue);
        }
        return queue;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/io/impl/MessageBuffer.java, SIB.processor, WAS602.SIB, o0610.11 1.36");
        }
    }
}

