/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.io.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.JsMessageFactory;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlAck;
import com.ibm.ws.sib.mfp.control.ControlAckExpected;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.processor.utils.Enumarray;
import com.ibm.ws.sib.trm.topology.CellulePair;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.List;

public class JsMessageWrapper {
    protected JsMessage jsMsg;
    protected ControlMessage cMsg;
    protected List encodedJsMessage;
    protected List encodedCntlMessage;
    protected int priority;
    protected int messageSize = -1;
    protected CellulePair[] ptpTarget;
    protected CellulePair[] pubsubTarget;
    protected boolean upstream;
    protected boolean isJsMessage = false;
    protected DebugInfo debugInfo;
    private static final TraceComponent tc = SibTr.register((Class)JsMessageWrapper.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public static JsMessageWrapper wrapPtp(JsMessage jsMessage, int n, CellulePair cellulePair) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"wrapPtp", (Object)new Object[]{jsMessage, new Integer(n), cellulePair});
        }
        JsMessageWrapper jsMessageWrapper = new JsMessageWrapper();
        jsMessageWrapper.jsMsg = jsMessage;
        jsMessageWrapper.cMsg = null;
        jsMessageWrapper.priority = n;
        jsMessageWrapper.ptpTarget = new CellulePair[1];
        jsMessageWrapper.ptpTarget[0] = cellulePair;
        jsMessageWrapper.isJsMessage = true;
        if (tc.isDebugEnabled()) {
            JsMessageWrapper jsMessageWrapper2 = jsMessageWrapper;
            jsMessageWrapper2.getClass();
            jsMessageWrapper.debugInfo = jsMessageWrapper2.new DebugInfo(jsMessage, n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"wrapPtp", (Object)jsMessageWrapper);
        }
        return jsMessageWrapper;
    }

    public static JsMessageWrapper wrapPtp(ControlMessage controlMessage, int n, CellulePair cellulePair) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"wrapPtp", (Object)new Object[]{controlMessage, new Integer(n), cellulePair});
        }
        JsMessageWrapper jsMessageWrapper = new JsMessageWrapper();
        jsMessageWrapper.cMsg = controlMessage;
        jsMessageWrapper.jsMsg = null;
        jsMessageWrapper.priority = n;
        jsMessageWrapper.ptpTarget = new CellulePair[1];
        jsMessageWrapper.ptpTarget[0] = cellulePair;
        jsMessageWrapper.isJsMessage = false;
        if (tc.isDebugEnabled()) {
            JsMessageWrapper jsMessageWrapper2 = jsMessageWrapper;
            jsMessageWrapper2.getClass();
            jsMessageWrapper.debugInfo = jsMessageWrapper2.new DebugInfo(controlMessage, n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"wrapPtp", (Object)jsMessageWrapper);
        }
        return jsMessageWrapper;
    }

    public static byte[] convertEncodedMessageToSingleByte(List list) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"convertEncodedMessageToSingleByte", (Object)list);
        }
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            byte[] byArray = (byte[])list.get(i);
            n += byArray.length;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            byte[] byArray2 = (byte[])list.get(i);
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            n2 += byArray2.length;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"convertEncodedMessageToSingleByte", (Object)byArray);
        }
        return byArray;
    }

    public JsMessage createCopyJsMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createCopyJsMessage");
        }
        JsMessage jsMessage = null;
        try {
            if (!this.isJsMessage) {
                jsMessage = null;
            } else if (this.jsMsg != null) {
                jsMessage = this.jsMsg.getSent();
            } else if (this.encodedJsMessage != null) {
                byte[] byArray = JsMessageWrapper.convertEncodedMessageToSingleByte(this.encodedJsMessage);
                jsMessage = JsMessageFactory.getInstance().createInboundJsMessage(byArray, 0, byArray.length);
            } else {
                jsMessage = null;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.io.impl.JsMessageWrapper.createCopyJsMessage", (String)"1:230:1.29", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
            jsMessage = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createCopyJsMessage", (Object)jsMessage);
        }
        return jsMessage;
    }

    public ControlMessage createCopyCtrlMessage() {
        return null;
    }

    public static JsMessageWrapper wrapPubSub(JsMessage jsMessage, int n, CellulePair[] cellulePairArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"wrapPubSub", (Object)new Object[]{jsMessage, new Integer(n), new Enumarray(cellulePairArray), bl});
        }
        JsMessageWrapper jsMessageWrapper = new JsMessageWrapper();
        jsMessageWrapper.jsMsg = jsMessage;
        jsMessageWrapper.cMsg = null;
        jsMessageWrapper.priority = n;
        jsMessageWrapper.pubsubTarget = cellulePairArray;
        jsMessageWrapper.upstream = bl;
        jsMessageWrapper.isJsMessage = true;
        if (tc.isDebugEnabled()) {
            JsMessageWrapper jsMessageWrapper2 = jsMessageWrapper;
            jsMessageWrapper2.getClass();
            jsMessageWrapper.debugInfo = jsMessageWrapper2.new DebugInfo(jsMessage, n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"wrapPubSub", (Object)jsMessageWrapper);
        }
        return jsMessageWrapper;
    }

    public static JsMessageWrapper wrapPubSub(ControlMessage controlMessage, int n, CellulePair[] cellulePairArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"wrapPubSub", (Object)new Object[]{controlMessage, new Integer(n), new Enumarray(cellulePairArray), bl});
        }
        JsMessageWrapper jsMessageWrapper = new JsMessageWrapper();
        jsMessageWrapper.cMsg = controlMessage;
        jsMessageWrapper.jsMsg = null;
        jsMessageWrapper.priority = n;
        jsMessageWrapper.pubsubTarget = cellulePairArray;
        jsMessageWrapper.upstream = bl;
        jsMessageWrapper.isJsMessage = false;
        if (tc.isDebugEnabled()) {
            JsMessageWrapper jsMessageWrapper2 = jsMessageWrapper;
            jsMessageWrapper2.getClass();
            jsMessageWrapper.debugInfo = jsMessageWrapper2.new DebugInfo(controlMessage, n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"wrapPubSub", (Object)jsMessageWrapper);
        }
        return jsMessageWrapper;
    }

    public static JsMessageWrapper wrapDirect(JsMessage jsMessage, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"wrapDirect", (Object)new Object[]{jsMessage, new Integer(n)});
        }
        JsMessageWrapper jsMessageWrapper = new JsMessageWrapper();
        jsMessageWrapper.jsMsg = jsMessage;
        jsMessageWrapper.cMsg = null;
        jsMessageWrapper.priority = n;
        jsMessageWrapper.isJsMessage = true;
        if (tc.isDebugEnabled()) {
            JsMessageWrapper jsMessageWrapper2 = jsMessageWrapper;
            jsMessageWrapper2.getClass();
            jsMessageWrapper.debugInfo = jsMessageWrapper2.new DebugInfo(jsMessage, n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"wrapDirect", (Object)jsMessageWrapper);
        }
        return jsMessageWrapper;
    }

    public static JsMessageWrapper wrapDirect(ControlMessage controlMessage, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"wrapDirect", (Object)new Object[]{controlMessage, new Integer(n)});
        }
        JsMessageWrapper jsMessageWrapper = new JsMessageWrapper();
        jsMessageWrapper.cMsg = controlMessage;
        jsMessageWrapper.jsMsg = null;
        jsMessageWrapper.priority = n;
        jsMessageWrapper.isJsMessage = false;
        if (tc.isDebugEnabled()) {
            JsMessageWrapper jsMessageWrapper2 = jsMessageWrapper;
            jsMessageWrapper2.getClass();
            jsMessageWrapper.debugInfo = jsMessageWrapper2.new DebugInfo(controlMessage, n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"wrapDirect", (Object)jsMessageWrapper);
        }
        return jsMessageWrapper;
    }

    public String toString() {
        if (this.debugInfo != null) {
            return this.debugInfo.toString() + "\nMessage: " + (this.jsMsg != null ? this.jsMsg.toString() : (this.cMsg != null ? this.cMsg.toString() : "none"));
        }
        return this.jsMsg != null ? this.jsMsg.toString() : (this.cMsg != null ? this.cMsg.toString() : "No message");
    }

    public void updateJsMessageWithEncodedForm(List list, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateJsMessageWithEncodedForm", (Object)new Object[]{list, new Integer(n)});
        }
        if (this.isJsMessage && this.jsMsg != null) {
            this.jsMsg = null;
            this.encodedJsMessage = list;
            this.messageSize = n;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateJsMessageWithEncodedForm");
        }
    }

    public int getMessageSize() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageSize");
            SibTr.exit((TraceComponent)tc, (String)"getMessageSize", (Object)new Integer(this.messageSize));
        }
        return this.messageSize;
    }

    public void updateCntrlMessageWithEncodedForm(List list, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateCntrlMessageWithEncodedForm", (Object)new Object[]{list, new Integer(n)});
        }
        if (!this.isJsMessage && this.cMsg != null) {
            this.cMsg = null;
            this.encodedCntlMessage = list;
            this.messageSize = n;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateCntrlMessageWithEncodedForm");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/io/impl/JsMessageWrapper.java, SIB.processor, WAS602.SIB, o0610.11 1.29");
        }
    }

    final class DebugInfo {
        private final ProtocolType protocolType;
        private final ControlMessageType controlType;
        private final int hashCode;
        private final int msgPriority;
        private final int sendPriority;
        private final long startTick;
        private final long endTick;
        private final SIBUuid12 streamId;

        public DebugInfo(JsMessage jsMessage, int n) {
            this.hashCode = jsMessage.hashCode();
            this.sendPriority = n;
            this.msgPriority = jsMessage.getPriority();
            this.protocolType = jsMessage.getGuaranteedProtocolType();
            this.controlType = null;
            this.startTick = jsMessage.getGuaranteedValueValueTick();
            this.endTick = -1L;
            this.streamId = jsMessage.getGuaranteedStreamUUID();
        }

        public DebugInfo(ControlMessage controlMessage, int n) {
            this.hashCode = controlMessage.hashCode();
            this.sendPriority = n;
            this.msgPriority = controlMessage.getPriority();
            this.protocolType = controlMessage.getGuaranteedProtocolType();
            this.controlType = controlMessage.getControlMessageType();
            this.streamId = controlMessage.getGuaranteedStreamUUID();
            if (this.controlType == ControlMessageType.ACK) {
                this.startTick = ((ControlAck)controlMessage).getAckPrefix();
                this.endTick = -1L;
            } else if (this.controlType == ControlMessageType.ACKEXPECTED) {
                this.startTick = ((ControlAckExpected)controlMessage).getTick();
                this.endTick = -1L;
            } else if (this.controlType == ControlMessageType.NACK) {
                this.startTick = ((ControlNack)controlMessage).getStartTick();
                this.endTick = ((ControlNack)controlMessage).getEndTick();
            } else if (this.controlType == ControlMessageType.SILENCE) {
                this.startTick = ((ControlSilence)controlMessage).getStartTick();
                this.endTick = ((ControlSilence)controlMessage).getEndTick();
            } else {
                this.startTick = -1L;
                this.endTick = -1L;
            }
        }

        public String toString() {
            if (this.controlType == null) {
                return this.protocolType + " data message" + "\nHashCode: " + Integer.toHexString(this.hashCode) + "\nPriorities: " + this.sendPriority + "(comms), " + this.msgPriority + "(msg)" + "\nTick: " + this.startTick + "\nStreamId: " + this.streamId;
            }
            if (this.endTick == -1L) {
                return this.protocolType + " " + this.controlType + " message" + "\nHashCode: " + Integer.toHexString(this.hashCode) + "\nPriorities: " + this.sendPriority + "(comms), " + this.msgPriority + "(msg)" + "\nTick: " + this.startTick + "\nStreamId: " + this.streamId;
            }
            return this.protocolType + " " + this.controlType + " message" + "\nHashCode: " + Integer.toHexString(this.hashCode) + "\nPriorities: " + this.sendPriority + "(comms), " + this.msgPriority + "(msg)" + "\nTick: " + this.startTick + "/" + this.endTick + "\nStreamId: " + this.streamId;
        }
    }
}

