/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.BaseMessageItemStream;
import com.ibm.ws.sib.processor.runtime.LocalTopicSpaceControl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;

public final class PubSubMessageItemStream
extends BaseMessageItemStream {
    private static final TraceComponent tc = SibTr.register((Class)PubSubMessageItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    static final TraceNLS nls;
    private LocalizationDefinition _lastLocalizationDefinitionSetByAdmin = null;
    private boolean _isSendAllowed;
    private long _alterationTime;
    private String _name;
    private long _remoteQueueHighLimit;

    public PubSubMessageItemStream() {
    }

    public PubSubMessageItemStream(BaseDestinationHandler baseDestinationHandler, Transaction transaction) throws OutOfCacheSpace, MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PubSubMessageItemStream", (Object)new Object[]{baseDestinationHandler, transaction});
        }
        this.setStorageStrategy(baseDestinationHandler.getStorageStrategy());
        baseDestinationHandler.addItemStream(this, transaction);
        this.initializeNonPersistent(baseDestinationHandler);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PubSubMessageItemStream", (Object)this);
        }
    }

    public void removeItemStream(Transaction transaction, long l) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeItemStream", (Object)new Object[]{transaction, new Long(l)});
        }
        this.deregisterControlAdapterMBean();
        this.remove(transaction, l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeItemStream");
        }
    }

    public void reconstitute(BaseDestinationHandler baseDestinationHandler) throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)baseDestinationHandler);
        }
        this.initializeNonPersistent(baseDestinationHandler);
        ExternalLocalTransaction externalLocalTransaction = baseDestinationHandler.getTxManager().createLocalTransaction();
        this.initialiseUnrestoredMsgIds();
        NonLockingCursor nonLockingCursor = null;
        try {
            nonLockingCursor = this.newNonLockingItemCursor(new ClassEqualsFilter(MessageItem.class));
            object = (MessageItem)nonLockingCursor.next();
            while (object != null) {
                if (((Item)object).getReferenceCount() == 0) {
                    ((AbstractItem)object).remove(externalLocalTransaction, -2L);
                }
                object = (MessageItem)nonLockingCursor.next();
            }
            externalLocalTransaction.commit();
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream.reconstitute", (String)"1:258:1.57", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)((Object)messageStoreException));
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream", "1:275:1.57", messageStoreException}, null), (Throwable)((Object)messageStoreException));
        }
        finally {
            if (nonLockingCursor != null) {
                nonLockingCursor.finished();
            }
        }
        if (tc.isEntryEnabled()) {
            object = this.getStatistics();
            SibTr.exit((TraceComponent)tc, (String)"reconstitute - counts total items, available items", (Object)new Object[]{new Long(object.getTotalItemCount()), new Long(object.getAvailableItemCount())});
        }
    }

    public boolean isRemoteQueueHighLimit() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isRemoteQueueHighLimit");
        }
        boolean bl = false;
        if (this._destHighMsgs != -1L) {
            Statistics statistics = this.getStatistics();
            boolean bl2 = bl = statistics.getTotalItemCount() >= this._remoteQueueHighLimit;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isRemoteQueueHighLimit", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isQLowRemoteLimit() {
        Statistics statistics;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isQLowRemoteLimit");
        }
        long l = this._destHighMsgs;
        boolean bl = false;
        if (this._remoteQueueHighLimit > this._destHighMsgs) {
            l = this._remoteQueueHighLimit - (this._remoteQueueHighLimit - this._destHighMsgs) / 2L;
        }
        boolean bl2 = bl = (statistics = this.getStatistics()).getTotalItemCount() <= l;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Queue depth=" + statistics.getTotalItemCount() + ", RemoteLowLimit=" + l));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isQLowRemoteLimit", (Object)new Boolean(bl));
        }
        return bl;
    }

    public BaseDestinationHandler getDestinationHandler() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHandler");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHandler", (Object)this.destinationHandler);
        }
        return this.destinationHandler;
    }

    public long countAvailablePublications() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"countAvailablePublications");
        }
        int n = this.destinationHandler.getSubscriptionIndex().getTotalSubscriptions();
        long l = this.getStatistics().getAvailableItemCount() - (long)n - 1L;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"countAvailablePublications", (Object)new Long(l));
        }
        return l;
    }

    public LocalizationDefinition getLocalizationDefinition() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalizationDefinition");
            SibTr.exit((TraceComponent)tc, (String)"getLocalizationDefinition", (Object)this._lastLocalizationDefinitionSetByAdmin);
        }
        return this._lastLocalizationDefinitionSetByAdmin;
    }

    public void updateLocalizationDefinition(LocalizationDefinition localizationDefinition) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLocalizationDefinition", (Object)localizationDefinition);
        }
        if (null != localizationDefinition) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            if (null == this._lastLocalizationDefinitionSetByAdmin) {
                bl = true;
                bl2 = true;
                bl3 = true;
                bl4 = true;
                bl5 = true;
            } else {
                if (this._lastLocalizationDefinitionSetByAdmin.getDestinationHighMsgs() != localizationDefinition.getDestinationHighMsgs()) {
                    bl = true;
                }
                if (this._lastLocalizationDefinitionSetByAdmin.getDestinationLowMsgs() != localizationDefinition.getDestinationLowMsgs()) {
                    bl2 = true;
                }
                if (this._lastLocalizationDefinitionSetByAdmin.isSendAllowed() != localizationDefinition.isSendAllowed()) {
                    bl3 = true;
                }
                if (this._lastLocalizationDefinitionSetByAdmin.getAlterationTime() != localizationDefinition.getAlterationTime()) {
                    bl4 = true;
                }
                String string = this._lastLocalizationDefinitionSetByAdmin.getName();
                String string2 = localizationDefinition.getName();
                if (null == string2 && string != null || null != string2 && string == null) {
                    bl5 = true;
                }
            }
            this._lastLocalizationDefinitionSetByAdmin = localizationDefinition;
            if (bl) {
                this.setDestHighMsgs(localizationDefinition.getDestinationHighMsgs());
            }
            if (bl2) {
                this.setDestLowMsgs(localizationDefinition.getDestinationLowMsgs());
            }
            if (bl3) {
                this.setSendAllowed(localizationDefinition.isSendAllowed());
            }
            if (bl4) {
                this.setAlterationTime(localizationDefinition.getAlterationTime());
            }
            if (bl5) {
                this.setName(localizationDefinition.getName());
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLocalizationDefinition");
        }
    }

    public void createControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        this.controlAdapter = new LocalTopicSpaceControl(this.destinationHandler.getMessageProcessor(), this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    public void deregisterControlAdapterMBean() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
        LocalTopicSpaceControl localTopicSpaceControl = (LocalTopicSpaceControl)this.getControlAdapter();
        localTopicSpaceControl.deregisterControlAdapterMBean();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
    }

    public void setDestHighMsgs(long l) {
        long l2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestHighMsgs", (Object)new Long(l));
        }
        super.setDestHighMsgs(l);
        long l3 = (long)((double)this._destHighMsgs * SIMPConstants.REMOTE_QUEUE_HIGH_PERCENTAGE_EXCESS);
        if (l3 == 0L) {
            ++l3;
        }
        if ((l2 = this._destHighMsgs + l3) < this._destHighMsgs) {
            this._remoteQueueHighLimit = Long.MAX_VALUE;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"remote Queue High Limit might be too small to prevent deadlock");
            }
        } else {
            this._remoteQueueHighLimit = l2;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("remoteQueueHighLimit=" + this._remoteQueueHighLimit));
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestHighMsgs");
        }
    }

    public void registerControlAdapterAsMBean() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
        LocalTopicSpaceControl localTopicSpaceControl = (LocalTopicSpaceControl)this.getControlAdapter();
        localTopicSpaceControl.registerControlAdapterAsMBean();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    public void dereferenceControlAdapter() {
        this.controlAdapter.dereferenceControllable();
        this.controlAdapter = null;
    }

    private void setName(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setName", (Object)string);
        }
        this._name = string;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setName");
        }
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)this._name);
        }
        return this._name;
    }

    protected void setDestLimits(long l, long l2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestLimits", (Object)new Object[]{new Long(l), new Long(l2)});
        }
        super.setDestLimits(l, l2);
        if (this._isEventNotificationEnabled) {
            this.setWatermarks(this._destLowMsgs, this._destHighMsgs, -1L, -1L);
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestLimits");
        }
    }

    public boolean isSendAllowed() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSendAllowed");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSendAllowed", (Object)new Boolean(this._isSendAllowed));
        }
        return this._isSendAllowed;
    }

    public void setSendAllowed(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSendAllowed", (Object)new Boolean(bl));
        }
        this._isSendAllowed = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setSendAllowed");
        }
    }

    public long getAlterationTime() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAlterationTime");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAlterationTime", (Object)new Long(this._alterationTime));
        }
        return this._alterationTime;
    }

    public void setAlterationTime(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setAlterationTime", (Object)new Long(l));
        }
        this._alterationTime = l;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setAlterationTime");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/store/itemstreams/PubSubMessageItemStream.java, SIB.processor, WAS602.SIB, o0610.11 1.57");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

