/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.itemstreams.BaseMessageItemStream;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

public abstract class PtoPMessageItemStream
extends BaseMessageItemStream
implements MessageEventListener,
ControllableResource {
    private static final TraceComponent tc = SibTr.register((Class)PtoPMessageItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    private static final int PERSISTENT_VERSION = 1;
    private OutputHandler outputHandler = null;
    protected SIBUuid8 messagingEngineUuid;
    private Boolean toBeDeleted = Boolean.FALSE;
    private boolean deleteRequiredAtReconstitute = false;

    public PtoPMessageItemStream() {
    }

    public PtoPMessageItemStream(BaseDestinationHandler baseDestinationHandler, SIBUuid8 sIBUuid8, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PtoPMessageItemStream", (Object)new Object[]{baseDestinationHandler, sIBUuid8, new Boolean(bl)});
        }
        this.messagingEngineUuid = sIBUuid8;
        this.setStorageStrategy(baseDestinationHandler.getStorageStrategy());
        this.initializeNonPersistent(baseDestinationHandler);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PtoPMessageItemStream", (Object)this);
        }
    }

    public void reconstitute(BaseDestinationHandler baseDestinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)baseDestinationHandler);
        }
        this.initializeNonPersistent(baseDestinationHandler);
        this.initialiseUnrestoredMsgIds();
        if (tc.isEntryEnabled()) {
            Statistics statistics = this.getStatistics();
            SibTr.exit((TraceComponent)tc, (String)"reconstitute - counts total items, available items", (Object)new Object[]{new Long(statistics.getTotalItemCount()), new Long(statistics.getAvailableItemCount())});
        }
    }

    public OutputHandler getOutputHandler() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getOutputHandler");
            SibTr.exit((TraceComponent)tc, (String)"getOutputHandler", (Object)this.outputHandler);
        }
        return this.outputHandler;
    }

    public void setOutputHandler(OutputHandler outputHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setOutputHandler", (Object)outputHandler);
        }
        this.outputHandler = outputHandler;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setOutputHandler");
        }
    }

    public void setDeleteRequiredAtReconstitute(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDeleteRequiredAtReconstitute", (Object)new Boolean(bl));
            SibTr.exit((TraceComponent)tc, (String)"setDeleteRequiredAtReconstitute");
        }
        this.deleteRequiredAtReconstitute = bl;
    }

    public boolean getDeleteRequiredAtReconstitute() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDeleteRequiredAtReconstitute");
            SibTr.exit((TraceComponent)tc, (String)"getDeleteRequiredAtReconstitute", (Object)new Boolean(this.deleteRequiredAtReconstitute));
        }
        return this.deleteRequiredAtReconstitute;
    }

    public SIBUuid8 getMessagingEngineUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessagingEngineUuid");
            SibTr.exit((TraceComponent)tc, (String)"getMessagingEngineUuid", (Object)this.messagingEngineUuid);
        }
        return this.messagingEngineUuid;
    }

    public BaseDestinationHandler getDestinationHandler() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHandler");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHandler", (Object)this.destinationHandler);
        }
        return this.destinationHandler;
    }

    public void unmarkAsToBeDeleted(Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unmarkAsToBeDeleted", (Object)transaction);
        }
        this.toBeDeleted = Boolean.FALSE;
        try {
            this.requestUpdate(transaction);
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream.unmarkAsToBeDeleted", (String)"1:341:1.86", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"unmarkAsToBeDeleted", (Object)((Object)messageStoreException));
            }
            throw new SIResourceException((Throwable)((Object)messageStoreException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unmarkAsToBeDeleted");
        }
    }

    public boolean isToBeDeleted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isToBeDeleted");
            SibTr.exit((TraceComponent)tc, (String)"isToBeDeleted", (Object)this.toBeDeleted);
        }
        return this.toBeDeleted;
    }

    public int getPersistentVersion() {
        return 1;
    }

    public void getPersistentData(ObjectOutputStream objectOutputStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)objectOutputStream);
        }
        try {
            HashMap hashMap = new HashMap();
            this.addPersistentDestinationData(hashMap);
            objectOutputStream.writeObject(hashMap);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream.getPersistentData", (String)"1:401:1.86", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream", "1:408:1.86", exception, this.getDestinationHandler().getName()});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)exception);
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream", "1:420:1.86", exception, this.getDestinationHandler().getName()}, null), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    public void addPersistentDestinationData(HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addPersistentDestinationData", (Object)hashMap);
        }
        hashMap.put("messagingEngineUuid", this.getMessagingEngineUuid().toByteArray());
        hashMap.put("toBeDeleted", this.toBeDeleted);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addPersistentDestinationData");
        }
    }

    public void restore(ObjectInputStream objectInputStream, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{objectInputStream, new Integer(n)});
        }
        this.checkPersistentVersionId(n);
        try {
            HashMap hashMap = (HashMap)objectInputStream.readObject();
            this.restorePersistentDestinationData(hashMap);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream.restore", (String)"1:469:1.86", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream", "1:476:1.86", exception});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)exception);
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream", "1:487:1.86", exception}, null), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public void restorePersistentDestinationData(HashMap hashMap) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restorePersistentDestinationData", (Object)new Object[]{hashMap});
        }
        this.messagingEngineUuid = new SIBUuid8((byte[])hashMap.get("messagingEngineUuid"));
        this.toBeDeleted = (Boolean)hashMap.get("toBeDeleted");
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restorePersistentDestinationData");
        }
    }

    public void registerForEvents(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForEvents");
        }
        sIMPMessage.registerMessageEventListener(3, this);
        sIMPMessage.registerMessageEventListener(5, this);
        sIMPMessage.registerMessageEventListener(2, this);
        sIMPMessage.registerMessageEventListener(4, this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForEvents");
        }
    }

    public void deregisterForEvents(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterForEvents");
        }
        sIMPMessage.deregisterMessageEventListener(3, this);
        sIMPMessage.deregisterMessageEventListener(5, this);
        sIMPMessage.deregisterMessageEventListener(2, this);
        sIMPMessage.deregisterMessageEventListener(4, this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterForEvents");
        }
    }

    public void messageEventOccurred(int n, SIMPMessage sIMPMessage, Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageEventOccurred", (Object)new Object[]{new Integer(n), sIMPMessage, transaction});
        }
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.testIfToBeDeleted(sIMPMessage);
                break;
            }
            default: {
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream", "1:586:1.86"}, null));
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream.messageEventOccurred", (String)"1:592:1.86", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream", "1:599:1.86"});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred", (Object)((Object)sIErrorException));
                }
                throw sIErrorException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred");
        }
    }

    public void testIfToBeDeleted(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"testIfToBeDeleted", (Object)sIMPMessage);
        }
        if (this.isInStore() && (this.isToBeDeleted() || this.getDestinationHandler().isToBeDeleted())) {
            this.deregisterForEvents(sIMPMessage);
            try {
                Statistics statistics = this.getStatistics();
                long l = statistics.getAvailableItemCount();
                long l2 = statistics.getUnavailableItemCount();
                if (l > 0L || l2 > 0L) {
                    this.getDestinationHandler().getDestinationManager().markDestinationAsCleanUpPending(this.getDestinationHandler());
                }
            }
            catch (NotInMessageStore notInMessageStore) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"testIfToBeDeleted");
        }
    }

    public abstract boolean reallocateMsgs();

    public void removeItemStream(Transaction transaction, long l) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeItemStream", (Object)new Object[]{transaction, new Long(l)});
        }
        this.deregisterControlAdapterMBean();
        this.remove(transaction, l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeItemStream");
        }
    }

    public void replaceUuid(SIBUuid8 sIBUuid8, Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"replaceUuid", (Object)new Object[]{sIBUuid8, transaction});
        }
        if (this.messagingEngineUuid.toString().equals("0000000000000001")) {
            this.messagingEngineUuid = sIBUuid8;
            try {
                this.requestUpdate(transaction);
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream.replaceUuid", (String)"1:718:1.86", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"replaceUuid", (Object)((Object)messageStoreException));
                }
                throw new SIResourceException((Throwable)((Object)messageStoreException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"replaceUuid");
        }
    }

    public void markAsToBeDeleted(Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"markAsToBeDeleted", (Object)transaction);
        }
        this.toBeDeleted = Boolean.TRUE;
        try {
            this.requestUpdate(transaction);
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream.markAsToBeDeleted", (String)"1:757:1.86", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"markAsToBeDeleted", (Object)((Object)messageStoreException));
            }
            throw new SIResourceException((Throwable)((Object)messageStoreException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"markAsToBeDeleted");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/store/itemstreams/PtoPMessageItemStream.java, SIB.processor, WAS602.SIB, o0610.11 1.86");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

