/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.StreamIsFull;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

public final class DurableSubscriptionItemStream
extends SubscriptionItemStream {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)DurableSubscriptionItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int VERSION = 1;
    private ConsumerDispatcherState _subState;
    private int _domain;
    private BaseDestinationHandler _bdh;
    private DestinationManager _destinationManager;
    private boolean _inDoubt = false;
    private String _selectorString;

    public DurableSubscriptionItemStream(ConsumerDispatcherState consumerDispatcherState, DestinationManager destinationManager, PubSubMessageItemStream pubSubMessageItemStream, Transaction transaction) throws OutOfCacheSpace, MessageStoreException, StreamIsFull {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DurableSubscriptionItemStream", (Object)new Object[]{consumerDispatcherState, destinationManager, pubSubMessageItemStream, transaction});
        }
        this._subState = consumerDispatcherState;
        this._destinationManager = destinationManager;
        consumerDispatcherState.setReady(false);
        this.setStorageStrategy(4);
        pubSubMessageItemStream.addReferenceStream(this, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DurableSubscriptionItemStream", (Object)this);
        }
    }

    public DurableSubscriptionItemStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DurableSubscriptionItemStream");
        }
        this._subState = new ConsumerDispatcherState();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DurableSubscriptionItemStream", (Object)this);
        }
    }

    public int getPersistentVersion() {
        return 1;
    }

    public void getPersistentData(ObjectOutputStream objectOutputStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)objectOutputStream);
        }
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("subscriberID", this._subState.getSubscriberID());
            hashMap.put("topicspace", this._subState.getTopicSpaceUuid().toString());
            hashMap.put("topicspaceName", this._subState.getTopicSpaceName());
            hashMap.put("topicspaceBusName", this._subState.getTopicSpaceBusName());
            hashMap.put("isToBeDeleted", new Boolean(this.toBeDeleted));
            String string = null;
            int n = SelectorDomain.SIMESSAGE.toInt();
            if (this._subState.getSelectionCriteria() != null) {
                string = this._subState.getSelectionCriteria().getSelectorString();
                n = this._subState.getSelectionCriteria().getSelectorDomain().toInt();
            }
            hashMap.put("selectorstring", string);
            hashMap.put("selectordomain", new Integer(n));
            hashMap.put("user", this._subState.getUser());
            hashMap.put("isSIBServerSubject", new Boolean(this._subState.isSIBServerSubject()));
            hashMap.put("topics", this._subState.getTopics());
            hashMap.put("isCloned", new Boolean(this._subState.isCloned()));
            hashMap.put("isNoLocal", new Boolean(this._subState.isNoLocal()));
            objectOutputStream.writeObject(hashMap);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.DurableSubscriptionItemStream.getPersistentData", (String)"1:278:1.73", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)iOException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)iOException);
            }
            throw new SIErrorException(nls.getFormattedMessage("SUBSCRIPTION_WARM_START_ERROR_CWSIP0148", new Object[]{this._destinationManager.getLocalME().getMessagingEngineName(), iOException}, null), (Throwable)iOException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    public void initializeNonPersistent(BaseDestinationHandler baseDestinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNonPersistent", (Object)baseDestinationHandler);
        }
        this._bdh = baseDestinationHandler;
        this._destinationManager = this._bdh.getDestinationManager();
        SelectionCriteria selectionCriteria = this._destinationManager.getLocalME().getSelectionCriteriaFactory().createSelectionCriteria(null, this._selectorString, SelectorDomain.getSelectorDomain((int)this._domain));
        this._subState.setSelectionCriteria(selectionCriteria);
        this._subState.setDurableHome(this._destinationManager.getLocalME().getMessagingEngineName());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    public void restore(ObjectInputStream objectInputStream, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{objectInputStream, new Integer(n)});
        }
        this.checkPersistentVersionId(n);
        PubSubMessageItemStream pubSubMessageItemStream = (PubSubMessageItemStream)this.getItemStream();
        BaseDestinationHandler baseDestinationHandler = (BaseDestinationHandler)pubSubMessageItemStream.getItemStream();
        this._destinationManager = baseDestinationHandler.getDestinationManager();
        try {
            HashMap hashMap = (HashMap)objectInputStream.readObject();
            this._subState.setSubscriberID((String)hashMap.get("subscriberID"));
            this._subState.setTopicSpaceUuid(new SIBUuid12((String)hashMap.get("topicspace")));
            this._subState.setTopicSpaceName((String)hashMap.get("topicspaceName"));
            this._subState.setTopicSpaceBusName((String)hashMap.get("topicspaceBusName"));
            this._selectorString = (String)hashMap.get("selectorstring");
            this.toBeDeleted = (Boolean)hashMap.get("isToBeDeleted");
            this._domain = (Integer)hashMap.get("selectordomain");
            boolean bl = (Boolean)hashMap.get("isSIBServerSubject");
            this._subState.setUser((String)hashMap.get("user"), bl);
            this._subState.setTopics((String[])hashMap.get("topics"));
            this._subState.setIsCloned((Boolean)hashMap.get("isCloned"));
            this._subState.setNoLocal((Boolean)hashMap.get("isNoLocal"));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.DurableSubscriptionItemStream.restore", (String)"1:359:1.73", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)exception);
            }
            throw new SIErrorException(nls.getFormattedMessage("SUBSCRIPTION_WARM_START_ERROR_CWSIP0148", new Object[]{this._destinationManager.getLocalME().getMessagingEngineName(), exception}, null), (Throwable)exception);
        }
        if (baseDestinationHandler == null || this._destinationManager == null) {
            this._inDoubt = true;
        } else {
            this.initializeNonPersistent(baseDestinationHandler);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        formattedWriter.newLine();
        formattedWriter.taggedValue("subscriberID", (Object)this._subState.getSubscriberID());
        formattedWriter.newLine();
        formattedWriter.startTag("topics");
        formattedWriter.indent();
        String[] stringArray = this._subState.getTopics();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                formattedWriter.newLine();
                formattedWriter.taggedValue("topic", (Object)stringArray[i]);
            }
        }
        formattedWriter.outdent();
        formattedWriter.newLine();
        formattedWriter.endTag("topics");
    }

    public ConsumerDispatcherState getConsumerDispatcherState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerDispatcherState");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerDispatcherState", (Object)this._subState);
        }
        return this._subState;
    }

    public void eventPostCommitRemove(Transaction transaction) {
        super.eventPostCommitRemove(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitRemove", (Object)transaction);
        }
        this.deleteDurableSubscription(false, true);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitRemove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventPostCommitAdd(Transaction transaction) {
        super.eventPostCommitAdd(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitAdd", (Object)transaction);
        }
        HashMap hashMap = this._destinationManager.getDurableSubscriptionsTable();
        ConsumerDispatcher consumerDispatcher = (ConsumerDispatcher)hashMap.get(this._subState.getSubscriberID());
        consumerDispatcher.activateDurableSubscriptionStats();
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            this._subState.setReady(true);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitAdd");
        }
    }

    public void eventPostRollbackAdd(Transaction transaction) {
        super.eventPostRollbackAdd(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackAdd", (Object)transaction);
        }
        this.deleteDurableSubscription(true, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackAdd");
        }
    }

    public void eventPostRollbackRemove(Transaction transaction) {
        super.eventPostRollbackRemove(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)transaction);
        }
        try {
            this._destinationManager.getLocalME().getProxyHandler().subscribeEvent(this._subState, null, false);
        }
        catch (SIResourceException sIResourceException) {
            FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.DurableSubscriptionItemStream.eventPostRollbackRemove", (String)"1:518:1.73", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackRemove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDurableSubscription(boolean bl, boolean bl2) {
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteDurableSubscription", (Object)new Object[]{new Boolean(bl), new Boolean(bl2)});
        }
        HashMap hashMap2 = hashMap = this._destinationManager.getDurableSubscriptionsTable();
        synchronized (hashMap2) {
            block8: {
                ConsumerDispatcher consumerDispatcher = (ConsumerDispatcher)hashMap.get(this._subState.getSubscriberID());
                if (consumerDispatcher != null && consumerDispatcher.dispatcherStateEquals(this._subState)) {
                    hashMap.remove(this._subState.getSubscriberID());
                    try {
                        consumerDispatcher.deleteConsumerDispatcher(bl, bl2);
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.DurableSubscriptionItemStream.deleteDurableSubscription", (String)"1:582:1.73", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                        if (!tc.isEntryEnabled()) break block8;
                        SibTr.exit((TraceComponent)tc, (String)"deleteDurableSubscription", (Object)((Object)sIException));
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteDurableSubscription");
        }
    }

    public boolean hasInDoubtItems() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasInDoubtItems");
            SibTr.exit((TraceComponent)tc, (String)"hasInDoubtItems", (Object)new Boolean(this._inDoubt));
        }
        return this._inDoubt;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/store/itemstreams/DurableSubscriptionItemStream.java, SIB.processor, WAS602.SIB, o0610.11 1.73");
        }
    }
}

