/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class AOProtocolItemStream
extends SIMPItemStream {
    private static TraceComponent tc = SibTr.register((Class)AOProtocolItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int PERSISTENT_VERSION = 1;
    private SIBUuid8 remoteMEId;
    private SIBUuid12 streamId;
    private DestinationHandler destinationHandler;

    public AOProtocolItemStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AOProtocolItemStream");
        }
        this.remoteMEId = null;
        this.streamId = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AOProtocolItemStream", (Object)this);
        }
    }

    public AOProtocolItemStream(SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12, DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AOProtocolItemStream", (Object)new Object[]{sIBUuid8, sIBUuid12, destinationHandler});
        }
        this.remoteMEId = sIBUuid8;
        this.streamId = sIBUuid12;
        this.destinationHandler = destinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AOProtocolItemStream", (Object)this);
        }
    }

    public final SIBUuid8 getRemoteMEId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteMEId");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteMEId", (Object)this.remoteMEId);
        }
        return this.remoteMEId;
    }

    public final SIBUuid12 getStreamId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamId");
            SibTr.exit((TraceComponent)tc, (String)"getStreamId", (Object)this.streamId);
        }
        return this.streamId;
    }

    public int getPersistentVersion() {
        return 1;
    }

    public void getPersistentData(ObjectOutputStream objectOutputStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)objectOutputStream);
        }
        try {
            objectOutputStream.writeUTF(this.remoteMEId.toString());
            objectOutputStream.writeUTF(this.streamId.toString());
        }
        catch (IOException iOException) {
            SIErrorException sIErrorException = new SIErrorException((Throwable)iOException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    public void restore(ObjectInputStream objectInputStream, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{objectInputStream, new Integer(n)});
        }
        this.checkPersistentVersionId(n);
        try {
            this.remoteMEId = new SIBUuid8(objectInputStream.readUTF());
            this.streamId = new SIBUuid12(objectInputStream.readUTF());
        }
        catch (Exception exception) {
            SIErrorException sIErrorException = new SIErrorException((Throwable)exception);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public void eventPostRollbackRemove(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)transaction);
        }
        super.eventPostRollbackRemove(transaction);
        try {
            this.unlock(this.getLockID());
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.AOProtocolItemStream.eventPostRollbackRemove", (String)"1:210:1.19", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackRemove");
        }
    }

    public DestinationHandler getDestinationHandler() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHandler");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHandler", (Object)this.destinationHandler);
        }
        return this.destinationHandler;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/store/itemstreams/AOProtocolItemStream.java, SIB.processor, WAS602.SIB, o0610.11 1.19");
        }
    }
}

